/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserException;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgConstraint;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTable;
import java.text.MessageFormat;

public class CreateTableParser {
    public static void parse(PgDatabase pgDatabase, String string, boolean bl) {
        Parser parser = new Parser(string);
        parser.expect("CREATE");
        boolean bl2 = parser.expectOptional("UNLOGGED");
        boolean bl3 = parser.expectOptional("FOREIGN");
        parser.expect("TABLE");
        parser.expectOptional("IF", "NOT", "EXISTS");
        String string2 = parser.parseIdentifier();
        String string3 = ParserUtils.getSchemaName(string2, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string3);
        if (pgSchema == null) {
            if (bl) {
                pgSchema = new PgSchema(string3);
                pgDatabase.addSchema(pgSchema);
            } else {
                throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string3, string));
            }
        }
        PgTable pgTable = new PgTable(ParserUtils.getObjectName(string2), pgDatabase, pgSchema);
        pgTable.setUnlogged(bl2);
        pgTable.setForeign(bl3);
        pgSchema.addRelation(pgTable);
        parser.expect("(");
        while (!parser.expectOptional(")")) {
            if (parser.expectOptional("CONSTRAINT")) {
                CreateTableParser.parseConstraint(parser, pgTable);
            } else {
                if (parser.expectOptional("PRIMARY", "KEY")) {
                    throw new ParserException(Resources.getString("CreateTablePrimaryKeyNotSupported"));
                }
                if (parser.expectOptional("UNIQUE")) {
                    throw new ParserException(Resources.getString("CreateTableUniqueNotSupported"));
                }
                CreateTableParser.parseColumn(parser, pgTable);
            }
            if (parser.expectOptional(")")) break;
            parser.expect(",");
        }
        while (!parser.expectOptional(";")) {
            if (parser.expectOptional("PARTITION", "BY")) {
                pgTable.setPartionBy("PARTITION BY " + parser.getExpression());
                continue;
            }
            if (parser.expectOptional("INHERITS")) {
                CreateTableParser.parseInherits(pgDatabase, parser, pgTable);
                continue;
            }
            if (parser.expectOptional("WITHOUT")) {
                pgTable.setWith("OIDS=false");
                continue;
            }
            if (parser.expectOptional("WITH")) {
                if (parser.expectOptional("OIDS") || parser.expectOptional("OIDS=true")) {
                    pgTable.setWith("OIDS=true");
                    continue;
                }
                if (parser.expectOptional("OIDS=false")) {
                    pgTable.setWith("OIDS=false");
                    continue;
                }
                pgTable.setWith(parser.getExpression());
                continue;
            }
            if (parser.expectOptional("TABLESPACE")) {
                pgTable.setTablespace(parser.parseString());
                continue;
            }
            if (parser.expectOptional("SERVER")) {
                pgTable.setForeignServer(parser.getExpression());
                continue;
            }
            parser.throwUnsupportedCommand();
        }
    }

    private static void parseInherits(PgDatabase pgDatabase, Parser parser, PgTable pgTable) {
        parser.expect("(");
        while (!parser.expectOptional(")")) {
            String string = parser.parseIdentifier();
            String string2 = ParserUtils.getObjectName(string);
            String string3 = string.contains(".") ? ParserUtils.getSecondObjectName(string) : pgDatabase.getDefaultSchema().getName();
            pgTable.addInherits(string3, string2);
            if (parser.expectOptional(")")) break;
            parser.expect(",");
        }
    }

    private static void parseConstraint(Parser parser, PgTable pgTable) {
        PgConstraint pgConstraint = new PgConstraint(ParserUtils.getObjectName(parser.parseIdentifier()));
        pgTable.addConstraint(pgConstraint);
        pgConstraint.setDefinition(parser.getExpression());
        pgConstraint.setTableName(pgTable.getName());
    }

    private static void parseColumn(Parser parser, PgTable pgTable) {
        PgColumn pgColumn = new PgColumn(ParserUtils.getObjectName(parser.parseIdentifier()));
        pgTable.addColumn(pgColumn);
        pgColumn.parseDefinition(parser.getExpression());
    }

    private CreateTableParser() {
    }
}

