/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 19:28:29 GMT 2018
 */

package uk.ac.sanger.artemis.components.variant;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockPrintWriter;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureFromVectorPredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.variant.IOUtils;
import uk.ac.sanger.artemis.components.variant.VCFview;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class IOUtils_ESTest extends IOUtils_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      StringWriter stringWriter0 = new StringWriter();
      StringBuffer stringBuffer0 = stringWriter0.getBuffer();
      IOUtils.wrapString("momehow y crossproduct a,phabet is incompa5ible with column ", stringBuffer0);
      assertEquals(61, stringBuffer0.length());
      assertEquals("momehow y crossproduct a,phabet is incompa5ible with column \n", stringWriter0.toString());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Hashtable<String, Boolean> hashtable0 = new Hashtable<String, Boolean>();
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("Feature base viewer for feature(s)");
      FeatureVector featureVector0 = entry0.checkFeatureStartCodons();
      // Undeclared exception!
      try { 
        IOUtils.writeVCF(hashtable0, (String) null, (-191743503), (VCFview) null, featureVector0, 6);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("}(QWgx'TlyP>");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "uk.ac.sanger.artemis.components.variant.IOUtils");
      FeatureVector featureVector0 = new FeatureVector();
      // Undeclared exception!
      try { 
        IOUtils.writeVCF((Map<String, Boolean>) null, "}(QWgx'TlyP>", 1324, (VCFview) null, featureVector0, 2);
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Premature end of file: data stream
         //
         verifyException("htsjdk.samtools.util.BlockCompressedInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      // Undeclared exception!
      try { 
        IOUtils.wrapString("No features selected.", (StringBuffer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.IOUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      try { 
        IOUtils.isBCF("|ei6ck#vttROA<W<@G");
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EvoSuiteURL evoSuiteURL0 = new EvoSuiteURL("http:");
      NetworkHandling.createRemoteTextFile(evoSuiteURL0, "Use N for filtered out sites");
      // Undeclared exception!
      try { 
        IOUtils.isBCF("http:");
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Premature end of file: data stream
         //
         verifyException("htsjdk.samtools.util.BlockCompressedInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("}(QWgx'TlyP>", "}(QWgx'TlyP>");
      Bases bases0 = new Bases(fastaStreamSequence0);
      FeatureVector featureVector0 = new FeatureVector();
      // Undeclared exception!
      try { 
        IOUtils.exportVariantFasta((VCFview) null, (PrintWriter) null, (-2776), featureVector0, bases0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.IOUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      // Undeclared exception!
      try { 
        IOUtils.exportVariantFasta((VCFview) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.IOUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MockPrintWriter mockPrintWriter0 = new MockPrintWriter("ftp:ftp:<FR");
      // Undeclared exception!
      try { 
        IOUtils.exportFasta((VCFview) null, (FeatureVector) null, true, mockPrintWriter0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.IOUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Hashtable<String, Boolean> hashtable0 = new Hashtable<String, Boolean>();
      // Undeclared exception!
      try { 
        IOUtils.export(hashtable0, (List<String>) null, (VCFview) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.IOUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("}(QWgx'TlyP>", "}(QWgx'TlyP>");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureVector featureVector0 = simpleEntryGroup0.getFeaturesInIndexRange(1324, 1);
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "}(QWgx'TlyP>");
      filteredEntryGroup0.createEntry("}(QWgx'TlyP>");
      // Undeclared exception!
      IOUtils.createFeatures((VCFview) null, filteredEntryGroup0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      MockPrintWriter mockPrintWriter0 = new MockPrintWriter("}QWgx'TlyP>");
      boolean boolean0 = IOUtils.isBCF("}QWgx'TlyP>");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      // Undeclared exception!
      try { 
        IOUtils.isBCF("ftp:<<FR");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.net.URL", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      try { 
        IOUtils.isBCF("http:");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Could not find: 
         //
         verifyException("org.evosuite.runtime.mock.java.net.EvoHttpURLConnection", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(" tn ae");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      // Undeclared exception!
      try { 
        IOUtils.createFeatures((VCFview) null, simpleEntryGroup0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.IOUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      StringWriter stringWriter0 = new StringWriter();
      StringBuffer stringBuffer0 = stringWriter0.getBuffer();
      IOUtils.wrapString("Somehow my crossproduct alphabet is incompatible with column ", stringBuffer0);
      assertEquals("Somehow my crossproduct alphabet is incompatible with column\n \n", stringBuffer0.toString());
      assertEquals("Somehow my crossproduct alphabet is incompatible with column\n \n", stringWriter0.toString());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      // Undeclared exception!
      try { 
        IOUtils.countVariants((VCFview) null, featureVector0);
      
      } catch(HeadlessException e) {
    	  	fail("Caught HeadlessException");
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("}(QWgx'TlyP>", "}(QWgx'TlyP>");
      FeatureVector featureVector0 = new FeatureVector();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "t|`,uYAD/");
      Entry entry0 = filteredEntryGroup0.createEntry();
      Feature feature0 = entry0.createFeature();
      featureVector0.insertElementAt(feature0, 0);
      // Undeclared exception!
      try { 
        IOUtils.countVariants((VCFview) null, featureVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.IOUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("}QWgx'TlyP>", "}QWgx'TlyP>");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureVector featureVector0 = simpleEntryGroup0.getFeaturesInIndexRange(1324, 1);
      MockPrintWriter mockPrintWriter0 = new MockPrintWriter("}QWgx'TlyP>");
      // Undeclared exception!
      try { 
        IOUtils.exportFasta((VCFview) null, featureVector0, false, mockPrintWriter0);
      
      } catch(HeadlessException e) {
    	  	fail("Caught HeadlessException");
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("}(QWgx'TlyP>");
      Selection selection0 = new Selection(clipboard0);
      MockPrintWriter mockPrintWriter0 = new MockPrintWriter("}(QWgx'TlyP>");
      // Undeclared exception!
      try { 
        IOUtils.exportFastaByRange((VCFview) null, selection0, true, mockPrintWriter0);
      
      } catch(HeadlessException e) {
    	  	fail("Caught HeadlessException");
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      HashMap<String, Boolean> hashMap0 = new HashMap<String, Boolean>();
      FeatureVector featureVector0 = new FeatureVector();
      // Undeclared exception!
      try { 
        IOUtils.writeVCF(hashMap0, "", 682, (VCFview) null, featureVector0, 0);
        fail("Expected HeadlessException");
      } catch(HeadlessException e) {
    	  	
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      File file0 = IOUtils.writeVCF((Map<String, Boolean>) null, "}(QWgx'TlyP>", 1324, (VCFview) null, featureVector0, 2);
      assertNull(file0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      IOUtils iOUtils0 = new IOUtils();
  }
}
