#ifndef ATL_sGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,240,480,720,1080,1680,1920,2040,2280
 * N : 25,240,480,720,1080,1680,1920,2040,2280
 * NB : 2,12,20,20,40,56,80,80,120
 */
#define ATL_sGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 132) (nb_) = 2; \
   else if ((n_) < 360) (nb_) = 12; \
   else if ((n_) < 900) (nb_) = 20; \
   else if ((n_) < 1380) (nb_) = 40; \
   else if ((n_) < 1800) (nb_) = 56; \
   else if ((n_) < 2160) (nb_) = 80; \
   else (nb_) = 120; \
}


#endif    /* end ifndef ATL_sGetNB_geqrf */
