#pragma once

#include "biboumi.h"

#ifdef BOTAN_FOUND

#include <botan/credentials_manager.h>
#include <botan/certstor.h>
#include <botan/tls_client.h>

class TCPSocketHandler;

/**
 * If the given cert isn’t valid, based on the given hostname
 * and fingerprint, then throws the exception if it’s non-empty.
 *
 * Must be called after the standard (from Botan) way of
 * checking the certificate, if we want to also accept certificates based
 * on a trusted fingerprint.
 */
void check_tls_certificate(const std::vector<Botan::X509_Certificate>& certs,
                           const std::string_view hostname, const std::string& trusted_fingerprint,
                           const std::exception_ptr& exc);

class BasicCredentialsManager: public Botan::Credentials_Manager
{
public:
  BasicCredentialsManager();

  BasicCredentialsManager(BasicCredentialsManager&&) = delete;
  BasicCredentialsManager(const BasicCredentialsManager&) = delete;
  BasicCredentialsManager& operator=(const BasicCredentialsManager&) = delete;
  BasicCredentialsManager& operator=(BasicCredentialsManager&&) = delete;

  std::vector<Botan::Certificate_Store*> trusted_certificate_authorities(const std::string& type,
                                                                         const std::string& context) override final;
  void set_trusted_fingerprint(const std::string& fingerprint);
  const std::string& get_trusted_fingerprint() const;

private:

  static bool try_to_open_one_ca_bundle(const std::vector<std::string>& paths);
  static void load_certs();
  static Botan::Certificate_Store_In_Memory certificate_store;
  static bool certs_loaded;
  std::string trusted_fingerprint;
};

#endif //BOTAN_FOUND

