# CiviCRM 5.25.0

Released May 6, 2020

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     | **yes** |
| Alter the API?                                                  | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     | **yes** |
| Introduce features?                                             | **yes** |
| Fix bugs?                                                       | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **End of life plans for php 7.0 & deprecate php 7.1
  ([dev/core#1528](https://lab.civicrm.org/dev/core/issues/1528):
  [16753](https://github.com/civicrm/civicrm-core/pull/16753),
  [599](https://github.com/civicrm/civicrm-drupal/pull/599),
  [598](https://github.com/civicrm/civicrm-drupal/pull/598),
  [111](https://github.com/civicrm/civicrm-backdrop/pull/111),
  [16678](https://github.com/civicrm/civicrm-core/pull/16678),
  [114](https://github.com/civicrm/civicrm-backdrop/pull/114),
  [187](https://github.com/civicrm/civicrm-wordpress/pull/187) and
  [184](https://github.com/civicrm/civicrm-wordpress/pull/184))**

  CiviCRM now requires PHP 7.1 at a minimum and recommends PHP 7.3.

  In the process of making this change, the minimum PHP version is now stored in
  a single place within the core codebase.  CMS-specific files have this value,
  too, but tests enforce that it be the same as the single core value.

- **Replace jcalendar instances with datepicker (Continued
  Work [dev/core#561](https://lab.civicrm.org/dev/core/issues/561):
  [15709](https://github.com/civicrm/civicrm-core/pull/15709) and
  [16863](https://github.com/civicrm/civicrm-core/pull/16863))**

  These changes continue work to move to datepicker from jcalendar by converting
  report instances from using the legacy jcalendar to using datepicker for date
  fields and deprecating the `addDateRange` function used by jcalendar.

- **APIv4 - Add Dashboard & DashboardContact entities
  ([16867](https://github.com/civicrm/civicrm-core/pull/16867))**

  Adds APIv4 support for Dashboard & DashboardContact and does some cleanup in
  the BAO and API layers for improved consistency.

- **Add new language, `nl_BE`
  ([17014](https://github.com/civicrm/civicrm-core/pull/17014))**

  Adds a new translation option for "Dutch (Belgium)".

- **Add hook to alter display value or Custom field value
  ([16921](https://github.com/civicrm/civicrm-core/pull/16921))**

  The new hook
  [`hook_civicrm_alterCustomFieldDisplayValue()`](https://docs.civicrm.org/dev/en/latest/hooks/hook_civicrm_alterCustomFieldDisplayValue/)
  allows modification of the displayed value for a custom field value.

- **APIv4 query improvements (Work towards
  [dev/report#31](https://lab.civicrm.org/dev/report/issues/31):
  [16917](https://github.com/civicrm/civicrm-core/pull/16917) and
  [16947](https://github.com/civicrm/civicrm-core/pull/16947))**

  This change builds out the APIv4 framework to support `GROUP BY` and different
  types of expressions in clauses that previously only accepted the names of
  fields. These expressions can now include numbers, `NULL`, strings, and
  whitelisted SQL functions. The framework can in theory handle most SQL
  functions, but this first PR adds support for the aggregate functions `AVG`,
  `COUNT`, `MAX`, `MIN`, and `SUM`.

- **install/index.php - Fix leak which breaks compatibility with current Backdrop
  ([#17249](https://github.com/civicrm/civicrm-core/pull/17249))**

### CiviContribute

- **Partial Refunds (Work towards
  [dev/financial#87](https://lab.civicrm.org/dev/financial/issues/87):
  [16480](https://github.com/civicrm/civicrm-core/pull/16480))**

  The "Add Payment" form is altered to permit payments to be added even if a
  contribution is fully paid.

- **Add privacy fields to Contribution Detail report
  ([16674](https://github.com/civicrm/civicrm-core/pull/16674))**

   Columns for the following fields are added to the contribution detail report:
   "Do Not Phone", "Do Not Mail", "Do Not SMS", "Do Not Trade".

 - **Add "pledge id" as column and filter in Contribution Detail report.
   ([16868](https://github.com/civicrm/civicrm-core/pull/16868))**

   This change improves the Contribution Detail Report by adding "pledge id" as
   a filter and column.

### CiviEvent

- **Remove additional display of buttons for events
  ([16550](https://github.com/civicrm/civicrm-core/pull/16550))**

  When viewing an event registration, this removes the Record Payment button
  from the Fees section.  Payments can still be recorded from the payments
  section.

### WordPress Integration

- **Merge REST API wrapper code
  ([160](https://github.com/civicrm/civicrm-wordpress/pull/160))**

  This merges the CiviCRM WP REST API Wrapper plugin's code into the core
  WordPress integration.  The result is that there are now native WordPress REST
  endpoints for the REST API, email tracking, and other endpoints that had been
  direct links to PHP files in the `extern` folder of the CiviCRM plugin.

- **Add shortcodes for Personal Campaign Pages
  ([185](https://github.com/civicrm/civicrm-wordpress/pull/185) and
  [16695](https://github.com/civicrm/civicrm-core/pull/16695))**

  Personal Campaign Pages are now available as a shortcode.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Activity Detail report gives syntax error with force=1 if include case
  activities is on
  ([dev/core#1710](https://lab.civicrm.org/dev/core/issues/1710):
  [17128](https://github.com/civicrm/civicrm-core/pull/17128))**

  The case activity table wasn't properly loaded when the Activity Detail report
  including case activities would go straight to displaying results.

- **Search Builder - Activity Type search not working.
  ([dev/core#1714](https://lab.civicrm.org/dev/core/issues/1714):
  [17215](https://github.com/civicrm/civicrm-core/pull/17215))**

  In Search Builder, searching by activity type would return no results,
  affecting not only direct searches but also smart groups that built with
  Search Builder.  This resolves the regression, which first appeared in 5.24.3.

- **Deleting entities leaves obsolete EntityTag records
  ([dev/core#667](https://lab.civicrm.org/dev/core/issues/667):
  [16832](https://github.com/civicrm/civicrm-core/pull/16832))**

  Fixes a bug where deleting a contact does not delete tags associated with the
  contact.

- **Profile Public Title (frontend_title column) is not used in profile
  create/edit mode
  ([dev/core#1683](https://lab.civicrm.org/dev/core/issues/1683):
  [16945](https://github.com/civicrm/civicrm-core/pull/16945))**

  The Public Title setting that was recently added for profiles would only
  replace the profile name on contribution and event forms.  When the profile
  was used in a standalone context, the name would always appear.

- **Auto-complete search results not consistent with other searches
  ([dev/core#787](https://lab.civicrm.org/dev/core/issues/787):
  [13809](https://github.com/civicrm/civicrm-core/pull/13809))**

- **Need to Increase Data Size for `form_values` column on
  civicrm_report_instance table
  ([dev/core#1569](https://lab.civicrm.org/dev/core/issues/1569):
  [16836](https://github.com/civicrm/civicrm-core/pull/16836))**

  This hanges the data type for the `form_values` column on the
  `civicrm_report_instance` from TEXT to LONGTEXT.

- **PHP warning on Add relationship form
  ([dev/core#1663](https://lab.civicrm.org/dev/core/issues/1663):
  [16845](https://github.com/civicrm/civicrm-core/pull/16845) and
  [16941](https://github.com/civicrm/civicrm-core/pull/16941))**

- **Removing all the dashlets from the dashboard leads to E_NOTICE
  ([dev/core#1668](https://lab.civicrm.org/dev/core/issues/1668):
  [16883](https://github.com/civicrm/civicrm-core/pull/16883))**

- **Regression: Api4 causes container being rebuild on every request
  ([dev/core#1674](https://lab.civicrm.org/dev/core/issues/1674):
  [16919](https://github.com/civicrm/civicrm-core/pull/16919))**

- **E_NOTICE when using the New Individual popup/profile
  ([dev/core#1676](https://lab.civicrm.org/dev/core/issues/1676):
  [16924](https://github.com/civicrm/civicrm-core/pull/16924))**

- **[regression] CiviCRM reports that smart groups won't work due to deleted
  custom fields that aren't deleted
  ([dev/core#1688](https://lab.civicrm.org/dev/core/issues/1688):
  [16961](https://github.com/civicrm/civicrm-core/pull/16961))**

  A system check would mistakenly report that a smart group was based upon a
  deleted custom field if it was based upon a checkbox or multi-select custom
  field.

- **Fix checking permissions in api3 profile get
  ([16848](https://github.com/civicrm/civicrm-core/pull/16848))**

  This resolves a bug where the API would reverse the value of the option to use
  a current user's permissions when retrieving the list of fields in a profile.

- **APIv4 - convert Result object to array when running through json_encode
  ([16828](https://github.com/civicrm/civicrm-core/pull/16828))**

- **Api4 AJAX endpoint: change required permission to access AJAX API.
  ([16705](https://github.com/civicrm/civicrm-core/pull/16705) and
  [17241](https://github.com/civicrm/civicrm-core/pull/17241))**

  The APIv4 AJAX endpoint is now open to users with either the Access CiviCRM or
  the Access AJAX API permissions, matching the APIv3 behavior.

- **Improvements to APIv4 select query
  ([16889](https://github.com/civicrm/civicrm-core/pull/16889) and
  [16900](https://github.com/civicrm/civicrm-core/pull/16900))**

- **APIv4 - Don't advertise implicit multi-joins in Explorer
  ([17205](https://github.com/civicrm/civicrm-core/pull/17205))**

  Implicit one-to-many joins in APIv4 have been problematic and may get removed.
  As a soft deprecation, these are no longer displayed in the APIv4 explorer.

- **CRM_Core_I18n - Provide a better label for new/unknown locales
  ([17021](https://github.com/civicrm/civicrm-core/pull/17021))**

  If CiviCRM finds a locale in the localization files but doesn't know what it
  is, it will now display the locale code instead of just a blank option.

- **Fixed fatal error for class not found when managed hook is invoked during
  upgrade ([17004](https://github.com/civicrm/civicrm-core/pull/17004))**

- **Log error message instead of throwing exception
  ([16880](https://github.com/civicrm/civicrm-core/pull/16880))**

- **Remove instances of fatal
  ([16759](https://github.com/civicrm/civicrm-core/pull/16759))**

  This throws exceptions rather than dying when encountering problems creating
  contacts.

- **Fix bug where a % in a serialized array can lead to the data being broken
  ([16694](https://github.com/civicrm/civicrm-core/pull/16694))**

- **Fix batch contact/activity update with radio options
  ([16855](https://github.com/civicrm/civicrm-core/pull/16855))**

  This fixes a failure to copy the value down a column if the field is radio
  buttons and the value in the first row contains a space.

- **Fix CustomDataView.tpl plain empty memo field.
  ([16839](https://github.com/civicrm/civicrm-core/pull/16839))**

  Ensure note custom fields display on their own lines

- **Fix setting outBound_option readonly in UI
  ([16774](https://github.com/civicrm/civicrm-core/pull/16774))**

  If the outbound mailer option is set via the settings file, the settings form
  will now disable the field.

- **Use dbAlias to generate where clause for date field in activity report
  ([16689](https://github.com/civicrm/civicrm-core/pull/16689))**

  This resolves potentially ambiguous queries in the Activity Summary and Detail
  reports if the activity table is joined again in the report.

- **[REF] Use composer patches to apply CiviCRM Customisations for CRM-1367 and
  CRM-5946 ([16870](https://github.com/civicrm/civicrm-core/pull/16870))**

  Migrates the patching of pear_mail from a script file to using composer
  patches to ensure CiviCRM customisations for CRM-1367 and CRM-5946 are applied
  consistently.

### CiviCase

- **Various errors recorded in log message on Manage Case screen -> relationship
  tab. ([dev/core#1664](https://lab.civicrm.org/dev/core/issues/1664):
  [16846](https://github.com/civicrm/civicrm-core/pull/16846))**

  Fixes log messages generated when opening the relationship tab on the Manage
  Case form.

- **"Merge Case" modal not showing relevant cases
  ([dev/core#1646](https://lab.civicrm.org/dev/core/issues/1646):
  [16798](https://github.com/civicrm/civicrm-core/pull/16798))**

  The pop-up to merge cases would only show 25 other cases.  It now shows all
  cases for a client.

- **Adding a timeline to a case doesn't get the last activity in the timeline
  right ([dev/core#1675](https://lab.civicrm.org/dev/core/issues/1675) and
  [dev/core#1695](https://lab.civicrm.org/dev/core/issues/1695):
  [289](https://github.com/civicrm/civicrm-packages/pull/289))**

  Ensures case custom fields are saved when submitted via Drupal webform.
  Additionally ensures that the last activity in the case timeline is set
  correctly.

- **Check for "Change Case Type" in case activity form doesn't do anything
  ([dev/core#1652](https://lab.civicrm.org/dev/core/issues/1652):
  [16785](https://github.com/civicrm/civicrm-core/pull/16785))**

- **When auditing cases on non-English deployments, richtext details
  are incorrectly escaped
  ([16659](https://github.com/civicrm/civicrm-core/pull/16659))**

- **Respect 'Do not notify activity type' setting
  ([16800](https://github.com/civicrm/civicrm-core/pull/16800))**

  The setting to not notify assignees for certain activity types was not
  respected when submitting an activity from a case.

### CiviContribute

- **Changes to "CiviContribute Component Settings" not saved
  ([dev/core#1724](https://lab.civicrm.org/dev/core/issues/1724):
  [17188](https://github.com/civicrm/civicrm-core/pull/17188))**

  The way that CiviContribute component settings were stored was updated for
  5.23, but the transition during the upgrade was problematic.  This replaces
  the transition code, resolving issues for sites upgrading directly from 5.22.x
  or earlier.  Sites on 5.23.x or 5.24.x should review their settings, however.

- **Invoice action not shown when invoicing enabled
  ([17164](https://github.com/civicrm/civicrm-core/pull/17164))**

  The "Invoices - print or email" action was not available for contribution
  search results even when invoicing was enabled.

- **Cumulative contributions not being calculated with the correct criteria
  ([dev/core#1740](https://lab.civicrm.org/dev/core/issues/1740):
  [17237](https://github.com/civicrm/civicrm-core/pull/17237))**

  The cumulative contributions display from a contribution page would needlessly
  filter contributions by date, with the end date being midnight on the current
  date.  That would exclude contributions received on the current day.

- **Updating misleading labels on buttons to confirmation pages
  ([dev/core#1613](https://lab.civicrm.org/dev/core/issues/1613):
  [16651](https://github.com/civicrm/civicrm-core/pull/16651))**

  Some donors and event registrants interpreted the button text "Confirm
  Contribution" (on contribution pages) and "Continue" (on event registration
  pages) to mean that this would complete the contribution or registration.  In
  fact, these would only appear when a confirmation page is used.

  The button text now appears as "Review your contribution" and "Review your
  registration", respectively.

- **Fix upgrade failure. Thin-out activation logic for `sequentialcreditnotes`.
  ([16971](https://github.com/civicrm/civicrm-core/pull/16971) following
  [dev/financial#84](https://lab.civicrm.org/dev/financial/issues/84))**

  This change fixes an issue for some builds when upgrading caused by the
  activation of the `sequentialcreditnotes` extension to replace core code that
  generates sequential credit note identifiers.

- **Fix Bug where Payment Balance is sometimes miscalculated
  ([16546](https://github.com/civicrm/civicrm-core/pull/16546))**

  Fixes a bug where Add Refund is displayed instead of Add Payment on partially
  paid event contributions.

- **Stop overwriting contact name with PayPal name
  ([CRM-20553](https://issues.civicrm.org/jira/browse/CRM-20553): [14667](https://github.com/civicrm/civicrm-core/pull/14667))**

  When a user creates a donation via PayPal, their CiviCRM contact name should
  not be overwritten to be their PayPal account name.

- **Fix use of "Soft Credit Amount Stats" and any filter of contribution…
  ([16591](https://github.com/civicrm/civicrm-core/pull/16591))**

  Ensures that one can use "Soft Credit Amount Stats" with all filters.

- **CRM_Core_Payment_PayPalProIPN should not call getPayPalPaymentProcessorID()
  if processor_id is clearly provided in URL
  ([dev/core#1579](https://lab.civicrm.org/dev/core/issues/1579):
  [16479](https://github.com/civicrm/civicrm-core/pull/16479))**

- **Update pending contribution status action also send email without warning
  ([dev/core#1640](https://lab.civicrm.org/dev/core/issues/1640):
  [16742](https://github.com/civicrm/civicrm-core/pull/16742))**]

  When bulk updating the status of contributions, there is now a checkbox to
  choose whether the contacts should be emailed.  Previously, emails would be
  generated without warning.

- **Fix display of payment processor title in cancelSubscription form
  ([16857](https://github.com/civicrm/civicrm-core/pull/16857))**

- **Make the checkbox, "Billing address is the same", respond to the change event
  ([16496](https://github.com/civicrm/civicrm-core/pull/16496))**

  This makes the "billing address is the same" checkbox trigger its changes no
  matter how the box is checked, not just by clicking it.

### CiviEvent

- **PayPal Express Checkout fails on events
  ([dev/financial#119](https://lab.civicrm.org/dev/financial/issues/119):
  [16692](https://github.com/civicrm/civicrm-core/pull/16692))**

- **Fixed fatal error for Event Participants custom search if price set field
  option is disabled after a registrant has already selected it
  ([16894](https://github.com/civicrm/civicrm-core/pull/16894))**

### CiviMember

- **Don't freeze fields for auto-renew memberships
  ([dev/core#1331](https://lab.civicrm.org/dev/core/issues/1331):
  [16609](https://github.com/civicrm/civicrm-core/pull/16609) and
  [16881](https://github.com/civicrm/civicrm-core/pull/16881))**

  Previously, many membership fields were frozen for administrators when the
  membership was set to auto-renew with a recurring contribution.

- **Deceased Contact via Inline doesn't update the Membership's status to
  Deceased ([dev/core#1599](https://lab.civicrm.org/dev/core/issues/1599):
  [16724](https://github.com/civicrm/civicrm-core/pull/16724) and
  [16787](https://github.com/civicrm/civicrm-core/pull/16787))**

  When marking a contact as deceased, this simplifies the underlying process and
  ensures that a message is displayed about memberships being updated to
  Deceased status.

- **Invalid currency "$" on sending offline membership receipt.
  ([dev/core#1682](https://lab.civicrm.org/dev/core/issues/1682):
  [16943](https://github.com/civicrm/civicrm-core/pull/16943))**

  Fixes an error when sending a receipt for a membership created from an offline
  membership form.  The default currency symbol was being saved as the currency
  itself.

- **Membership auto-renew is not optional if using price set
  ([dev/core#1630](https://lab.civicrm.org/dev/core/issues/1630):
  [16762](https://github.com/civicrm/civicrm-core/pull/16762))**

- **Membership join date checkbox on constituent detail report has lost its
  label ([dev/report#28](https://lab.civicrm.org/dev/report/issues/28):
  [16829](https://github.com/civicrm/civicrm-core/pull/16829))**

### Drupal Integration

- **Address no longer available as Relationship for Views in Drupal 7
  ([dev/drupal#110](https://lab.civicrm.org/dev/drupal/issues/110):
  [118](https://github.com/civicrm/civicrm-backdrop/pull/118) and
  [600](https://github.com/civicrm/civicrm-drupal/pull/600))**

- **Generalise typo3/phar-stream-wrapper so CiviCRM can be installed on D8.7
  ([17085](https://github.com/civicrm/civicrm-core/pull/17085))**

- **civicrm-setup and backward slashes in file paths on windows don't play nice
  together ([dev/core#1643](https://lab.civicrm.org/dev/core/issues/1643):
  [16886](https://github.com/civicrm/civicrm-core/pull/16886))**

  Fixes installing CiviCRM on Drupal8 sites on windows using civicrm-setup / cv
  core:install.

### WordPress Integration

- **5.23 breaks WP admin menu links
  ([dev/core#1637](https://lab.civicrm.org/dev/core/issues/1637):
  [16713](https://github.com/civicrm/civicrm-core/pull/16713))**

- **Set "cms.root" URL in addition to Path
  ([188](https://github.com/civicrm/civicrm-wordpress/pull/188))**

  This resolves a "Cannot resolve path using 'cms.root.url'" exception thrown on
  the "Settings - Resource URLs" screen incorrectly on a WordPress multisite
  subsite.

## <a name="misc"></a>Miscellany

- **Add recurring contribution ID to doCancelRecurring
  ([16741](https://github.com/civicrm/civicrm-core/pull/16741))**

- **Support PropertyBag in CRM_Utils_Array
  ([16699](https://github.com/civicrm/civicrm-core/pull/16699) and
  [16737](https://github.com/civicrm/civicrm-core/pull/16737))**

- **Added pseudoconstant for acl_id
  ([16925](https://github.com/civicrm/civicrm-core/pull/16925))**

- **Added pseudoconstant for state province
  ([16799](https://github.com/civicrm/civicrm-core/pull/16799))**

- **Added pseudoconstant for location type
  ([16758](https://github.com/civicrm/civicrm-core/pull/16758))**

- **Added pseudoconstant for priceset
  ([16754](https://github.com/civicrm/civicrm-core/pull/16754))**

- **Added pseudoconstant for bounce type
  ([16727](https://github.com/civicrm/civicrm-core/pull/16727))**

- **Added pseudoconstant for civicrm_tag.parent_id
  ([16703](https://github.com/civicrm/civicrm-core/pull/16703))**

- **Event Cart cleanup
  ([16691](https://github.com/civicrm/civicrm-core/pull/16691))**

- **Update cancelSubscription form to use updated methodology
  ([16501](https://github.com/civicrm/civicrm-core/pull/16501) and
  [16715](https://github.com/civicrm/civicrm-core/pull/16715))**

- **Skip expensive smarty Processing when nothing to see here
  ([16731](https://github.com/civicrm/civicrm-core/pull/16731))**

- **UFMatch - deprecate unused functions
  ([16849](https://github.com/civicrm/civicrm-core/pull/16849))**

- **Shifted UpdateMemberhsip to BAO Layer
  ([16690](https://github.com/civicrm/civicrm-core/pull/16690))**

- **Add DAO::writeRecord and DAO::deleteRecord methods
  ([16856](https://github.com/civicrm/civicrm-core/pull/16856))**

- **Add some deprecation notices, stop calling PrevNext::cleanupCache
  ([16697](https://github.com/civicrm/civicrm-core/pull/16697))**

- **Remove assigns for atypefile
  ([16895](https://github.com/civicrm/civicrm-core/pull/16895))**

- **Deprecate use of  in OptionGroup::add() function
  ([16910](https://github.com/civicrm/civicrm-core/pull/16910))**

- **Improve APIv4 selectUtils to handle join paths in fieldnames.
  ([16904](https://github.com/civicrm/civicrm-core/pull/16904))**

- **Upgrade jQuery validation version to v1.19.1
  ([16625](https://github.com/civicrm/civicrm-core/pull/16625))**

- **APIv3 - Use new DAO::deleteRecord method
  ([16869](https://github.com/civicrm/civicrm-core/pull/16869))**

- **Improve conditional in api3 ChainSubscriber
  ([16718](https://github.com/civicrm/civicrm-core/pull/16718))**

- **Mark unused function as deprecated
  ([16688](https://github.com/civicrm/civicrm-core/pull/16688))**

- **CRM/Contact - Cleanup boolean expressions
  ([16844](https://github.com/civicrm/civicrm-core/pull/16844))**

- **CRM/Contribute - Cleanup boolean expressions
  ([16853](https://github.com/civicrm/civicrm-core/pull/16853))**

- **Civi/Test - Refactor out CRM_Utils_Array::value
  ([16871](https://github.com/civicrm/civicrm-core/pull/16871))**

- **Cleanup reverse boolean expressions
  ([16850](https://github.com/civicrm/civicrm-core/pull/16850))**

- **CRM/Core - Cleanup boolean expressions
  ([16852](https://github.com/civicrm/civicrm-core/pull/16852))**

- **CRM/Utils - Cleanup boolean expressions
  ([16851](https://github.com/civicrm/civicrm-core/pull/16851))**

- **CRM - Cleanup boolean expressions
  ([16854](https://github.com/civicrm/civicrm-core/pull/16854))**

- **Fix another instance of silly use of CRM_Utils_Array::value
  ([16712](https://github.com/civicrm/civicrm-core/pull/16712))**

- **Fix passing a non-array to CRM_Utils_Array::value
  ([16701](https://github.com/civicrm/civicrm-core/pull/16701))**

- **Fix another instance of NULL being passed to CRM_Utils_Array::value
  ([16711](https://github.com/civicrm/civicrm-core/pull/16711))**

- **Remove an instance of passing non-arraay to CRM_Utils_Array::value(
  ([16706](https://github.com/civicrm/civicrm-core/pull/16706))**

- **Remove calls & deprecate CRM_Core_BAO_PrevNextCache::setItem
  ([16696](https://github.com/civicrm/civicrm-core/pull/16696))**

- **(POC) Add `hook_civicrm_postCommit`, a less foot-gunny variant of
  `hook_civicrm_post`
  ([15338](https://github.com/civicrm/civicrm-core/pull/15338))**

- **Fix typos in xml/dao
  ([16827](https://github.com/civicrm/civicrm-core/pull/16827))**

- **Deprecate unused/unneeded pseudoconstant functions
  ([16771](https://github.com/civicrm/civicrm-core/pull/16771))**

- **Deprecate calling contactTrashRestore function
  ([16824](https://github.com/civicrm/civicrm-core/pull/16824))**

- **Remove old stuff
  ([16835](https://github.com/civicrm/civicrm-core/pull/16835))**

- **Remove  deprecated cleaning  of money in  the  BAO layer
  ([16950](https://github.com/civicrm/civicrm-core/pull/16950))**

- **Remove unused deprecated function
  ([16812](https://github.com/civicrm/civicrm-core/pull/16812))**

- **Remove deprecated function
  ([16907](https://github.com/civicrm/civicrm-core/pull/16907))**

- **Remove unused code
  ([16914](https://github.com/civicrm/civicrm-core/pull/16914))**

- **Remove deprecated parameter
  ([16813](https://github.com/civicrm/civicrm-core/pull/16813))**

- **fix typo ([16865](https://github.com/civicrm/civicrm-core/pull/16865))**

- **API tests - remove unnecessary check for v4
  ([16866](https://github.com/civicrm/civicrm-core/pull/16866))**

- **[NFC] APIv4 - Add test coverage for expected fields from join
  ([16920](https://github.com/civicrm/civicrm-core/pull/16920))**

- **[NFC] Add in unit test to ensure that APIv4 Doesn't accept an invalid…
  ([16893](https://github.com/civicrm/civicrm-core/pull/16893))**

- **[NFC] Use strict comparison where  possible
  ([16896](https://github.com/civicrm/civicrm-core/pull/16896))**

- **[NFC] Code formatting
  ([16906](https://github.com/civicrm/civicrm-core/pull/16906))**

- **[NFC] minor form cleanup.
  ([16905](https://github.com/civicrm/civicrm-core/pull/16905))**

- **(NFC) Minor typo: receipients > recipients
  ([16810](https://github.com/civicrm/civicrm-core/pull/16810))**

- **[NFC] Minor code cleanup
  ([16823](https://github.com/civicrm/civicrm-core/pull/16823))**

- **[NFC] Deprecate passing in silly data
  ([16818](https://github.com/civicrm/civicrm-core/pull/16818))**

- **[NFC] Test cleanup
  ([16817](https://github.com/civicrm/civicrm-core/pull/16817))**

- **[NFC] Test cleanup, remove duplicate test
  ([16755](https://github.com/civicrm/civicrm-core/pull/16755))**

- **(NFC) Minor string error : for for > for
  ([16773](https://github.com/civicrm/civicrm-core/pull/16773))**

- **(NFC) Minor typo: contacts(s) -> contact(s)
  ([16804](https://github.com/civicrm/civicrm-core/pull/16804))**

- **(NFC) Query.php / Minor typo: Genrated -> Generated
  ([16803](https://github.com/civicrm/civicrm-core/pull/16803))**

- **[NFC] Fix comments, use single quotes
  ([16693](https://github.com/civicrm/civicrm-core/pull/16693))**

- **[NFC] Mark unused function deprecated, fix some comments & formatting
  ([16698](https://github.com/civicrm/civicrm-core/pull/16698))**

- **[NFC] cleanup in test class
  ([16764](https://github.com/civicrm/civicrm-core/pull/16764))**

- **[NFC] Use helper / api to delete contacts in tests
  ([16825](https://github.com/civicrm/civicrm-core/pull/16825))**

- **[NFC/TEST] Resurrect unfinished test for getRelatedCases()
  ([16885](https://github.com/civicrm/civicrm-core/pull/16885))**

- **[Test] Remove skip that seems no longer required
  ([16912](https://github.com/civicrm/civicrm-core/pull/16912))**

- **Test for PR 13809
  ([16474](https://github.com/civicrm/civicrm-core/pull/16474))**

- **[TEST] Add test for to time processing
  ([16861](https://github.com/civicrm/civicrm-core/pull/16861))**

- **[REF] Case Activities Report includes core activities *always*
  ([dev/core#1366](https://lab.civicrm.org/dev/core/issues/1366):
  [16670](https://github.com/civicrm/civicrm-core/pull/16670))**

- **[REF] Cleanup api3 DashboardContact
  ([16792](https://github.com/civicrm/civicrm-core/pull/16792))**

- **[REF] Fixes a bug in Message Template create API where by user permissions
  checks were being done on system workflow messages
  ([16788](https://github.com/civicrm/civicrm-core/pull/16788))**

- **[REF] Remove calls to fatal()
  ([16746](https://github.com/civicrm/civicrm-core/pull/16746))**

- **[REF] Cleanup uses of CRM_Utils_Array::value related to numbers
  ([16778](https://github.com/civicrm/civicrm-core/pull/16778))**

- **[REF]  cleanup financial type form - remove complex inheritence
  ([16777](https://github.com/civicrm/civicrm-core/pull/16777))**

- **[REF] Use ?? operator instead of CRM_Utils_Array::value()
  ([16710](https://github.com/civicrm/civicrm-core/pull/16710))**

- **[REF] dev/core#1116 - Remove unused misnamed activityTypeName variable
  ([16730](https://github.com/civicrm/civicrm-core/pull/16730))**

- **REF Switch to getter on cancelSubscription form
  ([16740](https://github.com/civicrm/civicrm-core/pull/16740))**

- **[REF] Minor code simplification
  ([16734](https://github.com/civicrm/civicrm-core/pull/16734))**

- **[REF] Hopefully fix regularly failing conformance test
  ([16732](https://github.com/civicrm/civicrm-core/pull/16732))**

- **[REF] Use empty() instead of CRM_Utils_Array::value() in inline conditionals
  ([16729](https://github.com/civicrm/civicrm-core/pull/16729))**

- **[REF] Use ?? operator instead of CRM_Utils_Array::value() in return
  statements ([16719](https://github.com/civicrm/civicrm-core/pull/16719))**

- **[REF] CRM_Utils_Array::value() -> empty()
  ([16704](https://github.com/civicrm/civicrm-core/pull/16704))**

- **[REF] Cleanup is_array(CRM_Utils_Array::value()) pattern
  ([16875](https://github.com/civicrm/civicrm-core/pull/16875))**

- **[REF] Remove redundant call to build permissions
  ([16862](https://github.com/civicrm/civicrm-core/pull/16862))**

- **[REF] Replace CRM_Utils_Array::value with ?? in variable assignments
  ([16768](https://github.com/civicrm/civicrm-core/pull/16768))**

- **[REF] Replace coalesce pattern with coalesce operator
  ([16802](https://github.com/civicrm/civicrm-core/pull/16802))**

- **[REF] Switch to using a non abandoned library for getting a mapping of
  mimetypes to extensions
  ([16436](https://github.com/civicrm/civicrm-core/pull/16436))**

- **[REF] move buildQuickForm function to the trait
  ([16948](https://github.com/civicrm/civicrm-core/pull/16948))**

- **[REF] Move properties to Trait
  ([16940](https://github.com/civicrm/civicrm-core/pull/16940))**

- **[REF] Start transitioning EmailCommon class to a trait
  ([16935](https://github.com/civicrm/civicrm-core/pull/16935))**

- **[REF] Remove fatal, fix some code comments
  ([16928](https://github.com/civicrm/civicrm-core/pull/16928))**

- **[REF] extract code to getEmails
  ([16929](https://github.com/civicrm/civicrm-core/pull/16929))**

- **[REF] Minor simplification - do not use variable variables
  ([16927](https://github.com/civicrm/civicrm-core/pull/16927))**

- **[REF] Extract code used to render a pseudoconstant when a table is defined.
  ([16902](https://github.com/civicrm/civicrm-core/pull/16902))**

- **[REF] Move form specific handling back to the relevant form.
  ([16913](https://github.com/civicrm/civicrm-core/pull/16913))**

- **[REF] APIv4 - Preserve order when expanding select wildcards
  ([16909](https://github.com/civicrm/civicrm-core/pull/16909))**

- **[REF] Remove & from before variable
  ([16897](https://github.com/civicrm/civicrm-core/pull/16897))**

- **[REF] Replace \CRM_Utils_Array::value with ??
  ([16872](https://github.com/civicrm/civicrm-core/pull/16872))**

- **[REF] Civi/Api4 - Refactor out 'use CRM_Utils_Array'
  ([16873](https://github.com/civicrm/civicrm-core/pull/16873))**

- **[REF] BAO_Contact - Remove CRM_Utils_Array::value and other unnecessary code
  ([16874](https://github.com/civicrm/civicrm-core/pull/16874))**

- **[REF] APIv4 - Restructure the way get query objects are constucted
  ([16878](https://github.com/civicrm/civicrm-core/pull/16878))**

- **[REF] Fix PCP getPcpDashboardInfo to be tested & use sensible functions
  ([16790](https://github.com/civicrm/civicrm-core/pull/16790))**

- **[REF] Simplify obtuse boolean expressions
  ([16822](https://github.com/civicrm/civicrm-core/pull/16822))**

- **[REF] Replace CRM_Utils_Array::value with ?? in variable assignments
  ([16820](https://github.com/civicrm/civicrm-core/pull/16820))**

- **[REF] cleanups on array operator
  ([16821](https://github.com/civicrm/civicrm-core/pull/16821))**

- **[REF] Simplify obtuse boolean expressions
  ([16819](https://github.com/civicrm/civicrm-core/pull/16819))**

- **[REF] Remove titleHeader var
  ([16816](https://github.com/civicrm/civicrm-core/pull/16816))**

- **[REF] simplify references to civicrm_acl
  ([16671](https://github.com/civicrm/civicrm-core/pull/16671))**

- **[REF] Fix retrieving invoice related settings when doing complete
  transaction ([17218](https://github.com/civicrm/civicrm-core/pull/17218))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

a-n The Artists Information Company - William Mortada; AGH Strategies - Alice
Frumin, Andrew Hunt; Alexy Mikhailichenko; Andrei Mondoc; Christian Wach; Circle
Interactive - Pradeep Nayak; CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts,
Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy; Dave D;
Freeform Solutions - Herb van den Dool; Fuzion - Jitendra Purohit; iXiam - César
Ramos; JMA Consulting - Seamus Lee; Joinery - Allen Shaw; Kartik Kathuria;
Lighthouse Design and Consulting - Brian Shaughnessy; Makoa - Usha F. Matisson;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Naomi Rosenberg; Ray Wright; OSSeed Technologies LLP - Sushant Paste; SYSTOPIA
Organisationsberatung - Björn Endres; Timbsoft Technologies - Tunbola Ogunwande;
Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Artful Robot - Rich Lott; British Humanist
Association - Andrew West; CiviDesk - Nicolas Ganivet; Coop SymbioTIC - Mathieu
Lutfy; Digitalcourage - Detlev Sieber; Freeform Solutions - S. Gray; Fuzion -
Jitendra Purohit; Greenpeace Central and Eastern Europe - Patrick Figel; Jamie
Tillman; JMA Consulting - Monish Deb; Korlon - Stuart Gaston; MJCO - Mikey
O'Toole; Richard van Oosterhout; Skvare - Mark Hanna; Squiffle Consulting -
Aidan Saunders; Tadpole Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
