. lib

darcs init r1
cd r1
touch f
darcs record -lam 'added f as file'
cd ..

darcs init r2
cd r2
mkdir f
darcs record -lam 'added f as dir'

darcs pull -a ../r1

# darcs-1 and darcs-2 resolve the conflict
# differently, we allow both
if cd f && cd ..; then
  rmdir f
else
  rm f
fi
mv f.\~0\~ f
# darcs whatsnew at this point reports nothing
not grep . ../whatsnew
# so revert should do nothing
darcs revert -a

# at this point pending should definitely be empty
# and the following should fail (nothing to record)
if not darcs record -lam 'resolve conflict'; then
  exit 0;
else
  # check that what we record is at least consistent
  # i.e. we have either addfile or adddir for f, but not both
  darcs log -v --last=1 > ../log
  if grep 'addfile ./f' ../log; then
    not grep 'adddir ./f' ../log
  fi
  if grep 'adddir ./f' ../log; then
    not grep 'addfile ./f' ../log
  fi
fi
