// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file sequencesTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "sequencesTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "sequences.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceShort_type_identifier(
        TypeIdentifierPair& type_ids_SequenceShort)
{

    ReturnCode_t return_code_SequenceShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceShort", type_ids_SequenceShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceShort)
    {
        StructTypeFlag struct_flags_SequenceShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceShort = "SequenceShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceShort;
        CompleteTypeDetail detail_SequenceShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceShort, ann_custom_SequenceShort, type_name_SequenceShort.to_string());
        CompleteStructHeader header_SequenceShort;
        header_SequenceShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceShort);
        CompleteStructMemberSeq member_seq_SequenceShort;
        {
            TypeIdentifierPair type_ids_var_sequence_short;
            ReturnCode_t return_code_var_sequence_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_unbounded", type_ids_var_sequence_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_short)
            {
                return_code_var_sequence_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_sequence_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_short, element_identifier_anonymous_sequence_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_short.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_unbounded, element_flags_anonymous_sequence_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_unbounded", type_ids_var_sequence_short))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_short = 0x00000000;
            bool common_var_sequence_short_ec {false};
            CommonStructMember common_var_sequence_short {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_short, member_flags_var_sequence_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_short, common_var_sequence_short_ec))};
            if (!common_var_sequence_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_short = "var_sequence_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_short;
            ann_custom_SequenceShort.reset();
            CompleteMemberDetail detail_var_sequence_short = TypeObjectUtils::build_complete_member_detail(name_var_sequence_short, member_ann_builtin_var_sequence_short, ann_custom_SequenceShort);
            CompleteStructMember member_var_sequence_short = TypeObjectUtils::build_complete_struct_member(common_var_sequence_short, detail_var_sequence_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceShort, member_var_sequence_short);
        }
        CompleteStructType struct_type_SequenceShort = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceShort, header_SequenceShort, member_seq_SequenceShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceShort, type_name_SequenceShort.to_string(), type_ids_SequenceShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceUShort_type_identifier(
        TypeIdentifierPair& type_ids_SequenceUShort)
{

    ReturnCode_t return_code_SequenceUShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceUShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceUShort", type_ids_SequenceUShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceUShort)
    {
        StructTypeFlag struct_flags_SequenceUShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceUShort = "SequenceUShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceUShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceUShort;
        CompleteTypeDetail detail_SequenceUShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceUShort, ann_custom_SequenceUShort, type_name_SequenceUShort.to_string());
        CompleteStructHeader header_SequenceUShort;
        header_SequenceUShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceUShort);
        CompleteStructMemberSeq member_seq_SequenceUShort;
        {
            TypeIdentifierPair type_ids_var_sequence_ushort;
            ReturnCode_t return_code_var_sequence_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_uint16_t_unbounded", type_ids_var_sequence_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_ushort)
            {
                return_code_var_sequence_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_sequence_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_uint16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_uint16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_ushort, element_identifier_anonymous_sequence_uint16_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_uint16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_uint16_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_ushort.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_uint16_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_uint16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_uint16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_uint16_t_unbounded, element_flags_anonymous_sequence_uint16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_uint16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_uint16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_uint16_t_unbounded", type_ids_var_sequence_ushort))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_uint16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_ushort = 0x00000000;
            bool common_var_sequence_ushort_ec {false};
            CommonStructMember common_var_sequence_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_ushort, member_flags_var_sequence_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_ushort, common_var_sequence_ushort_ec))};
            if (!common_var_sequence_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_ushort = "var_sequence_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_ushort;
            ann_custom_SequenceUShort.reset();
            CompleteMemberDetail detail_var_sequence_ushort = TypeObjectUtils::build_complete_member_detail(name_var_sequence_ushort, member_ann_builtin_var_sequence_ushort, ann_custom_SequenceUShort);
            CompleteStructMember member_var_sequence_ushort = TypeObjectUtils::build_complete_struct_member(common_var_sequence_ushort, detail_var_sequence_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceUShort, member_var_sequence_ushort);
        }
        CompleteStructType struct_type_SequenceUShort = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceUShort, header_SequenceUShort, member_seq_SequenceUShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceUShort, type_name_SequenceUShort.to_string(), type_ids_SequenceUShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceUShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceLong_type_identifier(
        TypeIdentifierPair& type_ids_SequenceLong)
{

    ReturnCode_t return_code_SequenceLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceLong", type_ids_SequenceLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceLong)
    {
        StructTypeFlag struct_flags_SequenceLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceLong = "SequenceLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceLong;
        CompleteTypeDetail detail_SequenceLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceLong, ann_custom_SequenceLong, type_name_SequenceLong.to_string());
        CompleteStructHeader header_SequenceLong;
        header_SequenceLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceLong);
        CompleteStructMemberSeq member_seq_SequenceLong;
        {
            TypeIdentifierPair type_ids_var_sequence_long;
            ReturnCode_t return_code_var_sequence_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int32_t_unbounded", type_ids_var_sequence_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_long)
            {
                return_code_var_sequence_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_sequence_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_long, element_identifier_anonymous_sequence_int32_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int32_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_long.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int32_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int32_t_unbounded, element_flags_anonymous_sequence_int32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int32_t_unbounded", type_ids_var_sequence_long))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_long = 0x00000000;
            bool common_var_sequence_long_ec {false};
            CommonStructMember common_var_sequence_long {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_long, member_flags_var_sequence_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_long, common_var_sequence_long_ec))};
            if (!common_var_sequence_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_long = "var_sequence_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_long;
            ann_custom_SequenceLong.reset();
            CompleteMemberDetail detail_var_sequence_long = TypeObjectUtils::build_complete_member_detail(name_var_sequence_long, member_ann_builtin_var_sequence_long, ann_custom_SequenceLong);
            CompleteStructMember member_var_sequence_long = TypeObjectUtils::build_complete_struct_member(common_var_sequence_long, detail_var_sequence_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceLong, member_var_sequence_long);
        }
        CompleteStructType struct_type_SequenceLong = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceLong, header_SequenceLong, member_seq_SequenceLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceLong, type_name_SequenceLong.to_string(), type_ids_SequenceLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceULong_type_identifier(
        TypeIdentifierPair& type_ids_SequenceULong)
{

    ReturnCode_t return_code_SequenceULong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceULong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceULong", type_ids_SequenceULong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceULong)
    {
        StructTypeFlag struct_flags_SequenceULong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceULong = "SequenceULong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceULong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceULong;
        CompleteTypeDetail detail_SequenceULong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceULong, ann_custom_SequenceULong, type_name_SequenceULong.to_string());
        CompleteStructHeader header_SequenceULong;
        header_SequenceULong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceULong);
        CompleteStructMemberSeq member_seq_SequenceULong;
        {
            TypeIdentifierPair type_ids_var_sequence_ulong;
            ReturnCode_t return_code_var_sequence_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_uint32_t_unbounded", type_ids_var_sequence_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_ulong)
            {
                return_code_var_sequence_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_sequence_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_uint32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_uint32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_ulong, element_identifier_anonymous_sequence_uint32_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_uint32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_uint32_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_ulong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_uint32_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_uint32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_uint32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_uint32_t_unbounded, element_flags_anonymous_sequence_uint32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_uint32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_uint32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_uint32_t_unbounded", type_ids_var_sequence_ulong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_uint32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_ulong = 0x00000000;
            bool common_var_sequence_ulong_ec {false};
            CommonStructMember common_var_sequence_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_ulong, member_flags_var_sequence_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_ulong, common_var_sequence_ulong_ec))};
            if (!common_var_sequence_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_ulong = "var_sequence_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_ulong;
            ann_custom_SequenceULong.reset();
            CompleteMemberDetail detail_var_sequence_ulong = TypeObjectUtils::build_complete_member_detail(name_var_sequence_ulong, member_ann_builtin_var_sequence_ulong, ann_custom_SequenceULong);
            CompleteStructMember member_var_sequence_ulong = TypeObjectUtils::build_complete_struct_member(common_var_sequence_ulong, detail_var_sequence_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceULong, member_var_sequence_ulong);
        }
        CompleteStructType struct_type_SequenceULong = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceULong, header_SequenceULong, member_seq_SequenceULong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceULong, type_name_SequenceULong.to_string(), type_ids_SequenceULong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceULong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceLongLong_type_identifier(
        TypeIdentifierPair& type_ids_SequenceLongLong)
{

    ReturnCode_t return_code_SequenceLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceLongLong", type_ids_SequenceLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceLongLong)
    {
        StructTypeFlag struct_flags_SequenceLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceLongLong = "SequenceLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceLongLong;
        CompleteTypeDetail detail_SequenceLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceLongLong, ann_custom_SequenceLongLong, type_name_SequenceLongLong.to_string());
        CompleteStructHeader header_SequenceLongLong;
        header_SequenceLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceLongLong);
        CompleteStructMemberSeq member_seq_SequenceLongLong;
        {
            TypeIdentifierPair type_ids_var_sequence_longlong;
            ReturnCode_t return_code_var_sequence_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int64_t_unbounded", type_ids_var_sequence_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_longlong)
            {
                return_code_var_sequence_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_var_sequence_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_longlong, element_identifier_anonymous_sequence_int64_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int64_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_longlong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int64_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int64_t_unbounded, element_flags_anonymous_sequence_int64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int64_t_unbounded", type_ids_var_sequence_longlong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_longlong = 0x00000000;
            bool common_var_sequence_longlong_ec {false};
            CommonStructMember common_var_sequence_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_longlong, member_flags_var_sequence_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_longlong, common_var_sequence_longlong_ec))};
            if (!common_var_sequence_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_longlong = "var_sequence_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_longlong;
            ann_custom_SequenceLongLong.reset();
            CompleteMemberDetail detail_var_sequence_longlong = TypeObjectUtils::build_complete_member_detail(name_var_sequence_longlong, member_ann_builtin_var_sequence_longlong, ann_custom_SequenceLongLong);
            CompleteStructMember member_var_sequence_longlong = TypeObjectUtils::build_complete_struct_member(common_var_sequence_longlong, detail_var_sequence_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceLongLong, member_var_sequence_longlong);
        }
        CompleteStructType struct_type_SequenceLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceLongLong, header_SequenceLongLong, member_seq_SequenceLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceLongLong, type_name_SequenceLongLong.to_string(), type_ids_SequenceLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceULongLong_type_identifier(
        TypeIdentifierPair& type_ids_SequenceULongLong)
{

    ReturnCode_t return_code_SequenceULongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceULongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceULongLong", type_ids_SequenceULongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceULongLong)
    {
        StructTypeFlag struct_flags_SequenceULongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceULongLong = "SequenceULongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceULongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceULongLong;
        CompleteTypeDetail detail_SequenceULongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceULongLong, ann_custom_SequenceULongLong, type_name_SequenceULongLong.to_string());
        CompleteStructHeader header_SequenceULongLong;
        header_SequenceULongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceULongLong);
        CompleteStructMemberSeq member_seq_SequenceULongLong;
        {
            TypeIdentifierPair type_ids_var_sequence_ulonglong;
            ReturnCode_t return_code_var_sequence_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_uint64_t_unbounded", type_ids_var_sequence_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_ulonglong)
            {
                return_code_var_sequence_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_var_sequence_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_uint64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_uint64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_ulonglong, element_identifier_anonymous_sequence_uint64_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_uint64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_uint64_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_ulonglong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_uint64_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_uint64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_uint64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_uint64_t_unbounded, element_flags_anonymous_sequence_uint64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_uint64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_uint64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_uint64_t_unbounded", type_ids_var_sequence_ulonglong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_uint64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_ulonglong = 0x00000000;
            bool common_var_sequence_ulonglong_ec {false};
            CommonStructMember common_var_sequence_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_ulonglong, member_flags_var_sequence_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_ulonglong, common_var_sequence_ulonglong_ec))};
            if (!common_var_sequence_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_ulonglong = "var_sequence_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_ulonglong;
            ann_custom_SequenceULongLong.reset();
            CompleteMemberDetail detail_var_sequence_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_sequence_ulonglong, member_ann_builtin_var_sequence_ulonglong, ann_custom_SequenceULongLong);
            CompleteStructMember member_var_sequence_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_sequence_ulonglong, detail_var_sequence_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceULongLong, member_var_sequence_ulonglong);
        }
        CompleteStructType struct_type_SequenceULongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceULongLong, header_SequenceULongLong, member_seq_SequenceULongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceULongLong, type_name_SequenceULongLong.to_string(), type_ids_SequenceULongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceULongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceFloat_type_identifier(
        TypeIdentifierPair& type_ids_SequenceFloat)
{

    ReturnCode_t return_code_SequenceFloat {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceFloat =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceFloat", type_ids_SequenceFloat);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceFloat)
    {
        StructTypeFlag struct_flags_SequenceFloat = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceFloat = "SequenceFloat";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceFloat;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceFloat;
        CompleteTypeDetail detail_SequenceFloat = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceFloat, ann_custom_SequenceFloat, type_name_SequenceFloat.to_string());
        CompleteStructHeader header_SequenceFloat;
        header_SequenceFloat = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceFloat);
        CompleteStructMemberSeq member_seq_SequenceFloat;
        {
            TypeIdentifierPair type_ids_var_sequence_float;
            ReturnCode_t return_code_var_sequence_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_float_unbounded", type_ids_var_sequence_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_float)
            {
                return_code_var_sequence_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_var_sequence_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_float_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_float_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_float, element_identifier_anonymous_sequence_float_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_float_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_float_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_float.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_float_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_float_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_float_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_float_unbounded, element_flags_anonymous_sequence_float_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_float_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_float_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_float_unbounded", type_ids_var_sequence_float))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_float_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_float = 0x00000000;
            bool common_var_sequence_float_ec {false};
            CommonStructMember common_var_sequence_float {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_float, member_flags_var_sequence_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_float, common_var_sequence_float_ec))};
            if (!common_var_sequence_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_float = "var_sequence_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_float;
            ann_custom_SequenceFloat.reset();
            CompleteMemberDetail detail_var_sequence_float = TypeObjectUtils::build_complete_member_detail(name_var_sequence_float, member_ann_builtin_var_sequence_float, ann_custom_SequenceFloat);
            CompleteStructMember member_var_sequence_float = TypeObjectUtils::build_complete_struct_member(common_var_sequence_float, detail_var_sequence_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceFloat, member_var_sequence_float);
        }
        CompleteStructType struct_type_SequenceFloat = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceFloat, header_SequenceFloat, member_seq_SequenceFloat);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceFloat, type_name_SequenceFloat.to_string(), type_ids_SequenceFloat))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceFloat already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceDouble_type_identifier(
        TypeIdentifierPair& type_ids_SequenceDouble)
{

    ReturnCode_t return_code_SequenceDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceDouble", type_ids_SequenceDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceDouble)
    {
        StructTypeFlag struct_flags_SequenceDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceDouble = "SequenceDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceDouble;
        CompleteTypeDetail detail_SequenceDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceDouble, ann_custom_SequenceDouble, type_name_SequenceDouble.to_string());
        CompleteStructHeader header_SequenceDouble;
        header_SequenceDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceDouble);
        CompleteStructMemberSeq member_seq_SequenceDouble;
        {
            TypeIdentifierPair type_ids_var_sequence_double;
            ReturnCode_t return_code_var_sequence_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_double_unbounded", type_ids_var_sequence_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_double)
            {
                return_code_var_sequence_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_var_sequence_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_double_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_double_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_double, element_identifier_anonymous_sequence_double_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_double_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_double_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_double.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_double_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_double_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_double_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_double_unbounded, element_flags_anonymous_sequence_double_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_double_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_double_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_double_unbounded", type_ids_var_sequence_double))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_double_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_double = 0x00000000;
            bool common_var_sequence_double_ec {false};
            CommonStructMember common_var_sequence_double {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_double, member_flags_var_sequence_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_double, common_var_sequence_double_ec))};
            if (!common_var_sequence_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_double = "var_sequence_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_double;
            ann_custom_SequenceDouble.reset();
            CompleteMemberDetail detail_var_sequence_double = TypeObjectUtils::build_complete_member_detail(name_var_sequence_double, member_ann_builtin_var_sequence_double, ann_custom_SequenceDouble);
            CompleteStructMember member_var_sequence_double = TypeObjectUtils::build_complete_struct_member(common_var_sequence_double, detail_var_sequence_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceDouble, member_var_sequence_double);
        }
        CompleteStructType struct_type_SequenceDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceDouble, header_SequenceDouble, member_seq_SequenceDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceDouble, type_name_SequenceDouble.to_string(), type_ids_SequenceDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceLongDouble_type_identifier(
        TypeIdentifierPair& type_ids_SequenceLongDouble)
{

    ReturnCode_t return_code_SequenceLongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceLongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceLongDouble", type_ids_SequenceLongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceLongDouble)
    {
        StructTypeFlag struct_flags_SequenceLongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceLongDouble = "SequenceLongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceLongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceLongDouble;
        CompleteTypeDetail detail_SequenceLongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceLongDouble, ann_custom_SequenceLongDouble, type_name_SequenceLongDouble.to_string());
        CompleteStructHeader header_SequenceLongDouble;
        header_SequenceLongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceLongDouble);
        CompleteStructMemberSeq member_seq_SequenceLongDouble;
        {
            TypeIdentifierPair type_ids_var_sequence_longdouble;
            ReturnCode_t return_code_var_sequence_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_longdouble_unbounded", type_ids_var_sequence_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_longdouble)
            {
                return_code_var_sequence_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_var_sequence_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_longdouble_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_longdouble_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_longdouble, element_identifier_anonymous_sequence_longdouble_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_longdouble_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_longdouble_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_longdouble.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_longdouble_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_longdouble_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_longdouble_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_longdouble_unbounded, element_flags_anonymous_sequence_longdouble_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_longdouble_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_longdouble_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_longdouble_unbounded", type_ids_var_sequence_longdouble))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_longdouble_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_longdouble = 0x00000000;
            bool common_var_sequence_longdouble_ec {false};
            CommonStructMember common_var_sequence_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_longdouble, member_flags_var_sequence_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_longdouble, common_var_sequence_longdouble_ec))};
            if (!common_var_sequence_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_longdouble = "var_sequence_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_longdouble;
            ann_custom_SequenceLongDouble.reset();
            CompleteMemberDetail detail_var_sequence_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_sequence_longdouble, member_ann_builtin_var_sequence_longdouble, ann_custom_SequenceLongDouble);
            CompleteStructMember member_var_sequence_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_sequence_longdouble, detail_var_sequence_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceLongDouble, member_var_sequence_longdouble);
        }
        CompleteStructType struct_type_SequenceLongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceLongDouble, header_SequenceLongDouble, member_seq_SequenceLongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceLongDouble, type_name_SequenceLongDouble.to_string(), type_ids_SequenceLongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceLongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceBoolean_type_identifier(
        TypeIdentifierPair& type_ids_SequenceBoolean)
{

    ReturnCode_t return_code_SequenceBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceBoolean", type_ids_SequenceBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceBoolean)
    {
        StructTypeFlag struct_flags_SequenceBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceBoolean = "SequenceBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceBoolean;
        CompleteTypeDetail detail_SequenceBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceBoolean, ann_custom_SequenceBoolean, type_name_SequenceBoolean.to_string());
        CompleteStructHeader header_SequenceBoolean;
        header_SequenceBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceBoolean);
        CompleteStructMemberSeq member_seq_SequenceBoolean;
        {
            TypeIdentifierPair type_ids_var_sequence_boolean;
            ReturnCode_t return_code_var_sequence_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_bool_unbounded", type_ids_var_sequence_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_boolean)
            {
                return_code_var_sequence_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_var_sequence_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_bool_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_bool_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_boolean, element_identifier_anonymous_sequence_bool_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_bool_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_bool_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_boolean.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_bool_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_bool_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_bool_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_bool_unbounded, element_flags_anonymous_sequence_bool_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_bool_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_bool_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_bool_unbounded", type_ids_var_sequence_boolean))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_bool_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_boolean = 0x00000000;
            bool common_var_sequence_boolean_ec {false};
            CommonStructMember common_var_sequence_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_boolean, member_flags_var_sequence_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_boolean, common_var_sequence_boolean_ec))};
            if (!common_var_sequence_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_boolean = "var_sequence_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_boolean;
            ann_custom_SequenceBoolean.reset();
            CompleteMemberDetail detail_var_sequence_boolean = TypeObjectUtils::build_complete_member_detail(name_var_sequence_boolean, member_ann_builtin_var_sequence_boolean, ann_custom_SequenceBoolean);
            CompleteStructMember member_var_sequence_boolean = TypeObjectUtils::build_complete_struct_member(common_var_sequence_boolean, detail_var_sequence_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceBoolean, member_var_sequence_boolean);
        }
        CompleteStructType struct_type_SequenceBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceBoolean, header_SequenceBoolean, member_seq_SequenceBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceBoolean, type_name_SequenceBoolean.to_string(), type_ids_SequenceBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceOctet_type_identifier(
        TypeIdentifierPair& type_ids_SequenceOctet)
{

    ReturnCode_t return_code_SequenceOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceOctet", type_ids_SequenceOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceOctet)
    {
        StructTypeFlag struct_flags_SequenceOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceOctet = "SequenceOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceOctet;
        CompleteTypeDetail detail_SequenceOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceOctet, ann_custom_SequenceOctet, type_name_SequenceOctet.to_string());
        CompleteStructHeader header_SequenceOctet;
        header_SequenceOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceOctet);
        CompleteStructMemberSeq member_seq_SequenceOctet;
        {
            TypeIdentifierPair type_ids_var_sequence_octet;
            ReturnCode_t return_code_var_sequence_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_byte_unbounded", type_ids_var_sequence_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_octet)
            {
                return_code_var_sequence_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_var_sequence_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_byte_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_byte_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_octet, element_identifier_anonymous_sequence_byte_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_byte_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_byte_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_octet.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_byte_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_byte_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_byte_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_byte_unbounded, element_flags_anonymous_sequence_byte_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_byte_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_byte_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_byte_unbounded", type_ids_var_sequence_octet))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_byte_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_octet = 0x00000000;
            bool common_var_sequence_octet_ec {false};
            CommonStructMember common_var_sequence_octet {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_octet, member_flags_var_sequence_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_octet, common_var_sequence_octet_ec))};
            if (!common_var_sequence_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_octet = "var_sequence_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_octet;
            ann_custom_SequenceOctet.reset();
            CompleteMemberDetail detail_var_sequence_octet = TypeObjectUtils::build_complete_member_detail(name_var_sequence_octet, member_ann_builtin_var_sequence_octet, ann_custom_SequenceOctet);
            CompleteStructMember member_var_sequence_octet = TypeObjectUtils::build_complete_struct_member(common_var_sequence_octet, detail_var_sequence_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceOctet, member_var_sequence_octet);
        }
        CompleteStructType struct_type_SequenceOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceOctet, header_SequenceOctet, member_seq_SequenceOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceOctet, type_name_SequenceOctet.to_string(), type_ids_SequenceOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceChar_type_identifier(
        TypeIdentifierPair& type_ids_SequenceChar)
{

    ReturnCode_t return_code_SequenceChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceChar", type_ids_SequenceChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceChar)
    {
        StructTypeFlag struct_flags_SequenceChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceChar = "SequenceChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceChar;
        CompleteTypeDetail detail_SequenceChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceChar, ann_custom_SequenceChar, type_name_SequenceChar.to_string());
        CompleteStructHeader header_SequenceChar;
        header_SequenceChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceChar);
        CompleteStructMemberSeq member_seq_SequenceChar;
        {
            TypeIdentifierPair type_ids_var_sequence_char;
            ReturnCode_t return_code_var_sequence_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_char_unbounded", type_ids_var_sequence_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_char)
            {
                return_code_var_sequence_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_var_sequence_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_char_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_char_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_char, element_identifier_anonymous_sequence_char_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_char_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_char_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_char.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_char_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_char_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_char_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_char_unbounded, element_flags_anonymous_sequence_char_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_char_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_char_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_char_unbounded", type_ids_var_sequence_char))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_char_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_char = 0x00000000;
            bool common_var_sequence_char_ec {false};
            CommonStructMember common_var_sequence_char {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_char, member_flags_var_sequence_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_char, common_var_sequence_char_ec))};
            if (!common_var_sequence_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_char = "var_sequence_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_char;
            ann_custom_SequenceChar.reset();
            CompleteMemberDetail detail_var_sequence_char = TypeObjectUtils::build_complete_member_detail(name_var_sequence_char, member_ann_builtin_var_sequence_char, ann_custom_SequenceChar);
            CompleteStructMember member_var_sequence_char = TypeObjectUtils::build_complete_struct_member(common_var_sequence_char, detail_var_sequence_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceChar, member_var_sequence_char);
        }
        CompleteStructType struct_type_SequenceChar = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceChar, header_SequenceChar, member_seq_SequenceChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceChar, type_name_SequenceChar.to_string(), type_ids_SequenceChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceWChar_type_identifier(
        TypeIdentifierPair& type_ids_SequenceWChar)
{

    ReturnCode_t return_code_SequenceWChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceWChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceWChar", type_ids_SequenceWChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceWChar)
    {
        StructTypeFlag struct_flags_SequenceWChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceWChar = "SequenceWChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceWChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceWChar;
        CompleteTypeDetail detail_SequenceWChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceWChar, ann_custom_SequenceWChar, type_name_SequenceWChar.to_string());
        CompleteStructHeader header_SequenceWChar;
        header_SequenceWChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceWChar);
        CompleteStructMemberSeq member_seq_SequenceWChar;
        {
            TypeIdentifierPair type_ids_var_sequence_wchar;
            ReturnCode_t return_code_var_sequence_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_wchar_t_unbounded", type_ids_var_sequence_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_wchar)
            {
                return_code_var_sequence_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_wchar_t", type_ids_var_sequence_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_wchar_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_wchar_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_wchar, element_identifier_anonymous_sequence_wchar_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_wchar_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_wchar_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_wchar.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_wchar_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_wchar_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_wchar_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_wchar_t_unbounded, element_flags_anonymous_sequence_wchar_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_wchar_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_wchar_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_wchar_t_unbounded", type_ids_var_sequence_wchar))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_wchar_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_wchar = 0x00000000;
            bool common_var_sequence_wchar_ec {false};
            CommonStructMember common_var_sequence_wchar {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_wchar, member_flags_var_sequence_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_wchar, common_var_sequence_wchar_ec))};
            if (!common_var_sequence_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_wchar = "var_sequence_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_wchar;
            ann_custom_SequenceWChar.reset();
            CompleteMemberDetail detail_var_sequence_wchar = TypeObjectUtils::build_complete_member_detail(name_var_sequence_wchar, member_ann_builtin_var_sequence_wchar, ann_custom_SequenceWChar);
            CompleteStructMember member_var_sequence_wchar = TypeObjectUtils::build_complete_struct_member(common_var_sequence_wchar, detail_var_sequence_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceWChar, member_var_sequence_wchar);
        }
        CompleteStructType struct_type_SequenceWChar = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceWChar, header_SequenceWChar, member_seq_SequenceWChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceWChar, type_name_SequenceWChar.to_string(), type_ids_SequenceWChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceWChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceString_type_identifier(
        TypeIdentifierPair& type_ids_SequenceString)
{

    ReturnCode_t return_code_SequenceString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceString", type_ids_SequenceString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceString)
    {
        StructTypeFlag struct_flags_SequenceString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceString = "SequenceString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceString;
        CompleteTypeDetail detail_SequenceString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceString, ann_custom_SequenceString, type_name_SequenceString.to_string());
        CompleteStructHeader header_SequenceString;
        header_SequenceString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceString);
        CompleteStructMemberSeq member_seq_SequenceString;
        {
            TypeIdentifierPair type_ids_var_sequence_string;
            ReturnCode_t return_code_var_sequence_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_anonymous_string_unbounded_unbounded", type_ids_var_sequence_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_string)
            {
                return_code_var_sequence_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_var_sequence_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_string)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_var_sequence_string))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_sequence_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_string, element_identifier_anonymous_sequence_anonymous_string_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_anonymous_string_unbounded_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_string.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_anonymous_string_unbounded_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_anonymous_string_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_anonymous_string_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_anonymous_string_unbounded_unbounded, element_flags_anonymous_sequence_anonymous_string_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_anonymous_string_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_anonymous_string_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_anonymous_string_unbounded_unbounded", type_ids_var_sequence_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_anonymous_string_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_string = 0x00000000;
            bool common_var_sequence_string_ec {false};
            CommonStructMember common_var_sequence_string {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_string, member_flags_var_sequence_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_string, common_var_sequence_string_ec))};
            if (!common_var_sequence_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_string = "var_sequence_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_string;
            ann_custom_SequenceString.reset();
            CompleteMemberDetail detail_var_sequence_string = TypeObjectUtils::build_complete_member_detail(name_var_sequence_string, member_ann_builtin_var_sequence_string, ann_custom_SequenceString);
            CompleteStructMember member_var_sequence_string = TypeObjectUtils::build_complete_struct_member(common_var_sequence_string, detail_var_sequence_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceString, member_var_sequence_string);
        }
        CompleteStructType struct_type_SequenceString = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceString, header_SequenceString, member_seq_SequenceString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceString, type_name_SequenceString.to_string(), type_ids_SequenceString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceWString_type_identifier(
        TypeIdentifierPair& type_ids_SequenceWString)
{

    ReturnCode_t return_code_SequenceWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceWString", type_ids_SequenceWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceWString)
    {
        StructTypeFlag struct_flags_SequenceWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceWString = "SequenceWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceWString;
        CompleteTypeDetail detail_SequenceWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceWString, ann_custom_SequenceWString, type_name_SequenceWString.to_string());
        CompleteStructHeader header_SequenceWString;
        header_SequenceWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceWString);
        CompleteStructMemberSeq member_seq_SequenceWString;
        {
            TypeIdentifierPair type_ids_var_sequence_wstring;
            ReturnCode_t return_code_var_sequence_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_anonymous_wstring_unbounded_unbounded", type_ids_var_sequence_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_wstring)
            {
                return_code_var_sequence_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_wstring_unbounded", type_ids_var_sequence_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_wstring)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_wstring_unbounded", type_ids_var_sequence_wstring, true))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_sequence_anonymous_wstring_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_anonymous_wstring_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_wstring, element_identifier_anonymous_sequence_anonymous_wstring_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_anonymous_wstring_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_anonymous_wstring_unbounded_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_wstring.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_anonymous_wstring_unbounded_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_anonymous_wstring_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_anonymous_wstring_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_anonymous_wstring_unbounded_unbounded, element_flags_anonymous_sequence_anonymous_wstring_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_anonymous_wstring_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_anonymous_wstring_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_anonymous_wstring_unbounded_unbounded", type_ids_var_sequence_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_anonymous_wstring_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_wstring = 0x00000000;
            bool common_var_sequence_wstring_ec {false};
            CommonStructMember common_var_sequence_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_wstring, member_flags_var_sequence_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_wstring, common_var_sequence_wstring_ec))};
            if (!common_var_sequence_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_wstring = "var_sequence_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_wstring;
            ann_custom_SequenceWString.reset();
            CompleteMemberDetail detail_var_sequence_wstring = TypeObjectUtils::build_complete_member_detail(name_var_sequence_wstring, member_ann_builtin_var_sequence_wstring, ann_custom_SequenceWString);
            CompleteStructMember member_var_sequence_wstring = TypeObjectUtils::build_complete_struct_member(common_var_sequence_wstring, detail_var_sequence_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceWString, member_var_sequence_wstring);
        }
        CompleteStructType struct_type_SequenceWString = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceWString, header_SequenceWString, member_seq_SequenceWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceWString, type_name_SequenceWString.to_string(), type_ids_SequenceWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceStringBounded_type_identifier(
        TypeIdentifierPair& type_ids_SequenceStringBounded)
{

    ReturnCode_t return_code_SequenceStringBounded {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceStringBounded =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceStringBounded", type_ids_SequenceStringBounded);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceStringBounded)
    {
        StructTypeFlag struct_flags_SequenceStringBounded = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceStringBounded = "SequenceStringBounded";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceStringBounded;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceStringBounded;
        CompleteTypeDetail detail_SequenceStringBounded = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceStringBounded, ann_custom_SequenceStringBounded, type_name_SequenceStringBounded.to_string());
        CompleteStructHeader header_SequenceStringBounded;
        header_SequenceStringBounded = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceStringBounded);
        CompleteStructMemberSeq member_seq_SequenceStringBounded;
        {
            TypeIdentifierPair type_ids_var_sequence_bounded_string;
            ReturnCode_t return_code_var_sequence_bounded_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_bounded_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_anonymous_string_10_unbounded", type_ids_var_sequence_bounded_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_bounded_string)
            {
                return_code_var_sequence_bounded_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_string_helper", type_ids_var_sequence_bounded_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_bounded_string)
                {
                ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_var_sequence_bounded_string);
                }
                bool element_identifier_anonymous_sequence_anonymous_string_10_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_anonymous_string_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_bounded_string, element_identifier_anonymous_sequence_anonymous_string_10_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_anonymous_string_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_anonymous_string_10_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_bounded_string.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_anonymous_string_10_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_anonymous_string_10_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_anonymous_string_10_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_anonymous_string_10_unbounded, element_flags_anonymous_sequence_anonymous_string_10_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_anonymous_string_10_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_anonymous_string_10_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_anonymous_string_10_unbounded", type_ids_var_sequence_bounded_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_anonymous_string_10_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_bounded_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_bounded_string = 0x00000000;
            bool common_var_sequence_bounded_string_ec {false};
            CommonStructMember common_var_sequence_bounded_string {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_bounded_string, member_flags_var_sequence_bounded_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_bounded_string, common_var_sequence_bounded_string_ec))};
            if (!common_var_sequence_bounded_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_bounded_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_bounded_string = "var_sequence_bounded_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_bounded_string;
            ann_custom_SequenceStringBounded.reset();
            CompleteMemberDetail detail_var_sequence_bounded_string = TypeObjectUtils::build_complete_member_detail(name_var_sequence_bounded_string, member_ann_builtin_var_sequence_bounded_string, ann_custom_SequenceStringBounded);
            CompleteStructMember member_var_sequence_bounded_string = TypeObjectUtils::build_complete_struct_member(common_var_sequence_bounded_string, detail_var_sequence_bounded_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceStringBounded, member_var_sequence_bounded_string);
        }
        CompleteStructType struct_type_SequenceStringBounded = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceStringBounded, header_SequenceStringBounded, member_seq_SequenceStringBounded);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceStringBounded, type_name_SequenceStringBounded.to_string(), type_ids_SequenceStringBounded))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceStringBounded already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceWStringBounded_type_identifier(
        TypeIdentifierPair& type_ids_SequenceWStringBounded)
{

    ReturnCode_t return_code_SequenceWStringBounded {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceWStringBounded =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceWStringBounded", type_ids_SequenceWStringBounded);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceWStringBounded)
    {
        StructTypeFlag struct_flags_SequenceWStringBounded = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceWStringBounded = "SequenceWStringBounded";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceWStringBounded;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceWStringBounded;
        CompleteTypeDetail detail_SequenceWStringBounded = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceWStringBounded, ann_custom_SequenceWStringBounded, type_name_SequenceWStringBounded.to_string());
        CompleteStructHeader header_SequenceWStringBounded;
        header_SequenceWStringBounded = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceWStringBounded);
        CompleteStructMemberSeq member_seq_SequenceWStringBounded;
        {
            TypeIdentifierPair type_ids_var_sequence_bounded_wstring;
            ReturnCode_t return_code_var_sequence_bounded_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_bounded_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_anonymous_wstring_10_unbounded", type_ids_var_sequence_bounded_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_bounded_wstring)
            {
                return_code_var_sequence_bounded_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_wstring_helper", type_ids_var_sequence_bounded_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_bounded_wstring)
                {
                ::register_Inner_alias_bounded_wstring_helper_type_identifier(type_ids_var_sequence_bounded_wstring);
                }
                bool element_identifier_anonymous_sequence_anonymous_wstring_10_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_anonymous_wstring_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_bounded_wstring, element_identifier_anonymous_sequence_anonymous_wstring_10_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_anonymous_wstring_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_anonymous_wstring_10_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_bounded_wstring.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_anonymous_wstring_10_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_anonymous_wstring_10_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_anonymous_wstring_10_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_anonymous_wstring_10_unbounded, element_flags_anonymous_sequence_anonymous_wstring_10_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_anonymous_wstring_10_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_anonymous_wstring_10_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_anonymous_wstring_10_unbounded", type_ids_var_sequence_bounded_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_anonymous_wstring_10_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_bounded_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_bounded_wstring = 0x00000000;
            bool common_var_sequence_bounded_wstring_ec {false};
            CommonStructMember common_var_sequence_bounded_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_bounded_wstring, member_flags_var_sequence_bounded_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_bounded_wstring, common_var_sequence_bounded_wstring_ec))};
            if (!common_var_sequence_bounded_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_bounded_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_bounded_wstring = "var_sequence_bounded_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_bounded_wstring;
            ann_custom_SequenceWStringBounded.reset();
            CompleteMemberDetail detail_var_sequence_bounded_wstring = TypeObjectUtils::build_complete_member_detail(name_var_sequence_bounded_wstring, member_ann_builtin_var_sequence_bounded_wstring, ann_custom_SequenceWStringBounded);
            CompleteStructMember member_var_sequence_bounded_wstring = TypeObjectUtils::build_complete_struct_member(common_var_sequence_bounded_wstring, detail_var_sequence_bounded_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceWStringBounded, member_var_sequence_bounded_wstring);
        }
        CompleteStructType struct_type_SequenceWStringBounded = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceWStringBounded, header_SequenceWStringBounded, member_seq_SequenceWStringBounded);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceWStringBounded, type_name_SequenceWStringBounded.to_string(), type_ids_SequenceWStringBounded))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceWStringBounded already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceEnum_type_identifier(
        TypeIdentifierPair& type_ids_SequenceEnum)
{

    ReturnCode_t return_code_SequenceEnum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceEnum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceEnum", type_ids_SequenceEnum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceEnum)
    {
        StructTypeFlag struct_flags_SequenceEnum = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceEnum = "SequenceEnum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceEnum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceEnum;
        CompleteTypeDetail detail_SequenceEnum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceEnum, ann_custom_SequenceEnum, type_name_SequenceEnum.to_string());
        CompleteStructHeader header_SequenceEnum;
        header_SequenceEnum = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceEnum);
        CompleteStructMemberSeq member_seq_SequenceEnum;
        {
            TypeIdentifierPair type_ids_var_sequence_enum;
            ReturnCode_t return_code_var_sequence_enum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_InnerEnumHelper_unbounded", type_ids_var_sequence_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_enum)
            {
                return_code_var_sequence_enum =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerEnumHelper", type_ids_var_sequence_enum);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_enum)
                {
                ::register_InnerEnumHelper_type_identifier(type_ids_var_sequence_enum);
                }
                bool element_identifier_anonymous_sequence_InnerEnumHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_InnerEnumHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_enum, element_identifier_anonymous_sequence_InnerEnumHelper_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_InnerEnumHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_InnerEnumHelper_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_enum.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_InnerEnumHelper_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_InnerEnumHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_InnerEnumHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_InnerEnumHelper_unbounded, element_flags_anonymous_sequence_InnerEnumHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_InnerEnumHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_InnerEnumHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_InnerEnumHelper_unbounded", type_ids_var_sequence_enum))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_InnerEnumHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_enum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_enum = 0x00000000;
            bool common_var_sequence_enum_ec {false};
            CommonStructMember common_var_sequence_enum {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_enum, member_flags_var_sequence_enum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_enum, common_var_sequence_enum_ec))};
            if (!common_var_sequence_enum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_enum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_enum = "var_sequence_enum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_enum;
            ann_custom_SequenceEnum.reset();
            CompleteMemberDetail detail_var_sequence_enum = TypeObjectUtils::build_complete_member_detail(name_var_sequence_enum, member_ann_builtin_var_sequence_enum, ann_custom_SequenceEnum);
            CompleteStructMember member_var_sequence_enum = TypeObjectUtils::build_complete_struct_member(common_var_sequence_enum, detail_var_sequence_enum);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceEnum, member_var_sequence_enum);
        }
        CompleteStructType struct_type_SequenceEnum = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceEnum, header_SequenceEnum, member_seq_SequenceEnum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceEnum, type_name_SequenceEnum.to_string(), type_ids_SequenceEnum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceEnum already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceBitMask_type_identifier(
        TypeIdentifierPair& type_ids_SequenceBitMask)
{

    ReturnCode_t return_code_SequenceBitMask {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceBitMask =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceBitMask", type_ids_SequenceBitMask);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceBitMask)
    {
        StructTypeFlag struct_flags_SequenceBitMask = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceBitMask = "SequenceBitMask";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceBitMask;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceBitMask;
        CompleteTypeDetail detail_SequenceBitMask = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceBitMask, ann_custom_SequenceBitMask, type_name_SequenceBitMask.to_string());
        CompleteStructHeader header_SequenceBitMask;
        header_SequenceBitMask = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceBitMask);
        CompleteStructMemberSeq member_seq_SequenceBitMask;
        {
            TypeIdentifierPair type_ids_var_sequence_bitmask;
            ReturnCode_t return_code_var_sequence_bitmask {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_bitmask =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_InnerBitMaskHelper_unbounded", type_ids_var_sequence_bitmask);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_bitmask)
            {
                return_code_var_sequence_bitmask =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitMaskHelper", type_ids_var_sequence_bitmask);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_bitmask)
                {
                ::register_InnerBitMaskHelper_type_identifier(type_ids_var_sequence_bitmask);
                }
                bool element_identifier_anonymous_sequence_InnerBitMaskHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_InnerBitMaskHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_bitmask, element_identifier_anonymous_sequence_InnerBitMaskHelper_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_InnerBitMaskHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_InnerBitMaskHelper_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_bitmask.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_InnerBitMaskHelper_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_InnerBitMaskHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_InnerBitMaskHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_InnerBitMaskHelper_unbounded, element_flags_anonymous_sequence_InnerBitMaskHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_InnerBitMaskHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_InnerBitMaskHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_InnerBitMaskHelper_unbounded", type_ids_var_sequence_bitmask))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_InnerBitMaskHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_bitmask = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_bitmask = 0x00000000;
            bool common_var_sequence_bitmask_ec {false};
            CommonStructMember common_var_sequence_bitmask {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_bitmask, member_flags_var_sequence_bitmask, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_bitmask, common_var_sequence_bitmask_ec))};
            if (!common_var_sequence_bitmask_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_bitmask member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_bitmask = "var_sequence_bitmask";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_bitmask;
            ann_custom_SequenceBitMask.reset();
            CompleteMemberDetail detail_var_sequence_bitmask = TypeObjectUtils::build_complete_member_detail(name_var_sequence_bitmask, member_ann_builtin_var_sequence_bitmask, ann_custom_SequenceBitMask);
            CompleteStructMember member_var_sequence_bitmask = TypeObjectUtils::build_complete_struct_member(common_var_sequence_bitmask, detail_var_sequence_bitmask);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceBitMask, member_var_sequence_bitmask);
        }
        CompleteStructType struct_type_SequenceBitMask = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceBitMask, header_SequenceBitMask, member_seq_SequenceBitMask);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceBitMask, type_name_SequenceBitMask.to_string(), type_ids_SequenceBitMask))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceBitMask already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceAlias_type_identifier(
        TypeIdentifierPair& type_ids_SequenceAlias)
{

    ReturnCode_t return_code_SequenceAlias {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceAlias =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceAlias", type_ids_SequenceAlias);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceAlias)
    {
        StructTypeFlag struct_flags_SequenceAlias = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceAlias = "SequenceAlias";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceAlias;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceAlias;
        CompleteTypeDetail detail_SequenceAlias = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceAlias, ann_custom_SequenceAlias, type_name_SequenceAlias.to_string());
        CompleteStructHeader header_SequenceAlias;
        header_SequenceAlias = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceAlias);
        CompleteStructMemberSeq member_seq_SequenceAlias;
        {
            TypeIdentifierPair type_ids_var_sequence_alias;
            ReturnCode_t return_code_var_sequence_alias {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_InnerAliasHelper_unbounded", type_ids_var_sequence_alias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_alias)
            {
                return_code_var_sequence_alias =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerAliasHelper", type_ids_var_sequence_alias);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_alias)
                {
                ::register_InnerAliasHelper_type_identifier(type_ids_var_sequence_alias);
                }
                bool element_identifier_anonymous_sequence_InnerAliasHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_InnerAliasHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_alias, element_identifier_anonymous_sequence_InnerAliasHelper_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_InnerAliasHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_InnerAliasHelper_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_alias.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_InnerAliasHelper_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_InnerAliasHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_InnerAliasHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_InnerAliasHelper_unbounded, element_flags_anonymous_sequence_InnerAliasHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_InnerAliasHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_InnerAliasHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_InnerAliasHelper_unbounded", type_ids_var_sequence_alias))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_InnerAliasHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_alias = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_alias = 0x00000000;
            bool common_var_sequence_alias_ec {false};
            CommonStructMember common_var_sequence_alias {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_alias, member_flags_var_sequence_alias, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_alias, common_var_sequence_alias_ec))};
            if (!common_var_sequence_alias_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_alias member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_alias = "var_sequence_alias";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_alias;
            ann_custom_SequenceAlias.reset();
            CompleteMemberDetail detail_var_sequence_alias = TypeObjectUtils::build_complete_member_detail(name_var_sequence_alias, member_ann_builtin_var_sequence_alias, ann_custom_SequenceAlias);
            CompleteStructMember member_var_sequence_alias = TypeObjectUtils::build_complete_struct_member(common_var_sequence_alias, detail_var_sequence_alias);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceAlias, member_var_sequence_alias);
        }
        CompleteStructType struct_type_SequenceAlias = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceAlias, header_SequenceAlias, member_seq_SequenceAlias);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceAlias, type_name_SequenceAlias.to_string(), type_ids_SequenceAlias))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceAlias already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceShortArray_type_identifier(
        TypeIdentifierPair& type_ids_SequenceShortArray)
{

    ReturnCode_t return_code_SequenceShortArray {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceShortArray =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceShortArray", type_ids_SequenceShortArray);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceShortArray)
    {
        StructTypeFlag struct_flags_SequenceShortArray = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceShortArray = "SequenceShortArray";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceShortArray;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceShortArray;
        CompleteTypeDetail detail_SequenceShortArray = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceShortArray, ann_custom_SequenceShortArray, type_name_SequenceShortArray.to_string());
        CompleteStructHeader header_SequenceShortArray;
        header_SequenceShortArray = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceShortArray);
        CompleteStructMemberSeq member_seq_SequenceShortArray;
        {
            TypeIdentifierPair type_ids_var_sequence_short_array;
            ReturnCode_t return_code_var_sequence_short_array {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_short_array =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_anonymous_array_int16_t_2_unbounded", type_ids_var_sequence_short_array);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_short_array)
            {
                return_code_var_sequence_short_array =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_array_helper", type_ids_var_sequence_short_array);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_short_array)
                {
                ::register_Inner_alias_array_helper_type_identifier(type_ids_var_sequence_short_array);
                }
                bool element_identifier_anonymous_sequence_anonymous_array_int16_t_2_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_anonymous_array_int16_t_2_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_short_array, element_identifier_anonymous_sequence_anonymous_array_int16_t_2_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_anonymous_array_int16_t_2_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_anonymous_array_int16_t_2_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_short_array.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_anonymous_array_int16_t_2_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_anonymous_array_int16_t_2_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_anonymous_array_int16_t_2_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_anonymous_array_int16_t_2_unbounded, element_flags_anonymous_sequence_anonymous_array_int16_t_2_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_anonymous_array_int16_t_2_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_anonymous_array_int16_t_2_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_anonymous_array_int16_t_2_unbounded", type_ids_var_sequence_short_array))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_anonymous_array_int16_t_2_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_short_array = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_short_array = 0x00000000;
            bool common_var_sequence_short_array_ec {false};
            CommonStructMember common_var_sequence_short_array {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_short_array, member_flags_var_sequence_short_array, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_short_array, common_var_sequence_short_array_ec))};
            if (!common_var_sequence_short_array_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_short_array member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_short_array = "var_sequence_short_array";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_short_array;
            ann_custom_SequenceShortArray.reset();
            CompleteMemberDetail detail_var_sequence_short_array = TypeObjectUtils::build_complete_member_detail(name_var_sequence_short_array, member_ann_builtin_var_sequence_short_array, ann_custom_SequenceShortArray);
            CompleteStructMember member_var_sequence_short_array = TypeObjectUtils::build_complete_struct_member(common_var_sequence_short_array, detail_var_sequence_short_array);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceShortArray, member_var_sequence_short_array);
        }
        CompleteStructType struct_type_SequenceShortArray = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceShortArray, header_SequenceShortArray, member_seq_SequenceShortArray);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceShortArray, type_name_SequenceShortArray.to_string(), type_ids_SequenceShortArray))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceShortArray already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceSequence_type_identifier(
        TypeIdentifierPair& type_ids_SequenceSequence)
{

    ReturnCode_t return_code_SequenceSequence {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceSequence =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceSequence", type_ids_SequenceSequence);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceSequence)
    {
        StructTypeFlag struct_flags_SequenceSequence = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceSequence = "SequenceSequence";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceSequence;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceSequence;
        CompleteTypeDetail detail_SequenceSequence = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceSequence, ann_custom_SequenceSequence, type_name_SequenceSequence.to_string());
        CompleteStructHeader header_SequenceSequence;
        header_SequenceSequence = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceSequence);
        CompleteStructMemberSeq member_seq_SequenceSequence;
        {
            TypeIdentifierPair type_ids_var_sequence_sequence;
            ReturnCode_t return_code_var_sequence_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded", type_ids_var_sequence_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_sequence)
            {
                return_code_var_sequence_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_sequence_helper", type_ids_var_sequence_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_sequence)
                {
                ::register_Inner_alias_sequence_helper_type_identifier(type_ids_var_sequence_sequence);
                }
                bool element_identifier_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_sequence, element_identifier_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded, element_flags_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded", type_ids_var_sequence_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_anonymous_sequence_int16_t_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_sequence = 0x00000000;
            bool common_var_sequence_sequence_ec {false};
            CommonStructMember common_var_sequence_sequence {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_sequence, member_flags_var_sequence_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_sequence, common_var_sequence_sequence_ec))};
            if (!common_var_sequence_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_sequence = "var_sequence_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_sequence;
            ann_custom_SequenceSequence.reset();
            CompleteMemberDetail detail_var_sequence_sequence = TypeObjectUtils::build_complete_member_detail(name_var_sequence_sequence, member_ann_builtin_var_sequence_sequence, ann_custom_SequenceSequence);
            CompleteStructMember member_var_sequence_sequence = TypeObjectUtils::build_complete_struct_member(common_var_sequence_sequence, detail_var_sequence_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceSequence, member_var_sequence_sequence);
        }
        CompleteStructType struct_type_SequenceSequence = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceSequence, header_SequenceSequence, member_seq_SequenceSequence);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceSequence, type_name_SequenceSequence.to_string(), type_ids_SequenceSequence))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceSequence already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceMap_type_identifier(
        TypeIdentifierPair& type_ids_SequenceMap)
{

    ReturnCode_t return_code_SequenceMap {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceMap =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceMap", type_ids_SequenceMap);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceMap)
    {
        StructTypeFlag struct_flags_SequenceMap = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceMap = "SequenceMap";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceMap;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceMap;
        CompleteTypeDetail detail_SequenceMap = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceMap, ann_custom_SequenceMap, type_name_SequenceMap.to_string());
        CompleteStructHeader header_SequenceMap;
        header_SequenceMap = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceMap);
        CompleteStructMemberSeq member_seq_SequenceMap;
        {
            TypeIdentifierPair type_ids_var_sequence_map;
            ReturnCode_t return_code_var_sequence_map {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded", type_ids_var_sequence_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_map)
            {
                return_code_var_sequence_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_map_helper", type_ids_var_sequence_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_map)
                {
                ::register_Inner_alias_map_helper_type_identifier(type_ids_var_sequence_map);
                }
                bool element_identifier_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_map, element_identifier_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_map.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded, element_flags_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded", type_ids_var_sequence_map))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_anonymous_map_int32_t_int32_t_0_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_map = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_map = 0x00000000;
            bool common_var_sequence_map_ec {false};
            CommonStructMember common_var_sequence_map {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_map, member_flags_var_sequence_map, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_map, common_var_sequence_map_ec))};
            if (!common_var_sequence_map_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_map member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_map = "var_sequence_map";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_map;
            ann_custom_SequenceMap.reset();
            CompleteMemberDetail detail_var_sequence_map = TypeObjectUtils::build_complete_member_detail(name_var_sequence_map, member_ann_builtin_var_sequence_map, ann_custom_SequenceMap);
            CompleteStructMember member_var_sequence_map = TypeObjectUtils::build_complete_struct_member(common_var_sequence_map, detail_var_sequence_map);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceMap, member_var_sequence_map);
        }
        CompleteStructType struct_type_SequenceMap = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceMap, header_SequenceMap, member_seq_SequenceMap);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceMap, type_name_SequenceMap.to_string(), type_ids_SequenceMap))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceMap already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceUnion_type_identifier(
        TypeIdentifierPair& type_ids_SequenceUnion)
{

    ReturnCode_t return_code_SequenceUnion {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceUnion =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceUnion", type_ids_SequenceUnion);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceUnion)
    {
        StructTypeFlag struct_flags_SequenceUnion = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceUnion = "SequenceUnion";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceUnion;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceUnion;
        CompleteTypeDetail detail_SequenceUnion = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceUnion, ann_custom_SequenceUnion, type_name_SequenceUnion.to_string());
        CompleteStructHeader header_SequenceUnion;
        header_SequenceUnion = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceUnion);
        CompleteStructMemberSeq member_seq_SequenceUnion;
        {
            TypeIdentifierPair type_ids_var_sequence_union;
            ReturnCode_t return_code_var_sequence_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_InnerUnionHelper_unbounded", type_ids_var_sequence_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_union)
            {
                return_code_var_sequence_union =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerUnionHelper", type_ids_var_sequence_union);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_union)
                {
                ::register_InnerUnionHelper_type_identifier(type_ids_var_sequence_union);
                }
                bool element_identifier_anonymous_sequence_InnerUnionHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_InnerUnionHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_union, element_identifier_anonymous_sequence_InnerUnionHelper_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_InnerUnionHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_InnerUnionHelper_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_union.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_InnerUnionHelper_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_InnerUnionHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_InnerUnionHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_InnerUnionHelper_unbounded, element_flags_anonymous_sequence_InnerUnionHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_InnerUnionHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_InnerUnionHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_InnerUnionHelper_unbounded", type_ids_var_sequence_union))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_InnerUnionHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_union = 0x00000000;
            bool common_var_sequence_union_ec {false};
            CommonStructMember common_var_sequence_union {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_union, member_flags_var_sequence_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_union, common_var_sequence_union_ec))};
            if (!common_var_sequence_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_union = "var_sequence_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_union;
            ann_custom_SequenceUnion.reset();
            CompleteMemberDetail detail_var_sequence_union = TypeObjectUtils::build_complete_member_detail(name_var_sequence_union, member_ann_builtin_var_sequence_union, ann_custom_SequenceUnion);
            CompleteStructMember member_var_sequence_union = TypeObjectUtils::build_complete_struct_member(common_var_sequence_union, detail_var_sequence_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceUnion, member_var_sequence_union);
        }
        CompleteStructType struct_type_SequenceUnion = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceUnion, header_SequenceUnion, member_seq_SequenceUnion);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceUnion, type_name_SequenceUnion.to_string(), type_ids_SequenceUnion))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceUnion already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceStructure_type_identifier(
        TypeIdentifierPair& type_ids_SequenceStructure)
{

    ReturnCode_t return_code_SequenceStructure {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceStructure =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceStructure", type_ids_SequenceStructure);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceStructure)
    {
        StructTypeFlag struct_flags_SequenceStructure = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceStructure = "SequenceStructure";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceStructure;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceStructure;
        CompleteTypeDetail detail_SequenceStructure = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceStructure, ann_custom_SequenceStructure, type_name_SequenceStructure.to_string());
        CompleteStructHeader header_SequenceStructure;
        header_SequenceStructure = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceStructure);
        CompleteStructMemberSeq member_seq_SequenceStructure;
        {
            TypeIdentifierPair type_ids_var_sequence_structure;
            ReturnCode_t return_code_var_sequence_structure {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_structure =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_InnerStructureHelper_unbounded", type_ids_var_sequence_structure);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_structure)
            {
                return_code_var_sequence_structure =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerStructureHelper", type_ids_var_sequence_structure);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_structure)
                {
                ::register_InnerStructureHelper_type_identifier(type_ids_var_sequence_structure);
                }
                bool element_identifier_anonymous_sequence_InnerStructureHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_InnerStructureHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_structure, element_identifier_anonymous_sequence_InnerStructureHelper_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_InnerStructureHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_InnerStructureHelper_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_structure.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_InnerStructureHelper_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_InnerStructureHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_InnerStructureHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_InnerStructureHelper_unbounded, element_flags_anonymous_sequence_InnerStructureHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_InnerStructureHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_InnerStructureHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_InnerStructureHelper_unbounded", type_ids_var_sequence_structure))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_InnerStructureHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_structure = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_structure = 0x00000000;
            bool common_var_sequence_structure_ec {false};
            CommonStructMember common_var_sequence_structure {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_structure, member_flags_var_sequence_structure, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_structure, common_var_sequence_structure_ec))};
            if (!common_var_sequence_structure_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_structure member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_structure = "var_sequence_structure";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_structure;
            ann_custom_SequenceStructure.reset();
            CompleteMemberDetail detail_var_sequence_structure = TypeObjectUtils::build_complete_member_detail(name_var_sequence_structure, member_ann_builtin_var_sequence_structure, ann_custom_SequenceStructure);
            CompleteStructMember member_var_sequence_structure = TypeObjectUtils::build_complete_struct_member(common_var_sequence_structure, detail_var_sequence_structure);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceStructure, member_var_sequence_structure);
        }
        CompleteStructType struct_type_SequenceStructure = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceStructure, header_SequenceStructure, member_seq_SequenceStructure);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceStructure, type_name_SequenceStructure.to_string(), type_ids_SequenceStructure))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceStructure already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceBitset_type_identifier(
        TypeIdentifierPair& type_ids_SequenceBitset)
{

    ReturnCode_t return_code_SequenceBitset {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceBitset =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceBitset", type_ids_SequenceBitset);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceBitset)
    {
        StructTypeFlag struct_flags_SequenceBitset = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceBitset = "SequenceBitset";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceBitset;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceBitset;
        CompleteTypeDetail detail_SequenceBitset = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceBitset, ann_custom_SequenceBitset, type_name_SequenceBitset.to_string());
        CompleteStructHeader header_SequenceBitset;
        header_SequenceBitset = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceBitset);
        CompleteStructMemberSeq member_seq_SequenceBitset;
        {
            TypeIdentifierPair type_ids_var_sequence_bitset;
            ReturnCode_t return_code_var_sequence_bitset {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_bitset =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_InnerBitsetHelper_unbounded", type_ids_var_sequence_bitset);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_bitset)
            {
                return_code_var_sequence_bitset =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitsetHelper", type_ids_var_sequence_bitset);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_bitset)
                {
                ::register_InnerBitsetHelper_type_identifier(type_ids_var_sequence_bitset);
                }
                bool element_identifier_anonymous_sequence_InnerBitsetHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_InnerBitsetHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_bitset, element_identifier_anonymous_sequence_InnerBitsetHelper_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_InnerBitsetHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_InnerBitsetHelper_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_bitset.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_InnerBitsetHelper_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_InnerBitsetHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_InnerBitsetHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_InnerBitsetHelper_unbounded, element_flags_anonymous_sequence_InnerBitsetHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_InnerBitsetHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_InnerBitsetHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_InnerBitsetHelper_unbounded", type_ids_var_sequence_bitset))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_InnerBitsetHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_bitset = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_bitset = 0x00000000;
            bool common_var_sequence_bitset_ec {false};
            CommonStructMember common_var_sequence_bitset {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_bitset, member_flags_var_sequence_bitset, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_bitset, common_var_sequence_bitset_ec))};
            if (!common_var_sequence_bitset_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_bitset member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_bitset = "var_sequence_bitset";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_bitset;
            ann_custom_SequenceBitset.reset();
            CompleteMemberDetail detail_var_sequence_bitset = TypeObjectUtils::build_complete_member_detail(name_var_sequence_bitset, member_ann_builtin_var_sequence_bitset, ann_custom_SequenceBitset);
            CompleteStructMember member_var_sequence_bitset = TypeObjectUtils::build_complete_struct_member(common_var_sequence_bitset, detail_var_sequence_bitset);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceBitset, member_var_sequence_bitset);
        }
        CompleteStructType struct_type_SequenceBitset = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceBitset, header_SequenceBitset, member_seq_SequenceBitset);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceBitset, type_name_SequenceBitset.to_string(), type_ids_SequenceBitset))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceBitset already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_BoundedSmallSequences_type_identifier(
        TypeIdentifierPair& type_ids_BoundedSmallSequences)
{

    ReturnCode_t return_code_BoundedSmallSequences {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BoundedSmallSequences =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BoundedSmallSequences", type_ids_BoundedSmallSequences);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BoundedSmallSequences)
    {
        StructTypeFlag struct_flags_BoundedSmallSequences = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_BoundedSmallSequences = "BoundedSmallSequences";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BoundedSmallSequences;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BoundedSmallSequences;
        CompleteTypeDetail detail_BoundedSmallSequences = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BoundedSmallSequences, ann_custom_BoundedSmallSequences, type_name_BoundedSmallSequences.to_string());
        CompleteStructHeader header_BoundedSmallSequences;
        header_BoundedSmallSequences = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_BoundedSmallSequences);
        CompleteStructMemberSeq member_seq_BoundedSmallSequences;
        {
            TypeIdentifierPair type_ids_var_sequence_small;
            ReturnCode_t return_code_var_sequence_small {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_small =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_1", type_ids_var_sequence_small);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_small)
            {
                return_code_var_sequence_small =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_sequence_small);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_small)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_1_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_1 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_small, element_identifier_anonymous_sequence_int16_t_1_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_1_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_1 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_small.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_1 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_1 = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_1 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_1, element_flags_anonymous_sequence_int16_t_1);
                {
                    SBound bound = static_cast<SBound>(1);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_1, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_1));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_1", type_ids_var_sequence_small))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_1 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_small = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_small = 0x00000000;
            bool common_var_sequence_small_ec {false};
            CommonStructMember common_var_sequence_small {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_small, member_flags_var_sequence_small, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_small, common_var_sequence_small_ec))};
            if (!common_var_sequence_small_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_small member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_small = "var_sequence_small";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_small;
            ann_custom_BoundedSmallSequences.reset();
            CompleteMemberDetail detail_var_sequence_small = TypeObjectUtils::build_complete_member_detail(name_var_sequence_small, member_ann_builtin_var_sequence_small, ann_custom_BoundedSmallSequences);
            CompleteStructMember member_var_sequence_small = TypeObjectUtils::build_complete_struct_member(common_var_sequence_small, detail_var_sequence_small);
            TypeObjectUtils::add_complete_struct_member(member_seq_BoundedSmallSequences, member_var_sequence_small);
        }
        {
            TypeIdentifierPair type_ids_var_unbounded_string_small_bounded_sequence;
            ReturnCode_t return_code_var_unbounded_string_small_bounded_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_unbounded_string_small_bounded_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_anonymous_string_unbounded_5", type_ids_var_unbounded_string_small_bounded_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_unbounded_string_small_bounded_sequence)
            {
                return_code_var_unbounded_string_small_bounded_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_var_unbounded_string_small_bounded_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_unbounded_string_small_bounded_sequence)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_var_unbounded_string_small_bounded_sequence))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_sequence_anonymous_string_unbounded_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_anonymous_string_unbounded_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_unbounded_string_small_bounded_sequence, element_identifier_anonymous_sequence_anonymous_string_unbounded_5_ec))};
                if (!element_identifier_anonymous_sequence_anonymous_string_unbounded_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_anonymous_string_unbounded_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_unbounded_string_small_bounded_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_anonymous_string_unbounded_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_anonymous_string_unbounded_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_anonymous_string_unbounded_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_anonymous_string_unbounded_5, element_flags_anonymous_sequence_anonymous_string_unbounded_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_anonymous_string_unbounded_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_anonymous_string_unbounded_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_anonymous_string_unbounded_5", type_ids_var_unbounded_string_small_bounded_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_anonymous_string_unbounded_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_unbounded_string_small_bounded_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_unbounded_string_small_bounded_sequence = 0x00000001;
            bool common_var_unbounded_string_small_bounded_sequence_ec {false};
            CommonStructMember common_var_unbounded_string_small_bounded_sequence {TypeObjectUtils::build_common_struct_member(member_id_var_unbounded_string_small_bounded_sequence, member_flags_var_unbounded_string_small_bounded_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_unbounded_string_small_bounded_sequence, common_var_unbounded_string_small_bounded_sequence_ec))};
            if (!common_var_unbounded_string_small_bounded_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_unbounded_string_small_bounded_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_unbounded_string_small_bounded_sequence = "var_unbounded_string_small_bounded_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_unbounded_string_small_bounded_sequence;
            ann_custom_BoundedSmallSequences.reset();
            CompleteMemberDetail detail_var_unbounded_string_small_bounded_sequence = TypeObjectUtils::build_complete_member_detail(name_var_unbounded_string_small_bounded_sequence, member_ann_builtin_var_unbounded_string_small_bounded_sequence, ann_custom_BoundedSmallSequences);
            CompleteStructMember member_var_unbounded_string_small_bounded_sequence = TypeObjectUtils::build_complete_struct_member(common_var_unbounded_string_small_bounded_sequence, detail_var_unbounded_string_small_bounded_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_BoundedSmallSequences, member_var_unbounded_string_small_bounded_sequence);
        }
        CompleteStructType struct_type_BoundedSmallSequences = TypeObjectUtils::build_complete_struct_type(struct_flags_BoundedSmallSequences, header_BoundedSmallSequences, member_seq_BoundedSmallSequences);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_BoundedSmallSequences, type_name_BoundedSmallSequences.to_string(), type_ids_BoundedSmallSequences))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "BoundedSmallSequences already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_BoundedBigSequences_type_identifier(
        TypeIdentifierPair& type_ids_BoundedBigSequences)
{

    ReturnCode_t return_code_BoundedBigSequences {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BoundedBigSequences =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BoundedBigSequences", type_ids_BoundedBigSequences);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BoundedBigSequences)
    {
        StructTypeFlag struct_flags_BoundedBigSequences = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_BoundedBigSequences = "BoundedBigSequences";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BoundedBigSequences;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BoundedBigSequences;
        CompleteTypeDetail detail_BoundedBigSequences = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BoundedBigSequences, ann_custom_BoundedBigSequences, type_name_BoundedBigSequences.to_string());
        CompleteStructHeader header_BoundedBigSequences;
        header_BoundedBigSequences = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_BoundedBigSequences);
        CompleteStructMemberSeq member_seq_BoundedBigSequences;
        {
            TypeIdentifierPair type_ids_var_sequence_big;
            ReturnCode_t return_code_var_sequence_big {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence_big =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_41925", type_ids_var_sequence_big);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_big)
            {
                return_code_var_sequence_big =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_sequence_big);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence_big)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_41925_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_41925 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_big, element_identifier_anonymous_sequence_int16_t_41925_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_41925_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_41925 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence_big.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_41925 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_41925 = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_41925 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_41925, element_flags_anonymous_sequence_int16_t_41925);
                {
                    LBound bound = 41925;
                    PlainSequenceLElemDefn seq_ldefn = TypeObjectUtils::build_plain_sequence_l_elem_defn(header_anonymous_sequence_int16_t_41925, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_41925));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_l_sequence_type_identifier(seq_ldefn, "anonymous_sequence_int16_t_41925", type_ids_var_sequence_big))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_41925 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence_big = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence_big = 0x00000000;
            bool common_var_sequence_big_ec {false};
            CommonStructMember common_var_sequence_big {TypeObjectUtils::build_common_struct_member(member_id_var_sequence_big, member_flags_var_sequence_big, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence_big, common_var_sequence_big_ec))};
            if (!common_var_sequence_big_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence_big member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence_big = "var_sequence_big";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence_big;
            ann_custom_BoundedBigSequences.reset();
            CompleteMemberDetail detail_var_sequence_big = TypeObjectUtils::build_complete_member_detail(name_var_sequence_big, member_ann_builtin_var_sequence_big, ann_custom_BoundedBigSequences);
            CompleteStructMember member_var_sequence_big = TypeObjectUtils::build_complete_struct_member(common_var_sequence_big, detail_var_sequence_big);
            TypeObjectUtils::add_complete_struct_member(member_seq_BoundedBigSequences, member_var_sequence_big);
        }
        {
            TypeIdentifierPair type_ids_var_unbounded_string_large_bounded_sequence;
            ReturnCode_t return_code_var_unbounded_string_large_bounded_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_unbounded_string_large_bounded_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_anonymous_string_unbounded_256", type_ids_var_unbounded_string_large_bounded_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_unbounded_string_large_bounded_sequence)
            {
                return_code_var_unbounded_string_large_bounded_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_var_unbounded_string_large_bounded_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_unbounded_string_large_bounded_sequence)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_var_unbounded_string_large_bounded_sequence))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_sequence_anonymous_string_unbounded_256_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_anonymous_string_unbounded_256 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_unbounded_string_large_bounded_sequence, element_identifier_anonymous_sequence_anonymous_string_unbounded_256_ec))};
                if (!element_identifier_anonymous_sequence_anonymous_string_unbounded_256_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_anonymous_string_unbounded_256 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_unbounded_string_large_bounded_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_anonymous_string_unbounded_256 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_anonymous_string_unbounded_256 = 0;
                PlainCollectionHeader header_anonymous_sequence_anonymous_string_unbounded_256 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_anonymous_string_unbounded_256, element_flags_anonymous_sequence_anonymous_string_unbounded_256);
                {
                    LBound bound = 256;
                    PlainSequenceLElemDefn seq_ldefn = TypeObjectUtils::build_plain_sequence_l_elem_defn(header_anonymous_sequence_anonymous_string_unbounded_256, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_anonymous_string_unbounded_256));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_l_sequence_type_identifier(seq_ldefn, "anonymous_sequence_anonymous_string_unbounded_256", type_ids_var_unbounded_string_large_bounded_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_anonymous_string_unbounded_256 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_unbounded_string_large_bounded_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_unbounded_string_large_bounded_sequence = 0x00000001;
            bool common_var_unbounded_string_large_bounded_sequence_ec {false};
            CommonStructMember common_var_unbounded_string_large_bounded_sequence {TypeObjectUtils::build_common_struct_member(member_id_var_unbounded_string_large_bounded_sequence, member_flags_var_unbounded_string_large_bounded_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_unbounded_string_large_bounded_sequence, common_var_unbounded_string_large_bounded_sequence_ec))};
            if (!common_var_unbounded_string_large_bounded_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_unbounded_string_large_bounded_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_unbounded_string_large_bounded_sequence = "var_unbounded_string_large_bounded_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_unbounded_string_large_bounded_sequence;
            ann_custom_BoundedBigSequences.reset();
            CompleteMemberDetail detail_var_unbounded_string_large_bounded_sequence = TypeObjectUtils::build_complete_member_detail(name_var_unbounded_string_large_bounded_sequence, member_ann_builtin_var_unbounded_string_large_bounded_sequence, ann_custom_BoundedBigSequences);
            CompleteStructMember member_var_unbounded_string_large_bounded_sequence = TypeObjectUtils::build_complete_struct_member(common_var_unbounded_string_large_bounded_sequence, detail_var_unbounded_string_large_bounded_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_BoundedBigSequences, member_var_unbounded_string_large_bounded_sequence);
        }
        CompleteStructType struct_type_BoundedBigSequences = TypeObjectUtils::build_complete_struct_type(struct_flags_BoundedBigSequences, header_BoundedBigSequences, member_seq_BoundedBigSequences);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_BoundedBigSequences, type_name_BoundedBigSequences.to_string(), type_ids_BoundedBigSequences))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "BoundedBigSequences already registered in TypeObjectRegistry for a different type.");
        }
    }
}

