/*******************************************************************************
*
*       This file is part of the General Hidden Markov Model Library,
*       GHMM version __VERSION__, see http://ghmm.org
*
*       Filename: ghmm/ghmmwrapper/pclasschange.h
*       Authors:  Matthias Heinig, Janne Grunau
*
*       Copyright (C) 1998-2004 Alexander Schliep
*       Copyright (C) 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
*       Copyright (C) 2002-2004 Max-Planck-Institut fuer Molekulare Genetik,
*                               Berlin
*
*       Contact: schliep@ghmm.org
*
*       This library is free software; you can redistribute it and/or
*       modify it under the terms of the GNU Library General Public
*       License as published by the Free Software Foundation; either
*       version 2 of the License, or (at your option) any later version.
*
*       This library is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*       Library General Public License for more details.
*
*       You should have received a copy of the GNU Library General Public
*       License along with this library; if not, write to the Free
*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*
*       This file is version $Revision: 1713 $
*                       from $Date: 2006-10-16 10:06:28 -0400 (Mon, 16 Oct 2006) $
*             last change by $Author: grunau $.
*
*******************************************************************************/

#ifndef PCLASSCHANGE_H
#define PCLASSCHANGE_H

#include <ghmm/pmodel.h>
#include <ghmm/psequence.h>


struct threshold_user_data {
  /** which double value in myseq **/
  int seq_index;
  /** cut off value **/
  double threshold;
  /** add this to the index in sequence X **/
  int offset_x;
  /** add this to the index in sequence Y **/
  int offset_y;
};
typedef struct threshold_user_data threshold_user_data;

struct boolean_user_data {
  /** which double value in myseq **/
  int seq_index;
  /** add this to the index in sequence X **/
  int offset_x;
  /** add this to the index in sequence Y **/
  int offset_y;
};
typedef struct boolean_user_data boolean_user_data;

int gt_sum(ghmm_dpmodel *mo, ghmm_dpseq *X, ghmm_dpseq *Y, int index_x, int index_y, void *user_data);

int lt_sum(ghmm_dpmodel *mo, ghmm_dpseq *X, ghmm_dpseq *Y, int index_x, int index_y, void *user_data);

int boolean_and(ghmm_dpmodel *mo, ghmm_dpseq *X, ghmm_dpseq *Y, int index_x, int index_y, void *user_data);

int boolean_or(ghmm_dpmodel *mo, ghmm_dpseq *X, ghmm_dpseq *Y, int index_x, int index_y, void *user_data);

void set_to_lt_sum(ghmm_dpmodel_class_change_context *pccc, int seq_index, double threshold, int offset_x, int offset_y);

void set_to_gt_sum(ghmm_dpmodel_class_change_context *pccc, int seq_index, double threshold, int offset_x, int offset_y);

void set_to_boolean_and(ghmm_dpmodel_class_change_context *pccc, int seq_index, int offset_x, int offset_y);

void set_to_boolean_or(ghmm_dpmodel_class_change_context *pccc, int seq_index, int offset_x, int offset_y);
#endif
