// Code generated by smithy-go-codegen DO NOT EDIT.

package fis

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/fis/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the target account configurations of the specified experiment template.
func (c *Client) ListTargetAccountConfigurations(ctx context.Context, params *ListTargetAccountConfigurationsInput, optFns ...func(*Options)) (*ListTargetAccountConfigurationsOutput, error) {
	if params == nil {
		params = &ListTargetAccountConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTargetAccountConfigurations", params, optFns, c.addOperationListTargetAccountConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTargetAccountConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTargetAccountConfigurationsInput struct {

	// The ID of the experiment template.
	//
	// This member is required.
	ExperimentTemplateId *string

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListTargetAccountConfigurationsOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// The target account configurations.
	TargetAccountConfigurations []types.TargetAccountConfigurationSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTargetAccountConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTargetAccountConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTargetAccountConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTargetAccountConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListTargetAccountConfigurationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTargetAccountConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTargetAccountConfigurationsAPIClient is a client that implements the
// ListTargetAccountConfigurations operation.
type ListTargetAccountConfigurationsAPIClient interface {
	ListTargetAccountConfigurations(context.Context, *ListTargetAccountConfigurationsInput, ...func(*Options)) (*ListTargetAccountConfigurationsOutput, error)
}

var _ ListTargetAccountConfigurationsAPIClient = (*Client)(nil)

// ListTargetAccountConfigurationsPaginatorOptions is the paginator options for
// ListTargetAccountConfigurations
type ListTargetAccountConfigurationsPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTargetAccountConfigurationsPaginator is a paginator for
// ListTargetAccountConfigurations
type ListTargetAccountConfigurationsPaginator struct {
	options   ListTargetAccountConfigurationsPaginatorOptions
	client    ListTargetAccountConfigurationsAPIClient
	params    *ListTargetAccountConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListTargetAccountConfigurationsPaginator returns a new
// ListTargetAccountConfigurationsPaginator
func NewListTargetAccountConfigurationsPaginator(client ListTargetAccountConfigurationsAPIClient, params *ListTargetAccountConfigurationsInput, optFns ...func(*ListTargetAccountConfigurationsPaginatorOptions)) *ListTargetAccountConfigurationsPaginator {
	if params == nil {
		params = &ListTargetAccountConfigurationsInput{}
	}

	options := ListTargetAccountConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTargetAccountConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTargetAccountConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTargetAccountConfigurations page.
func (p *ListTargetAccountConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTargetAccountConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListTargetAccountConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListTargetAccountConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTargetAccountConfigurations",
	}
}
