// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package generic

import (
	"context"
	"fmt"
	"strings"

	"code.forgejo.org/f3/gof3/v3/options"
)

var treeFactories = make(map[string]TreeFactory, 10)

type TreeFactory func(ctx context.Context, opts options.Interface) TreeInterface

func RegisterFactory(name string, factory TreeFactory) {
	name = strings.ToLower(name)
	treeFactories[name] = factory
}

func GetFactory(name string) TreeFactory {
	name = strings.ToLower(name)
	factory, ok := treeFactories[name]
	if !ok {
		panic(fmt.Errorf("no factory registered for %s", name))
	}
	return factory
}
