//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"regexp"
)

// GetUsagesInLocationServer is a fake server for instances of the armappservice.GetUsagesInLocationClient type.
type GetUsagesInLocationServer struct {
	// NewListPager is the fake for method GetUsagesInLocationClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(location string, options *armappservice.GetUsagesInLocationClientListOptions) (resp azfake.PagerResponder[armappservice.GetUsagesInLocationClientListResponse])
}

// NewGetUsagesInLocationServerTransport creates a new instance of GetUsagesInLocationServerTransport with the provided implementation.
// The returned GetUsagesInLocationServerTransport instance is connected to an instance of armappservice.GetUsagesInLocationClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGetUsagesInLocationServerTransport(srv *GetUsagesInLocationServer) *GetUsagesInLocationServerTransport {
	return &GetUsagesInLocationServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armappservice.GetUsagesInLocationClientListResponse]](),
	}
}

// GetUsagesInLocationServerTransport connects instances of armappservice.GetUsagesInLocationClient to instances of GetUsagesInLocationServer.
// Don't use this type directly, use NewGetUsagesInLocationServerTransport instead.
type GetUsagesInLocationServerTransport struct {
	srv          *GetUsagesInLocationServer
	newListPager *tracker[azfake.PagerResponder[armappservice.GetUsagesInLocationClientListResponse]]
}

// Do implements the policy.Transporter interface for GetUsagesInLocationServerTransport.
func (g *GetUsagesInLocationServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GetUsagesInLocationClient.NewListPager":
		resp, err = g.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GetUsagesInLocationServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if g.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := g.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := g.srv.NewListPager(locationParam, nil)
		newListPager = &resp
		g.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappservice.GetUsagesInLocationClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		g.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		g.newListPager.remove(req)
	}
	return resp, nil
}
