//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataprotection

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewBackupInstancesClient creates a new instance of BackupInstancesClient.
func (c *ClientFactory) NewBackupInstancesClient() *BackupInstancesClient {
	subClient, _ := NewBackupInstancesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBackupPoliciesClient creates a new instance of BackupPoliciesClient.
func (c *ClientFactory) NewBackupPoliciesClient() *BackupPoliciesClient {
	subClient, _ := NewBackupPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBackupVaultOperationResultsClient creates a new instance of BackupVaultOperationResultsClient.
func (c *ClientFactory) NewBackupVaultOperationResultsClient() *BackupVaultOperationResultsClient {
	subClient, _ := NewBackupVaultOperationResultsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBackupVaultsClient creates a new instance of BackupVaultsClient.
func (c *ClientFactory) NewBackupVaultsClient() *BackupVaultsClient {
	subClient, _ := NewBackupVaultsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClient creates a new instance of Client.
func (c *ClientFactory) NewClient() *Client {
	subClient, _ := NewClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDeletedBackupInstancesClient creates a new instance of DeletedBackupInstancesClient.
func (c *ClientFactory) NewDeletedBackupInstancesClient() *DeletedBackupInstancesClient {
	subClient, _ := NewDeletedBackupInstancesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDppResourceGuardProxyClient creates a new instance of DppResourceGuardProxyClient.
func (c *ClientFactory) NewDppResourceGuardProxyClient() *DppResourceGuardProxyClient {
	subClient, _ := NewDppResourceGuardProxyClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewExportJobsClient creates a new instance of ExportJobsClient.
func (c *ClientFactory) NewExportJobsClient() *ExportJobsClient {
	subClient, _ := NewExportJobsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewExportJobsOperationResultClient creates a new instance of ExportJobsOperationResultClient.
func (c *ClientFactory) NewExportJobsOperationResultClient() *ExportJobsOperationResultClient {
	subClient, _ := NewExportJobsOperationResultClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobsClient creates a new instance of JobsClient.
func (c *ClientFactory) NewJobsClient() *JobsClient {
	subClient, _ := NewJobsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationResultClient creates a new instance of OperationResultClient.
func (c *ClientFactory) NewOperationResultClient() *OperationResultClient {
	subClient, _ := NewOperationResultClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationStatusBackupVaultContextClient creates a new instance of OperationStatusBackupVaultContextClient.
func (c *ClientFactory) NewOperationStatusBackupVaultContextClient() *OperationStatusBackupVaultContextClient {
	subClient, _ := NewOperationStatusBackupVaultContextClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationStatusClient creates a new instance of OperationStatusClient.
func (c *ClientFactory) NewOperationStatusClient() *OperationStatusClient {
	subClient, _ := NewOperationStatusClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationStatusResourceGroupContextClient creates a new instance of OperationStatusResourceGroupContextClient.
func (c *ClientFactory) NewOperationStatusResourceGroupContextClient() *OperationStatusResourceGroupContextClient {
	subClient, _ := NewOperationStatusResourceGroupContextClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewRecoveryPointsClient creates a new instance of RecoveryPointsClient.
func (c *ClientFactory) NewRecoveryPointsClient() *RecoveryPointsClient {
	subClient, _ := NewRecoveryPointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewResourceGuardsClient creates a new instance of ResourceGuardsClient.
func (c *ClientFactory) NewResourceGuardsClient() *ResourceGuardsClient {
	subClient, _ := NewResourceGuardsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableTimeRangesClient creates a new instance of RestorableTimeRangesClient.
func (c *ClientFactory) NewRestorableTimeRangesClient() *RestorableTimeRangesClient {
	subClient, _ := NewRestorableTimeRangesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
