//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import "time"

// AADAdminProperties - Workspace active directory administrator properties
type AADAdminProperties struct {
	// Workspace active directory administrator type
	AdministratorType *string

	// Login of the workspace active directory administrator
	Login *string

	// Object ID of the workspace active directory administrator
	Sid *string

	// Tenant ID of the workspace active directory administrator
	TenantID *string
}

// AttachedDatabaseConfiguration - Class representing an attached database configuration.
type AttachedDatabaseConfiguration struct {
	// Resource location.
	Location *string

	// The properties of the attached database configuration.
	Properties *AttachedDatabaseConfigurationProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AttachedDatabaseConfigurationListResult - The list attached database configurations operation response.
type AttachedDatabaseConfigurationListResult struct {
	// The list of attached database configurations.
	Value []*AttachedDatabaseConfiguration
}

// AttachedDatabaseConfigurationProperties - Class representing the an attached database configuration properties of kind
// specific.
type AttachedDatabaseConfigurationProperties struct {
	// REQUIRED; The name of the database which you would like to attach, use * if you want to follow all current and future databases.
	DatabaseName *string

	// REQUIRED; The default principals modification kind
	DefaultPrincipalsModificationKind *DefaultPrincipalsModificationKind

	// REQUIRED; The resource id of the kusto pool where the databases you would like to attach reside.
	KustoPoolResourceID *string

	// Table level sharing specifications
	TableLevelSharingProperties *TableLevelSharingProperties

	// READ-ONLY; The list of databases from the clusterResourceId which are currently attached to the kusto pool.
	AttachedDatabaseNames []*string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState
}

// AutoPauseProperties - Auto-pausing properties of a Big Data pool powered by Apache Spark
type AutoPauseProperties struct {
	// Number of minutes of idle time before the Big Data pool is automatically paused.
	DelayInMinutes *int32

	// Whether auto-pausing is enabled for the Big Data pool.
	Enabled *bool
}

// AutoScaleProperties - Auto-scaling properties of a Big Data pool powered by Apache Spark
type AutoScaleProperties struct {
	// Whether automatic scaling is enabled for the Big Data pool.
	Enabled *bool

	// The maximum number of nodes the Big Data pool can support.
	MaxNodeCount *int32

	// The minimum number of nodes the Big Data pool can support.
	MinNodeCount *int32
}

// AvailableRpOperation - An operation that is available in this resource provider
type AvailableRpOperation struct {
	// Display properties of the operation
	Display *AvailableRpOperationDisplayInfo

	// Whether this operation is a data action
	IsDataAction *string

	// Operation name
	Name *string

	// Operation origin
	Origin *string

	// Operation properties
	Properties *OperationMetaPropertyInfo
}

// AvailableRpOperationDisplayInfo - Description of an available operation
type AvailableRpOperationDisplayInfo struct {
	// Operation description
	Description *string

	// Operation name
	Operation *string

	// Resource provider name
	Provider *string

	// Resource type
	Resource *string
}

// AzureADOnlyAuthentication - Azure Active Directory Only Authentication Info
type AzureADOnlyAuthentication struct {
	// azureADOnlyAuthentication resource properties
	Properties *AzureADOnlyAuthenticationProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AzureADOnlyAuthenticationListResult - A list of active directory only authentications.
type AzureADOnlyAuthenticationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*AzureADOnlyAuthentication
}

// AzureADOnlyAuthenticationProperties - Properties of a active directory only authentication.
type AzureADOnlyAuthenticationProperties struct {
	// REQUIRED; Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool

	// READ-ONLY; property configuration date
	CreationDate *time.Time

	// READ-ONLY; property configuration state
	State *StateValue
}

// AzureCapacity - Azure capacity definition.
type AzureCapacity struct {
	// REQUIRED; The default capacity that would be used.
	Default *int32

	// REQUIRED; Maximum allowed capacity.
	Maximum *int32

	// REQUIRED; Minimum allowed capacity.
	Minimum *int32

	// REQUIRED; Scale type.
	ScaleType *AzureScaleType
}

// AzureEntityResource - The resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AzureResourceSKU - Azure resource SKU definition.
type AzureResourceSKU struct {
	// The number of instances of the cluster.
	Capacity *AzureCapacity

	// Resource Namespace and Type.
	ResourceType *string

	// The SKU details.
	SKU *AzureSKU
}

// AzureSKU - Azure SKU definition.
type AzureSKU struct {
	// REQUIRED; SKU name.
	Name *SKUName

	// REQUIRED; SKU size.
	Size *SKUSize

	// The number of instances of the cluster.
	Capacity *int32
}

// BigDataPoolPatchInfo - Properties patch for a Big Data pool
type BigDataPoolPatchInfo struct {
	// Updated tags for the Big Data pool
	Tags map[string]*string
}

// BigDataPoolResourceInfo - A Big Data pool
type BigDataPoolResourceInfo struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Big Data pool properties
	Properties *BigDataPoolResourceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BigDataPoolResourceInfoListResult - Collection of Big Data pool information
type BigDataPoolResourceInfoListResult struct {
	// Link to the next page of results
	NextLink *string

	// List of Big Data pools
	Value []*BigDataPoolResourceInfo
}

// BigDataPoolResourceProperties - Properties of a Big Data pool powered by Apache Spark
type BigDataPoolResourceProperties struct {
	// Auto-pausing properties
	AutoPause *AutoPauseProperties

	// Auto-scaling properties
	AutoScale *AutoScaleProperties

	// The cache size
	CacheSize *int32

	// List of custom libraries/packages associated with the spark pool.
	CustomLibraries []*LibraryInfo

	// The default folder where Spark logs will be written.
	DefaultSparkLogFolder *string

	// Dynamic Executor Allocation
	DynamicExecutorAllocation *DynamicExecutorAllocation

	// Whether autotune is required or not.
	IsAutotuneEnabled *bool

	// Whether compute isolation is required or not.
	IsComputeIsolationEnabled *bool

	// Library version requirements
	LibraryRequirements *LibraryRequirements

	// The number of nodes in the Big Data pool.
	NodeCount *int32

	// The level of compute power that each node in the Big Data pool has.
	NodeSize *NodeSize

	// The kind of nodes that the Big Data pool provides.
	NodeSizeFamily *NodeSizeFamily

	// The state of the Big Data pool.
	ProvisioningState *string

	// Whether session level packages enabled.
	SessionLevelPackagesEnabled *bool

	// Spark configuration file to specify additional properties
	SparkConfigProperties *SparkConfigProperties

	// The Spark events folder
	SparkEventsFolder *string

	// The Apache Spark version.
	SparkVersion *string

	// READ-ONLY; The time when the Big Data pool was created.
	CreationDate *time.Time

	// READ-ONLY; The time when the Big Data pool was updated successfully.
	LastSucceededTimestamp *time.Time
}

// CheckNameAvailabilityRequest - A request about whether a workspace name is available
type CheckNameAvailabilityRequest struct {
	// Workspace name
	Name *string

	// Type: workspace
	Type *string
}

// CheckNameAvailabilityResponse - A response saying whether the workspace name is available
type CheckNameAvailabilityResponse struct {
	// Whether the workspace name is available
	Available *bool

	// Validation message
	Message *string

	// Workspace name
	Name *string

	// Reason the workspace name is or is not available
	Reason *string
}

// CheckNameResult - The result returned from a check name availability request.
type CheckNameResult struct {
	// Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated.
	Message *string

	// The name that was checked.
	Name *string

	// Specifies a Boolean value that indicates if the name is available.
	NameAvailable *bool

	// Message providing the reason why the given name is invalid.
	Reason *Reason
}

// ClusterPrincipalAssignment - Class representing a cluster principal assignment.
type ClusterPrincipalAssignment struct {
	// The cluster principal.
	Properties *ClusterPrincipalProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterPrincipalAssignmentCheckNameRequest - A principal assignment check name availability request.
type ClusterPrincipalAssignmentCheckNameRequest struct {
	// REQUIRED; Principal Assignment resource name.
	Name *string

	// CONSTANT; The type of resource, Microsoft.Synapse/workspaces/kustoPools/principalAssignments.
	// Field has constant value "Microsoft.Synapse/workspaces/kustoPools/principalAssignments", any specified value is ignored.
	Type *string
}

// ClusterPrincipalAssignmentListResult - The list Kusto cluster principal assignments operation response.
type ClusterPrincipalAssignmentListResult struct {
	// The list of Kusto cluster principal assignments.
	Value []*ClusterPrincipalAssignment
}

// ClusterPrincipalProperties - A class representing cluster principal property.
type ClusterPrincipalProperties struct {
	// REQUIRED; The principal ID assigned to the cluster principal. It can be a user email, application ID, or security group
	// name.
	PrincipalID *string

	// REQUIRED; Principal type.
	PrincipalType *PrincipalType

	// REQUIRED; Cluster principal role.
	Role *ClusterPrincipalRole

	// The tenant id of the principal
	TenantID *string

	// READ-ONLY; The service principal object id in AAD (Azure active directory)
	AADObjectID *string

	// READ-ONLY; The principal name
	PrincipalName *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState

	// READ-ONLY; The tenant name of the principal
	TenantName *string
}

// CmdkeySetup - The custom setup of running cmdkey commands.
type CmdkeySetup struct {
	// REQUIRED; The type of custom setup.
	Type *string

	// REQUIRED; Cmdkey command custom setup type properties.
	TypeProperties *CmdkeySetupTypeProperties
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type CmdkeySetup.
func (c *CmdkeySetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: c.Type,
	}
}

// CmdkeySetupTypeProperties - Cmdkey command custom setup type properties.
type CmdkeySetupTypeProperties struct {
	// REQUIRED; The password of data source access.
	Password SecretBaseClassification

	// REQUIRED; The server name of data source access.
	TargetName any

	// REQUIRED; The user name of data source access.
	UserName any
}

// ComponentSetup - The custom setup of installing 3rd party components.
type ComponentSetup struct {
	// REQUIRED; The type of custom setup.
	Type *string

	// REQUIRED; Install 3rd party component type properties.
	TypeProperties *LicensedComponentSetupTypeProperties
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type ComponentSetup.
func (c *ComponentSetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: c.Type,
	}
}

// CreateSQLPoolRestorePointDefinition - Contains the information necessary to perform a create Sql pool restore point operation.
type CreateSQLPoolRestorePointDefinition struct {
	// REQUIRED; The restore point label to apply
	RestorePointLabel *string
}

// CspWorkspaceAdminProperties - Initial workspace AAD admin properties for a CSP subscription
type CspWorkspaceAdminProperties struct {
	// AAD object ID of initial workspace admin
	InitialWorkspaceAdminObjectID *string
}

// CustomSetupBase - The base definition of the custom setup.
type CustomSetupBase struct {
	// REQUIRED; The type of custom setup.
	Type *string
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type CustomSetupBase.
func (c *CustomSetupBase) GetCustomSetupBase() *CustomSetupBase { return c }

// CustomerManagedKeyDetails - Details of the customer managed key associated with the workspace
type CustomerManagedKeyDetails struct {
	// Key encryption key
	KekIdentity *KekIdentityProperties

	// The key object of the workspace
	Key *WorkspaceKeyDetails

	// READ-ONLY; The customer managed key status on the workspace
	Status *string
}

// DataConnection - Class representing a data connection.
type DataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind

	// Resource location.
	Location *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnection implements the DataConnectionClassification interface for type DataConnection.
func (d *DataConnection) GetDataConnection() *DataConnection { return d }

// DataConnectionCheckNameRequest - A data connection check name availability request.
type DataConnectionCheckNameRequest struct {
	// REQUIRED; Data Connection name.
	Name *string

	// CONSTANT; The type of resource, Microsoft.Synapse/workspaces/kustoPools/databases/dataConnections.
	// Field has constant value "Microsoft.Synapse/workspaces/kustoPools/databases/dataConnections", any specified value is ignored.
	Type *string
}

// DataConnectionListResult - The list Kusto data connections operation response.
type DataConnectionListResult struct {
	// The list of Kusto data connections.
	Value []DataConnectionClassification
}

// DataConnectionValidation - Class representing an data connection validation.
type DataConnectionValidation struct {
	// The name of the data connection.
	DataConnectionName *string

	// The data connection properties to validate.
	Properties DataConnectionClassification
}

// DataConnectionValidationListResult - The list Kusto data connection validation result.
type DataConnectionValidationListResult struct {
	// The list of Kusto data connection validation errors.
	Value []*DataConnectionValidationResult
}

// DataConnectionValidationResult - The result returned from a data connection validation request.
type DataConnectionValidationResult struct {
	// A message which indicates a problem in data connection validation.
	ErrorMessage *string
}

// DataLakeStorageAccountDetails - Details of the data lake storage account associated with the workspace
type DataLakeStorageAccountDetails struct {
	// Account URL
	AccountURL *string

	// Create managed private endpoint to this storage account or not
	CreateManagedPrivateEndpoint *bool

	// Filesystem name
	Filesystem *string

	// ARM resource Id of this storage account
	ResourceID *string
}

type DataMaskingPolicy struct {
	// The properties of the data masking policy.
	Properties *DataMaskingPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The kind of data masking policy. Metadata, used for Azure portal.
	Kind *string

	// READ-ONLY; The location of the data masking policy.
	Location *string

	// READ-ONLY; Fully qualified resource ID of the sql pool
	ManagedBy *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DataMaskingPolicyProperties - The properties of a database data masking policy.
type DataMaskingPolicyProperties struct {
	// REQUIRED; The state of the data masking policy.
	DataMaskingState *DataMaskingState

	// The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking
	// policy does not apply. The specified users receive data results without masking
	// for all of the database queries.
	ExemptPrincipals *string

	// READ-ONLY; The list of the application principals. This is a legacy parameter and is no longer used.
	ApplicationPrincipals *string

	// READ-ONLY; The masking level. This is a legacy parameter and is no longer used.
	MaskingLevel *string
}

// DataMaskingRule - Represents a Sql pool data masking rule.
type DataMaskingRule struct {
	// The properties of the resource.
	Properties *DataMaskingRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The kind of Data Masking Rule. Metadata, used for Azure portal.
	Kind *string

	// READ-ONLY; The location of the data masking rule.
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DataMaskingRuleListResult - The response to a list data masking rules request.
type DataMaskingRuleListResult struct {
	// The list of Sql pool data masking rules.
	Value []*DataMaskingRule
}

// DataMaskingRuleProperties - The properties of a Sql pool data masking rule.
type DataMaskingRuleProperties struct {
	// REQUIRED; The column name on which the data masking rule is applied.
	ColumnName *string

	// REQUIRED; The masking function that is used for the data masking rule.
	MaskingFunction *DataMaskingFunction

	// REQUIRED; The schema name on which the data masking rule is applied.
	SchemaName *string

	// REQUIRED; The table name on which the data masking rule is applied.
	TableName *string

	// The alias name. This is a legacy parameter and is no longer used.
	AliasName *string

	// The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will
	// be ignored.
	NumberFrom *string

	// The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter
	// will be ignored.
	NumberTo *string

	// If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise,
	// this parameter will be ignored.
	PrefixSize *string

	// If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter
	// will be ignored.
	ReplacementString *string

	// The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction,
	// and specify ruleState as disabled. However, if the rule doesn't
	// already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState.
	RuleState *DataMaskingRuleState

	// If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this
	// parameter will be ignored.
	SuffixSize *string

	// READ-ONLY; The rule Id.
	ID *string
}

// DataWarehouseUserActivities - User activities of a data warehouse
type DataWarehouseUserActivities struct {
	// Resource properties.
	Properties *DataWarehouseUserActivitiesProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DataWarehouseUserActivitiesProperties - User activities of a data warehouse. This currently includes the count of running
// or suspended queries. For more information, please view the sys.dmpdwexec_requests dynamic management view (DMV).
type DataWarehouseUserActivitiesProperties struct {
	// READ-ONLY; Count of running and suspended queries.
	ActiveQueriesCount *int32
}

// Database - Class representing a Kusto database.
type Database struct {
	// REQUIRED; Kind of the database
	Kind *Kind

	// Resource location.
	Location *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDatabase implements the DatabaseClassification interface for type Database.
func (d *Database) GetDatabase() *Database { return d }

// DatabaseCheckNameRequest - The result returned from a database check name availability request.
type DatabaseCheckNameRequest struct {
	// REQUIRED; Resource name.
	Name *string

	// REQUIRED; The type of resource, for instance Microsoft.Synapse/workspaces/kustoPools/databases.
	Type *Type
}

// DatabaseListResult - The list Kusto databases operation response.
type DatabaseListResult struct {
	// The list of Kusto databases.
	Value []DatabaseClassification
}

// DatabasePrincipalAssignment - Class representing a database principal assignment.
type DatabasePrincipalAssignment struct {
	// The database principal.
	Properties *DatabasePrincipalProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DatabasePrincipalAssignmentCheckNameRequest - A principal assignment check name availability request.
type DatabasePrincipalAssignmentCheckNameRequest struct {
	// REQUIRED; Principal Assignment resource name.
	Name *string

	// CONSTANT; The type of resource, Microsoft.Synapse/workspaces/kustoPools/databases/principalAssignments.
	// Field has constant value "Microsoft.Synapse/workspaces/kustoPools/databases/principalAssignments", any specified value
	// is ignored.
	Type *string
}

// DatabasePrincipalAssignmentListResult - The list Kusto database principal assignments operation response.
type DatabasePrincipalAssignmentListResult struct {
	// The list of Kusto database principal assignments.
	Value []*DatabasePrincipalAssignment
}

// DatabasePrincipalProperties - A class representing database principal property.
type DatabasePrincipalProperties struct {
	// REQUIRED; The principal ID assigned to the database principal. It can be a user email, application ID, or security group
	// name.
	PrincipalID *string

	// REQUIRED; Principal type.
	PrincipalType *PrincipalType

	// REQUIRED; Database principal role.
	Role *DatabasePrincipalRole

	// The tenant id of the principal
	TenantID *string

	// READ-ONLY; The service principal object id in AAD (Azure active directory)
	AADObjectID *string

	// READ-ONLY; The principal name
	PrincipalName *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState

	// READ-ONLY; The tenant name of the principal
	TenantName *string
}

// DatabaseStatistics - A class that contains database statistics information.
type DatabaseStatistics struct {
	// The database size - the total size of compressed data and index in bytes.
	Size *float32
}

// DedicatedSQLminimalTLSSettings - Dedicated Sql Minimal Tls Settings Info
type DedicatedSQLminimalTLSSettings struct {
	// Resource properties.
	Properties *DedicatedSQLminimalTLSSettingsProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; Resource location.
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DedicatedSQLminimalTLSSettingsListResult - A list of the server's dedicated sql minimal tls settings.
type DedicatedSQLminimalTLSSettingsListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*DedicatedSQLminimalTLSSettings
}

// DedicatedSQLminimalTLSSettingsPatchInfo - Dedicated SQL minimal tls settings patch info
type DedicatedSQLminimalTLSSettingsPatchInfo struct {
	// minimal tls version
	MinimalTLSVersion *string
}

// DedicatedSQLminimalTLSSettingsProperties - Properties of a dedicated sql minimal tls settings.
type DedicatedSQLminimalTLSSettingsProperties struct {
	// The minimal tls version of the sql server.
	MinimalTLSVersion *string
}

// DynamicExecutorAllocation - Dynamic Executor Allocation Properties
type DynamicExecutorAllocation struct {
	// Indicates whether Dynamic Executor Allocation is enabled or not.
	Enabled *bool

	// The maximum number of executors alloted
	MaxExecutors *int32

	// The minimum number of executors alloted
	MinExecutors *int32
}

// EncryptionDetails - Details of the encryption associated with the workspace
type EncryptionDetails struct {
	// Customer Managed Key Details
	Cmk *CustomerManagedKeyDetails

	// READ-ONLY; Double Encryption enabled
	DoubleEncryptionEnabled *bool
}

// EncryptionProtector - The server encryption protector.
type EncryptionProtector struct {
	// Resource properties.
	Properties *EncryptionProtectorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string

	// READ-ONLY; Resource location.
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// EncryptionProtectorListResult - A list of server encryption protectors.
type EncryptionProtectorListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*EncryptionProtector
}

// EncryptionProtectorProperties - Properties for an encryption protector execution.
type EncryptionProtectorProperties struct {
	// REQUIRED; The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
	ServerKeyType *ServerKeyType

	// The name of the server key.
	ServerKeyName *string

	// READ-ONLY; Subregion of the encryption protector.
	Subregion *string

	// READ-ONLY; Thumbprint of the server key.
	Thumbprint *string

	// READ-ONLY; The URI of the server key.
	URI *string
}

// EntityReference - The entity reference.
type EntityReference struct {
	// The name of this referenced entity.
	ReferenceName *string

	// The type of this referenced entity.
	Type *IntegrationRuntimeEntityReferenceType
}

// EnvironmentVariableSetup - The custom setup of setting environment variable.
type EnvironmentVariableSetup struct {
	// REQUIRED; The type of custom setup.
	Type *string

	// REQUIRED; Add environment variable type properties.
	TypeProperties *EnvironmentVariableSetupTypeProperties
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type EnvironmentVariableSetup.
func (e *EnvironmentVariableSetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: e.Type,
	}
}

// EnvironmentVariableSetupTypeProperties - Environment variable custom setup type properties.
type EnvironmentVariableSetupTypeProperties struct {
	// REQUIRED; The name of the environment variable.
	VariableName *string

	// REQUIRED; The value of the environment variable.
	VariableValue *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// ErrorResponseAutoGenerated - Common error response for all Azure Resource Manager APIs to return error details for failed
// operations. (This also follows the OData error response format.)
type ErrorResponseAutoGenerated struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorResponseAutoGenerated

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// EventGridConnectionProperties - Class representing the Kusto event grid connection properties.
type EventGridConnectionProperties struct {
	// REQUIRED; The event hub consumer group.
	ConsumerGroup *string

	// REQUIRED; The resource ID where the event grid is configured to send events.
	EventHubResourceID *string

	// REQUIRED; The resource ID of the storage account where the data resides.
	StorageAccountResourceID *string

	// The name of blob storage event type to process.
	BlobStorageEventType *BlobStorageEventType

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *EventGridDataFormat

	// A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
	IgnoreFirstRecord *bool

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState
}

// EventGridDataConnection - Class representing an Event Grid data connection.
type EventGridDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind

	// Resource location.
	Location *string

	// The properties of the Event Grid data connection.
	Properties *EventGridConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnection implements the DataConnectionClassification interface for type EventGridDataConnection.
func (e *EventGridDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		ID:         e.ID,
		Kind:       e.Kind,
		Location:   e.Location,
		Name:       e.Name,
		SystemData: e.SystemData,
		Type:       e.Type,
	}
}

// EventHubConnectionProperties - Class representing the Kusto event hub connection properties.
type EventHubConnectionProperties struct {
	// REQUIRED; The event hub consumer group.
	ConsumerGroup *string

	// REQUIRED; The resource ID of the event hub to be used to create a data connection.
	EventHubResourceID *string

	// The event hub messages compression type
	Compression *Compression

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *EventHubDataFormat

	// System properties of the event hub
	EventSystemProperties []*string

	// The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
	ManagedIdentityResourceID *string

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState
}

// EventHubDataConnection - Class representing an event hub data connection.
type EventHubDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind

	// Resource location.
	Location *string

	// The Event Hub data connection properties to validate.
	Properties *EventHubConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnection implements the DataConnectionClassification interface for type EventHubDataConnection.
func (e *EventHubDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		ID:         e.ID,
		Kind:       e.Kind,
		Location:   e.Location,
		Name:       e.Name,
		SystemData: e.SystemData,
		Type:       e.Type,
	}
}

// ExtendedSQLPoolBlobAuditingPolicy - An extended Sql pool blob auditing policy.
type ExtendedSQLPoolBlobAuditingPolicy struct {
	// Resource properties.
	Properties *ExtendedSQLPoolBlobAuditingPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ExtendedSQLPoolBlobAuditingPolicyListResult - A list of sql pool extended auditing settings.
type ExtendedSQLPoolBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*ExtendedSQLPoolBlobAuditingPolicy
}

// ExtendedSQLPoolBlobAuditingPolicyProperties - Properties of an extended Sql pool blob auditing policy.
type ExtendedSQLPoolBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETED_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'state'
	// as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool

	// Specifies condition of where clause when creating an audit.
	PredicateExpression *string

	// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed. The default
	// minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, not
	// specifying the storageAccountAccessKey will use SQL server system-assigned
	// managed identity to access the storage. Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server
	// identity. For more information, see Auditing to storage using Managed
	// Identity authentication [https://go.microsoft.com/fwlink/?linkid=2114355]
	StorageAccountAccessKey *string

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string
}

// ExtendedServerBlobAuditingPolicy - An extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicy struct {
	// Resource properties.
	Properties *ExtendedServerBlobAuditingPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ExtendedServerBlobAuditingPolicyListResult - A list of server extended auditing settings.
type ExtendedServerBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*ExtendedServerBlobAuditingPolicy
}

// ExtendedServerBlobAuditingPolicyProperties - Properties of an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETED_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'state'
	// as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool

	// Specifies the state of devops audit. If state is Enabled, devops logs will be sent to Azure Monitor. In order to send the
	// events to Azure Monitor, specify 'State' as 'Enabled',
	// 'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true
	// When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit' diagnostic logs category on
	// the master database should also be created.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsDevopsAuditEnabled *bool

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool

	// Specifies condition of where clause when creating an audit.
	PredicateExpression *string

	// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed. The default
	// minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, not
	// specifying the storageAccountAccessKey will use SQL server system-assigned
	// managed identity to access the storage. Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server
	// identity. For more information, see Auditing to storage using Managed
	// Identity authentication [https://go.microsoft.com/fwlink/?linkid=2114355]
	StorageAccountAccessKey *string

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string
}

// FollowerDatabaseDefinition - A class representing follower database request.
type FollowerDatabaseDefinition struct {
	// REQUIRED; Resource name of the attached database configuration in the follower cluster.
	AttachedDatabaseConfigurationName *string

	// REQUIRED; Resource id of the cluster that follows a database owned by this cluster.
	KustoPoolResourceID *string

	// READ-ONLY; The database name owned by this cluster that was followed. * in case following all databases.
	DatabaseName *string
}

// FollowerDatabaseListResult - The list Kusto database principals operation response.
type FollowerDatabaseListResult struct {
	// The list of follower database result.
	Value []*FollowerDatabaseDefinition
}

// GeoBackupPolicy - A database geo backup policy.
type GeoBackupPolicy struct {
	// REQUIRED; The properties of the geo backup policy.
	Properties *GeoBackupPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; Kind of geo backup policy. This is metadata used for the Azure portal experience.
	Kind *string

	// READ-ONLY; Backup policy location.
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GeoBackupPolicyListResult - The response to a list geo backup policies request.
type GeoBackupPolicyListResult struct {
	// The list of geo backup policies.
	Value []*GeoBackupPolicy
}

// GeoBackupPolicyProperties - The properties of the geo backup policy.
type GeoBackupPolicyProperties struct {
	// REQUIRED; The state of the geo backup policy.
	State *GeoBackupPolicyState

	// READ-ONLY; The storage type of the geo backup policy.
	StorageType *string
}

// GetSsisObjectMetadataRequest - The request payload of get SSIS object metadata.
type GetSsisObjectMetadataRequest struct {
	// Metadata path.
	MetadataPath *string
}

// IPFirewallRuleInfo - IP firewall rule
type IPFirewallRuleInfo struct {
	// IP firewall rule properties
	Properties *IPFirewallRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IPFirewallRuleInfoListResult - List of IP firewall rules
type IPFirewallRuleInfoListResult struct {
	// Link to next page of results
	NextLink *string

	// List of IP firewall rules
	Value []*IPFirewallRuleInfo
}

// IPFirewallRuleProperties - IP firewall rule properties
type IPFirewallRuleProperties struct {
	// The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress
	EndIPAddress *string

	// The start IP address of the firewall rule. Must be IPv4 format
	StartIPAddress *string

	// READ-ONLY; Resource provisioning state
	ProvisioningState *ProvisioningState
}

// IntegrationRuntime - Azure Synapse nested object which serves as a compute resource for activities.
type IntegrationRuntime struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Integration runtime description.
	Description *string
}

// GetIntegrationRuntime implements the IntegrationRuntimeClassification interface for type IntegrationRuntime.
func (i *IntegrationRuntime) GetIntegrationRuntime() *IntegrationRuntime { return i }

// IntegrationRuntimeAuthKeys - The integration runtime authentication keys.
type IntegrationRuntimeAuthKeys struct {
	// The primary integration runtime authentication key.
	AuthKey1 *string

	// The secondary integration runtime authentication key.
	AuthKey2 *string
}

// IntegrationRuntimeComputeProperties - The compute resource properties for managed integration runtime.
type IntegrationRuntimeComputeProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Data flow properties for managed integration runtime.
	DataFlowProperties *IntegrationRuntimeDataFlowProperties

	// The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
	Location *string

	// Maximum parallel executions count per node for managed integration runtime.
	MaxParallelExecutionsPerNode *int32

	// The node size requirement to managed integration runtime.
	NodeSize *string

	// The required number of nodes for managed integration runtime.
	NumberOfNodes *int32

	// VNet properties for managed integration runtime.
	VNetProperties *IntegrationRuntimeVNetProperties
}

// IntegrationRuntimeConnectionInfo - Connection information for encrypting the on-premises data source credentials.
type IntegrationRuntimeConnectionInfo struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The on-premises integration runtime host URL.
	HostServiceURI *string

	// READ-ONLY; The integration runtime SSL certificate thumbprint. Click-Once application uses it to do server validation.
	IdentityCertThumbprint *string

	// READ-ONLY; Whether the identity certificate is expired.
	IsIdentityCertExprired *bool

	// READ-ONLY; The public key for encrypting a credential when transferring the credential to the integration runtime.
	PublicKey *string

	// READ-ONLY; The token generated in service. Callers use this token to authenticate to integration runtime.
	ServiceToken *string

	// READ-ONLY; The integration runtime version.
	Version *string
}

// IntegrationRuntimeCustomSetupScriptProperties - Custom setup script properties for a managed dedicated integration runtime.
type IntegrationRuntimeCustomSetupScriptProperties struct {
	// The URI of the Azure blob container that contains the custom setup script.
	BlobContainerURI *string

	// The SAS token of the Azure blob container.
	SasToken *SecureString
}

// IntegrationRuntimeDataFlowProperties - Data flow properties for managed integration runtime.
type IntegrationRuntimeDataFlowProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Cluster will not be recycled and it will be used in next data flow activity run until TTL (time to live) is reached if
	// this is set as false. Default is true.
	Cleanup *bool

	// Compute type of the cluster which will execute data flow job.
	ComputeType *DataFlowComputeType

	// Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
	CoreCount *int32

	// Time to live (in minutes) setting of the cluster which will execute data flow job.
	TimeToLive *int32
}

// IntegrationRuntimeDataProxyProperties - Data proxy properties for a managed dedicated integration runtime.
type IntegrationRuntimeDataProxyProperties struct {
	// The self-hosted integration runtime reference.
	ConnectVia *EntityReference

	// The path to contain the staged data in the Blob storage.
	Path *string

	// The staging linked service reference.
	StagingLinkedService *EntityReference
}

// IntegrationRuntimeEnableinteractivequery - Integration Runtime Operation Status Properties
type IntegrationRuntimeEnableinteractivequery struct {
	// The operation error message.
	Error *string

	// The operation name.
	Name *string

	// The operation properties.
	Properties any

	// EnableInteractivequery status of Integrationruntimes.
	Status *WorkspaceStatus
}

// IntegrationRuntimeListResponse - A list of integration runtime resources.
type IntegrationRuntimeListResponse struct {
	// REQUIRED; List of integration runtimes.
	Value []*IntegrationRuntimeResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// IntegrationRuntimeMonitoringData - Get monitoring data response.
type IntegrationRuntimeMonitoringData struct {
	// Integration runtime name.
	Name *string

	// Integration runtime node monitoring data.
	Nodes []*IntegrationRuntimeNodeMonitoringData
}

// IntegrationRuntimeNodeIPAddress - The IP address of self-hosted integration runtime node.
type IntegrationRuntimeNodeIPAddress struct {
	// READ-ONLY; The IP address of self-hosted integration runtime node.
	IPAddress *string
}

// IntegrationRuntimeNodeMonitoringData - Monitoring data for integration runtime node.
type IntegrationRuntimeNodeMonitoringData struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; Available memory (MB) on the integration runtime node.
	AvailableMemoryInMB *int32

	// READ-ONLY; CPU percentage on the integration runtime node.
	CPUUtilization *int32

	// READ-ONLY; Maximum concurrent jobs on the integration runtime node.
	ConcurrentJobsLimit *int32

	// READ-ONLY; The number of jobs currently running on the integration runtime node.
	ConcurrentJobsRunning *int32

	// READ-ONLY; The maximum concurrent jobs in this integration runtime.
	MaxConcurrentJobs *int32

	// READ-ONLY; Name of the integration runtime node.
	NodeName *string

	// READ-ONLY; Received bytes on the integration runtime node.
	ReceivedBytes *float32

	// READ-ONLY; Sent bytes on the integration runtime node.
	SentBytes *float32
}

// IntegrationRuntimeOperationStatus - Integration Runtime Operation Status Properties
type IntegrationRuntimeOperationStatus struct {
	// The operation error message.
	Error *string

	// The operation name.
	Name *string

	// The operation properties.
	Properties any

	// status of Start Integrationruntimes.
	Status *WorkspaceStatus
}

// IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint - Azure-SSIS integration runtime outbound network dependency
// endpoints for one category.
type IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint struct {
	// The category of outbound network dependency.
	Category *string

	// The endpoints for outbound network dependency.
	Endpoints []*IntegrationRuntimeOutboundNetworkDependenciesEndpoint
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpoint - The endpoint for Azure-SSIS integration runtime outbound network
// dependency.
type IntegrationRuntimeOutboundNetworkDependenciesEndpoint struct {
	// The domain name of endpoint.
	DomainName *string

	// The details of endpoint.
	EndpointDetails []*IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails - The details of Azure-SSIS integration runtime outbound network
// dependency endpoint.
type IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails struct {
	// The port of endpoint.
	Port *int32
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse - Azure-SSIS integration runtime outbound network dependency
// endpoints.
type IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse struct {
	// The list of outbound network dependency endpoints.
	Value []*IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint
}

// IntegrationRuntimeRegenerateKeyParameters - Parameters to regenerate the authentication key.
type IntegrationRuntimeRegenerateKeyParameters struct {
	// The name of the authentication key to regenerate.
	KeyName *IntegrationRuntimeAuthKeyName
}

// IntegrationRuntimeResource - Integration runtime resource type.
type IntegrationRuntimeResource struct {
	// REQUIRED; Integration runtime properties.
	Properties IntegrationRuntimeClassification

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IntegrationRuntimeSsisCatalogInfo - Catalog information for managed dedicated integration runtime.
type IntegrationRuntimeSsisCatalogInfo struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The password of the administrator user account of the catalog database.
	CatalogAdminPassword *SecureString

	// The administrator user name of catalog database.
	CatalogAdminUserName *string

	// The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
	CatalogPricingTier *IntegrationRuntimeSsisCatalogPricingTier

	// The catalog database server URL.
	CatalogServerEndpoint *string
}

// IntegrationRuntimeSsisProperties - SSIS properties for managed integration runtime.
type IntegrationRuntimeSsisProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Catalog information for managed dedicated integration runtime.
	CatalogInfo *IntegrationRuntimeSsisCatalogInfo

	// Custom setup script properties for a managed dedicated integration runtime.
	CustomSetupScriptProperties *IntegrationRuntimeCustomSetupScriptProperties

	// Data proxy properties for a managed dedicated integration runtime.
	DataProxyProperties *IntegrationRuntimeDataProxyProperties

	// The edition for the SSIS Integration Runtime
	Edition *IntegrationRuntimeEdition

	// Custom setup without script properties for a SSIS integration runtime.
	ExpressCustomSetupProperties []CustomSetupBaseClassification

	// License type for bringing your own license scenario.
	LicenseType *IntegrationRuntimeLicenseType
}

// IntegrationRuntimeStatus - Integration runtime status.
type IntegrationRuntimeStatus struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The workspace name which the integration runtime belong to.
	DataFactoryName *string

	// READ-ONLY; The state of integration runtime.
	State *IntegrationRuntimeState
}

// GetIntegrationRuntimeStatus implements the IntegrationRuntimeStatusClassification interface for type IntegrationRuntimeStatus.
func (i *IntegrationRuntimeStatus) GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus { return i }

// IntegrationRuntimeStatusResponse - Integration runtime status response.
type IntegrationRuntimeStatusResponse struct {
	// REQUIRED; Integration runtime properties.
	Properties IntegrationRuntimeStatusClassification

	// READ-ONLY; The integration runtime name.
	Name *string
}

// IntegrationRuntimeStopOperationStatus - Integration Runtime Operation Status Properties
type IntegrationRuntimeStopOperationStatus struct {
	// The operation error message.
	Error *string

	// The operation name.
	Name *string

	// The operation properties.
	Properties any

	// status of Start Integrationruntimes.
	Status *WorkspaceStatus
}

// IntegrationRuntimeVNetProperties - VNet properties for managed integration runtime.
type IntegrationRuntimeVNetProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Resource IDs of the public IP addresses that this integration runtime will use.
	PublicIPs []*string

	// The name of the subnet this integration runtime will join.
	Subnet *string

	// The ID of subnet, to which this Azure-SSIS integration runtime will be joined.
	SubnetID *string

	// The ID of the VNet that this integration runtime will join.
	VNetID *string
}

// IotHubConnectionProperties - Class representing the Kusto Iot hub connection properties.
type IotHubConnectionProperties struct {
	// REQUIRED; The iot hub consumer group.
	ConsumerGroup *string

	// REQUIRED; The resource ID of the Iot hub to be used to create a data connection.
	IotHubResourceID *string

	// REQUIRED; The name of the share access policy
	SharedAccessPolicyName *string

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *IotHubDataFormat

	// System properties of the iot hub
	EventSystemProperties []*string

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState
}

// IotHubDataConnection - Class representing an iot hub data connection.
type IotHubDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind

	// Resource location.
	Location *string

	// The Iot Hub data connection properties.
	Properties *IotHubConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnection implements the DataConnectionClassification interface for type IotHubDataConnection.
func (i *IotHubDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		ID:         i.ID,
		Kind:       i.Kind,
		Location:   i.Location,
		Name:       i.Name,
		SystemData: i.SystemData,
		Type:       i.Type,
	}
}

// KekIdentityProperties - Key encryption key properties
type KekIdentityProperties struct {
	// Boolean specifying whether to use system assigned identity or not
	UseSystemAssignedIdentity any

	// User assigned identity resource Id
	UserAssignedIdentity *string
}

// Key - A workspace key
type Key struct {
	// Keys resource properties
	Properties *KeyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// KeyInfoListResult - List of keys
type KeyInfoListResult struct {
	// Link to the next page of results
	NextLink *string

	// List of keys
	Value []*Key
}

// KeyProperties - Key properties
type KeyProperties struct {
	// Used to activate the workspace after a customer managed key is provided.
	IsActiveCMK *bool

	// The Key Vault Url of the workspace key.
	KeyVaultURL *string
}

// KustoPool - Class representing a Kusto kusto pool.
type KustoPool struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The SKU of the kusto pool.
	SKU *AzureSKU

	// The kusto pool properties.
	Properties *KustoPoolProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// KustoPoolCheckNameRequest - The object sent for a kusto pool check name availability request.
type KustoPoolCheckNameRequest struct {
	// REQUIRED; Kusto Pool name.
	Name *string

	// CONSTANT; The type of resource, Microsoft.Synapse/workspaces/kustoPools.
	// Field has constant value "Microsoft.Synapse/workspaces/kustoPools", any specified value is ignored.
	Type *string
}

// KustoPoolListResult - The list Kusto pools operation response.
type KustoPoolListResult struct {
	// The list of Kusto pools.
	Value []*KustoPool
}

// KustoPoolPrivateLinkResources - Class representing a Private Link Resources.
type KustoPoolPrivateLinkResources struct {
	// The Private Link Resources.
	Properties *PrivateLinkResourcesProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// KustoPoolProperties - Class representing the Kusto pool properties.
type KustoPoolProperties struct {
	// A boolean value that indicates if the purge operations are enabled.
	EnablePurge *bool

	// A boolean value that indicates if the streaming ingest is enabled.
	EnableStreamingIngest *bool

	// Optimized auto scale definition.
	OptimizedAutoscale *OptimizedAutoscale

	// The workspace unique identifier.
	WorkspaceUID *string

	// READ-ONLY; The Kusto Pool data ingestion URI.
	DataIngestionURI *string

	// READ-ONLY; List of the Kusto Pool's language extensions.
	LanguageExtensions *LanguageExtensionsList

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState

	// READ-ONLY; The state of the resource.
	State *State

	// READ-ONLY; The reason for the Kusto Pool's current state.
	StateReason *string

	// READ-ONLY; The Kusto Pool URI.
	URI *string
}

// KustoPoolUpdate - Class representing an update to a Kusto kusto pool.
type KustoPoolUpdate struct {
	// The kusto pool properties.
	Properties *KustoPoolProperties

	// The SKU of the kusto pool.
	SKU *AzureSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LanguageExtension - The language extension object.
type LanguageExtension struct {
	// The language extension name.
	LanguageExtensionName *LanguageExtensionName
}

// LanguageExtensionsList - The list of language extension objects.
type LanguageExtensionsList struct {
	// The list of language extensions.
	Value []*LanguageExtension
}

// LibraryInfo - Library/package information of a Big Data pool powered by Apache Spark
type LibraryInfo struct {
	// Storage blob container name.
	ContainerName *string

	// Name of the library.
	Name *string

	// Storage blob path of library.
	Path *string

	// Type of the library.
	Type *string

	// The last update time of the library.
	UploadedTimestamp *time.Time

	// READ-ONLY; Creator Id of the library/package.
	CreatorID *string

	// READ-ONLY; Provisioning status of the library/package.
	ProvisioningStatus *string
}

// LibraryListResponse - A list of Library resources.
type LibraryListResponse struct {
	// REQUIRED; List of Library.
	Value []*LibraryResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// LibraryRequirements - Library requirements for a Big Data pool powered by Apache Spark
type LibraryRequirements struct {
	// The library requirements.
	Content *string

	// The filename of the library requirements file.
	Filename *string

	// READ-ONLY; The last update time of the library requirements file.
	Time *time.Time
}

// LibraryResource - Library response details
type LibraryResource struct {
	// REQUIRED; Library/package properties.
	Properties *LibraryInfo

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LicensedComponentSetupTypeProperties - Installation of licensed component setup type properties.
type LicensedComponentSetupTypeProperties struct {
	// REQUIRED; The name of the 3rd party component.
	ComponentName *string

	// The license key to activate the component.
	LicenseKey SecretBaseClassification
}

// LinkedIntegrationRuntime - The linked integration runtime information.
type LinkedIntegrationRuntime struct {
	// READ-ONLY; The creating time of the linked integration runtime.
	CreateTime *time.Time

	// READ-ONLY; The location of the workspace for which the linked integration runtime belong to.
	DataFactoryLocation *string

	// READ-ONLY; The name of the workspace for which the linked integration runtime belong to.
	DataFactoryName *string

	// READ-ONLY; The name of the linked integration runtime.
	Name *string

	// READ-ONLY; The subscription ID for which the linked integration runtime belong to.
	SubscriptionID *string
}

// LinkedIntegrationRuntimeKeyAuthorization - The key authorization type integration runtime.
type LinkedIntegrationRuntimeKeyAuthorization struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string

	// REQUIRED; The key used for authorization.
	Key *SecureString
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeKeyAuthorization.
func (l *LinkedIntegrationRuntimeKeyAuthorization) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return &LinkedIntegrationRuntimeType{
		AuthorizationType: l.AuthorizationType,
	}
}

// LinkedIntegrationRuntimeRbacAuthorization - The role based access control (RBAC) authorization type integration runtime.
type LinkedIntegrationRuntimeRbacAuthorization struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string

	// REQUIRED; The resource identifier of the integration runtime to be shared.
	ResourceID *string
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeRbacAuthorization.
func (l *LinkedIntegrationRuntimeRbacAuthorization) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return &LinkedIntegrationRuntimeType{
		AuthorizationType: l.AuthorizationType,
	}
}

// LinkedIntegrationRuntimeType - The base definition of a linked integration runtime.
type LinkedIntegrationRuntimeType struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeType.
func (l *LinkedIntegrationRuntimeType) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return l
}

// ListResourceSKUsResult - List of available SKUs for a Kusto Pool.
type ListResourceSKUsResult struct {
	// The collection of available SKUs for an existing resource.
	Value []*AzureResourceSKU
}

// ListSQLPoolSecurityAlertPolicies - A list of SQL pool security alert policies.
type ListSQLPoolSecurityAlertPolicies struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*SQLPoolSecurityAlertPolicy
}

// MaintenanceWindowOptions - Maintenance window options.
type MaintenanceWindowOptions struct {
	// Resource properties.
	Properties *MaintenanceWindowOptionsProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MaintenanceWindowOptionsProperties - Maintenance window options properties.
type MaintenanceWindowOptionsProperties struct {
	// Whether we allow multiple maintenance windows per cycle.
	AllowMultipleMaintenanceWindowsPerCycle *bool

	// Default duration for maintenance window.
	DefaultDurationInMinutes *int32

	// Whether maintenance windows are enabled for the database.
	IsEnabled *bool

	// Available maintenance cycles e.g. {Saturday, 0, 4860}, {Wednesday, 0, 2460}.
	MaintenanceWindowCycles []*MaintenanceWindowTimeRange

	// Minimum number of maintenance windows cycles to be set on the database.
	MinCycles *int32

	// Minimum duration of maintenance window.
	MinDurationInMinutes *int32

	// Time granularity in minutes for maintenance windows.
	TimeGranularityInMinutes *int32
}

// MaintenanceWindowTimeRange - Maintenance window time range.
type MaintenanceWindowTimeRange struct {
	// Day of maintenance window.
	DayOfWeek *DayOfWeek

	// Duration of maintenance window in minutes.
	Duration *string

	// Start time minutes offset from 12am.
	StartTime *string
}

// MaintenanceWindows - Maintenance windows.
type MaintenanceWindows struct {
	// Resource properties.
	Properties *MaintenanceWindowsProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MaintenanceWindowsProperties - Maintenance windows resource properties.
type MaintenanceWindowsProperties struct {
	TimeRanges []*MaintenanceWindowTimeRange
}

// ManagedIdentity - The workspace managed identity
type ManagedIdentity struct {
	// The type of managed identity for the workspace
	Type *ResourceIdentityType

	// The user assigned managed identities.
	UserAssignedIdentities map[string]*UserAssignedManagedIdentity

	// READ-ONLY; The principal ID of the workspace managed identity
	PrincipalID *string

	// READ-ONLY; The tenant ID of the workspace managed identity
	TenantID *string
}

// ManagedIdentitySQLControlSettingsModel - Sql Control Settings for workspace managed identity
type ManagedIdentitySQLControlSettingsModel struct {
	// Sql Control Settings for workspace managed identity
	Properties *ManagedIdentitySQLControlSettingsModelProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ManagedIdentitySQLControlSettingsModelProperties - Sql Control Settings for workspace managed identity
type ManagedIdentitySQLControlSettingsModelProperties struct {
	// Grant sql control to managed identity
	GrantSQLControlToManagedIdentity *ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity
}

// ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity - Grant sql control to managed identity
type ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity struct {
	// Desired state
	DesiredState *DesiredState

	// READ-ONLY; Actual state
	ActualState *ActualState
}

// ManagedIntegrationRuntime - Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
type ManagedIntegrationRuntime struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// REQUIRED; Managed integration runtime properties.
	TypeProperties *ManagedIntegrationRuntimeTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Integration runtime description.
	Description *string

	// Managed integration runtime managed virtual network.
	ManagedVirtualNetwork *ManagedIntegrationRuntimeManagedVirtualNetworkReference

	// READ-ONLY; Integration runtime state, only valid for managed dedicated integration runtime.
	State *IntegrationRuntimeState
}

// GetIntegrationRuntime implements the IntegrationRuntimeClassification interface for type ManagedIntegrationRuntime.
func (m *ManagedIntegrationRuntime) GetIntegrationRuntime() *IntegrationRuntime {
	return &IntegrationRuntime{
		AdditionalProperties: m.AdditionalProperties,
		Description:          m.Description,
		Type:                 m.Type,
	}
}

// ManagedIntegrationRuntimeError - Error definition for managed integration runtime.
type ManagedIntegrationRuntimeError struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message.
	Message *string

	// READ-ONLY; Managed integration runtime error parameters.
	Parameters []*string

	// READ-ONLY; The time when the error occurred.
	Time *time.Time
}

// ManagedIntegrationRuntimeManagedVirtualNetworkReference - Managed integration runtime managed virtual network reference.
type ManagedIntegrationRuntimeManagedVirtualNetworkReference struct {
	// The id of the managed virtual network.
	ID *string

	// The reference name of the managed virtual network.
	ReferenceName *string

	// The type of the managed virtual network.
	Type *string
}

// ManagedIntegrationRuntimeNode - Properties of integration runtime node.
type ManagedIntegrationRuntimeNode struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The errors that occurred on this integration runtime node.
	Errors []*ManagedIntegrationRuntimeError

	// READ-ONLY; The managed integration runtime node id.
	NodeID *string

	// READ-ONLY; The managed integration runtime node status.
	Status *ManagedIntegrationRuntimeNodeStatus
}

// ManagedIntegrationRuntimeOperationResult - Properties of managed integration runtime operation result.
type ManagedIntegrationRuntimeOperationResult struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The activity id for the operation request.
	ActivityID *string

	// READ-ONLY; The error code.
	ErrorCode *string

	// READ-ONLY; Managed integration runtime error parameters.
	Parameters []*string

	// READ-ONLY; The operation result.
	Result *string

	// READ-ONLY; The start time of the operation.
	StartTime *time.Time

	// READ-ONLY; The operation type. Could be start or stop.
	Type *string
}

// ManagedIntegrationRuntimeStatus - Managed integration runtime status.
type ManagedIntegrationRuntimeStatus struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// REQUIRED; Managed integration runtime status type properties.
	TypeProperties *ManagedIntegrationRuntimeStatusTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The workspace name which the integration runtime belong to.
	DataFactoryName *string

	// READ-ONLY; The state of integration runtime.
	State *IntegrationRuntimeState
}

// GetIntegrationRuntimeStatus implements the IntegrationRuntimeStatusClassification interface for type ManagedIntegrationRuntimeStatus.
func (m *ManagedIntegrationRuntimeStatus) GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus {
	return &IntegrationRuntimeStatus{
		AdditionalProperties: m.AdditionalProperties,
		DataFactoryName:      m.DataFactoryName,
		State:                m.State,
		Type:                 m.Type,
	}
}

// ManagedIntegrationRuntimeStatusTypeProperties - Managed integration runtime status type properties.
type ManagedIntegrationRuntimeStatusTypeProperties struct {
	// READ-ONLY; The time at which the integration runtime was created, in ISO8601 format.
	CreateTime *time.Time

	// READ-ONLY; The last operation result that occurred on this integration runtime.
	LastOperation *ManagedIntegrationRuntimeOperationResult

	// READ-ONLY; The list of nodes for managed integration runtime.
	Nodes []*ManagedIntegrationRuntimeNode

	// READ-ONLY; The errors that occurred on this integration runtime.
	OtherErrors []*ManagedIntegrationRuntimeError
}

// ManagedIntegrationRuntimeTypeProperties - Managed integration runtime type properties.
type ManagedIntegrationRuntimeTypeProperties struct {
	// The compute resource for managed integration runtime.
	ComputeProperties *IntegrationRuntimeComputeProperties

	// SSIS properties for managed integration runtime.
	SsisProperties *IntegrationRuntimeSsisProperties
}

// ManagedVirtualNetworkSettings - Managed Virtual Network Settings
type ManagedVirtualNetworkSettings struct {
	// Allowed Aad Tenant Ids For Linking
	AllowedAADTenantIDsForLinking []*string

	// Linked Access Check On Target Resource
	LinkedAccessCheckOnTargetResource *bool

	// Prevent Data Exfiltration
	PreventDataExfiltration *bool
}

// MetadataSyncConfig - Configuration for metadata sync
type MetadataSyncConfig struct {
	// Metadata Sync Config properties
	Properties *MetadataSyncConfigProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MetadataSyncConfigProperties - Metadata Sync Config properties
type MetadataSyncConfigProperties struct {
	// Indicates whether the metadata sync is enabled or disabled
	Enabled *bool

	// The Sync Interval in minutes.
	SyncIntervalInMinutes *int32
}

// Operation - A REST API operation
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay

	// This is of the format {provider}/{resource}/{operation}.
	Name *string

	// The intended executor of the operation.
	Origin *string

	// Properties of the operation.
	Properties any
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// The friendly name of the operation.
	Description *string

	// For example: read, write, delete.
	Operation *string

	// Friendly name of the resource provider.
	Provider *string

	// The resource type on which the operation is performed.
	Resource *string
}

// OperationListResult - Result of the request to list REST API operations. It contains a list of operations and a URL nextLink
// to get the next set of results.
type OperationListResult struct {
	// The list of operations supported by the resource provider.
	Value []*Operation

	// READ-ONLY; The URL to get the next set of operation list results if there are any.
	NextLink *string
}

// OperationMetaLogSpecification - What is this?
type OperationMetaLogSpecification struct {
	// Time range the log covers
	BlobDuration *string

	// Log display name
	DisplayName *string

	// Log unique name
	Name *string
}

// OperationMetaMetricDimensionSpecification - What is this?
type OperationMetaMetricDimensionSpecification struct {
	// Dimension display name
	DisplayName *string

	// Dimension unique name
	Name *string

	// Whether this metric should be exported for Shoebox
	ToBeExportedForShoebox *bool
}

// OperationMetaMetricSpecification - What is this?
type OperationMetaMetricSpecification struct {
	// Metric aggregation type
	AggregationType *string

	// Metric dimensions
	Dimensions []*OperationMetaMetricDimensionSpecification

	// Metric description
	DisplayDescription *string

	// Metric display name
	DisplayName *string

	// Whether the regional MDM account is enabled
	EnableRegionalMdmAccount *bool

	// Metric filter
	MetricFilterPattern *string

	// Metric unique name
	Name *string

	// The source MDM account
	SourceMdmAccount *string

	// The source MDM namespace
	SourceMdmNamespace *string

	// Whether the metric supports instance-level aggregation
	SupportsInstanceLevelAggregation *bool

	// Metric units
	Unit *string
}

// OperationMetaPropertyInfo - What is this?
type OperationMetaPropertyInfo struct {
	// Operation service specification
	ServiceSpecification *OperationMetaServiceSpecification
}

// OperationMetaServiceSpecification - What is this?
type OperationMetaServiceSpecification struct {
	// Service log specifications
	LogSpecifications []*OperationMetaLogSpecification

	// Service metric specifications
	MetricSpecifications []*OperationMetaMetricSpecification
}

// OperationResource - An operation
type OperationResource struct {
	// Operation start time
	EndTime *time.Time

	// Errors from the operation
	Error *ErrorDetail

	// Operation ID
	ID *string

	// Operation name
	Name *string

	// Completion percentage of the operation
	PercentComplete *float32

	// Operation properties
	Properties any

	// Operation start time
	StartTime *time.Time

	// Operation status
	Status *OperationStatus
}

// OptimizedAutoscale - A class that contains the optimized auto scale definition.
type OptimizedAutoscale struct {
	// REQUIRED; A boolean value that indicate if the optimized autoscale feature is enabled or not.
	IsEnabled *bool

	// REQUIRED; Maximum allowed instances count.
	Maximum *int32

	// REQUIRED; Minimum allowed instances count.
	Minimum *int32

	// REQUIRED; The version of the template defined, for instance 1.
	Version *int32
}

// PrivateEndpoint - Private endpoint details
type PrivateEndpoint struct {
	// READ-ONLY; Resource id of the private endpoint.
	ID *string
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Private endpoint connection properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type PrivateEndpointConnectionForPrivateLinkHub struct {
	ID   *string
	Name *string

	// Properties of a private endpoint connection.
	Properties *PrivateEndpointConnectionProperties
	Type       *string
}

// PrivateEndpointConnectionForPrivateLinkHubBasic - Private Endpoint Connection For Private Link Hub - Basic
type PrivateEndpointConnectionForPrivateLinkHubBasic struct {
	// Properties of private endpoint connection for private link hub
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; identifier
	ID *string
}

type PrivateEndpointConnectionForPrivateLinkHubBasicAutoGenerated struct {
	ID *string

	// Properties of a private endpoint connection.
	Properties *PrivateEndpointConnectionProperties
}

type PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse struct {
	NextLink *string
	Value    []*PrivateEndpointConnectionForPrivateLinkHub
}

// PrivateEndpointConnectionList - A list of private endpoint connections
type PrivateEndpointConnectionList struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// The private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpoint

	// Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// READ-ONLY; Provisioning state of the private endpoint connection.
	ProvisioningState *string
}

// PrivateLinkHub - A privateLinkHub
type PrivateLinkHub struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// PrivateLinkHub resource properties
	Properties *PrivateLinkHubProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkHubInfoListResult - List of privateLinkHubs
type PrivateLinkHubInfoListResult struct {
	// Link to the next page of results
	NextLink *string

	// List of privateLinkHubs
	Value []*PrivateLinkHub
}

// PrivateLinkHubPatchInfo - PrivateLinkHub patch details
type PrivateLinkHubPatchInfo struct {
	// Resource tags
	Tags map[string]*string
}

// PrivateLinkHubProperties - PrivateLinkHub properties
type PrivateLinkHubProperties struct {
	// PrivateLinkHub provisioning state
	ProvisioningState *string

	// READ-ONLY; List of private endpoint connections
	PrivateEndpointConnections []*PrivateEndpointConnectionForPrivateLinkHubBasic
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The private link resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string

	// READ-ONLY; Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string
}

// PrivateLinkResources - The list Kusto Private Link Resources operation response.
type PrivateLinkResources struct {
	// The list of Kusto Private Link Resources.
	Value []*KustoPoolPrivateLinkResources
}

// PrivateLinkResourcesProperties - Private Link Resources Properties.
type PrivateLinkResourcesProperties struct {
	// READ-ONLY; The Private link resources GroupId
	GroupID *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string

	// READ-ONLY; The private link resource required zone names.
	RequiredZoneNames []*string
}

// PrivateLinkServiceConnectionState - Connection state details of the private endpoint
type PrivateLinkServiceConnectionState struct {
	// The private link service connection description.
	Description *string

	// The private link service connection status.
	Status *string

	// READ-ONLY; The actions required for private link service connection.
	ActionsRequired *string
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PurviewConfiguration - Purview Configuration
type PurviewConfiguration struct {
	// Purview Resource ID
	PurviewResourceID *string
}

// QueryInterval - A database query.
type QueryInterval struct {
	// READ-ONLY; The number of times the query was executed during this interval.
	ExecutionCount *int32

	// READ-ONLY; The start time of the measurement interval (ISO8601 format).
	IntervalStartTime *time.Time

	// READ-ONLY; The list of query metrics during this interval.
	Metrics []*QueryMetric
}

// QueryMetric - A database query.
type QueryMetric struct {
	// READ-ONLY; The name of the metric for display in user interface
	DisplayName *string

	// READ-ONLY; The name of the metric
	Name *string

	// READ-ONLY; The unit of measurement
	Unit *QueryMetricUnit

	// READ-ONLY; The measured value
	Value *float64
}

// QueryStatistic - A database query.
type QueryStatistic struct {
	// READ-ONLY; The list of query intervals.
	Intervals []*QueryInterval

	// READ-ONLY; The id of the query
	QueryID *string
}

// ReadOnlyFollowingDatabase - Class representing a read only following database.
type ReadOnlyFollowingDatabase struct {
	// REQUIRED; Kind of the database
	Kind *Kind

	// Resource location.
	Location *string

	// The database properties.
	Properties *ReadOnlyFollowingDatabaseProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDatabase implements the DatabaseClassification interface for type ReadOnlyFollowingDatabase.
func (r *ReadOnlyFollowingDatabase) GetDatabase() *Database {
	return &Database{
		ID:         r.ID,
		Kind:       r.Kind,
		Location:   r.Location,
		Name:       r.Name,
		SystemData: r.SystemData,
		Type:       r.Type,
	}
}

// ReadOnlyFollowingDatabaseProperties - Class representing the Kusto database properties.
type ReadOnlyFollowingDatabaseProperties struct {
	// The time the data should be kept in cache for fast queries in TimeSpan.
	HotCachePeriod *string

	// READ-ONLY; The name of the attached database configuration cluster
	AttachedDatabaseConfigurationName *string

	// READ-ONLY; The name of the leader cluster
	LeaderClusterResourceID *string

	// READ-ONLY; The principals modification kind of the database
	PrincipalsModificationKind *PrincipalsModificationKind

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState

	// READ-ONLY; The time the data should be kept before it stops being accessible to queries in TimeSpan.
	SoftDeletePeriod *string

	// READ-ONLY; The statistics of the database.
	Statistics *DatabaseStatistics
}

// ReadWriteDatabase - Class representing a read write database.
type ReadWriteDatabase struct {
	// REQUIRED; Kind of the database
	Kind *Kind

	// Resource location.
	Location *string

	// The database properties.
	Properties *ReadWriteDatabaseProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDatabase implements the DatabaseClassification interface for type ReadWriteDatabase.
func (r *ReadWriteDatabase) GetDatabase() *Database {
	return &Database{
		ID:         r.ID,
		Kind:       r.Kind,
		Location:   r.Location,
		Name:       r.Name,
		SystemData: r.SystemData,
		Type:       r.Type,
	}
}

// ReadWriteDatabaseProperties - Class representing the Kusto database properties.
type ReadWriteDatabaseProperties struct {
	// The time the data should be kept in cache for fast queries in TimeSpan.
	HotCachePeriod *string

	// The time the data should be kept before it stops being accessible to queries in TimeSpan.
	SoftDeletePeriod *string

	// READ-ONLY; Indicates whether the database is followed.
	IsFollowed *bool

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ResourceProvisioningState

	// READ-ONLY; The statistics of the database.
	Statistics *DatabaseStatistics
}

// RecommendedSensitivityLabelUpdate - A recommended sensitivity label update operation.
type RecommendedSensitivityLabelUpdate struct {
	// Resource properties.
	Properties *RecommendedSensitivityLabelUpdateProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RecommendedSensitivityLabelUpdateList - A list of recommended sensitivity label update operations.
type RecommendedSensitivityLabelUpdateList struct {
	Operations []*RecommendedSensitivityLabelUpdate
}

// RecommendedSensitivityLabelUpdateProperties - Properties of an operation executed on a recommended sensitivity label.
type RecommendedSensitivityLabelUpdateProperties struct {
	// REQUIRED; Column name to update.
	Column *string

	// REQUIRED
	Op *RecommendedSensitivityLabelUpdateKind

	// REQUIRED; Schema name of the column to update.
	Schema *string

	// REQUIRED; Table name of the column to update.
	Table *string
}

// RecoverableSQLPool - A recoverable sql pool
type RecoverableSQLPool struct {
	// The properties of a recoverable sql pool
	Properties *RecoverableSQLPoolProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RecoverableSQLPoolListResult - The response to a list recoverable sql pools request
type RecoverableSQLPoolListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; A list of recoverable sql pool
	Value []*RecoverableSQLPool
}

// RecoverableSQLPoolProperties - The properties of a recoverable sql pool
type RecoverableSQLPoolProperties struct {
	// READ-ONLY; The edition of the database
	Edition *string

	// READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string

	// READ-ONLY; The last available backup date of the database (ISO8601 format)
	LastAvailableBackupDate *time.Time

	// READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string
}

// ReplaceAllFirewallRulesOperationResponse - An existing operation for replacing the firewall rules
type ReplaceAllFirewallRulesOperationResponse struct {
	// The operation ID
	OperationID *string
}

// ReplaceAllIPFirewallRulesRequest - Replace all IP firewall rules request
type ReplaceAllIPFirewallRulesRequest struct {
	// IP firewall rule properties
	IPFirewallRules map[string]*IPFirewallRuleProperties
}

// ReplicationLink - Represents a Sql pool replication link.
type ReplicationLink struct {
	// The properties representing the resource.
	Properties *ReplicationLinkProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; Location of the workspace that contains this firewall rule.
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ReplicationLinkListResult - Represents the response to a List Sql pool replication link request.
type ReplicationLinkListResult struct {
	// The list of Sql pool replication links housed in the Sql pool.
	Value []*ReplicationLink

	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string
}

// ReplicationLinkProperties - Represents the properties of a Sql pool replication link.
type ReplicationLinkProperties struct {
	// READ-ONLY; Legacy value indicating whether termination is allowed. Currently always returns true.
	IsTerminationAllowed *bool

	// READ-ONLY; The name of the partner Sql pool.
	PartnerDatabase *string

	// READ-ONLY; The Azure Region of the partner Sql pool.
	PartnerLocation *string

	// READ-ONLY; The role of the partner Sql pool in the replication link.
	PartnerRole *ReplicationRole

	// READ-ONLY; The name of the workspace hosting the partner Sql pool.
	PartnerServer *string

	// READ-ONLY; The percentage of seeding complete for the replication link.
	PercentComplete *int32

	// READ-ONLY; Replication mode of this replication link.
	ReplicationMode *string

	// READ-ONLY; The replication state for the replication link.
	ReplicationState *ReplicationState

	// READ-ONLY; The role of the Sql pool in the replication link.
	Role *ReplicationRole

	// READ-ONLY; The start time for the replication link.
	StartTime *time.Time
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceMoveDefinition - Contains the information necessary to perform a resource move (rename).
type ResourceMoveDefinition struct {
	// REQUIRED; The target ID for the resource
	ID *string
}

// RestorableDroppedSQLPool - A restorable dropped Sql pool
type RestorableDroppedSQLPool struct {
	// The properties of a restorable dropped Sql pool
	Properties *RestorableDroppedSQLPoolProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The geo-location where the resource lives
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RestorableDroppedSQLPoolListResult - The response to a list restorable dropped Sql pools request
type RestorableDroppedSQLPoolListResult struct {
	// REQUIRED; A list of restorable dropped Sql pools
	Value []*RestorableDroppedSQLPool
}

// RestorableDroppedSQLPoolProperties - The properties of a restorable dropped Sql pool
type RestorableDroppedSQLPoolProperties struct {
	// READ-ONLY; The creation date of the database (ISO8601 format)
	CreationDate *time.Time

	// READ-ONLY; The name of the database
	DatabaseName *string

	// READ-ONLY; The deletion date of the database (ISO8601 format)
	DeletionDate *time.Time

	// READ-ONLY; The earliest restore date of the database (ISO8601 format)
	EarliestRestoreDate *time.Time

	// READ-ONLY; The edition of the database
	Edition *string

	// READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string

	// READ-ONLY; The max size in bytes of the database
	MaxSizeBytes *string

	// READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string
}

// RestorePoint - Database restore points.
type RestorePoint struct {
	// Resource properties.
	Properties *RestorePointProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; Resource location.
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RestorePointListResult - A list of long term retention backups.
type RestorePointListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*RestorePoint
}

// RestorePointProperties - Properties of a database restore point
type RestorePointProperties struct {
	// READ-ONLY; The earliest time to which this database can be restored
	EarliestRestoreDate *time.Time

	// READ-ONLY; The time the backup was taken
	RestorePointCreationDate *time.Time

	// READ-ONLY; The label of restore point for backup request by user
	RestorePointLabel *string

	// READ-ONLY; The type of restore point
	RestorePointType *RestorePointType
}

// SKU - SQL pool SKU
type SKU struct {
	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32

	// The SKU name
	Name *string

	// The service tier
	Tier *string
}

// SKUDescription - The Kusto SKU description of given resource type
type SKUDescription struct {
	// READ-ONLY; Locations and zones
	LocationInfo []*SKULocationInfoItem

	// READ-ONLY; The set of locations that the SKU is available
	Locations []*string

	// READ-ONLY; The name of the SKU
	Name *string

	// READ-ONLY; The resource type
	ResourceType *string

	// READ-ONLY; The restrictions because of which SKU cannot be used
	Restrictions []any

	// READ-ONLY; The size of the SKU
	Size *string
}

// SKUDescriptionList - The list of the SKU descriptions
type SKUDescriptionList struct {
	// READ-ONLY; SKU descriptions
	Value []*SKUDescription
}

// SKULocationInfoItem - The locations and zones info for SKU.
type SKULocationInfoItem struct {
	// REQUIRED; The available location of the SKU.
	Location *string

	// The available zone of the SKU.
	Zones []*string
}

// SQLPool - A SQL Analytics pool
type SQLPool struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// SQL pool properties
	Properties *SQLPoolResourceProperties

	// SQL pool SKU
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SQLPoolBlobAuditingPolicy - A Sql pool blob auditing policy.
type SQLPoolBlobAuditingPolicy struct {
	// Resource properties.
	Properties *SQLPoolBlobAuditingPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; Resource kind.
	Kind *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SQLPoolBlobAuditingPolicyListResult - A list of Sql pool auditing settings.
type SQLPoolBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*SQLPoolBlobAuditingPolicy
}

// SQLPoolBlobAuditingPolicyProperties - Properties of a Sql pool blob auditing policy.
type SQLPoolBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETED_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'state'
	// as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, storageAccountAccessKey
	// is required.
	StorageAccountAccessKey *string

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// is required.
	StorageEndpoint *string
}

// SQLPoolBlobAuditingPolicySQLPoolOperationListResult - The response to a list Sql pool operations request
type SQLPoolBlobAuditingPolicySQLPoolOperationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*SQLPoolOperation
}

// SQLPoolColumn - A Sql pool column resource.
type SQLPoolColumn struct {
	// Resource properties.
	Properties *SQLPoolColumnProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SQLPoolColumnListResult - A list of Sql pool columns.
type SQLPoolColumnListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*SQLPoolColumn
}

// SQLPoolColumnProperties - Sql pool column properties.
type SQLPoolColumnProperties struct {
	// The column data type.
	ColumnType *ColumnDataType

	// READ-ONLY; Indicates whether column value is computed or not
	IsComputed *bool
}

// SQLPoolConnectionPolicy - A Sql pool connection policy.
type SQLPoolConnectionPolicy struct {
	// Resource properties.
	Properties *SQLPoolConnectionPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; Resource kind.
	Kind *string

	// READ-ONLY; Resource location.
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SQLPoolConnectionPolicyProperties - Properties of a Sql pool connection policy.
type SQLPoolConnectionPolicyProperties struct {
	// The fully qualified host name of the auditing proxy.
	ProxyDNSName *string

	// The port number of the auditing proxy.
	ProxyPort *string

	// The state of proxy redirection.
	RedirectionState *string

	// The state of security access.
	SecurityEnabledAccess *string

	// The connection policy state.
	State *string

	// Whether server default is enabled or disabled.
	UseServerDefault *string

	// The visibility of the auditing proxy.
	Visibility *string
}

// SQLPoolInfoListResult - List of SQL pools
type SQLPoolInfoListResult struct {
	// Link to the next page of results
	NextLink *string

	// List of SQL pools
	Value []*SQLPool
}

// SQLPoolOperation - A Sql pool operation.
type SQLPoolOperation struct {
	// Resource properties.
	Properties *SQLPoolOperationProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SQLPoolOperationProperties - The properties of a Sql pool operation.
type SQLPoolOperationProperties struct {
	// READ-ONLY; The name of the Sql pool the operation is being performed on.
	DatabaseName *string

	// READ-ONLY; The operation description.
	Description *string

	// READ-ONLY; The operation error code.
	ErrorCode *int32

	// READ-ONLY; The operation error description.
	ErrorDescription *string

	// READ-ONLY; The operation error severity.
	ErrorSeverity *int32

	// READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *time.Time

	// READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool

	// READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool

	// READ-ONLY; The name of operation.
	Operation *string

	// READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string

	// READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32

	// READ-ONLY; The name of the server.
	ServerName *string

	// READ-ONLY; The operation start time.
	StartTime *time.Time

	// READ-ONLY; The operation state.
	State *ManagementOperationState
}

// SQLPoolPatchInfo - A SQL Analytics pool patch info
type SQLPoolPatchInfo struct {
	// The geo-location where the resource lives
	Location *string

	// SQL pool properties
	Properties *SQLPoolResourceProperties

	// SQL pool SKU
	SKU *SKU

	// Resource tags.
	Tags map[string]*string
}

// SQLPoolResourceProperties - Properties of a SQL Analytics pool
type SQLPoolResourceProperties struct {
	// Collation mode
	Collation *string

	// Specifies the mode of sql pool creation.
	// Default: regular sql pool creation.
	// PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must
	// be specified as the resource ID of the existing sql pool, and
	// restorePointInTime must be specified.
	// Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId must be specified as the recoverableDatabaseId
	// to restore.
	// Restore: Creates a sql pool by restoring a backup of a deleted sql pool. SourceDatabaseId should be the sql pool's original
	// resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be
	// specified.
	CreateMode *CreateMode

	// Maximum size in bytes
	MaxSizeBytes *int64

	// Resource state
	ProvisioningState *string

	// Backup database to restore from
	RecoverableDatabaseID *string

	// Snapshot time to restore
	RestorePointInTime *time.Time

	// Specifies the time that the sql pool was deleted
	SourceDatabaseDeletionDate *time.Time

	// Source database to create from
	SourceDatabaseID *string

	// The storage account type used to store backups for this sql pool.
	StorageAccountType *StorageAccountType

	// READ-ONLY; Date the SQL pool was created
	CreationDate *time.Time

	// READ-ONLY; Resource status
	Status *string
}

// SQLPoolSchema - A Sql pool schema resource.
type SQLPoolSchema struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SQLPoolSchemaListResult - A list of Sql pool schemas.
type SQLPoolSchemaListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*SQLPoolSchema
}

// SQLPoolSecurityAlertPolicy - A Sql pool security alert policy.
type SQLPoolSecurityAlertPolicy struct {
	// Resource properties.
	Properties *SecurityAlertPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SQLPoolTable - A Sql pool table resource.
type SQLPoolTable struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SQLPoolTableListResult - A list of Sql pool tables.
type SQLPoolTableListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*SQLPoolTable
}

// SQLPoolUsage - The Sql pool usages.
type SQLPoolUsage struct {
	// READ-ONLY; The current value of the usage metric.
	CurrentValue *float64

	// READ-ONLY; The usage metric display name.
	DisplayName *string

	// READ-ONLY; The current limit of the usage metric.
	Limit *float64

	// READ-ONLY; The name of the usage metric.
	Name *string

	// READ-ONLY; The next reset time for the usage metric (ISO8601 format).
	NextResetTime *time.Time

	// READ-ONLY; The name of the resource.
	ResourceName *string

	// READ-ONLY; The units of the usage metric.
	Unit *string
}

// SQLPoolUsageListResult - The response to a list Sql pool usages request.
type SQLPoolUsageListResult struct {
	// REQUIRED; The list of usages for the Sql pool.
	Value []*SQLPoolUsage

	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string
}

// SQLPoolVulnerabilityAssessment - A Sql pool vulnerability assessment.
type SQLPoolVulnerabilityAssessment struct {
	// Resource properties.
	Properties *SQLPoolVulnerabilityAssessmentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SQLPoolVulnerabilityAssessmentListResult - A list of the Sql pool's vulnerability assessments.
type SQLPoolVulnerabilityAssessmentListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*SQLPoolVulnerabilityAssessment
}

// SQLPoolVulnerabilityAssessmentProperties - Properties of a Sql pool Vulnerability Assessment.
type SQLPoolVulnerabilityAssessmentProperties struct {
	// The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties

	// Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey'
	// isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string

	// A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/). It is required
	// if server level vulnerability assessment policy doesn't set
	StorageContainerPath *string

	// A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter.
	// If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is
	// required.
	StorageContainerSasKey *string
}

// SQLPoolVulnerabilityAssessmentRuleBaseline - A Sql pool vulnerability assessment rule baseline.
type SQLPoolVulnerabilityAssessmentRuleBaseline struct {
	// Resource properties.
	Properties *SQLPoolVulnerabilityAssessmentRuleBaselineProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SQLPoolVulnerabilityAssessmentRuleBaselineItem - Properties for an Sql pool vulnerability assessment rule baseline's result.
type SQLPoolVulnerabilityAssessmentRuleBaselineItem struct {
	// REQUIRED; The rule baseline result
	Result []*string
}

// SQLPoolVulnerabilityAssessmentRuleBaselineProperties - Properties of a Sql pool vulnerability assessment rule baseline.
type SQLPoolVulnerabilityAssessmentRuleBaselineProperties struct {
	// REQUIRED; The rule baseline result
	BaselineResults []*SQLPoolVulnerabilityAssessmentRuleBaselineItem
}

// SQLPoolVulnerabilityAssessmentScanExportProperties - Properties of the export operation's result.
type SQLPoolVulnerabilityAssessmentScanExportProperties struct {
	// READ-ONLY; Location of the exported report (e.g. https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
	ExportedReportLocation *string
}

// SQLPoolVulnerabilityAssessmentScansExport - A Sql pool Vulnerability Assessment scan export resource.
type SQLPoolVulnerabilityAssessmentScansExport struct {
	// Resource properties.
	Properties *SQLPoolVulnerabilityAssessmentScanExportProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SecretBase - The base definition of a secret type.
type SecretBase struct {
	// REQUIRED; Type of the secret.
	Type *string
}

// GetSecretBase implements the SecretBaseClassification interface for type SecretBase.
func (s *SecretBase) GetSecretBase() *SecretBase { return s }

// SecureString - Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or
// List API calls.
type SecureString struct {
	// REQUIRED; Type of the secret.
	Type *string

	// REQUIRED; Value of secure string.
	Value *string
}

// GetSecretBase implements the SecretBaseClassification interface for type SecureString.
func (s *SecureString) GetSecretBase() *SecretBase {
	return &SecretBase{
		Type: s.Type,
	}
}

// SecurityAlertPolicyProperties - Properties of a security alert policy.
type SecurityAlertPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on
	// the specific Sql pool.
	State *SecurityAlertPolicyState

	// Specifies an array of alerts that are disabled. Allowed values are: SqlInjection, SqlInjectionVulnerability, AccessAnomaly,
	// DataExfiltration, UnsafeAction
	DisabledAlerts []*string

	// Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool

	// Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses []*string

	// Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32

	// Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat
	// Detection audit logs.
	StorageEndpoint *string

	// READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *time.Time
}

// SelfHostedIntegrationRuntime - Self-hosted integration runtime.
type SelfHostedIntegrationRuntime struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Integration runtime description.
	Description *string

	// When this property is not null, means this is a linked integration runtime. The property is used to access original integration
	// runtime.
	TypeProperties *SelfHostedIntegrationRuntimeTypeProperties
}

// GetIntegrationRuntime implements the IntegrationRuntimeClassification interface for type SelfHostedIntegrationRuntime.
func (s *SelfHostedIntegrationRuntime) GetIntegrationRuntime() *IntegrationRuntime {
	return &IntegrationRuntime{
		AdditionalProperties: s.AdditionalProperties,
		Description:          s.Description,
		Type:                 s.Type,
	}
}

// SelfHostedIntegrationRuntimeNode - Properties of Self-hosted integration runtime node.
type SelfHostedIntegrationRuntimeNode struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The integration runtime capabilities dictionary
	Capabilities map[string]*string

	// READ-ONLY; Maximum concurrent jobs on the integration runtime node.
	ConcurrentJobsLimit *int32

	// READ-ONLY; The time at which the integration runtime will expire in ISO8601 format.
	ExpiryTime *time.Time

	// READ-ONLY; URI for the host machine of the integration runtime.
	HostServiceURI *string

	// READ-ONLY; Indicates whether this node is the active dispatcher for integration runtime requests.
	IsActiveDispatcher *bool

	// READ-ONLY; The most recent time at which the integration runtime was connected in ISO8601 format.
	LastConnectTime *time.Time

	// READ-ONLY; The last time for the integration runtime node update end.
	LastEndUpdateTime *time.Time

	// READ-ONLY; The time the node last started up.
	LastStartTime *time.Time

	// READ-ONLY; The last time for the integration runtime node update start.
	LastStartUpdateTime *time.Time

	// READ-ONLY; The integration runtime node last stop time.
	LastStopTime *time.Time

	// READ-ONLY; The result of the last integration runtime node update.
	LastUpdateResult *IntegrationRuntimeUpdateResult

	// READ-ONLY; Machine name of the integration runtime node.
	MachineName *string

	// READ-ONLY; The maximum concurrent jobs in this integration runtime.
	MaxConcurrentJobs *int32

	// READ-ONLY; Name of the integration runtime node.
	NodeName *string

	// READ-ONLY; The time at which the integration runtime node was registered in ISO8601 format.
	RegisterTime *time.Time

	// READ-ONLY; Status of the integration runtime node.
	Status *SelfHostedIntegrationRuntimeNodeStatus

	// READ-ONLY; Version of the integration runtime node.
	Version *string

	// READ-ONLY; Status of the integration runtime node version.
	VersionStatus *string
}

// SelfHostedIntegrationRuntimeStatus - Self-hosted integration runtime status.
type SelfHostedIntegrationRuntimeStatus struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType

	// REQUIRED; Self-hosted integration runtime status type properties.
	TypeProperties *SelfHostedIntegrationRuntimeStatusTypeProperties

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; The workspace name which the integration runtime belong to.
	DataFactoryName *string

	// READ-ONLY; The state of integration runtime.
	State *IntegrationRuntimeState
}

// GetIntegrationRuntimeStatus implements the IntegrationRuntimeStatusClassification interface for type SelfHostedIntegrationRuntimeStatus.
func (s *SelfHostedIntegrationRuntimeStatus) GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus {
	return &IntegrationRuntimeStatus{
		AdditionalProperties: s.AdditionalProperties,
		DataFactoryName:      s.DataFactoryName,
		State:                s.State,
		Type:                 s.Type,
	}
}

// SelfHostedIntegrationRuntimeStatusTypeProperties - Self-hosted integration runtime status type properties.
type SelfHostedIntegrationRuntimeStatusTypeProperties struct {
	// The list of linked integration runtimes that are created to share with this integration runtime.
	Links []*LinkedIntegrationRuntime

	// The newer versions on download center.
	NewerVersions []*string

	// The list of nodes for this integration runtime.
	Nodes []*SelfHostedIntegrationRuntimeNode

	// The service region of the integration runtime
	ServiceRegion *string

	// READ-ONLY; Whether Self-hosted integration runtime auto update has been turned on.
	AutoUpdate *IntegrationRuntimeAutoUpdate

	// READ-ONLY; The estimated time when the self-hosted integration runtime will be updated.
	AutoUpdateETA *time.Time

	// READ-ONLY; Object with additional information about integration runtime capabilities.
	Capabilities map[string]*string

	// READ-ONLY; The time at which the integration runtime was created, in ISO8601 format.
	CreateTime *time.Time

	// READ-ONLY; It is used to set the encryption mode for node-node communication channel (when more than 2 self-hosted integration
	// runtime nodes exist).
	InternalChannelEncryption *IntegrationRuntimeInternalChannelEncryptionMode

	// READ-ONLY; The latest version on download center.
	LatestVersion *string

	// READ-ONLY; The local time zone offset in hours.
	LocalTimeZoneOffset *string

	// READ-ONLY; The node communication Channel encryption mode
	NodeCommunicationChannelEncryptionMode *string

	// READ-ONLY; The version that the integration runtime is going to update to.
	PushedVersion *string

	// READ-ONLY; The date at which the integration runtime will be scheduled to update, in ISO8601 format.
	ScheduledUpdateDate *time.Time

	// READ-ONLY; The URLs for the services used in integration runtime backend service.
	ServiceUrls []*string

	// READ-ONLY; The task queue id of the integration runtime.
	TaskQueueID *string

	// READ-ONLY; The time in the date scheduled by service to update the integration runtime, e.g., PT03H is 3 hours
	UpdateDelayOffset *string

	// READ-ONLY; Version of the integration runtime.
	Version *string

	// READ-ONLY; Status of the integration runtime version.
	VersionStatus *string
}

// SelfHostedIntegrationRuntimeTypeProperties - The self-hosted integration runtime properties.
type SelfHostedIntegrationRuntimeTypeProperties struct {
	// Linked integration runtime type from data factory
	LinkedInfo LinkedIntegrationRuntimeTypeClassification
}

// SensitivityLabel - A sensitivity label.
type SensitivityLabel struct {
	// Resource properties.
	Properties *SensitivityLabelProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; managed by
	ManagedBy *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SensitivityLabelListResult - A list of sensitivity labels.
type SensitivityLabelListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*SensitivityLabel
}

// SensitivityLabelProperties - Properties of a sensitivity label.
type SensitivityLabelProperties struct {
	// The information type.
	InformationType *string

	// The information type ID.
	InformationTypeID *string

	// The label ID.
	LabelID *string

	// The label name.
	LabelName *string
	Rank      *SensitivityLabelRank

	// READ-ONLY; The column name.
	ColumnName *string

	// READ-ONLY; Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether
	// the sensitivity recommendation on this column is disabled (dismissed) or not.
	IsDisabled *bool

	// READ-ONLY; The schema name.
	SchemaName *string

	// READ-ONLY; The table name.
	TableName *string
}

// SensitivityLabelUpdate - A sensitivity label update operation.
type SensitivityLabelUpdate struct {
	// Resource properties.
	Properties *SensitivityLabelUpdateProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SensitivityLabelUpdateList - A list of sensitivity label update operations.
type SensitivityLabelUpdateList struct {
	Operations []*SensitivityLabelUpdate
}

// SensitivityLabelUpdateProperties - Properties of an operation executed on a sensitivity label.
type SensitivityLabelUpdateProperties struct {
	// REQUIRED; Column name to update.
	Column *string

	// REQUIRED
	Op *SensitivityLabelUpdateKind

	// REQUIRED; Schema name of the column to update.
	Schema *string

	// REQUIRED; Table name of the column to update.
	Table *string

	// The sensitivity label information to apply on a column.
	SensitivityLabel *SensitivityLabel
}

// ServerBlobAuditingPolicy - A server blob auditing policy.
type ServerBlobAuditingPolicy struct {
	// Resource properties.
	Properties *ServerBlobAuditingPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerBlobAuditingPolicyListResult - A list of server auditing settings.
type ServerBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*ServerBlobAuditingPolicy
}

// ServerBlobAuditingPolicyProperties - Properties of a server blob auditing policy.
type ServerBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETED_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'state'
	// as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool

	// Specifies the state of devops audit. If state is Enabled, devops logs will be sent to Azure Monitor. In order to send the
	// events to Azure Monitor, specify 'State' as 'Enabled',
	// 'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true
	// When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit' diagnostic logs category on
	// the master database should also be created.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsDevopsAuditEnabled *bool

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool

	// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed. The default
	// minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, not
	// specifying the storageAccountAccessKey will use SQL server system-assigned
	// managed identity to access the storage. Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server
	// identity. For more information, see Auditing to storage using Managed
	// Identity authentication [https://go.microsoft.com/fwlink/?linkid=2114355]
	StorageAccountAccessKey *string

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string
}

// ServerSecurityAlertPolicy - Workspace managed Sql server security alert policy.
type ServerSecurityAlertPolicy struct {
	// Resource properties.
	Properties *ServerSecurityAlertPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerSecurityAlertPolicyListResult - A list of the workspace managed sql server's security alert policies.
type ServerSecurityAlertPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*ServerSecurityAlertPolicy
}

// ServerSecurityAlertPolicyProperties - Properties of a security alert policy.
type ServerSecurityAlertPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on
	// the specific server
	State *SecurityAlertPolicyState

	// Specifies an array of alerts that are disabled. Allowed values are: SqlInjection, SqlInjectionVulnerability, AccessAnomaly,
	// DataExfiltration, UnsafeAction
	DisabledAlerts []*string

	// Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool

	// Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses []*string

	// Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32

	// Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat
	// Detection audit logs.
	StorageEndpoint *string

	// READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *time.Time
}

// ServerUsage - Represents server metrics.
type ServerUsage struct {
	// READ-ONLY; The current value of the metric.
	CurrentValue *float64

	// READ-ONLY; The metric display name.
	DisplayName *string

	// READ-ONLY; The current limit of the metric.
	Limit *float64

	// READ-ONLY; Name of the server usage metric.
	Name *string

	// READ-ONLY; The next reset time for the metric (ISO8601 format).
	NextResetTime *time.Time

	// READ-ONLY; The name of the resource.
	ResourceName *string

	// READ-ONLY; The units of the metric.
	Unit *string
}

// ServerUsageListResult - Represents the response to a list server metrics request.
type ServerUsageListResult struct {
	// REQUIRED; The list of server metrics for the server.
	Value []*ServerUsage

	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string
}

// ServerVulnerabilityAssessment - A server vulnerability assessment.
type ServerVulnerabilityAssessment struct {
	// Resource properties.
	Properties *ServerVulnerabilityAssessmentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerVulnerabilityAssessmentListResult - A list of the server's vulnerability assessments.
type ServerVulnerabilityAssessmentListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*ServerVulnerabilityAssessment
}

// ServerVulnerabilityAssessmentProperties - Properties of a server Vulnerability Assessment.
type ServerVulnerabilityAssessmentProperties struct {
	// REQUIRED; A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
	StorageContainerPath *string

	// The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties

	// Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey'
	// isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string

	// A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath'
	// parameter. If 'storageAccountAccessKey' isn't specified,
	// StorageContainerSasKey is required.
	StorageContainerSasKey *string
}

// SparkConfigProperties - SparkConfig Properties for a Big Data pool powered by Apache Spark
type SparkConfigProperties struct {
	// The type of the spark config properties file.
	ConfigurationType *ConfigurationType

	// The spark config properties.
	Content *string

	// The filename of the spark config properties file.
	Filename *string

	// READ-ONLY; The last update time of the spark config properties file.
	Time *time.Time
}

// SparkConfigurationInfo - SparkConfiguration Artifact information
type SparkConfigurationInfo struct {
	// REQUIRED; SparkConfiguration configs.
	Configs map[string]*string

	// Annotations for SparkConfiguration.
	Annotations []*string

	// SparkConfiguration merge configs.
	ConfigMergeRule map[string]*string

	// The timestamp of resource creation.
	Created *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// Description about the SparkConfiguration.
	Description *string

	// additional Notes.
	Notes *string
}

// SparkConfigurationListResponse - A list of SparkConfiguration resources.
type SparkConfigurationListResponse struct {
	// REQUIRED; List of SparkConfiguration.
	Value []*SparkConfigurationResource

	// The link to the next page of results, if any remaining results exist.
	NextLink *string
}

// SparkConfigurationResource - SparkConfiguration response details
type SparkConfigurationResource struct {
	// REQUIRED; SparkConfiguration properties.
	Properties *SparkConfigurationInfo

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SsisEnvironment - Ssis environment.
type SsisEnvironment struct {
	// REQUIRED; Type of metadata.
	Type *SsisObjectMetadataType

	// Metadata description.
	Description *string

	// Folder id which contains environment.
	FolderID *int64

	// Metadata id.
	ID *int64

	// Metadata name.
	Name *string

	// Variable in environment
	Variables []*SsisVariable
}

// GetSsisObjectMetadata implements the SsisObjectMetadataClassification interface for type SsisEnvironment.
func (s *SsisEnvironment) GetSsisObjectMetadata() *SsisObjectMetadata {
	return &SsisObjectMetadata{
		Description: s.Description,
		ID:          s.ID,
		Name:        s.Name,
		Type:        s.Type,
	}
}

// SsisEnvironmentReference - Ssis environment reference.
type SsisEnvironmentReference struct {
	// Environment folder name.
	EnvironmentFolderName *string

	// Environment name.
	EnvironmentName *string

	// Environment reference id.
	ID *int64

	// Reference type
	ReferenceType *string
}

// SsisFolder - Ssis folder.
type SsisFolder struct {
	// REQUIRED; Type of metadata.
	Type *SsisObjectMetadataType

	// Metadata description.
	Description *string

	// Metadata id.
	ID *int64

	// Metadata name.
	Name *string
}

// GetSsisObjectMetadata implements the SsisObjectMetadataClassification interface for type SsisFolder.
func (s *SsisFolder) GetSsisObjectMetadata() *SsisObjectMetadata {
	return &SsisObjectMetadata{
		Description: s.Description,
		ID:          s.ID,
		Name:        s.Name,
		Type:        s.Type,
	}
}

// SsisObjectMetadata - SSIS object metadata.
type SsisObjectMetadata struct {
	// REQUIRED; Type of metadata.
	Type *SsisObjectMetadataType

	// Metadata description.
	Description *string

	// Metadata id.
	ID *int64

	// Metadata name.
	Name *string
}

// GetSsisObjectMetadata implements the SsisObjectMetadataClassification interface for type SsisObjectMetadata.
func (s *SsisObjectMetadata) GetSsisObjectMetadata() *SsisObjectMetadata { return s }

// SsisObjectMetadataListResponse - A list of SSIS object metadata.
type SsisObjectMetadataListResponse struct {
	// The link to the next page of results, if any remaining results exist.
	NextLink *string

	// List of SSIS object metadata.
	Value []SsisObjectMetadataClassification
}

// SsisObjectMetadataStatusResponse - The status of the operation.
type SsisObjectMetadataStatusResponse struct {
	// The operation error message.
	Error *string

	// The operation name.
	Name *string

	// The operation properties.
	Properties *string

	// The status of the operation.
	Status *string
}

// SsisPackage - Ssis Package.
type SsisPackage struct {
	// REQUIRED; Type of metadata.
	Type *SsisObjectMetadataType

	// Metadata description.
	Description *string

	// Folder id which contains package.
	FolderID *int64

	// Metadata id.
	ID *int64

	// Metadata name.
	Name *string

	// Parameters in package
	Parameters []*SsisParameter

	// Project id which contains package.
	ProjectID *int64

	// Project version which contains package.
	ProjectVersion *int64
}

// GetSsisObjectMetadata implements the SsisObjectMetadataClassification interface for type SsisPackage.
func (s *SsisPackage) GetSsisObjectMetadata() *SsisObjectMetadata {
	return &SsisObjectMetadata{
		Description: s.Description,
		ID:          s.ID,
		Name:        s.Name,
		Type:        s.Type,
	}
}

// SsisParameter - Ssis parameter.
type SsisParameter struct {
	// Parameter type.
	DataType *string

	// Default value of parameter.
	DefaultValue *string

	// Parameter description.
	Description *string

	// Design default value of parameter.
	DesignDefaultValue *string

	// Parameter id.
	ID *int64

	// Parameter name.
	Name *string

	// Whether parameter is required.
	Required *bool

	// Whether parameter is sensitive.
	Sensitive *bool

	// Default sensitive value of parameter.
	SensitiveDefaultValue *string

	// Parameter value set.
	ValueSet *bool

	// Parameter value type.
	ValueType *string

	// Parameter reference variable.
	Variable *string
}

// SsisProject - Ssis project.
type SsisProject struct {
	// REQUIRED; Type of metadata.
	Type *SsisObjectMetadataType

	// Metadata description.
	Description *string

	// Environment reference in project
	EnvironmentRefs []*SsisEnvironmentReference

	// Folder id which contains project.
	FolderID *int64

	// Metadata id.
	ID *int64

	// Metadata name.
	Name *string

	// Parameters in project
	Parameters []*SsisParameter

	// Project version.
	Version *int64
}

// GetSsisObjectMetadata implements the SsisObjectMetadataClassification interface for type SsisProject.
func (s *SsisProject) GetSsisObjectMetadata() *SsisObjectMetadata {
	return &SsisObjectMetadata{
		Description: s.Description,
		ID:          s.ID,
		Name:        s.Name,
		Type:        s.Type,
	}
}

// SsisVariable - Ssis variable.
type SsisVariable struct {
	// Variable type.
	DataType *string

	// Variable description.
	Description *string

	// Variable id.
	ID *int64

	// Variable name.
	Name *string

	// Whether variable is sensitive.
	Sensitive *bool

	// Variable sensitive value.
	SensitiveValue *string

	// Variable value.
	Value *string
}

// SubResource - Azure Synapse nested resource, which belongs to a workspace.
type SubResource struct {
	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TableLevelSharingProperties - Tables that will be included and excluded in the follower database
type TableLevelSharingProperties struct {
	// List of external tables exclude from the follower database
	ExternalTablesToExclude []*string

	// List of external tables to include in the follower database
	ExternalTablesToInclude []*string

	// List of materialized views exclude from the follower database
	MaterializedViewsToExclude []*string

	// List of materialized views to include in the follower database
	MaterializedViewsToInclude []*string

	// List of tables to exclude from the follower database
	TablesToExclude []*string

	// List of tables to include in the follower database
	TablesToInclude []*string
}

// TopQueries - A database query.
type TopQueries struct {
	// READ-ONLY; The function that is used to aggregate each query's metrics.
	AggregationFunction *QueryAggregationFunction

	// READ-ONLY; The execution type that is used to filter the query instances that are returned.
	ExecutionType *QueryExecutionType

	// READ-ONLY; The duration of the interval (ISO8601 duration format).
	IntervalType *string

	// READ-ONLY; The number of requested queries.
	NumberOfTopQueries *int32

	// READ-ONLY; The end time for queries that are returned (ISO8601 format)
	ObservationEndTime *time.Time

	// READ-ONLY; The start time for queries that are returned (ISO8601 format)
	ObservationStartTime *time.Time

	// READ-ONLY; The type of metric to use for ordering the top metrics.
	ObservedMetric *QueryObservedMetricType

	// READ-ONLY; The list of queries.
	Queries []*QueryStatistic
}

// TopQueriesListResult - Represents the response to a get top queries request.
type TopQueriesListResult struct {
	// REQUIRED; The list of top queries.
	Value []*TopQueries
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TransparentDataEncryption - Represents a Sql pool transparent data encryption configuration.
type TransparentDataEncryption struct {
	// Represents the properties of the resource.
	Properties *TransparentDataEncryptionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; Resource location.
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TransparentDataEncryptionListResult - A list of transparent data encryption configurations.
type TransparentDataEncryptionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*TransparentDataEncryption
}

// TransparentDataEncryptionProperties - Represents the properties of a database transparent data encryption.
type TransparentDataEncryptionProperties struct {
	// The status of the database transparent data encryption.
	Status *TransparentDataEncryptionStatus
}

// UpdateIntegrationRuntimeNodeRequest - Update integration runtime node request.
type UpdateIntegrationRuntimeNodeRequest struct {
	// The number of concurrent jobs permitted to run on the integration runtime node. Values between 1 and maxConcurrentJobs(inclusive)
	// are allowed.
	ConcurrentJobsLimit *int32
}

// UpdateIntegrationRuntimeRequest - Update integration runtime request.
type UpdateIntegrationRuntimeRequest struct {
	// Enables or disables the auto-update feature of the self-hosted integration runtime. See https://go.microsoft.com/fwlink/?linkid=854189.
	AutoUpdate *IntegrationRuntimeAutoUpdate

	// The time offset (in hours) in the day, e.g., PT03H is 3 hours. The integration runtime auto update will happen on that
	// time.
	UpdateDelayOffset *string
}

// UserAssignedManagedIdentity - User Assigned Managed Identity
type UserAssignedManagedIdentity struct {
	// READ-ONLY; The client ID.
	ClientID *string

	// READ-ONLY; The principal ID.
	PrincipalID *string
}

// VirtualNetworkProfile - Virtual Network Profile
type VirtualNetworkProfile struct {
	// Subnet ID used for computes in workspace
	ComputeSubnetID *string
}

// VulnerabilityAssessmentRecurringScansProperties - Properties of a Vulnerability Assessment recurring scans.
type VulnerabilityAssessmentRecurringScansProperties struct {
	// Specifies that the schedule scan notification will be is sent to the subscription administrators.
	EmailSubscriptionAdmins *bool

	// Specifies an array of e-mail addresses to which the scan notification is sent.
	Emails []*string

	// Recurring scans state.
	IsEnabled *bool
}

// VulnerabilityAssessmentScanError - Properties of a vulnerability assessment scan error.
type VulnerabilityAssessmentScanError struct {
	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error message.
	Message *string
}

// VulnerabilityAssessmentScanRecord - A vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecord struct {
	// Resource properties.
	Properties *VulnerabilityAssessmentScanRecordProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VulnerabilityAssessmentScanRecordListResult - A list of vulnerability assessment scan records.
type VulnerabilityAssessmentScanRecordListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*VulnerabilityAssessmentScanRecord
}

// VulnerabilityAssessmentScanRecordProperties - Properties of a vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecordProperties struct {
	// READ-ONLY; The scan end time (UTC).
	EndTime *time.Time

	// READ-ONLY; The scan errors.
	Errors []*VulnerabilityAssessmentScanError

	// READ-ONLY; The number of failed security checks.
	NumberOfFailedSecurityChecks *int32

	// READ-ONLY; The scan ID.
	ScanID *string

	// READ-ONLY; The scan start time (UTC).
	StartTime *time.Time

	// READ-ONLY; The scan status.
	State *VulnerabilityAssessmentScanState

	// READ-ONLY; The scan results storage container path.
	StorageContainerPath *string

	// READ-ONLY; The scan trigger type.
	TriggerType *VulnerabilityAssessmentScanTriggerType
}

// WorkloadClassifier - Workload classifier operations for a data warehouse
type WorkloadClassifier struct {
	// Resource properties.
	Properties *WorkloadClassifierProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WorkloadClassifierListResult - A list of workload classifiers for a workload group.
type WorkloadClassifierListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*WorkloadClassifier
}

// WorkloadClassifierProperties - Workload classifier definition. For more information look at sys.workloadmanagementworkload_classifiers
// (DMV).
type WorkloadClassifierProperties struct {
	// REQUIRED; The workload classifier member name.
	MemberName *string

	// The workload classifier context.
	Context *string

	// The workload classifier end time for classification.
	EndTime *string

	// The workload classifier importance.
	Importance *string

	// The workload classifier label.
	Label *string

	// The workload classifier start time for classification.
	StartTime *string
}

// WorkloadGroup - Workload group operations for a sql pool
type WorkloadGroup struct {
	// Resource properties.
	Properties *WorkloadGroupProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WorkloadGroupListResult - A list of workload groups.
type WorkloadGroupListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*WorkloadGroup
}

// WorkloadGroupProperties - Workload group definition. For more information look at sys.workloadmanagementworkload_groups
// (DMV).
type WorkloadGroupProperties struct {
	// REQUIRED; The workload group cap percentage resource.
	MaxResourcePercent *int32

	// REQUIRED; The workload group minimum percentage resource.
	MinResourcePercent *int32

	// REQUIRED; The workload group request minimum grant percentage.
	MinResourcePercentPerRequest *float64

	// The workload group importance level.
	Importance *string

	// The workload group request maximum grant percentage.
	MaxResourcePercentPerRequest *float64

	// The workload group query execution timeout.
	QueryExecutionTimeout *int32
}

// Workspace - A workspace
type Workspace struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Identity of the workspace
	Identity *ManagedIdentity

	// Workspace resource properties
	Properties *WorkspaceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WorkspaceAADAdminInfo - Workspace active directory administrator
type WorkspaceAADAdminInfo struct {
	// Workspace active directory administrator properties
	Properties *AADAdminProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WorkspaceInfoListResult - List of workspaces
type WorkspaceInfoListResult struct {
	// Link to the next page of results
	NextLink *string

	// List of workspaces
	Value []*Workspace
}

// WorkspaceKeyDetails - Details of the customer managed key associated with the workspace
type WorkspaceKeyDetails struct {
	// Workspace Key sub-resource key vault url
	KeyVaultURL *string

	// Workspace Key sub-resource name
	Name *string
}

// WorkspacePatchInfo - Workspace patch details
type WorkspacePatchInfo struct {
	// The identity of the workspace
	Identity *ManagedIdentity

	// Workspace patch properties
	Properties *WorkspacePatchProperties

	// Resource tags
	Tags map[string]*string
}

// WorkspacePatchProperties - Workspace patch properties
type WorkspacePatchProperties struct {
	// The encryption details of the workspace
	Encryption *EncryptionDetails

	// Managed Virtual Network Settings
	ManagedVirtualNetworkSettings *ManagedVirtualNetworkSettings

	// Enable or Disable public network access to workspace
	PublicNetworkAccess *WorkspacePublicNetworkAccess

	// Purview Configuration
	PurviewConfiguration *PurviewConfiguration

	// SQL administrator login password
	SQLAdministratorLoginPassword *string

	// Git integration settings
	WorkspaceRepositoryConfiguration *WorkspaceRepositoryConfiguration

	// READ-ONLY; Resource provisioning state
	ProvisioningState *string
}

// WorkspaceProperties - Workspace properties
type WorkspaceProperties struct {
	// Enable or Disable AzureADOnlyAuthentication on All Workspace subresource
	AzureADOnlyAuthentication *bool

	// Connectivity endpoints
	ConnectivityEndpoints map[string]*string

	// Initial workspace AAD admin properties for a CSP subscription
	CspWorkspaceAdminProperties *CspWorkspaceAdminProperties

	// Workspace default data lake storage account details
	DefaultDataLakeStorage *DataLakeStorageAccountDetails

	// The encryption details of the workspace
	Encryption *EncryptionDetails

	// Workspace managed resource group. The resource group name uniquely identifies the resource group within the user subscriptionId.
	// The resource group name must be no longer than 90 characters long, and
	// must be alphanumeric characters (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with
	// '.'
	ManagedResourceGroupName *string

	// Setting this to 'default' will ensure that all compute for this workspace is in a virtual network managed on behalf of
	// the user.
	ManagedVirtualNetwork *string

	// Managed Virtual Network Settings
	ManagedVirtualNetworkSettings *ManagedVirtualNetworkSettings

	// Private endpoint connections to the workspace
	PrivateEndpointConnections []*PrivateEndpointConnection

	// Enable or Disable public network access to workspace
	PublicNetworkAccess *WorkspacePublicNetworkAccess

	// Purview Configuration
	PurviewConfiguration *PurviewConfiguration

	// Login for workspace SQL active directory administrator
	SQLAdministratorLogin *string

	// SQL administrator login password
	SQLAdministratorLoginPassword *string

	// Is trustedServiceBypassEnabled for the workspace
	TrustedServiceBypassEnabled *bool

	// Virtual Network profile
	VirtualNetworkProfile *VirtualNetworkProfile

	// Git integration settings
	WorkspaceRepositoryConfiguration *WorkspaceRepositoryConfiguration

	// READ-ONLY; The ADLA resource ID.
	AdlaResourceID *string

	// READ-ONLY; Workspace level configs and feature flags
	ExtraProperties map[string]any

	// READ-ONLY; Resource provisioning state
	ProvisioningState *string

	// READ-ONLY; Workspace settings
	Settings map[string]any

	// READ-ONLY; The workspace unique identifier
	WorkspaceUID *string
}

// WorkspaceRepositoryConfiguration - Git integration settings
type WorkspaceRepositoryConfiguration struct {
	// Account name
	AccountName *string

	// Collaboration branch
	CollaborationBranch *string

	// GitHub Enterprise host name. For example: https://github.mydomain.com
	HostName *string

	// The last commit ID
	LastCommitID *string

	// VSTS project name
	ProjectName *string

	// Repository name
	RepositoryName *string

	// Root folder to use in the repository
	RootFolder *string

	// The VSTS tenant ID
	TenantID *string

	// Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration
	Type *string
}
