# AngularUI Router &nbsp;[![Build Status](https://travis-ci.org/angular-ui/ui-router.svg?branch=master)](https://travis-ci.org/angular-ui/ui-router)

[![Greenkeeper badge](https://badges.greenkeeper.io/angular-ui/ui-router.svg)](https://greenkeeper.io/)

**Note: this is the Angular 1.x source for UI-Router version 1.0.  If you are looking for the source for UI-Router 
version 0.2.x, it can be found [here](https://github.com/angular-ui/ui-router/tree/legacy)**

---


#### The de-facto solution to flexible routing in angular
---
**[Tutorials](https://ui-router.github.io/tutorials/)** |
**[API Docs](https://ui-router.github.io/docs/latest/)** |
**[Download stable](http://unpkg.com/@uirouter/angularjs@latest/release/angular-ui-router.js)** (or **[Minified](http://unpkg.com/@uirouter/angularjs@latest/release/angular-ui-router.min.js)**) **|**
**[Guide](https://github.com/angular-ui/ui-router/wiki) |**
**[Sample App](http://ui-router.github.io/resources/sampleapp/) |**
**[FAQ](https://github.com/angular-ui/ui-router/wiki/Frequently-Asked-Questions) |**
**[Report an Issue](https://github.com/angular-ui/ui-router/blob/master/CONTRIBUTING.md#report-an-issue) |**
**[Contribute](https://github.com/angular-ui/ui-router/blob/master/CONTRIBUTING.md#contribute) |**
**[Help!](http://stackoverflow.com/questions/ask?tags=angularjs,angular-ui-router) |**

---

Angular UI-Router is a client-side [Single Page Application](https://en.wikipedia.org/wiki/Single-page_application) 
routing framework for [AngularJS](http://angularjs.org).  
  
Routing frameworks for SPAs update the browser's URL as the user navigates through the app.  Conversely, this allows 
changes to the browser's URL to drive navigation through the app, thus allowing the user to create a bookmark to a 
location deep within the SPA.

UI-Router applications are modeled as a hierarchical tree of states. UI-Router provides a 
[*state machine*](https://en.wikipedia.org/wiki/Finite-state_machine) to manage the transitions between those 
application states in a transaction-like manner. 

## Get Started


- [UI-Router for Angular 1](https://ui-router.github.io/ng1)
- [UI-Router for Angular 2](https://ui-router.github.io/ng2)
- [UI-Router for React](https://ui-router.github.io/react)

## Resources

* [In-Depth Guide](https://github.com/angular-ui/ui-router/wiki)
* [Slides comparing ngRoute to ui-router](http://slid.es/timkindberg/ui-router#/)
* [UI-Router Extras / Addons for legacy (0.x)](http://christopherthielen.github.io/ui-router-extras/#/home) (@christopherthielen)
 
### Videos

* [Introduction Video](https://egghead.io/lessons/angularjs-introduction-ui-router) (egghead.io)
* [Tim Kindberg on Angular UI-Router](https://www.youtube.com/watch?v=lBqiZSemrqg)
* [Activating States](https://egghead.io/lessons/angularjs-ui-router-activating-states) (egghead.io)
* [Learn Angular.js using UI-Router](http://youtu.be/QETUuZ27N0w) (LearnCode.academy)

## Reporting issues and Contributing

Please read our [Contributor guidelines](CONTRIBUTING.md) before reporting an issue or creating a pull request.
