/*
 ***** BEGIN LICENSE BLOCK *****
 * Version: EPL 2.0/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Eclipse Public
 * License Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.eclipse.org/legal/epl-v20.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Copyright (C) 2013-2017 The JRuby Team (jruby@jruby.org)
 * 
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the EPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the EPL, the GPL or the LGPL.
 ***** END LICENSE BLOCK *****/
package org.jruby.ext.ripper;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          107,  464,  467,  318,  671,  596,  319,  230,  230,  645, 
          327,  404,  273,  712,  246,  247,  486,  203,  252,  390, 
          384,   96,   96,  696,  342,  397,  775,  200,  641,  308, 
          909,  650,  912,  499,  232,  232,  766,  203,  445,  660, 
          770,  595,  983,  311,  907,   89,   89,  200,  550,  552, 
          916,  915,  571,  285,  289,  818,  712,  571,  125,  249, 
          342, 1292,  569,  442,  911,  233,  233, 1163,  341,  203, 
         1279,  529,   96,   96,  585,  531,  309,  389,  249,  585, 
          709,  308,  334,  334,  709, 1068,  232,  308,  308,  257, 
          391,  392,  336,  465,  308,  678,  978,  280,  237,  237, 
          704,  818,  612,  517,  818,  282,  230,  278,  339,  245, 
          761,  383,  684,  778,  742, 1234,  996,  742,  748,  641, 
          835,  650,  819,  804, 1169,  125,  819,  819,  309,  203, 
         1306,  779,  998,  232,  422,  422,  321,  232,  284,  288, 
         1111,  459,  232,  232,  749,  742,  805,  806,  742,  748, 
          818,  612,  748,  108,  729,  480,  125,  338,  896,  125, 
          739,  486,  105,  742,  233,  430,  806,  748,  501,  377, 
           94,  474,  348,  349,  375, 1168,  125,  377,  372,  376, 
          273,  729,  375,  373,  806,  374,  513,  376, 1279,  750, 
          899, 1184,  383,  105, 1139, 1140,  769,  237,  427,  521, 
          339,  523, 1027,  427,  427,  242,  486,  535,  245,  337, 
          818,  342,  806,  105, 1306,  510,  563,  733, 1067, 1067, 
          249,  600,  601,  602,  603,  334,  334,  769, 1112,  773, 
          769,  273,  540,  664,  230,  336,  230,  230,  486,  818, 
           96,  838,  929,  498,  519,  769,  567,  712,  804,  338, 
         1228, 1199,  107,  818,  246,  520, 1330,  391,  845,  818, 
          773,  232,  718,  232,  232,  819, 1118,  232,  382,  232, 
          753,  805,  775,   96,  307,   96,  486,  308,  773,  249, 
          914,  747,  817,  747,  907,  339,  824,  914,  818,   96, 
          510,   96,  233,  718,  233,  494,  846,   89,  911,  389, 
          761,  902, 1256,  775,  759,  733,  254,  339,  569,  248, 
          769,  718,  860,  515,  336,  754,  709,  729,  709, 1105, 
          256,  775,  687, 1291,  309,  237,  278,  237,  500,  996, 
          502, 1236, 1237,  729,  338,  759,  818, 1185,  759,  510, 
          348,  349, 1208,  773,  388,  533,  847,  389,  819,  382, 
           96,  475,  476,  759, 1007,   96,  338,  307,  818,  612, 
           96,  273,  232,  232,  232,  232,   96,  232,  232, 1000, 
         1002, 1004, 1162, 1006, 1273,  308,  386,  396, 1008,  854, 
          230,  568,  692,  649,   89, 1067,  498,  742,   94,  666, 
          604,  748,  479,  656,  125,  486,  599,  656,  656,  656, 
          651,  342,  686,  709,  688,  819,  819,  232,  651,  715, 
          819,  819,  683,  818,  322,  960,  718, 1162,  759,  720, 
          721,   96,  309,  427,  427,  427,  427,  804,  605,  606, 
         1167,  105, 1274,  323,  694,  804, 1067,  732,  232,  818, 
          818,  612,  734,  535,  269,   96,  543,  458,  761,  888, 
          761,  733,  818, 1067, 1067, 1067,  278,  679,  351,  875, 
          486,  486,   96,  232,   96,  571,  351,  818,  806,  769, 
          818,  230,  138,  649,   60,  742,  897,  498,  543,  748, 
          897, 1145,  656,  364,  365,  656,  656,  585,  818,  879, 
          651,  389,  762,  818,  886,  545,  546,  722,  232,  668, 
          733,  818,  773,  324,    8,  881,  649,  585,  683,  585, 
          389,  963,  656,  308,    8, 1351,  203,  712, 1308,  818, 
         1310,  138,  884,  651,  427,  818,  200,  545,  546,  325, 
          458,  230,  788,  649,  907,  718,  479,  498, 1106,   96, 
          916, 1313,  679,  813,  819,  775,  922,  510,  867,  330, 
          651,  806,  389,  683,  818,  539,  819,  769,  232,  922, 
          309, 1052, 1052,    8,  710, 1075, 1077,  535, 1138,  864, 
         1080, 1082,  669, 1088,  818,  813,  670,  759, 1209, 1211, 
         1212, 1213,  562, 1186,  837,  250,  787,  253,  709,  791, 
          773,  784,  641,  992,  650,  389,  563,  675,  386,  387, 
          815,  964, 1349,  376,  815,  815,  833,  735,  379,  571, 
          863,  525,  907,  232, 1142,  974,  232,  400, 1175, 1241, 
         1244, 1258,  437,  718,  856,  389,  567,  568, 1267,    8, 
         1095,  585,  389,  775,  802,  803, 1176,  308,  885,  849, 
          691,  427,  775,  809,  811,  524,  386,  478,  812,  818, 
          395,  438,  376,  809,  823,  870, 1197,  921,  812,  879, 
          761,  761,  369,  922,  368,  759,  286,  230,  399,  649, 
          952,  437,  427,  498,   97,  427,  816, 1217,  343,  904, 
          816,  816,  232,  230,  309,  649,  651,  377,  871,  498, 
          804,  775,  375,  373,  232,  374,   96,  376,  818,   96, 
          438,  232,  651,  525, 1192,   97,  818,  203,  308,  343, 
          232,  818,  829,  829,  819,   96,  249,  200,  818,  962, 
          818,  802,  809,  818,  818,   97, 1327,  812, 1052,  138, 
          805, 1328,  401,  966,  922,  569,  437,  528,  805,  953, 
         1190,  535,  232,  585, 1324,  819,  405,  955,  470,  818, 
         1322, 1238, 1339,  377, 1269,  309,  775,  345,  375,  373, 
         1345,  374,  851,  376, 1186,  438, 1186,  234,  241,  818, 
          914,  972,  669, 1186,  804,  543, 1141,  961,  468,  818, 
         1205,  924,  348,  930,  818,  389,  103, 1150,  345,  248, 
          386,  512,  144,  477,  818,  481,  442,  819,  656,  656, 
          880,  990,  991,  882,  484,  656,  656,  683,  683,  386, 
          538,  308,  792,  485, 1188,  487,  348,  103,  348,  488, 
          544,  995,  975,  733,  545,  546,   97,   97,  486,  469, 
          675,  348,  471,  472,  473,  829,  309,  103, 1286,   97, 
           97,  144,  507, 1194, 1186,  511, 1186,  969, 1186, 1100, 
         1186,  386,  674,  532,  733,   19,  351, 1233,  309,  729, 
          232,   96,  203,  348, 1242, 1245,  406,  309,  969, 1186, 
          514,  656,  656,  486,  656,  656,  101,   97,   97,  518, 
          806,  527,   96,  815,  815, 1010,   19,  880,  815,  815, 
          530,   97, 1165, 1166,  386,  690,  348,  534, 1229, 1096, 
         1221, 1222,  818,  818,   19,  486,  825,  101,  818,  308, 
          818,  804,  804,  804,  805, 1243, 1246,  804,  804,  309, 
          804,  427,  541, 1239,  386,  951, 1013,  101,  804, 1099, 
          734,  386, 1216,  356,  357,  594, 1073, 1073,   97,  652, 
          308,  656,   97,   97,  230,   96,  649,   97,   97,  597, 
          498,  819,  656,  655,  307,  818,  818,  818,  825,  816, 
          816,  734,  543,  651,  816,  816,  818,  818, 1121,   96, 
           19,  232,  818,  818,  818,  883,  351,  667,   96,  818, 
           96, 1155,  819,  308,  656,  307,  818,  910,  421,   96, 
          232,  917,  308, 1085,  489, 1188,  492, 1188,  805, 1301, 
         1302, 1303, 1094,  557,  818,  558,  559,  560,  561,  562, 
          789,  545,  546,   95, 1230,  818,  818,  804,  672,  421, 
          249,  689,  815,  563,  693,  792,  424,  942,   96,  129, 
         1135,  348,   98, 1191,  815,  947,  598,  564, 1231,  137, 
          699, 1325,  351,  700,   95,   97,  795,  565,  569,  144, 
          799,  427,  570,  567,  568,  103,  716,  424, 1218,  364, 
          365,  717,  486,   98,   93, 1202,   97,  539,   97,   97, 
          719, 1206,   97, 1207,   97,  682,  348,  725,   97, 1188, 
           97,  539,  736,   98,  386, 1316,  726,  701,  137, 1240, 
           96,  708,  848,   96,   97,  286,   97, 1219,  816,  125, 
          853,  486,  857, 1270, 1271,  750,  763,   19,   19,   19, 
          816,  539,  422,   19,   19,  539,   19,  348,  348,  924, 
          682,  765,  425,  767,   19,   96,  769,  486,  486,  774, 
           96,   96,  780,   96,  708,  805,  805,  805,  286,  750, 
         1290,  805,  805,  422,  805,  101,  486,  776, 1320, 1321, 
          777,  106,  805,  425,  750,   97, 1268,   96,  733,  308, 
           97, 1298, 1299, 1300,  423,   97,  503,   97,   97,   97, 
           97,   97,   97,   97, 1294,  782,  504,  505,  486,  232, 
          800,  794,  106,  114,  114, 1076, 1078,  801,  749,  733, 
         1081, 1083,  537,  537,  771,  423,  114,  114,  326,  804, 
          969,  797,  106,  839,  806,  807, 1265,  733,  326,  230, 
          808,  649,   97,   19,   99,  498,   96,  784,  850,  750, 
          818, 1117,  749, 1119,  818,  818,   97, 1120,  651, 1076, 
         1078,  867, 1081, 1083,  114,  114,  232,  749,  308,  326, 
          427,  805,  321,   97,  864,   99,   96,  898,  114,  873, 
           97,  132,  818,  818,  661,  662,  663,  326,  818,  874, 
          900,  965,  543,  806,  148,   99,  969,   97,   97,   97, 
          876,  877,  828,  834,  903,  104,  905,   96, 1343,  977, 
          108,  788,  979,  920,  932, 1317,  934,  677,  943,  232, 
          232,  937, 1180,  944,  102,  114,  137,   94,  806,  114, 
          132,   98,  749,   97,  114,  114,  104,  548,  872,  948, 
          950,  545,  546,  954,  698,  958,  557,  878,  558,  559, 
          560,  561,  562,  326, 1193,  102,  104,  708,  959,  286, 
          348,  348,  677,  922,  144,  486,  563,  100,   96,  711, 
          986,  969,  713,  714,   97,  102,  989,  999, 1001,  298, 
          427,  427, 1003, 1193,  543,  551, 1005,  779, 1011,  298, 
          565, 1070,  742,   97,  788,  566,  567,  568,  100,  730, 
          119, 1154,  683, 1115,  682,  682, 1116, 1097,  710, 1164, 
         1172, 1098,  919,   40,   41,   42,   43, 1173,  100, 1101, 
          298, 1210, 1103,  293,  543,  927,  742, 1107, 1203,  761, 
          486,  486,  114,  545,  546,  806,  710, 1204,  298,  543, 
          710,  742,  921,  430,  708, 1225,  148,  683,   97,  806, 
          106,   97, 1162,  114, 1215,  114,  114,  710, 1226,  114, 
         1227,  114, 1283,  761, 1025,  114,  957,  114, 1251,  548, 
         1253, 1250, 1257,  545,  546, 1259,  792, 1260,  761, 1281, 
         1296,  114,  348,  114,  549,  118, 1282,  682,  545,  546, 
          326,  326,  326, 1293, 1297,  148,  326,  326, 1304,  326, 
         1311, 1315, 1326, 1307,  298, 1331,  742,  326, 1333,  981, 
          129,   97, 1314,   99, 1335,   97,   97,   97,  543, 1337, 
          104,  104,  326,  326,  326,  326,  326,  348, 1346,   97, 
         1356,   97,  682,  543,   97,  818,   97,  818,  132, 1196, 
          792,  129,  114,  761,  129,   97,  348,  114,  806,  804, 
           97,  788,  114,  811,  114,  114,  114,  114,  114,  114, 
          114,  129,  543,  548,  806,  811,  813,  545,  546,  642, 
         1230,  104,  104,  806,  104,  310,  806,   97,  746,  139, 
          368, 1110,  545,  546,  818, 1347,  329, 1348,  806, 1350, 
         1250,  348,  752,  102,  425, 1250,  326,  973, 1093,  114, 
          509, 1318, 1329,  731,  733, 1289,  822,  751, 1359, 1214, 
         1177,  545,  546,  114,  642,  684,  677,  677,  642,  642, 
         1104,  806, 1152,  441, 1250, 1309,  908,  310,  139,  286, 
          114,   18,  901,  423,  423,  138,  100,  114,  997, 1074, 
          460,  298,  298,  298, 1329,  913, 1312,  298,  298, 1280, 
          298, 1344,  813,  636,  114,  114,  114,  956,  298, 1110, 
          684,  557,   18,  558,  559,  560,  561,  463, 1352, 1235, 
          298,  298, 1232,  298,  298,  298,  298,  806,   84,   84, 
           18, 1247,  394, 1248,  925,  940,  941, 1295,  891,  892, 
          114,  893,  945,  946, 1266,   97,   97,    0,   45,   46, 
            0,  683,  683,  148,  710,  755,  710,  710,  710,  710, 
          710,  343,  344,  345,  346,  347, 1156,   97, 1157, 1158, 
          137, 1159,    0,    0,  710,    0,    0,    0,  298,   84, 
           84,  114, 1195,  306,  806,  806,    0,    0,  710,  104, 
          140,    0,    0,    0,    0, 1201,   18,  298,  710,    0, 
          114,    0,    0,  710,  710,  710,    0,  806,  984,  985, 
         1160,  987,  988,  557,    0,  558,  559,  560,  561,    0, 
         1110,    0,  104,    0,  104,    0,  685,    0,    0,  129, 
           97,  348,  348,    0,    0,  306,  682,  682,  104,  140, 
          104,  306,  306,    0,   97,   97,    0,    0,  306,   97, 
           97,   68,    0,    0,   97,  114,   97,  755,  114,    0, 
            0,   68,  756,   97,    0,   97,    0,    0, 1152,    0, 
            0,  685,    0,  310,   97,   97,    0,    0, 1079,    0, 
            0,  142,    0,  806,  806,  806,  139,    0,    0, 1091, 
         1272,    0,   68,    0,    0,  348,  348,    0,  557,  104, 
          558,  559,  560,  561,  104,    0,    0,    0,    0,  104, 
           68,    0,    0,   97,    0,  104, 1323,  687,  114,  677, 
            0, 1108,  114,  114,  114,  806,    0, 1037, 1037,    0, 
          142,    0,    0,   18,   18,   18,  114,    0,  114,   18, 
           18,  114,   18,  114,    0,    0,    0,   84,    0,  788, 
           18,    0,  114,  677,    0,  677,  680,  114,    0,  120, 
            0,  684,  687,    0,  684,  684,    0,    0,  677,    0, 
          104,  310,    0,  795,    0,   97,   68,    0,   97,    0, 
           84,    0,   84,   97,  114,    0,  789,    0,    0,    0, 
          680,    0,  680,    0,  104,   97,   84,    0,   84,    0, 
          677,    0,    0,  791,    0,  680,  684,  795,    0,  795, 
           97,  104,    0,  104,    0,   97,   97,    0,   97,    0, 
         1037, 1037,  795,  710, 1037, 1276,    0,  558,  559,  560, 
          561,  306,  788,  677,    0,    0,    0,  680,    0,   18, 
          788,    0,   97,    0,  113,    0,  677,  140,    0,    0, 
            0,  710,    0,    0,  795,  710,    0,   84, 1037,  113, 
            0,    0,   84,    0,   97,    0,    0,   84,    0,  789, 
          680,    0,  710,   84,  818,    0,    0,    0,    0,   85, 
           85,    0,    0,    0,    0,    0,  795,  795,  104,  788, 
          113,  677,    0,  113, 1037,  677,    0,    0,    0,    0, 
            0,   97,  114,  114,    0,    0,    0,    0,    0,  310, 
          113,    0,    0,   68,   68,   68,    0,  141,   68,   68, 
           68,   97,   68,  788,  114,  685,  685,    0,   84,  306, 
           85,   85,   68,    0,  307, 1037,    0,    0,  142, 1037, 
          677,    0,   68,   68,    0,   68,   68,   68,   68,   68, 
            0,    0,   84,  686,    0, 1037, 1037, 1037, 1037,    0, 
          135,    0, 1037, 1037,    0, 1037,  141,    0,    0,   84, 
            0,   84,  788,    0,   97,   97,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  307,  114,  143,  788, 
          789,    0,  307,  307,  139,    0,  680,    0,  686,  307, 
          134,  114,  114,    0,  133,    0,  114,  114,    0,  135, 
            0,  114,    0,  114,  106,  106,  687,  687,    0,   68, 
          114,    0,  114,   97,  688,  820,  789,    0,    0,  820, 
          820,  114,  114,  310,    0,    0,  679,  143,    0,    0, 
          678,  680,    0,  795,    0,  104,   84,    0,  104,  134, 
            0,    0,    0,  133,  677,  677,    0,    0,    0,    0, 
          684,  684, 1038, 1038,  104,  106,  106,  306,    0,  688, 
          114,    0,    0,  789,    0,    0,    0,    0,    0,  132, 
          788,  679,    0,    0, 1037,  678,    0,    0,    0, 1037, 
            0,  680,  680,    0,    0,    0, 1037,    0,   85,    0, 
            0,    0,    0,    0,  310,  136,  789,  521,  795,  795, 
          116,    0,  680,  894,  121,    0,  685,  521, 1037,  710, 
            0,  710,  710,  710,  710,  710,    0,    0,  113,  788, 
            0,   85,  114,   85,  462,  114,    0,    0, 1037,  710, 
          114,  681,    0,    0,    0,  677,  677,   85,  521,   85, 
            0,  521,  114,  710,  136, 1038, 1038,  680,    0, 1038, 
            0,  685,    0,  710,    0,    0,  521,  114,  710,  710, 
          710,    0,  114,  114,  141,  114,    0,    0,    0,    0, 
            0,    0,  307,   84,    0,    0,  681,   84,   84,  789, 
            0,  306,  150, 1038,  677,  677,    0,    0,    0,  114, 
          521,    0,  123,   84,  687,  791,   84,  310,   85,  127, 
          104,  795,    0,   85,    0,    0,    0,  135,   85,    0, 
            0,  114,   84,    0,   85,    0,   73,    0,  339, 1038, 
          789,  104,  521,  106,    0,    0,   73,    0,  791,    0, 
            0,  150,  126,    0,  791,  143,    0,    0,    0,  687, 
            0,    0,  686,  686,    0,    0,  795,  134,  114,    0, 
            0,  133,  306,    0,    0,    0,  106,   73,  106,    0, 
         1038,    0,    0,  339, 1038,    0,    0,    0,  114,   85, 
          307,    0,  106,    0,  106,   73,    0,    0,  795,  791, 
         1038, 1038, 1038, 1038,  104,  680,  680, 1038, 1038,    0, 
         1038,    0,    0,   85,    0,  122,    0,  686,  820,  820, 
            0,    0,    0,  820,  820,    0,    0,    0,  104,    0, 
           85,  791,   85,  688,  688,    0,    0,  104,    0,  104, 
            0,  114,  114, 1039, 1039,  679,  679,    0,  104,  678, 
          678,  100,  100,  106,    0,  135,  789,  149,  106,  140, 
            0,   73,  686,  106,    0,    0,    0,    0,    0,  106, 
            0,  124,  136,  688,    0,  306,    0,    0,   84,  521, 
          521,  521,    0,    0,  521,  521,  521,  104,  521, 1136, 
          114,    0,    0,  349,    0,    0,  521,    0,  521,   84, 
            0,    0,  100,  100,    0,    0,  149,   85,  521,  521, 
            0,  521,  521,  521,  521,  521,    0,    0,  688,    0, 
            0,  680,  680,    0,  106,  685,  685,    0,  307, 1038, 
            0, 1040, 1040,    0, 1038,    0, 1039, 1039,  349,    0, 
         1039, 1038,    0,    0,    0,    0,    0,  142,  106,  104, 
          681,  681,  104,    0,  146,  795,    0,  820,    0,  150, 
            0,    0,   84, 1038,    0,  106,  521,  106,  577,  820, 
            0,  115,    0,  679, 1039,    0,   84,   84,  577,    0, 
            0,   84,   84, 1038,  104,  521,   84,  145,  791,  104, 
          104,    0,  104,    0,    0,   84,    0,   84,   73,   73, 
           73,    0,    0,   73,   73,   73,   84,   73,    0,  577, 
         1039,    0,  577,  687,  687,   73,  104,   73,  679,    0, 
          795,  795,    0,    0, 1040, 1040,    0,  577, 1040,    0, 
           73,   73,   73,   73,   73,    0,    0,  339,  339,    0, 
            0,    0,  106,    0,   85,   84,    0,  306,   85,   85, 
          141, 1039,  307,  791,  791, 1039,    0,    0,    0,    0, 
            0,  577, 1040,    0,   85,  423,  114,   85,  678,    0, 
          100, 1039, 1039, 1039, 1039,  104,    0,    0, 1039, 1039, 
            0, 1039,    0,   85,    0,    0,    0,    0,    0,    0, 
            0,    0,  577,  577,  119,    0,    0,    0, 1040,    0, 
            0,  116,    0,  100,   73,  100,  143,   84,    0,    0, 
           84,    0,    0,  678,  149,   84,  686,  686,    0,  100, 
          118,  100,    0,  307,    0,  119,    0,   84,  119,    0, 
          683,  789,  116,    0,    0,  116,    0,  680,    0, 1040, 
          146,    0,   84, 1040,  423,  119,    0,   84,   84,    0, 
           84,  118,  116,    0,  118,    0,  682,    0,    0, 1040, 
         1040, 1040, 1040,    0,    0,    0, 1040, 1040,    0, 1040, 
          791,  118,  688,  688,   84,  683,  795,  127,    0,  821, 
          100,    0,  680,  821,  821,  100,    0, 1041, 1041,  146, 
          100,    0,  349,  349,    0,    0,  100,  104,    0,  106, 
         1039,  682,  106,    0,    0, 1039,  134,  791,  127,    0, 
            0,  127, 1039,  795,  789,    0,    0,    0,  106,    0, 
            0,  795,  117,  306,  681,    0,  307,    0,  127,   85, 
          577,  577,  577,   84, 1039,  577,  577,  577,    0,  577, 
          120,    0,    0,    0,    0,    0,    0,  577,    0,  577, 
           85,  100,    0,  795, 1039,    0,    0,    0,  795,  577, 
          577,    0,  577,  577,  577,  577,  577,    0,  131,  681, 
          339,  120,  679,  679,  120,  100,  684,    0,    0,    0, 
         1041, 1041,    0,    0, 1041,    0,    0,    0, 1040,    0, 
          795,  120,  100, 1040,  100,  145,    0,    0,    0,  792, 
         1040,  133,  306,  128,    0,  792,    0,    0,    0,    0, 
            0,    0,    0,   85,    0,  339,    0,  577, 1041,    0, 
            0,  684, 1040,    0,    0,  791,    0,   85,   85,    0, 
          147,  791,   85,   85,    0,    0,  577,   85,    0,    0, 
            0,    0, 1040,    0,  145,    0,   85,  130,   85,  349, 
          792,    0,    0,    0, 1041,   84,    0,   85,    0,    0, 
          792,    0,    0,  119,  106,    0,  792,  678,  678,  100, 
          116,  789,    0,  121,    0,    0,  791,    0,    0,  147, 
            0,    0,  792,    0,    0,  106,    0,    0,    0,  118, 
            0, 1042, 1042,   47,  349, 1041,   85,  146,  307, 1041, 
            0,    0,    0,   47,  121,    0,    0,  121,  791,  685, 
          795,  792,    0,    0,    0, 1041, 1041, 1041, 1041,    0, 
            0,    0, 1041, 1041,  121, 1041,    0,    0,    0,  683, 
          683,    0,    0,    0,   47,    0,  680,  680,    0,    0, 
            0,    0,    0,  792,    0,    0,  127,  795,  106,    0, 
            0,    0,   47,    0,  685,  682,  682,  136,   85,    0, 
            0,   85,  821,  821,    0,    0,   85,  821,  821,    0, 
            0,    0,  106,    0,    0,  795,  795,    0,   85,    0, 
            0,  106,    0,  106, 1042, 1042,    0,    0, 1042,    0, 
            0,    0,  106,   85,    0,    0,    0,    0,   85,   85, 
            0,   85,    0,  150,    0,    0,  100,  229,  229,  120, 
          100,  100,  795,  795, 1043, 1043,    0,    0,   47,    0, 
            0,    0, 1042,  681,  681,   85,  100,    0,    0,  100, 
            0,  106,    0, 1137,    0,    0,    0,  126,  147,  792, 
          262,  266,  267,  268, 1041,  100,    0,  229,  229, 1041, 
            0,    0,  145,    0,    0,    0, 1041,    0, 1042,  326, 
          328,    0,    0,    0,    0,  791,    0,  791,  126,  339, 
          339,  126,    0,  791,  307,  684,  684,    0, 1041,    0, 
            0,    0,  149,    0,   85,    0,    0,  147,  126,    0, 
            0,    0,    0,  106,    0,    0,  106,    0, 1041, 1042, 
          792,  821,    0, 1042,  792,  792,  229, 1043, 1043,    0, 
            0, 1043,    0,  821,    0,    0,    0,    0,  791, 1042, 
         1042, 1042, 1042,    0,  569,    0, 1042, 1042,  106, 1042, 
          791,  791,    0,  106,  106,    0,  106,    0,    0,    0, 
            0,    0,  121,    0,    0, 1043,  128,    0,  349,  349, 
          791,    0,    0,  307,    0,   47,   47,   47,    0,    0, 
          106,   47,   47,    0,   47,  792,  792,    0,    0,    0, 
            0,    0,   47, 1044, 1044,    0,  792,  128,    0,    0, 
          128, 1043,  792,    0,    0,    0,    0,   47,   47,   47, 
           47,  100,    0,    0,    0,    0,    0,  128,    0,    0, 
            0,    0,    0,    0,    0,    0,   85,    0,  685,  685, 
            0,  229,  100,    0,  229,  229,  229,    0,  326,  106, 
            0,    0, 1043,    0,    0,    0, 1043,  792,    0,    0, 
            0,    0,    0,    0,  229,    0,  229,  229,    0,    0, 
            0,    0, 1043, 1043, 1043, 1043,    0,    0, 1042, 1043, 
         1043,    0, 1043, 1042, 1187,    0,    0,    0,    0,  792, 
         1042,   47,    0,    0,    0,    0, 1044, 1044,    0,    0, 
         1044,    0,    0,    0,    0,  100,    0,    0,    0,    0, 
          123,    0, 1042,    0,    0,    0,    0,    0,    0,  100, 
          100,    0,    0,    0,  100,  100,    0,    0,    0,  100, 
            0,    0, 1042,    0, 1044,    0,  126,  791,  100,    0, 
          100,  123,    0,    0,  123,    0,  687,    0,    0,  100, 
            0,    0,    0,    0,    0, 1045, 1045,    0,    0,    0, 
            0,  123,    0,    0,    0,    0,    0, 1047, 1047,    0, 
         1044,  106,    0,  608,  609,  610,  611,  612,    0,    0, 
          613,  614,  615,  616,  617,  618,  619,  620,  100,  622, 
            0,  687,  623,  624,  625,  626,  627,  628,  629,  630, 
          631, 1043,  791,  791,    0,    0, 1043,    0,    0,    0, 
          229, 1044,    0, 1043,    0, 1044,  654,    0,    0,    0, 
            0,    0,  557,    0,  558,  559,  560,  561,  562,    0, 
            0, 1044, 1044, 1044, 1044, 1043,    0,    0, 1044, 1044, 
            0, 1044,  563,    0,    0,  128,  792,    0, 1045, 1045, 
          100,    0, 1045,  100,    0, 1043,    0,    0,  100,    0, 
            0,    0,    0,    0, 1144, 1187,  565, 1187,    0,    0, 
          100, 1187,  567,  568, 1187,    0,    0, 1189,    0,    0, 
            0,    0,    0,    0,    0,  100, 1045,    0,    0,    0, 
          100,  100,    0,  100,    0,    0,   49,    0, 1174,  229, 
            0,  229,    0,  229,    0,    0,   49,  229,    0,    0, 
            0,  792,  792,    0,    0,  268,    0,  100,  785,    0, 
         1254,    0, 1045,    0,    0, 1261,    0,    0,  785,    0, 
          724,    0,    0,  727, 1047,    0,    0,   49,    0,    0, 
            0,    0,    0,    0,    0, 1187,  229, 1187,    0, 1187, 
          229, 1187,    0,    0,    0,   49,    0,    0,    0,  785, 
         1044,  229,  785, 1045,    0, 1044,    0, 1045,    0,    0, 
         1187,  273, 1044,    0,    0, 1220,  100,  785,    0,  123, 
            0,  273,    0, 1045, 1045, 1045, 1045,    0,    0,    0, 
         1045, 1045,    0, 1045, 1044, 1144,    0,    0,    0,    0, 
            0,  122, 1144, 1144,    0,  124,  229,    0,    0,  273, 
            0,  785,  273,    0, 1044,  273,  786,    0,    0,  790, 
            0,   49,    0,    0,    0,    0,    0,    0,    0,  273, 
          273,  273,  122,  273,  273,  122,  124,  686,    0,  124, 
            0,  688,  115,  785,    0,  687,  687, 1332, 1334, 1336, 
         1338,    0,  122,    0, 1340,    0,  124,    0, 1189,    0, 
         1189,    0,    0,    0,  273,  273,    0, 1189,    0,    0, 
            0,    0,    0,  115,    0,    0,  115,    0,  679,  814, 
            0,    0,  686,  814,  827,  229,  688, 1354, 1355, 1357, 
         1358,    0,    0,  115,    0,  273,  273,  229,  100, 1360, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0, 1045,  229,    0,    0,    0, 1045,    0,    0, 
          229,  786,  790,  679, 1045,    0,    0,    0,    0,  229, 
            0,    0,    0,  814,    0,  814,  814,    0, 1189,  229, 
         1189,  229, 1189,    0, 1189,    0, 1045,    0,    0,    0, 
            0,    0,  814,    0,    0,    0,    0,    0,   49,   49, 
           49,    0,    0, 1189,   49,   49, 1045,   49,    0,    0, 
            0,    0,    0,    0,    0,   49,    0,    0,    0,    0, 
          785,  785,  785,    0,    0,  785,  785,  785,    0,  785, 
           49,   49,   49,   49,  229,    0,  318,  785,    0,  785, 
          785,    0,    0,    0,    0,    0,  318,  229,    0,  785, 
          785,    0,  785,  785,  785,  785,  785,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  229,    0,    0,    0, 
            0,    0,    0,  273,  273,  273,    0,  318,  273,  273, 
          273,    0,  273,    0,    0,    0,  114,    0,  229,    0, 
          273,    0,  273,  273,  273,  318,    0,    0,    0,    0, 
            0,    0,  273,  273,   49,  273,  273,  273,  273,  273, 
          122,    0,  785,    0,  124,    0,    0,  114,    0,    0, 
          114,    0,  678,    0,    0,    0,  785,    0,    0,  318, 
            0,  229,    0,    0,    0,    0,    0,  114,  273,  273, 
          273,  273,  273,  273,  273,  273,  273,  273,  273,  273, 
            0,  115,    0,    0,  273,  273,    0,    0,    0,    0, 
          273,  318,    0,    0,    0,  273,    0,  678,    0,    0, 
            0,    0,    0,    0,    0,    0,  686,  686,    0,  273, 
          688,  688,  273,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0, 1014, 1015, 1016, 1017,    0,    0, 1069, 
            0,    0,  814,  814,  117,    0,    0,  814,  814,    0, 
            0, 1084,    0,    0,  229,    0,    0,  679,  679,  677, 
          229,    0,    0,    0,    0,    0,    0,    0,    0,  677, 
            0,    0,    0,    0,    0,  117,    0,    0,  117,    0, 
          681,    0,  229,    0,    0,    0,  814,  814,    0,  814, 
          814,  229,  788,    0,    0,  117,  677,  677,    0,  788, 
          677,  677,  677,  677,  677,  677,  677,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  677,  677,  677, 
          132,  677,  677,    0,    0,  681,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  318,  318, 
          318,    0,    0,  318,  318,  318,    0,  318,    0,    0, 
          677,    0,  677,  677,    0,  318,    0,  318,  318,    0, 
            0,    0,    0,    0,    0,  131,    0,  318,  318,    0, 
          318,  318,  318,  318,  318,    0,    0,    0,    0,    0, 
          680,  814,  788,  677,  677,  788,    0,    0,    0,    0, 
          680,    0,    0,  814,  229,  114,  131,    0,    0,  131, 
            0,  339,    0,    0,    0,    0,    0,  229,    0,    0, 
          814,    0,    0,  789,    0,    0,  131,  680,  680,    0, 
          789,  680,  680,  680,  680,  680,  680,  680,    0,    0, 
          318,    0,    0,    0,  130,    0,    0,    0,  680,  680, 
          680,  135,  680,  680,  318,    0,  339,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  678,  678,    0,    0,  130,    0,    0,  130,    0, 
          349,  680,    0,  680,  680,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  130,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  229,  789,  680,  680,  789,    0,    0,    0, 
            0,    0,    0,  117,    0,  349,  788,  788,  788,  229, 
          788,  677,  677,  677,  788,  788,  677,  677,  677,  788, 
          677,  788,  788,  788,  788,  788,  788,  788,  677,  788, 
          677,  677,  677,  788,  788,  788,  788,  788,  788,  788, 
          677,  677,  788,  677,  677,  677,  677,  677,    0,  788, 
            0,    0,  788,  788,  788,  788,  788,  788,  788,  788, 
          788,  788,  788,  788,  788,  788,  788,  788,  788,  681, 
          681,  788,    0,  788,  788,  677,  677,  677,  677,  677, 
          677,  677,  677,  677,  677,  677,  677,  677,  788,  788, 
            0,    0,  677,  677,  677,  677,  788,  689,  677,  788, 
          788,  788,  788,  677,  788,  788,  788,  788,  788,  788, 
          788,  788,  788,  788,    0,  788,  788,  677,    0,    0, 
          677,    0,    0,    0,  131,    0,    0,  789,  789,  789, 
            0,  789,  680,  680,  680,  789,  789,  680,  680,  680, 
          789,  680,  789,  789,  789,  789,  789,  789,  789,  680, 
          789,  680,  680,  680,  789,  789,  789,  789,  789,  789, 
          789,  680,  680,  789,  680,  680,  680,  680,  680,    0, 
          789,    0,    0,  789,  789,  789,  789,  789,  789,  789, 
          789,  789,  789,  789,  789,  789,  789,  789,  789,  789, 
          339,  339,  789,  130,  789,  789,  680,  680,  680,  680, 
          680,  680,  680,  680,  680,  680,  680,  680,  680,  789, 
          789,    0,    0,  680,  680,  680,  680,  789,  692,  680, 
          789,  789,  789,  789,  680,  789,  789,  789,  789,  789, 
          789,  789,  789,  789,  789,  795,  789,  789,  680,    0, 
            0,  680,    0,    0,    0,  795,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  349, 
          349,    0,    0,    0,    0,    0,    0,    0,  791,    0, 
            0,    0,  795,  795,    0,  791,  795,  795,  795,  795, 
          795,  795,  795,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  795,  795,  795,  146,  795,  795,    0, 
            0,    0,    0,    0, 1018, 1019, 1020, 1021,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
         1022, 1023, 1024,    0,    0,    0,  795,    0,  795,  795, 
           40,   41,   42,   43,   44,    0,    0,    0,    0,  303, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  791,    0,    0,    0,    0,    0,  795,  795, 
          795,  791,  791,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   58,   59,   60,   61,   62, 
           63,   64,    0,   65,   66,  791,    0,    0,    0,  791, 
          791,    0,  791,  791,  791,  791,  791,  791,  791,  791, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          791,  791,  791,  145,  791,  791,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  791,    0,  791,  791,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  791,  791,  791,  791,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  791,  791,  791,    0,  791,  795,  795,  795, 
          791,  791,  795,  795,  795,  791,  795,  791,  791,  791, 
          791,  791,  791,  791,  795,  795,  795,  795,  795,  791, 
          791,  791,  791,  791,  791,  791,  795,  795,  791,  795, 
          795,  795,  795,  795,    0,  791,    0,    0,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,    0,    0,  791,    0,  791, 
          791,  795,  795,  795,  795,  795,  795,  795,  795,  795, 
          795,  795,  795,  795,  791,  791,    0,    0,  795,  795, 
          795,  795,  791,    0,  795,  791,  791,  791,  791,  795, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
            0,  791,  791,  795,    0,    0,  795,    0,    0,  791, 
          791,  791,    0,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,    0,  791,    0,    0,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,    0,    0,  791,    0,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,    0,    0,  791,  791,  791,  791,  791, 
            0,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  792,  791,  791, 
          791,    0,    0,  791,    0,    0,    0,  792,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          792,    0,    0,    0,  792,  792,    0,  792,  792,  792, 
          792,  792,  792,  792,  792,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  792,  792,  792,  147,  792, 
          792,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  792,    0, 
          792,  792,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  340,    0,    0,    0,    0,    0, 
          792,  792,  792,  792,  340,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  790,    0,    0, 
            0,  340,  340,    0,  790,  340,  340,  340,  340,  340, 
          340,  340,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  340,  340,  340,    0,  340,  340,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  340,    0,  340,  340,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  790,  340,  340, 
          790,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  792,  792,  792,    0,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,    0,  792,    0,    0, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,    0,    0,  792, 
            0,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,    0,    0, 
          792,  792,  792,  792,  792,    0,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,    0,  792,  792,  792,    0,    0,  792,    0, 
            0,  790,  790,  790,    0,  790,  340,  340,  340,  790, 
          790,  340,  340,  340,  790,  340,  790,  790,  790,  790, 
          790,  790,  790,  340,  790,  340,  340,  340,  790,  790, 
          790,  790,  790,  790,  790,  340,  340,  790,  340,  340, 
          340,  340,  340,    0,  790,    0,    0,  790,  790,  790, 
          790,  790,  790,  790,  790,  790,  790,  790,  790,  790, 
          790,  790,  790,  790,    0,    0,  790,    0,  790,  790, 
          340,  340,  340,  340,  340,  340,  340,  340,  340,  340, 
          340,  340,  340,  790,  790,    0,    0,  340,  340,  340, 
          340,  790,    0,  340,  790,  790,  790,  790,  340,  790, 
          790,  790,  790,  790,  790,  790,  790,  790,  790,  796, 
          790,  790,  340,    0,    0,  340,    0,    0,    0,  796, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  793,    0,    0,    0,  796,  796,    0,  793, 
          796,  796,  796,  796,  796,  796,  796,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  796,  796,  796, 
            0,  796,  796,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          796,    0,  796,  796,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  797,    0,    0,    0, 
            0,    0,  796,  796,  796,  793,  797,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  794, 
            0,    0,    0,  797,  797,    0,  794,  797,  797,  797, 
          797,  797,  797,  797,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  797,  797,  797,    0,  797,  797, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  797,    0,  797, 
          797,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  797, 
          797,  797,  794,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  793,  793,  793,    0, 
          793,  796,  796,  796,  793,  793,  796,  796,  796,  793, 
          796,  793,  793,  793,  793,  793,  793,  793,  796,  796, 
          796,  796,  796,  793,  793,  793,  793,  793,  793,  793, 
          796,  796,  793,  796,  796,  796,  796,  796,    0,  793, 
            0,    0,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,    0, 
            0,  793,    0,  793,  793,  796,  796,  796,  796,  796, 
          796,  796,  796,  796,  796,  796,  796,  796,  793,  793, 
            0,    0,  796,  796,  796,  796,  793,    0,  796,  793, 
          793,  793,  793,  796,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,    0,  793,  793,  796,    0,    0, 
          796,    0,    0,  794,  794,  794,    0,  794,  797,  797, 
          797,  794,  794,  797,  797,  797,  794,  797,  794,  794, 
          794,  794,  794,  794,  794,  797,  797,  797,  797,  797, 
          794,  794,  794,  794,  794,  794,  794,  797,  797,  794, 
          797,  797,  797,  797,  797,    0,  794,    0,    0,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,    0,    0,  794,    0, 
          794,  794,  797,  797,  797,  797,  797,  797,  797,  797, 
          797,  797,  797,  797,  797,  794,  794,    0,    0,  797, 
          797,  797,  797,  794,    0,  797,  794,  794,  794,  794, 
          797,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  348,  794,  794,  797,    0,    0,  797,    0,    0, 
            0,  348,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  792,    0,    0,    0,  348,  348, 
            0,  792,  348,  348,  348,  348,  348,  348,  348,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  348, 
          348,  348,  148,  348,  348,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  377,  372,    0, 
            0,    0,  375,  373,    0,  374,    0,  376,    0,    0, 
            0,    0,  348,    0,  348,  348,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  486,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  486,    0,    0,    0,  348,  348,  792,    0,    0, 
            0,    0,    0,    0,  371,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  486,  486, 
            0,    0,  486,  486,  486,  486,  486,  486,  486,    0, 
            0,    0,    0,    0,  370,    0,    0,    0,    0,  486, 
          486,  486,  144,  486,  486,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  226,    0,    0,    0,    0,    0,    0, 
            0,    0,  486,    0,  486,  486,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  226,    0,  226,    0,  226,    0,    0,    0,  683, 
            0,    0,    0,    0,  486,  486,  486,    0,    0,    0, 
            0,    0,  226,    0,  226,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  792,  792, 
          792,    0,  792,  348,  348,  348,  792,  792,  348,  348, 
          348,  792,  348,  792,  792,  792,  792,  792,  792,  792, 
          348,    0,  348,  348,  348,  792,  792,  792,  792,  792, 
          792,  792,  348,  348,  792,  348,  348,  348,  348,  348, 
            0,  792,    0,    0,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,    0,    0,  792,    0,  792,  792,  348,  348,  348, 
          348,  348,  348,  348,  348,  348,  348,  348,  348,  348, 
          792,  792,    0,    0,  348,  348,  348,  348,  792,    0, 
          348,  792,  792,  792,  792,  348,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  351,  792,  792,  348, 
            0,    0,  348,  486,  486,  486,    0,    0,  486,  486, 
          486,    0,  486,  364,  365,    0,    0,    0,    0,    0, 
          486,  486,  486,  486,  486,    0,    0,    0,    0,    0, 
            0,    0,  486,  486,    0,  486,  486,  486,  486,  486, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  683,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  683,    0,  486,  486,  486, 
          486,  486,  486,  486,  486,  486,  486,  486,  486,  486, 
            0,    0,    0,    0,  486,  486,  486,  486,    0,    0, 
          486,    0,  683,  683,    0,  486,  683,  683,  683,  683, 
          683,  683,  683,    0,    0,    0,    0,    0,    0,  486, 
            0,    0,  486,  683,  683,  683,  138,  683,  683,  226, 
            0,  226,  226,  226,  226,  226,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  226, 
            0,    0,    0,    0,    0,    0,  683,    0,  683,  683, 
          682,    0,    0,  226,    0,    0,    0,    0,    0,  683, 
          682,    0,    0,  226,    0,    0,    0,    0,  226,  226, 
          226,    0,    0,    0,    0,    0,    0,    0,    0,  683, 
          683,    0,    0,    0,    0,    0,    0,  682,  682,    0, 
            0,  682,  682,  682,  682,  682,  682,  682,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  682,  682, 
          682,  137,  682,  682,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  569,    0,  887,    0,  570, 
            0,  682,    0,  682,  682,    0,    0,    0,  684,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  684,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  682,  682,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  684,  684,    0,    0,  684, 
          684,  684,  684,  684,  684,  684,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  684,  684,  684,  139, 
          684,  684,    0,    0,    0,    0,    0,  683,  683,  683, 
            0,    0,  683,  683,  683,    0,  683,    0,    0,    0, 
            0,    0,    0,    0,  683,    0,  683,  683,  683,  684, 
            0,  684,  684,    0,    0,    0,  683,  683,    0,  683, 
          683,  683,  683,  683,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   39,    0,    0,    0,    0, 
            0,    0,  684,  684,    0,   39,    0,    0,    0,    0, 
            0,  683,  683,  683,  683,  683,  683,  683,  683,  683, 
          683,  683,  683,  683,    0,    0,    0,    0,  683,  683, 
          683,  683,    0,  695,  683,    0,   39,    0,    0,  683, 
            0,    0,  682,  682,  682,    0,    0,  682,  682,  682, 
            0,  682,    0,  683,   39,    0,  683,    0,    0,  682, 
            0,  682,  682,  682,    0,    0,    0,    0,    0,    0, 
            0,  682,  682,    0,  682,  682,  682,  682,  682,    0, 
            0,    0,    0,    0,  569,    0,    0,    0,  570,    0, 
            0,    0,    0,    0,    0,    0,  569,    0,    0,    0, 
          570,    0,    0,    0,    0,    0,  682,  682,  682,  682, 
          682,  682,  682,  682,  682,  682,  682,  682,  682,    0, 
           39,    0,    0,  682,  682,  682,  682,    0,  694,  682, 
            0,    0,    0,  557,  682,  558,  559,  560,  561,  562, 
          684,  684,  684,    0,    0,  684,  684,  684,  682,  684, 
            0,  682,    0,  563,    0,    0,    0,  684,    0,  684, 
          684,  684,    0,    0,    0,    0,    0,  564,    0,  684, 
          684,    0,  684,  684,  684,  684,  684,  565,    0,    0, 
            0,    0,  566,  567,  568,    0,    0,    0,    0,    0, 
            0,    0,  685,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  685,    0,  684,  684,  684,  684,  684,  684, 
          684,  684,  684,  684,  684,  684,  684,    0,    0,    0, 
            0,  684,  684,  684,  684,    0,  696,  684,    0,  685, 
          685,    0,  684,  685,  685,  685,  685,  685,  685,  685, 
            0,    0,    0,    0,    0,    0,  684,    0,    0,  684, 
          685,  685,  685,  140,  685,  685,    0,   39,   39,   39, 
            0,    0,    0,   39,   39,    0,   39,    0,    0,    0, 
            0,    0,    0,    0,   39,    0,    0,    0,    0,    0, 
            0,    0,    0,  685,    0,  685,  685,  687,    0,   39, 
           39,   39,   39,   39,    0,    0,    0,  687,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  685,  685,    0,    0, 
            0,    0,    0,    0,  687,  687,    0,    0,  687,  687, 
          687,  687,  687,  687,  687,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  687,  687,  687,  142,  687, 
          687,    0,  557,    0,  558,  559,  560,  561,  562,    0, 
            0,    0,    0,   39,  557,    0,  558,  559,  560,  561, 
          562,    0,  563,    0,    0,    0,    0,    0,  687,    0, 
          687,  687,    0,    0,  563,  686,  564,    0,    0,    0, 
            0,    0,    0,    0,    0,  686,  565,    0,    0,    0, 
            0,  566,  567,  568,    0,    0,    0,    0,  565,    0, 
            0,  687,  687,  566,  567,  568,    0,    0,    0,    0, 
            0,    0,  686,  686,    0,    0,  686,  686,  686,  686, 
          686,  686,  686,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  686,  686,  686,  141,  686,  686,    0, 
            0,    0,    0,    0,  685,  685,  685,    0,    0,  685, 
          685,  685,    0,  685,    0,    0,    0,    0,    0,    0, 
            0,  685,    0,  685,  685,  685,  686,    0,  686,  686, 
            0,    0,    0,  685,  685,    0,  685,  685,  685,  685, 
          685,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   27,    0,    0,    0,    0,    0,    0,  686, 
          686,    0,   27,    0,    0,    0,    0,    0,  685,  685, 
          685,  685,  685,  685,  685,  685,  685,  685,  685,  685, 
          685,    0,    0,    0,    0,  685,  685,  685,  685,    0, 
          697,  685,    0,   27,    0,    0,  685,    0,    0,  687, 
          687,  687,    0,    0,  687,  687,  687,    0,  687,    0, 
          685,   27,    0,  685,    0,    0,  687,    0,  687,  687, 
          687,    0,    0,    0,    0,    0,    0,    0,  687,  687, 
            0,  687,  687,  687,  687,  687,    0,  377,  372,    0, 
            0,    0,  375,  373,    0,  374,    0,  376,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          369,    0,  368,  687,  687,  687,  687,  687,  687,  687, 
          687,  687,  687,  687,  687,  687,    0,   27,    0,    0, 
          687,  687,  687,  687,    0,  699,  687,    0,    0,    0, 
            0,  687,    0,    0,  371,    0,    0,  686,  686,  686, 
            0,    0,  686,  686,  686,  687,  686,    0,  687,    0, 
            0,    0,    0,    0,  686,    0,  686,  686,  686,    0, 
            0,    0,    0,    0,  370,    0,  686,  686,    0,  686, 
          686,  686,  686,  686,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  688, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  688, 
            0,  686,  686,  686,  686,  686,  686,  686,  686,  686, 
          686,  686,  686,  686,    0,    0,    0,    0,  686,  686, 
          686,  686,    0,  698,  686,    0,  688,  688,    0,  686, 
          688,  688,  688,  688,  688,  688,  688,    0,    0,    0, 
            0,    0,    0,  686,    0,    0,  686,  688,  688,  688, 
          143,  688,  688,    0,   27,   27,   27,    0,    0,    0, 
           27,   27,    0,   27,    0,    0,    0,    0,    0,    0, 
            0,   27,    0,    0,    0,    0,    0,    0,    0,    0, 
          688,    0,  688,  688,  679,    0,   27,   27,   27,   27, 
           27,    0,    0,    0,  679,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  688,  688,    0,    0,    0,    0,    0, 
            0,  679,  679,    0,    0,  679,  679,  679,  679,  679, 
          679,  679,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  679,  679,  679,  134,  679,  679,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           27,    0,    0,    0,    0,    0,  351,    0,    0,    0, 
            0,  356,  357,    0,    0,  679,    0,  679,  679,    0, 
            0,    0,  678,  364,  365,    0,    0,    0,    0,    0, 
            0,    0,  678,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  679,  679, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  678, 
          678,    0,    0,  678,  678,  678,  678,  678,  678,  678, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          678,  678,  678,  133,  678,  678,    0,    0,    0,    0, 
            0,  688,  688,  688,    0,    0,  688,  688,  688,    0, 
          688,    0,    0,    0,    0,    0,    0,    0,  688,    0, 
          688,  688,  688,  678,    0,  678,  678,    0,    0,    0, 
          688,  688,    0,  688,  688,  688,  688,  688,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   48, 
            0,    0,    0,    0,    0,    0,  678,  678,    0,   48, 
            0,    0,    0,    0,    0,  688,  688,  688,  688,  688, 
          688,  688,  688,  688,  688,  688,  688,  688,    0,    0, 
            0,    0,  688,  688,  688,  688,    0,  700,  688,    0, 
           48,    0,    0,  688,    0,    0,  679,  679,  679,    0, 
            0,  679,  679,  679,    0,  679,    0,  688,   48,    0, 
          688,    0,    0,  679,    0,  679,  679,  679,    0,    0, 
            0,    0,    0,    0,    0,  679,  679,    0,  679,  679, 
          679,  679,  679,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          679,  679,  679,  679,  679,  679,  679, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          679,  679,  679,  679,  679,  679,    0,   48,    0,    0, 
          679,  679,  679,  679,    0,  691,  679,    0,    0,    0, 
            0,  679,    0,    0,    0,    0,    0,  678,  678,  678, 
            0,    0,  678,  678,  678,  679,  678,    0,  679,    0, 
            0,    0,    0,    0,  678,    0,  678,  678,  678,    0, 
            0,    0,    0,    0,    0,    0,  678,  678,    0,  678, 
          678,  678,  678,  678,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  681, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  681, 
            0,  678,  678,  678,  678,  678,  678,  678,  678,  678, 
          678,  678,  678,  678,    0,    0,    0,    0,  678,  678, 
          678,  678,    0,  690,  678,    0,  681,  681,    0,  678, 
          681,  681,  681,  681,  681,  681,  681,    0,    0,    0, 
            0,    0,    0,  678,    0,    0,  678,  681,  681,  681, 
          136,  681,  681,    0,   48,   48,   48,    0,    0,    0, 
           48,   48,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
          681,    0,  681,  681,  485,    0,   48,   48,   48,   48, 
           48,    0,    0,    0,  485,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  681,  681,    0,    0,    0,    0,    0, 
            0,  485,  485,    0,    0,  485,  485,  485,  485,  485, 
          485,  485,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  485,  485,  485,    0,  485,  485,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  485,    0,  485,  485,    0, 
            0,    0,  818,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  818,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  485,  485,  485, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  818, 
          818,    0,    0,  818,  818,  818,  818,  818,  818,  818, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          818,  818,  818,    0,  818,  818,    0,    0,    0,    0, 
            0,  681,  681,  681,    0,    0,  681,  681,  681,    0, 
          681,    0,    0,    0,    0,    0,    0,    0,  681,    0, 
          681,  681,  681,  818,    0,  818,  818,    0,    0,    0, 
          681,  681,    0,  681,  681,  681,  681,  681,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,  818,  818,  818,    0,   50, 
            0,    0,    0,    0,    0,  681,  681,  681,  681,  681, 
          681,  681,  681,  681,  681,  681,  681,  681,    0,    0, 
            0,    0,  681,  681,  681,  681,    0,  693,  681,    0, 
           50,    0,    0,  681,    0,    0,  485,  485,  485,    0, 
            0,  485,  485,  485,    0,  485,    0,  681,   50,    0, 
          681,    0,    0,  485,  485,  485,  485,  485,    0,    0, 
            0,    0,    0,    0,    0,  485,  485,    0,  485,  485, 
          485,  485,  485,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          485,  485,  485,  485,  485,  485,  485,  485,  485,  485, 
          485,  485,  485,    0,   50,    0,    0,  485,  485,  485, 
          485,    0,    0,  485,    0,    0,    0,    0,  485,    0, 
            0,    0,    0,    0,  818,  818,  818,    0,    0,  818, 
          818,  818,  485,  818,    0,  485,    0,    0,    0,    0, 
            0,  818,  818,  818,  818,  818,    0,    0,    0,    0, 
            0,    0,    0,  818,  818,    0,  818,  818,  818,  818, 
          818,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  339,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  339,    0,  818,  818, 
          818,  818,  818,  818,  818,  818,  818,  818,  818,  818, 
          818,    0,    0,    0,    0,  818,  818,  818,  818,    0, 
            0,  818,    0,  339,  339,    0,  818,  339,  339,  339, 
          339,  339,  339,  339,    0,    0,    0,    0,    0,    0, 
          818,    0,    0,  818,  339,  339,  339,  150,  339,  339, 
            0,   50,   50,   50,    0,    0,    0,   50,   50,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,    0,  339,    0,  339, 
          339,  349,    0,   50,   50,   50,   50,   50,    0,    0, 
            0,  349,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          339,  339,    0,    0,    0,    0,    0,    0,  349,  349, 
            0,    0,  349,  349,  349,  349,  349,  349,  349,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  349, 
          349,  349,  149,  349,  349,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  349,    0,  349,  349,    0,    0,    0,  621, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  621, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  349,  349,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  621,  621,    0,    0, 
          621,  621,  621,  621,  621,  621,  621,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  621,  621,  621, 
            0,  621,  621,    0,    0,    0,    0,    0,  339,  339, 
          339,    0,    0,  339,  339,  339,    0,  339,    0,    0, 
            0,    0,    0,    0,    0,  339,    0,  339,  339,  339, 
          621,    0,  621,  621,    0,    0,    0,  339,  339,    0, 
          339,  339,  339,  339,  339,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,  621,  621,    0,   52,    0,    0,    0, 
            0,    0,  339,  339,  339,  339,  339,  339,  339,  339, 
          339,  339,  339,  339,  339,    0,    0,    0,    0,  339, 
          339,  339,  339,    0,    0,  339,    0,   52,    0,    0, 
          339,    0,    0,  349,  349,  349,    0,    0,  349,  349, 
          349,    0,  349,    0,  339,   52,    0,  339,    0,    0, 
          349,    0,  349,  349,  349,    0,    0,    0,    0,    0, 
            0,    0,  349,  349,    0,  349,  349,  349,  349,  349, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  349,  349,  349, 
          349,  349,  349,  349,  349,  349,  349,  349,  349,  349, 
            0,   52,    0,    0,  349,  349,  349,  349,    0,    0, 
          349,    0,    0,    0,    0,  349,    0,    0,    0,    0, 
            0,  621,  621,  621,    0,    0,  621,  621,  621,  349, 
          621,    0,  349,    0,    0,    0,    0,    0,  621,    0, 
          621,  621,  621,    0,    0,    0,    0,    0,    0,    0, 
          621,  621,    0,  621,  621,  621,  621,  621,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  284,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  284,    0,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,    0,    0, 
            0,    0,  621,  621,  621,  621,    0,    0,  621,    0, 
          284,  284,    0,  621,  284,  284,  284,  284,  284,  386, 
          284,    0,    0,    0,    0,    0,    0,  621,    0,    0, 
          621,  284,  284,  284,    0,  284,  284,    0,   52,   52, 
           52,    0,    0,    0,   52,   52,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,   52,    0,    0,    0,    0, 
            0,    0,    0,    0,  386,    0,  284,  284,  361,    0, 
           52,   52,   52,   52,    0,    0,    0,    0,  361,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  284,  284,    0, 
            0,    0,    0,    0,    0,  361,  361,    0,    0,  361, 
          361,  361,  361,  361,  361,  361,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  361,  361,  361,    0, 
          361,  361,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  361, 
            0,  361,  361,    0,    0,    0,  355,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  355,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  361,  361,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  355,  355,    0,    0,  355,  355,  355, 
          355,  355,  355,  355,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  355,  355,  355,    0,  355,  355, 
            0,    0,    0,    0,    0,  284,  284,  284,    0,    0, 
          284,  284,  284,    0,  284,    0,    0,    0,    0,    0, 
            0,    0,  284,    0,  284,  284,  284,  355,    0,  355, 
          355,    0,    0,    0,  284,  284,    0,  284,  284,  284, 
          284,  284,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   38,    0,    0,    0,    0,    0, 
          355,  355,    0,    0,   38,    0,    0,    0,    0,  284, 
          284,  284,  284,  284,  284,  284,  284,  284,  284,  284, 
          284,  284,    0,    0,    0,    0,  284,  284,  386,  386, 
            0,    0,  284,    0,    0,   38,    0,  284,    0,    0, 
          361,  361,  361,    0,    0,  361,  361,  361,    0,  361, 
            0,  284,    0,   38,  284,    0,    0,  361,    0,  361, 
          361,  361,    0,    0,    0,    0,    0,    0,    0,  361, 
          361,    0,  361,  361,  361,  361,  361,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  321,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  321,    0,  361,  361,  361,  361,  361,  361, 
          361,  361,  361,  361,  361,  361,  361,    0,    0,   38, 
            0,  361,  361,  361,  361,    0,    0,  361,    0,    0, 
            0,    0,  361,  321,    0,    0,  321,    0,  355,  355, 
          355,    0,    0,  355,  355,  355,  361,  355,    0,  361, 
            0,  321,    0,    0,    0,  355,    0,  355,  355,  355, 
            0,    0,    0,    0,    0,    0,    0,  355,  355,    0, 
          355,  355,  355,  355,  355,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  321,    0,    0,    0,    0, 
          669,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          669,    0,  355,  355,  355,  355,  355,  355,  355,  355, 
          355,  355,  355,  355,  355,    0,    0,  321,    0,  355, 
          355,  355,  355,    0,    0,  355,    0,  669,  669,    0, 
          355,  669,  669,  669,  669,  669,  669,  669,    0,    0, 
            0,    0,    0,    0,  355,    0,    0,  355,  669,  669, 
          669,    0,  669,  669,    0,    0,   38,   38,   38,    0, 
            0,    0,   38,   38,    0,   38,    0,    0,    0,    0, 
            0,    0,    0,   38,    0,    0,    0,    0,    0,    0, 
            0,  669,    0,  669,  669,  248,    0,    0,   38,   38, 
           38,   38,    0,    0,    0,  248,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  669,  669,    0,    0,    0,    0, 
            0,    0,  248,  248,    0,    0,  248,  248,  248,  248, 
          248,    0,  248,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  248,  248,  248,    0,  248,  248,    0, 
            0,    0,    0,    0,  321,  321,  321,    0,    0,  321, 
          321,  321,   38,  321,    0,    0,    0,    0,    0,    0, 
            0,  321,    0,  321,  321,    0,    0,    0,  248,  248, 
            0,  249,    0,  321,  321,    0,  321,  321,  321,  321, 
          321,  249,  377,  372,    0,    0,    0,  375,  373,    0, 
          374,    0,  376,    0,    0,    0,    0,    0,    0,  248, 
          248,    0,    0,    0,    0,  369,    0,  368,  249,  249, 
            0,    0,  249,  249,  249,  249,  249,    0,  249,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  249, 
          249,  249,    0,  249,  249,    0,  321,    0,    0,  371, 
            0,    0,  669,  669,  669,    0,    0,  669,  669,  669, 
          321,  669,    0,    0,    0,    0,    0,    0,    0,  669, 
            0,  669,  669,  669,  249,  249,    0,    0,    0,  370, 
            0,  669,  669,    0,  669,  669,  669,  669,  669,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  323,    0,    0,    0,  249,  249,    0,    0,    0, 
            0,  323,    0,    0,    0,    0,    0,  669,  669,  669, 
          669,  669,  669,  669,  669,  669,  669,  669,  669,    0, 
            0,    0,    0,  669,  669,  669,  669,    0,    0,  669, 
            0,    0,  323,    0,  669,  323,    0,  248,  248,  248, 
            0,    0,  248,  248,  248,    0,  248,    0,  669,    0, 
          323,  669,    0,    0,  248,    0,  248,  248,  248,    0, 
            0,    0,    0,    0,    0,    0,  248,  248,    0,  248, 
          248,  248,  248,  248,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  323,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  248,  248,  248,  248,  248,  248,  248,  248,  248, 
          248,  248,  248,  248,    0,    0,  323,    0,  248,  248, 
            0,    0,    0,    0,  248,    0,    0,    0,    0,  248, 
            0,    0,    0,  249,  249,  249,    0,    0,  249,  249, 
          249,    0,  249,  248,    0,    0,  248,    0,    0,    0, 
          249,    0,  249,  249,  249,    0,    0,    0,    0,    0, 
            0,    0,  249,  249,    0,  249,  249,  249,  249,  249, 
            0,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,    0,    0,    0,  260,    0,    0,  364,  365, 
            0,    0,    0,    0,    0,  260,    0,  249,  249,  249, 
          249,  249,  249,  249,  249,  249,  249,  249,  249,  249, 
            0,    0,    0,    0,  249,  249,    0,    0,    0,    0, 
          249,    0,  260,  260,    0,  249,  260,  260,  260,  260, 
          260,    0,  260,    0,    0,    0,    0,    0,    0,  249, 
            0,    0,  249,  260,  260,  260,    0,  260,  260,    0, 
            0,    0,    0,  323,  323,  323,    0,    0,  323,  323, 
          323,    0,  323,    0,    0,    0,    0,    0,    0,    0, 
          323,    0,  323,  323,    0,    0,    0,    0,  260,  260, 
          257,    0,  323,  323,    0,  323,  323,  323,  323,  323, 
          257,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  260, 
          260,    0,    0,    0,    0,    0,    0,  257,  257,    0, 
            0,  257,  257,  257,  257,  257,    0,  257,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  257,  257, 
          257,    0,  257,  257,    0,  323,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  323, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  257,  257,    0,  254,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  254,  377,  372,    0, 
            0,    0,  375,  373,    0,  374,    0,  376,    0,    0, 
            0,    0,    0,    0,  257,  257,    0,    0,    0,    0, 
          369,    0,  368,  254,  254,    0,    0,  254,  254,  254, 
          254,  254,    0,  254,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  254,  254,  254,    0,  254,  254, 
            0,    0,    0,    0,  371,    0,    0,  260,  260,  260, 
            0,    0,  260,  260,  260,    0,  260,    0,    0,    0, 
            0,    0,    0,    0,  260,    0,  260,  260,  260,  254, 
          254,    0,    0,    0,  370,    0,  260,  260,    0,  260, 
          260,  260,  260,  260,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  819,    0,    0,    0,    0, 
          254,  254,    0,    0,    0,  819,    0,    0,    0,    0, 
            0,    0,  260,  260,  260,  260,  260,  260,  260,  260, 
          260,  260,  260,  260,    0,    0,    0,    0,  260,  260, 
            0,    0,    0,    0,  260,    0,  819,    0,    0,  260, 
          329,    0,  257,  257,  257,    0,    0,  257,  257,  257, 
          329,  257,    0,  260,  819,    0,  260,    0,    0,  257, 
            0,  257,  257,  257,    0,    0,    0,    0,    0,    0, 
            0,  257,  257,    0,  257,  257,  257,  257,  257,    0, 
            0,  329,    0,    0,  322,    0,    0,    0,  819,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  329, 
            0,    0,    0,    0,    0,    0,    0,  257,  257,  257, 
          257,  257,  257,  257,  257,  257,  257,  257,  257,    0, 
          819,    0,    0,  257,  257,    0,    0,    0,    0,  257, 
            0,    0,    0,    0,  257,    0,    0,    0,  254,  254, 
          254,    0,    0,  254,  254,  254,    0,  254,  257,    0, 
            0,  257,    0,    0,    0,  254,    0,  254,  254,  254, 
            0,    0,    0,    0,    0,  329,    0,  254,  254,    0, 
          254,  254,  254,  254,  254,    0,  351,  352,  353,  354, 
          355,  356,  357,  358,    0,  360,  361,    0,    0,    0, 
          255,    0,    0,  364,  365,    0,    0,    0,    0,    0, 
          255,    0,    0,  254,  254,  254,  254,  254,  254,  254, 
          254,  254,  254,  254,  254,    0,    0,    0,    0,  254, 
          254,    0,    0,    0,    0,  254,    0,  255,  255,    0, 
          254,  255,  255,  255,  255,  255,    0,  255,    0,    0, 
            0,    0,    0,    0,  254,    0,    0,  254,  255,  255, 
          255,    0,  255,  255,    0,    0,    0,  819,  819,  819, 
            0,    0,  819,  819,  819,    0,  819,    0,    0,    0, 
            0,    0,    0,    0,  819,    0,  819,  819,    0,    0, 
            0,    0,    0,  255,  255,  256,  819,  819,    0,  819, 
          819,  819,  819,  819,    0,  256,    0,    0,    0,    0, 
            0,    0,  329,  329,  329,    0,    0,  329,  329,  329, 
            0,  329,    0,    0,  255,  255,    0,    0,    0,  329, 
            0,    0,  256,  256,    0,    0,  256,  256,  256,  256, 
          256,    0,  256,    0,  329,  329,  329,  329,  329,    0, 
            0,    0,    0,  256,  256,  256,    0,  256,  256,  819, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  819,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  256,  256, 
            0,  258,    0,    0,    0,    0,    0,    0,    0,  329, 
            0,  258,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  329,  256, 
          256,    0,    0,    0,    0,    0,    0,    0,  258,  258, 
            0,    0,  258,  258,  258,  258,  258,    0,  258,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  258, 
          258,  258,    0,  258,  258,    0,    0,    0,    0,    0, 
            0,    0,  255,  255,  255,    0,    0,  255,  255,  255, 
            0,  255,    0,    0,    0,    0,    0,    0,    0,  255, 
            0,  255,  255,  255,  258,  258,    0,    0,    0,    0, 
            0,  255,  255,    0,  255,  255,  255,  255,  255,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          475,    0,    0,    0,    0,  258,  258,    0,    0,    0, 
          475,    0,    0,    0,    0,    0,    0,  255,  255,  255, 
          255,  255,  255,  255,  255,  255,  255,  255,  255,    0, 
            0,    0,    0,  255,  255,    0,    0,    0,    0,  255, 
            0,  475,    0,    0,  255,  584,  475,  256,  256,  256, 
            0,    0,  256,  256,  256,  584,  256,    0,  255,  475, 
            0,  255,    0,    0,  256,    0,  256,  256,  256,    0, 
            0,    0,    0,    0,    0,    0,  256,  256,    0,  256, 
          256,  256,  256,  256,    0,    0,  584,    0,    0,  584, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  584,    0,    0,    0,    0,    0, 
            0,    0,  256,  256,  256,  256,  256,  256,  256,  256, 
          256,  256,  256,  256,    0,  475,    0,    0,  256,  256, 
            0,    0,    0,    0,  256,    0,    0,    0,  584,  256, 
            0,   82,    0,  258,  258,  258,    0,    0,  258,  258, 
          258,   82,  258,  256,    0,    0,  256,    0,    0,    0, 
          258,    0,  258,  258,  258,    0,    0,    0,    0,  584, 
          584,    0,  258,  258,    0,  258,  258,  258,  258,  258, 
            0,    0,   82,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  265,    0,    0,    0,    0, 
           82,    0,    0,    0,    0,  265,    0,    0,  258,  258, 
          258,  258,  258,  258,  258,  258,  258,  258,  258,  258, 
            0,    0,    0,    0,  258,  258,    0,    0,    0,    0, 
          258,    0,  265,  265,   82,  258,  265,  265,  265,  265, 
          265,    0,  265,    0,    0,    0,    0,    0,    0,  258, 
            0,    0,  258,  265,  265,    0,    0,    0,  265,    0, 
            0,    0,  475,  475,  475,    0,   82,  475,  475,  475, 
            0,  475,    0,    0,    0,    0,    0,    0,    0,  475, 
            0,  475,    0,    0,    0,    0,    0,    0,  265,  265, 
          252,  475,  475,    0,  475,  475,  475,  475,  475,    0, 
          252,    0,    0,    0,    0,    0,    0,  584,  584,  584, 
            0,    0,  584,  584,  584,    0,  584,    0,    0,  265, 
          265,    0,    0,    0,  584,    0,  584,    0,  252,    0, 
            0,  252,    0,  252,  252,  252,  584,  584,    0,  584, 
          584,  584,  584,  584,    0,  475,  475,    0,  252,  252, 
          252,    0,  252,  252,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  475,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  252,  252,    0,  253,    0,    0,    0, 
            0,    0,    0,    0,  584,    0,  253,    0,    0,    0, 
            0,    0,    0,   82,   82,   82,    0,    0,   82,   82, 
           82,    0,   82,  584,  252,  252,    0,    0,    0,    0, 
           82,    0,   82,   82,  253,    0,    0,  253,    0,  253, 
          253,  253,   82,   82,    0,   82,   82,   82,   82,   82, 
            0,    0,    0,    0,  253,  253,  253,    0,  253,  253, 
            0,    0,    0,    0,    0,    0,    0,  265,  265,  265, 
            0,    0,  265,  265,  265,    0,  265,    0,    0,    0, 
            0,    0,    0,    0,  265,    0,  265,  265,  265,  253, 
          253,    0,    0,    0,    0,    0,  265,  265,    0,  265, 
          265,  265,  265,  265,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  278,    0,    0,   82, 
          253,  253,    0,    0,    0,    0,  278,    0,    0,    0, 
            0,  265,  265,  265,  265,  265,    0,    0,  265,  265, 
          265,  265,  265,  265,    0,    0,    0,    0,  265,  265, 
            0,    0,    0,    0,  265,    0,    0,  278,    0,  265, 
          278,    0,  252,  252,  252,    0,    0,  252,  252,  252, 
            0,  252,    0,  265,  278,  278,  265,    0,    0,  252, 
            0,  252,  252,  252,    0,    0,    0,    0,    0,    0, 
            0,  252,  252,    0,  252,  252,  252,  252,  252,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  278, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  252,  252,  252, 
          252,  252,  252,  252,  252,  252,  252,  252,  252,    0, 
            0,  278,    0,  252,  252,    0,    0,    0,    0,  252, 
            0,    0,    0,    0,  252,    0,    0,    0,  253,  253, 
          253,    0,    0,  253,  253,  253,    0,  253,  252,    0, 
            0,  252,    0,    0,    0,  253,    0,  253,  253,  253, 
            0,    0,    0,    0,    0,    0,    0,  253,  253,    0, 
          253,  253,  253,  253,  253,    0,    0,  274,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  274,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  253,  253,  253,  253,  253,  253,  253, 
          253,  253,  253,  253,  253,  274,    0,    0,  274,  253, 
          253,  274,    0,    0,    0,  253,    0,    0,    0,    0, 
          253,    0,    0,    0,    0,  274,  274,  274,    0,  274, 
          274,    0,    0,    0,  253,    0,    0,  253,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  278,  278, 
          278,    0,    0,  278,  278,  278,    0,  278,    0,    0, 
          274,  274,  263,    0,    0,  278,    0,  278,  278,  278, 
            0,    0,  263,    0,    0,    0,    0,  278,  278,    0, 
          278,  278,  278,  278,  278,    0,    0,    0,    0,    0, 
            0,  274,  274,    0,    0,    0,    0,    0,    0,    0, 
          263,    0,    0,  263,    0,    0,  263,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          263,  263,  263,    0,  263,  263,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  278,    0,    0,    0,    0, 
          278,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  278,  263,  263,  278,  261,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  261,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  263,  263,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  261, 
            0,    0,  261,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  261,  261,  261,    0, 
          261,  261,    0,    0,    0,    0,    0,    0,    0,  274, 
          274,  274,    0,    0,  274,  274,  274,    0,  274,  219, 
            0,    0,    0,    0,    0,    0,  274,    0,  274,  274, 
          274,  261,  261,    0,    0,    0,    0,    0,  274,  274, 
            0,  274,  274,  274,  274,  274,    0,  219,    0,  219, 
            0,  219,    0,    0,    0,  682,    0,    0,    0,    0, 
            0,    0,  261,  261,    0,    0,    0,    0,  219,    0, 
          219,    0,    0,    0,  274,  274,  274,  274,  274,  274, 
          274,  274,  274,  274,  274,  274,    0,    0,    0,   86, 
          274,  274,    0,    0,    0,    0,  274,    0,    0,   86, 
            0,  274,    0,    0,  263,  263,  263,    0,    0,  263, 
          263,  263,    0,  263,    0,  274,    0,    0,  274,    0, 
            0,  263,    0,  263,  263,  263,    0,    0,    0,    0, 
           86,    0,    0,  263,  263,    0,  263,  263,  263,  263, 
          263,    0,    0,    0,    0,    0,    0,    0,   86,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  263, 
          263,  263,  263,  263,  263,  263,  263,  263,  263,  263, 
          263,    0,   86,    0,    0,    0,    0,  262,    0,    0, 
            0,  263,    0,    0,    0,    0,  263,  262,    0,    0, 
          261,  261,  261,    0,    0,  261,  261,  261,    0,  261, 
          263,    0,    0,  263,   86,    0,    0,  261,    0,  261, 
          261,  261,    0,    0,    0,    0,    0,    0,  262,  261, 
          261,  262,  261,  261,  261,  261,  261,    0,    0,    0, 
            0,    0,    0,    0,    0,  262,  262,  262,    0,  262, 
          262,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  261,  261,  261,  261,  261, 
          261,  261,  261,  261,  261,  261,  261,    0,    0,    0, 
          262,  262,    0,  289,    0,    0,    0,  261,    0,    0, 
            0,    0,  261,  289,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  261,    0,    0,  261, 
            0,  262,  262,    0,    0,  219,    0,  219,  219,  219, 
          219,  219,    0,    0,  289,    0,    0,  289,    0,    0, 
            0,    0,    0,    0,    0,  219,    0,    0,    0,    0, 
            0,  289,  289,  289,    0,  289,  289,    0,    0,  219, 
            0,   86,   86,   86,    0,  682,   86,   86,   86,  219, 
           86,    0,    0,    0,  219,  219,  219,    0,   86,    0, 
           86,   86,    0,    0,    0,    0,  289,    0,  290,    0, 
           86,   86,    0,   86,   86,   86,   86,   86,  290,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  289,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  290, 
            0,    0,  290,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  290,  290,  290,    0, 
          290,  290,    0,    0,    0,    0,    0,    0,    0,  262, 
          262,  262,    0,    0,  262,  262,  262,   86,  262,    0, 
            0,    0,    0,    0,    0,    0,  262,    0,  262,  262, 
          262,  290,    0,    0,    0,    0,    0,    0,  262,  262, 
            0,  262,  262,  262,  262,  262,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  264,    0, 
            0,    0,    0,  290,    0,    0,    0,    0,  264,    0, 
            0,    0,    0,    0,  262,  262,  262,  262,  262,  262, 
          262,  262,  262,  262,  262,  262,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  262,    0,    0,  264, 
            0,  262,  264,  327,    0,  289,  289,  289,    0,    0, 
          289,  289,  289,  327,  289,  262,  264,  264,  262,    0, 
            0,  264,  289,    0,  289,  289,  289,    0,    0,    0, 
            0,    0,    0,    0,  289,  289,    0,  289,  289,  289, 
          289,  289,    0,    0,  327,    0,    0,  323,    0,    0, 
            0,  264,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  327,    0,    0,    0,    0,    0,    0,    0, 
          289,  289,  289,  289,  289,  289,  289,  289,  289,  289, 
          289,  289,    0,  264,    0,    0,    0,    0,    0,    0, 
            0,    0,  289,    0,    0,    0,    0,  289,  266,    0, 
          290,  290,  290,    0,    0,  290,  290,  290,  266,  290, 
            0,  289,    0,    0,  289,    0,    0,  290,    0,  290, 
          290,  290,    0,    0,    0,    0,    0,    0,  327,  290, 
          290,    0,  290,  290,  290,  290,  290,    0,    0,  266, 
            0,    0,  266,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  266,  266,    0,    0, 
            0,  266,    0,    0,    0,  290,  290,  290,  290,  290, 
          290,  290,  290,  290,  290,  290,  290,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  290,    0,    0, 
            0,  266,  290,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  290,    0,    0,  290, 
            0,    0,    0,    0,    0,    0,    0,    0,  267,    0, 
          264,  264,  264,  266,    0,  264,  264,  264,  267,  264, 
            0,    0,    0,    0,    0,    0,    0,  264,    0,  264, 
          264,  264,    0,    0,    0,    0,    0,    0,    0,  264, 
          264,    0,  264,  264,  264,  264,  264,    0,    0,  267, 
            0,    0,  267,    0,    0,  327,  327,  327,    0,    0, 
          327,  327,  327,    0,  327,    0,  267,  267,    0,  268, 
            0,  267,  327,    0,    0,    0,    0,    0,    0,  268, 
            0,  264,  264,    0,    0,  264,  264,  327,  327,  327, 
          327,  327,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,  267,  264,    0,    0,    0,    0,    0,    0,    0, 
          268,    0,    0,  268,    0,    0,  264,    0,    0,  264, 
            0,    0,    0,    0,    0,    0,    0,  268,  268,    0, 
            0,    0,  268,  267,    0,    0,    0,    0,    0,    0, 
            0,    0,  327,    0,    0,    0,    0,    0,    0,    0, 
          266,  266,  266,    0,    0,  266,  266,  266,    0,  266, 
            0,  327,  268,    0,    0,    0,    0,  266,    0,  266, 
          266,  266,    0,    0,    0,    0,    0,    0,    0,  266, 
          266,    0,  266,  266,  266,  266,  266,  275,    0,    0, 
            0,    0,    0,    0,  268,    0,    0,  275,    0,    0, 
            0,    0,  229,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  266,  266,    0,    0,  266,  266,    0,  275,    0, 
          229,  275,  229,    0,  229,    0,    0,  266,  684,    0, 
            0,    0,  266,    0,    0,  275,  275,    0,    0,    0, 
          275,  229,    0,  229,    0,    0,  266,    0,    0,  266, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          267,  267,  267,    0,    0,  267,  267,  267,    0,  267, 
          275,    0,    0,    0,    0,    0,    0,  267,    0,  267, 
          267,  267,    0,    0,    0,    0,    0,    0,    0,  267, 
          267,    0,  267,  267,  267,  267,  267,    0,    0,    0, 
            0,    0,  275,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  268,  268,  268,  269,    0,  268,  268,  268,    0, 
          268,  267,  267,    0,  269,  267,  267,    0,  268,    0, 
          268,  268,  268,    0,    0,    0,    0,  267,    0,    0, 
          268,  268,  267,  268,  268,  268,  268,  268,    0,    0, 
            0,    0,    0,    0,    0,  269,  267,    0,  269,  267, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  269,  269,    0,    0,    0,  269,    0,    0, 
            0,    0,  268,  268,    0,    0,  268,  268,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  268,    0, 
            0,    0,    0,  268,    0,    0,    0,  269,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  268,    0,    0, 
          268,    0,    0,    0,    0,    0,    0,  270,    0,  275, 
          275,  275,    0,    0,  275,  275,  275,  270,  275,  269, 
            0,    0,    0,    0,    0,    0,  275,    0,  275,  275, 
          275,    0,    0,    0,    0,    0,    0,    0,  275,  275, 
            0,  275,  275,  275,  275,  275,    0,    0,  270,    0, 
            0,  270,    0,    0,    0,    0,    0,    0,  229,    0, 
          229,  229,  229,  229,  229,  270,  270,    0,    0,    0, 
          270,    0,    0,    0,    0,    0,    0,    0,  229,    0, 
          275,  275,    0,    0,  275,  275,    0,    0,    0,    0, 
            0,    0,  229,    0,    0,    0,  275,    0,  684,    0, 
          270,  275,  229,    0,    0,    0,    0,  229,  229,  229, 
            0,    0,    0,    0,    0,  275,    0,    0,  275,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  270,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  276,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  276,    0,    0,  269,  269,  269,    0, 
            0,  269,  269,  269,    0,  269,    0,    0,    0,    0, 
            0,    0,    0,  269,    0,  269,  269,  269,    0,    0, 
            0,    0,    0,    0,  276,  269,  269,  276,  269,  269, 
          269,  269,  269,    0,    0,    0,    0,    0,    0,    0, 
            0,  276,  276,    0,    0,    0,  276,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  269,  269,    0, 
            0,  269,  269,    0,    0,    0,  276,    0,    0,    0, 
            0,    0,    0,  269,    0,    0,    0,    0,  269,    0, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,    0, 
            0,    0,  269,    0,    0,  269,  250,    0,  276,  270, 
          270,  270,    0,    0,  270,  270,  270,    0,  270,    0, 
            0,    0,    0,    0,    0,    0,  270,    0,  270,  270, 
          270,    0,    0,    0,    0,    0,    0,  250,  270,  270, 
          250,  270,  270,  270,  270,  270,  251,    0,    0,    0, 
            0,    0,    0,    0,  250,  250,  251,    0,    0,  250, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          270,  270,    0,    0,  270,  270,    0,  251,    0,  250, 
          251,    0,    0,    0,    0,    0,  270,    0,    0,    0, 
            0,  270,    0,    0,  251,  251,    0,    0,    0,  251, 
            0,    0,    0,    0,    0,  270,    0,    0,  270,    0, 
            0,  250,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  251, 
            0,    0,    0,    0,    0,  276,  276,  276,    0,    0, 
          276,  276,  276,    0,  276,    0,    0,    0,    0,    0, 
          246,    0,  276,    0,  276,  276,  276,    0,    0,    0, 
          246,  251,    0,    0,  276,  276,    0,  276,  276,  276, 
          276,  276,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  246,    0,    0,  246,    0,  214,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  276,  246,  246, 
          276,  276,    0,  246,    0,    0,    0,    0,    0,    0, 
            0,    0,  276,    0,  214,    0,  214,  276,  214,    0, 
            0,    0,  685,    0,    0,    0,    0,    0,    0,    0, 
            0,  276,    0,  246,  276,  214,    0,  214,  250,  250, 
          250,    0,    0,  250,  250,  250,    0,  250,    0,    0, 
            0,    0,    0,    0,    0,  250,    0,  250,  250,  250, 
            0,    0,    0,    0,    0,  246,    0,  250,  250,    0, 
          250,  250,  250,  250,  250,  247,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  247,    0,    0,  251,  251, 
          251,    0,    0,  251,  251,  251,    0,  251,    0,    0, 
            0,    0,    0,    0,    0,  251,    0,  251,  251,  251, 
            0,    0,    0,    0,    0,    0,  247,  251,  251,  247, 
          251,  251,  251,  251,  251,  250,    0,    0,    0,    0, 
          250,    0,    0,  247,  247,    0,    0,    0,  247,    0, 
          281,    0,    0,    0,  250,    0,    0,  250,    0,    0, 
          281,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  247,    0, 
            0,    0,    0,    0,    0,  251,    0,    0,    0,    0, 
          251,  281,    0,    0,  281,  283,    0,    0,    0,    0, 
            0,    0,    0,    0,  251,  283,    0,  251,  281,  281, 
          247,    0,  246,  246,  246,    0,    0,  246,  246,  246, 
            0,  246,    0,    0,    0,    0,    0,    0,    0,  246, 
            0,  246,  246,  246,    0,    0,  283,    0,    0,  283, 
            0,  246,  246,  281,  246,  246,  246,  246,  246,    0, 
            0,    0,    0,  283,  283,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  279,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  279,  281,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  283,    0, 
            0,    0,  214,    0,  214,  214,  214,  214,  214,  246, 
            0,    0,    0,    0,  246,  279,    0,    0,  279,    0, 
            0,    0,  214,    0,    0,    0,    0,    0,  246,    0, 
          283,  246,  279,  279,    0,    0,  214,    0,    0,  299, 
            0,    0,  685,    0,    0,    0,  214,    0,    0,  299, 
            0,  214,  214,  214,    0,    0,    0,  247,  247,  247, 
            0,    0,  247,  247,  247,    0,  247,  279,    0,    0, 
            0,    0,    0,    0,  247,    0,  247,  247,  247,    0, 
          299,    0,    0,  299,    0,    0,  247,  247,    0,  247, 
          247,  247,  247,  247,    0,    0,    0,  299,  299,  279, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  281,  281,  281,    0,    0,  281,  281,  281, 
            0,  281,  299,    0,    0,    0,    0,    0,    0,  281, 
            0,  281,  281,  281,  247,    0,    0,    0,    0,  247, 
            0,  281,  281,    0,  281,  281,  281,  281,  281,    0, 
            0,    0,    0,  247,  299,    0,  247,  283,  283,  283, 
            0,  293,  283,  283,  283,    0,  283,    0,    0,    0, 
            0,  293,    0,    0,  283,    0,  283,  283,  283,    0, 
            0,    0,    0,    0,    0,    0,  283,  283,    0,  283, 
          283,  283,  283,  283,    0,    0,    0,    0,    0,  281, 
            0,    0,  293,    0,  281,  293,    0,    0,    0,  280, 
            0,    0,    0,    0,    0,    0,    0,    0,  281,  280, 
          293,  281,    0,    0,    0,    0,  279,  279,  279,    0, 
            0,  279,  279,  279,    0,  279,    0,    0,    0,    0, 
            0,    0,    0,  279,  283,  279,  279,  279,    0,  283, 
          280,    0,    0,  280,  293,  279,  279,    0,  279,  279, 
          279,  279,  279,  283,    0,    0,  283,  280,  280,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  282,    0, 
            0,    0,    0,    0,    0,    0,  293,    0,  282,    0, 
            0,  299,  299,  299,    0,    0,  299,  299,  299,    0, 
          299,    0,  280,    0,    0,    0,    0,    0,  299,    0, 
          299,  299,  299,  279,    0,    0,    0,  196,  279,  282, 
          299,  299,  282,  299,  299,  299,  299,  299,    0,  298, 
            0,    0,  279,    0,  280,  279,  282,  282,    0,  298, 
            0,    0,    0,    0,    0,  196,    0,  196,    0,  196, 
            0,    0,    0,  687,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  196,    0,  196,    0, 
          298,  282,    0,  298,    0,    0,    0,    0,  299,    0, 
            0,    0,    0,  299,    0,    0,    0,  298,  298,    0, 
            0,    0,    0,    0,    0,    0,    0,  299,    0,    0, 
          299,    0,    0,  282,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  298,  293,  293,  293,    0,    0,  293,  293, 
          293,    0,  293,    0,    0,    0,    0,    0,    0,    0, 
          293,    0,  293,  293,  293,    0,    0,    0,    0,    0, 
            0,    0,  293,  293,  298,  293,  293,  293,  293,  293, 
            0,    0,    0,    0,  249,    0,    0,    0,    0,    0, 
            0,  280,  280,  280,    0,    0,  280,  280,  280,    0, 
          280,    0,    0,    0,    0,    0,    0,    0,  280,    0, 
          280,  280,  280,    0,    0,    0,    0,    0,    0,    0, 
          280,  280,    0,  280,  280,  280,  280,    0,    0,    0, 
          293,    0,    0,    0,    0,  293,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  293, 
            0,    0,  293,    0,    0,    0,    0,    0,    0,    0, 
          282,  282,  282,    0,    0,  282,  282,  282, 1036,  282, 
            0,    0,    0,    0,    0,    0,    0,  282,  280,  282, 
          282,  282,    0,  280,    0,    0,    0,    0,    0,  282, 
          282,    0,  282,  282,  282,  282,    0,  280,    0,    0, 
          280,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  298,  298,  298,    0,    0,  298,  298,  298,    0, 
          298,    0,    0,    0,    0,    0,    0,    0,  298,    0, 
          298,  298,  298,  196,    0,  196,  196,  196,  196,  196, 
          298,  298,    0,  298,  298,  298,  298,  282,  485,    0, 
            0,    0,  282,  196,    0,    0,    0,    0,  485,    0, 
            0,    0,    0,    0,    0,    0,  282,  196,    0,  282, 
            0,    0,    0,  687,    0,    0,    0,  196,    0,    0, 
            0,  315,  196,  196,  196,  485,  485,    0,    0,  485, 
          485,  485,  485,  485,  485,  485,    0,    0,  298,    0, 
            0,    0,    0,  298,    0,    0,    0,  485,  485,    0, 
          485,  485,    0,    0,    0,    0,    0,  298,    0,    0, 
          298,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  485, 
            0,  485,  485,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          818, 1018, 1019, 1020, 1021,    0,    0,    0,    0,    0, 
          818,  485,  485,  485,  315,    0,    0, 1022, 1023, 1024, 
         1025,    0,    0,    0, 1026,    0,    0,   40,   41,   42, 
           43,   44,    0,  315,    0,    0,  303,  818,  818,    0, 
            0,  818,  818,  818,  818,  818,  818,  818,    0,    0, 
            0,    0,    0, 1028, 1029,    0,    0,    0,    0,  818, 
          818, 1030,  818,  818, 1031,    0, 1032, 1033,    0, 1034, 
            0,    0,   58,   59,   60,   61,   62,   63,   64,    0, 
           65,   66,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  818,    0,  818,  818,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  818,  818,  818,  315,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  315,  315,  315,    0,  315, 
          485,  485,  485,  315,  315,  485,  485,  485,  315,  485, 
          315,  315,  315,  315,  315,  315,  315,  485,  485,  485, 
          485,    0,  315,  315,  315,  315,  315,  315,  315,  485, 
          485,  315,  485,  485,  485,  485,  485,    0,  315,    0, 
            0,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,  315,    0,    0, 
          315,    0,  315,  315,  485,  485,  485,  485,  485,  485, 
          485,  485,  485,  485,  485,  485,  485,  315,  315,    0, 
            0,  485,  485,  485,  485,  315,    0,  485,  315,  315, 
          315,  315,  485,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,  315,    0,  315,  315,  485,  315,  315,  315, 
            0,  315,  818,  818,  818,  315,  315,  818,  818,  818, 
          315,  818,  315,  315,  315,  315,  315,  315,  315,  818, 
          818,  818,  818,    0,  315,  315,  315,  315,  315,  315, 
          315,  818,  818,  315,  818,  818,  818,  818,  818,    0, 
          315,    0,    0,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
            0,    0,  315,    0,  315,  315,  818,  818,  818,  818, 
          818,  818,  818,  818,  818,  818,  818,  818,  818,  315, 
          315,    0,    0,  818,  818,  818,  818,  315,    0,  818, 
          315,  315,  315,  315,  818,  315,  315,  315,  315,  315, 
          315,  315,  315,  315,  315,  355,  315,  315,  818,    0, 
            0,    0,    0,    0,    0,  355,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  315,    0, 
            0,    0,  355,  355,    0,    0,  355,  355,  355,  355, 
          355,  355,  355,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  355,  355,    0,  355,  355,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  355,    0,  355,  355, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  677,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  677,    0,  355, 
          355,  315,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          788,    0,    0,    0,  677,  677,    0,  788,  677,  677, 
          677,  113,  677,  677,  677,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  677,  677,  132,  677, 
          677,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  677,    0, 
            0,  677,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          788,  677,  677,  788,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  315,  315,  315,    0,  315,  355,  355,  355, 
          315,  315,  355,  355,  355,  315,  355,  315,  315,  315, 
          315,  315,  315,  315,  355,    0,  355,  355,    0,  315, 
          315,  315,  315,  315,  315,  315,  355,  355,  315,  355, 
          355,  355,  355,  355,    0,  315,    0,    0,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,  315,  315,  315,    0,    0,  315,    0,  315, 
          315,  355,  355,  355,  355,  355,  355,  355,  355,  355, 
          355,  355,  355,  355,  315,  315,    0,    0,  355,  355, 
          355,  355,  315,    0,  355,  315,  315,  315,  315,  355, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
            0,  315,  315,  355,  788,  788,  788,    0,  788,  677, 
          677,  677,  788,  788,    0,  677,  677,  788,  677,  788, 
          788,  788,  788,  788,  788,  788,  677,  788,    0,    0, 
            0,  788,  788,  788,  788,  788,  788,  788,  677,  677, 
          788,  677,  677,  677,  677,  677,    0,  788,    0,    0, 
          788,  788,  788,  788,  788,  788,  788,  788,  788,  788, 
          788,  788,  788,  788,  788,  788,  788,    0,    0,  788, 
            0,  788,  788,  677,  677,  677,  677,  677,  677,  677, 
          677,  677,  677,  677,  677,  677,  788,  788,    0,    0, 
          677,  677,  677,  677,  788,  689,  677,  788,  788,  788, 
          788,    0,  788,  788,  788,  788,  788,  788,  788,  788, 
          788,  788,  680,  788,  788,  677,    0,    0,    0,    0, 
            0,    0,  680,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  789,    0,    0,    0,  680, 
          680,    0,  789,  680,  680,  680,  116,  680,  680,  680, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  680,  680,  135,  680,  680,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  680,    0,    0,  680,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  795,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  795,  789,  680,  680,  789,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  791,    0,    0, 
            0,  795,  795,    0,  791,  795,  795,  795,  127,  795, 
          795,  795,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  795,  795,  146,  795,  795,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  795,    0,    0,  795,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  795,  795,  795, 
          791,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  789, 
          789,  789,    0,  789,  680,  680,  680,  789,  789,    0, 
          680,  680,  789,  680,  789,  789,  789,  789,  789,  789, 
          789,  680,  789,    0,    0,    0,  789,  789,  789,  789, 
          789,  789,  789,  680,  680,  789,  680,  680,  680,  680, 
          680,    0,  789,    0,    0,  789,  789,  789,  789,  789, 
          789,  789,  789,  789,  789,  789,  789,  789,  789,  789, 
          789,  789,    0,    0,  789,    0,  789,  789,  680,  680, 
          680,  680,  680,  680,  680,  680,  680,  680,  680,  680, 
          680,  789,  789,    0,    0,  680,  680,  680,  680,  789, 
          692,  680,  789,  789,  789,  789,    0,  789,  789,  789, 
          789,  789,  789,  789,  789,  789,  789,    0,  789,  789, 
          680,  791,  791,  791,    0,  791,  795,  795,  795,  791, 
          791,    0,  795,  795,  791,  795,  791,  791,  791,  791, 
          791,  791,  791,  795,  795,    0,    0,    0,  791,  791, 
          791,  791,  791,  791,  791,  795,  795,  791,  795,  795, 
          795,  795,  795,    0,  791,    0,    0,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,    0,    0,  791,    0,  791,  791, 
          795,  795,  795,  795,  795,  795,  795,  795,  795,  795, 
          795,  795,  795,  791,  791,    0,    0,  795, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

          795,  795,  795,  791,    0,  795,  791,  791,  791,  791, 
            0,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  795,    0,    0,    0,    0,    0, 
            0,  791,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  791,    0,    0,    0,  791,  791, 
            0,  791,  791,  791,  791,  126,  791,  791,  791,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          791,  791,  145,  791,  791,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  791,    0,    0,  791,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  792,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  792,  791,  791,  791,  791,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  792,    0,    0,    0, 
          792,  792,    0,  792,  792,  792,  792,  128,  792,  792, 
          792,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  792,  792,  147,  792,  792,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  792,    0,    0,  792,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  792,  792,  792,  792, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  791,  791, 
          791,    0,  791,  791,  791,  791,  791,  791,    0,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,    0,    0,    0,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
            0,  791,    0,    0,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,    0,    0,  791,    0,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,    0,    0,  791,  791,  791,  791,  791,    0, 
          791,  791,  791,  791,  791,    0,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,    0,  791,  791,  791, 
          792,  792,  792,    0,  792,  792,  792,  792,  792,  792, 
            0,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,    0,    0,    0,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,    0,  792,    0,    0,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,    0,    0,  792,    0,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,    0,    0,  792,  792,  792,  792, 
          792,    0,  792,  792,  792,  792,  792,    0,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  795,  792, 
          792,  792,    0,    0,    0,    0,    0,    0,  795,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  791,    0,    0,    0,  795,  795,    0,  791,  795, 
          795,  795,  795,  795,  795,  795,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  795,  795,  146, 
          795,  795,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  795, 
            0,    0,  795,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          791,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          791,  795,  795,  795,  791,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  791,    0,    0,    0,  791,  791,    0, 
          791,  791,  791,  791,  791,  791,  791,  791,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  791, 
          791,  145,  791,  791,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  791,    0,    0,  791,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  791,  791,  791,  791,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  791,  791,  791,    0,  791, 
          795,  795,  795,  791,  791,    0,  795,  795,  791,  795, 
          791,  791,  791,  791,  791,  791,  791,  795,  795,    0, 
            0,    0,  791,  791,  791,  791,  791,  791,  791,  795, 
          795,  791,  795,  795,  795,  795,  795,    0,  791,    0, 
            0,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,    0,    0, 
          791,    0,  791,  791,  795,  795,  795,  795,  795,  795, 
          795,  795,  795,  795,  795,  795,  795,  791,  791,    0, 
            0,  795,  795,  795,  795,  791,    0,  795,  791,  791, 
          791,  791,    0,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,    0,  791,  791,  795,  791,  791,  791, 
            0,  791,  791,  791,  791,  791,  791,    0,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,    0,    0,    0,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,    0, 
          791,    0,    0,  791,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
            0,    0,  791,    0,  791,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  791,  791,  791,  791,  791, 
          791,    0,    0,  791,  791,  791,  791,  791,    0,  791, 
          791,  791,  791,  791,    0,  791,  791,  791,  791,  791, 
          791,  791,  791,  791,  791,  792,  791,  791,  791,    0, 
            0,    0,    0,    0,    0,  792,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  792,    0, 
            0,    0,  792,  792,    0,  792,  792,  792,  792,  792, 
          792,  792,  792,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  792,  792,  147,  792,  792,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  792,    0,    0,  792, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  348,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  348,  792,  792, 
          792,  792,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          792,    0,    0,    0,  348,  348,    0,  792,  348,  348, 
          348,  129,  348,  348,  348,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  348,  348,  148,  348, 
          348,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  348,    0, 
            0,  348,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  348,  348,  792,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  792,  792,  792,    0,  792,  792,  792,  792, 
          792,  792,    0,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,    0,    0,    0,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,    0,  792,    0,    0,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,    0,    0,  792,    0,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,    0,    0,  792,  792, 
          792,  792,  792,    0,  792,  792,  792,  792,  792,    0, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
            0,  792,  792,  792,  792,  792,  792,    0,  792,  348, 
          348,  348,  792,  792,    0,  348,  348,  792,  348,  792, 
          792,  792,  792,  792,  792,  792,  348,    0,    0,    0, 
            0,  792,  792,  792,  792,  792,  792,  792,  348,  348, 
          792,  348,  348,  348,  348,  348,    0,  792,    0,    0, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,    0,    0,  792, 
            0,  792,  792,  348,  348,  348,  348,  348,  348,  348, 
          348,  348,  348,  348,  348,  348,  792,  792,    0,    0, 
          348,  348,  348,  348,  792,    0,  348,  792,  792,  792, 
          792,    0,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,  348,  792,  792,  348,    0,    0,    0,    0, 
            0,    0,  348,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  792,    0,    0,    0,  348, 
          348,    0,  792,  348,  348,  348,  348,  348,  348,  348, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  348,  348,  148,  348,  348,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  348,    0,    0,  348,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  818,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  818,    0,  348,  348,  792,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  315,    0,    0, 
            0,    0,    0,    0,    0,  818,    0,    0,    0,    0, 
          818,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  818,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  197,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  197,    0,  197,    0, 
          197,    0,    0,    0,  686,    0,    0,  818,    0,  818, 
          315,    0,    0,    0,    0,    0,    0,  197,    0,  197, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  792, 
          792,  792,    0,  792,  348,  348,  348,  792,  792,    0, 
          348,  348,  792,  348,  792,  792,  792,  792,  792,  792, 
          792,  348,    0,    0,    0,    0,  792,  792,  792,  792, 
          792,  792,  792,  348,  348,  792,  348,  348,  348,  348, 
          348,    0,  792,    0,    0,  792,  792,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,  792,  792,  792, 
          792,  792,    0,    0,  792,    0,  792,  792,  348,  348, 
          348,  348,  348,  348,  348,  348,  348,  348,  348,  348, 
          348,  792,  792,    0,    0,  348,  348,  348,  348,  792, 
            0,  348,  792,  792,  792,  792,    0,  792,  792,  792, 
          792,  792,  792,  792,  792,  792,  792,    0,  792,  792, 
          348,  315,  315,  315,    0,  315,  818,  818,  818,  315, 
          315,  818,  818,  818,  315,  818,  315,  315,  315,  315, 
          315,  315,  315,  818,  818,  818,    0,    0,  315,  315, 
          315,  315,  315,  315,  315,  818,  818,  315,  818,  818, 
          818,  818,  818,    0,  315,    0,    0,  315,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,  315,  315,    0,    0,  315,    0,  315,  315, 
            0,    0,    0,    0,    0,    0,  382,    0,    0,    0, 
            0,    0,    0,  315,  315,    0,  382,    0,    0,  818, 
          818,  315,    0,    0,  315,  315,  315,  315,    0,  315, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,    0, 
          315,  315,  818,  382,  382,    0,    0,  382,  382,  382, 
          382,  382,  382,  382,  197,    0,  197,  197,  197,  197, 
          197,    0,    0,    0,    0,  382,  382,    0,  382,  382, 
            0,    0,    0,    0,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  197,    0, 
            0,    0,    0,    0,  686,    0,    0,  382,  197,  382, 
          382,  383,    0,  197,  197,  197,    0,    0,    0,    0, 
            0,  383,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          382,  382,    0,    0,    0,    0,    0,    0,  383,  383, 
            0,    0,  383,  383,  383,  383,  383,  383,  383,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          383,  383,    0,  383,  383,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  383,    0,  383,  383,    0,    0,    0,  352, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  352, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  383,  383,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  352,  352,    0,    0, 
          352,  352,  352,  352,  352,  352,  352,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  352,  352, 
            0,  352,  352,    0,    0,    0,    0,    0,  382,  382, 
          382,    0,    0,  382,  382,  382,    0,  382,    0,    0, 
            0,    0,    0,    0,    0,  382,    0,  382,  382,    0, 
          352,    0,  352,  352,    0,    0,    0,  382,  382,    0, 
          382,  382,  382,  382,  382,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  352,  352,    0,    0,    0,    0,    0, 
            0,    0,  382,  382,  382,  382,  382,  382,  382,  382, 
          382,  382,  382,  382,  382,    0,    0,    0,    0,  382, 
          382,  382,  382,    0,    0,  382,    0,    0,    0,    0, 
          382,    0,    0,  383,  383,  383,    0,    0,  383,  383, 
          383,    0,  383,  198,  382,    0,    0,    0,    0,    0, 
          383,    0,  383,  383,    0,    0,    0,    0,    0,    0, 
            0,    0,  383,  383,    0,  383,  383,  383,  383,  383, 
            0,  198,    0,  198,    0,  198,    0,    0,    0,  688, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  198,    0,  198,    0,    0,  383,  383,  383, 
          383,  383,  383,  383,  383,  383,  383,  383,  383,  383, 
            0,    0,    0,    0,  383,  383,  383,  383,    0,    0, 
          383,    0,    0,    0,    0,  383,    0,    0,    0,    0, 
            0,  352,  352,  352,    0,    0,  352,  352,  352,  383, 
          352,    0,    0,    0,    0,    0,    0,    0,  352,    0, 
          352,  352,    0,    0,    0,    0,    0,    0,    0,    0, 
          352,  352,    0,  352,  352,  352,  352,  352,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  486,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  486,    0,  352,  352,  352,  352,  352, 
          352,  352,  352,  352,  352,  352,  352,  352,    0,    0, 
            0,    0,  352,  352,  352,  352,    0,    0,  352,    0, 
          486,  486,    0,  352,  486,  486,  486,  125,  486,  486, 
          486,    0,    0,    0,    0,    0,    0,  352,    0,    0, 
            0,    0,  486,  486,  144,  486,  486,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  486,  486,    0,    0,  486,    0,    0, 
            0,    0,    0,  486,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  486,  486,  486,    0, 
          486,  486,    0,    0,  486,  486,  486,  486,  486,  486, 
          486,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  486,  486,  144,  486,  486,    0,    0,  198, 
            0,  198,  198,  198,  198,  198,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  198, 
            0,    0,    0,    0,  486,  683,    0,  486,    0,    0, 
            0,    0,    0,  198,    0,  683,    0,    0,    0,  688, 
            0,    0,    0,  198,    0,    0,    0,    0,  198,  198, 
          198,    0,    0,    0,    0,    0,  486,  486,  486,    0, 
            0,    0,  683,  683,    0,    0,  683,  683,  683,  119, 
          683,  683,  683,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  683,  683,  138,  683,  683,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  486,  486,  486,    0,    0, 
            0,  486,  486,    0,  486,    0,  683,    0,    0,  683, 
            0,    0,  486,  486,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  486,  486,    0,  486,  486,  486, 
          486,  486,    0,    0,    0,    0,    0,    0,    0,  683, 
          683,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  486, 
          486,  486,  486,  486,  486,  486,  486,  486,  486,  486, 
          486,  486,    0,    0,    0,    0,  486,  486,  486,  486, 
            0,    0,  486,    0,    0,  486,  486,  486,    0,    0, 
            0,  486,  486,    0,  486,    0,    0,    0,    0,    0, 
            0,  486,  486,  486,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  486,  486,    0,  486,  486,  486, 
          486,  486,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  486, 
          486,  486,  486,  486,  486,  486,  486,  486,  486,  486, 
          486,  486,    0,    0,    0,    0,  486,  486,  486,  486, 
            0,    0,  486,    0,    0,    0,    0,  683,  683,  683, 
            0,    0,    0,  683,  683,    0,  683,    0,    0,    0, 
            0,  486,    0,    0,  683,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  683,  683,    0,  683, 
          683,  683,  683,  683,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  682,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  682,    0, 
            0,  683,  683,  683,  683,  683,  683,  683,  683,  683, 
          683,  683,  683,  683,    0,    0,    0,    0,  683,  683, 
          683,  683,    0,  695,  683,  682,  682,    0,    0,  682, 
          682,  682,  118,  682,  682,  682,    0,    0,    0,    0, 
            0,    0,    0,  683,    0,    0,    0,  682,  682,  137, 
          682,  682,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  684,  682, 
            0,    0,  682,    0,    0,    0,    0,    0,  684,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  682,  682,    0,  684,  684,    0,    0,  684, 
          684,  684,  120,  684,  684,  684,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  684,  684,  139, 
          684,  684,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  684, 
          685,    0,  684,    0,    0,    0,    0,    0,    0,    0, 
          685,  377,  372,    0,    0,    0,  375,  373,    0,  374, 
            0,  376,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  684,  684,  369,    0,  368,  685,  685,    0, 
            0,  685,  685,  685,  121,  685,  685,  685,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  685, 
          685,  140,  685,  685,    0,    0,    0,    0,  371,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          682,  682,  682,    0,    0,    0,  682,  682,    0,  682, 
            0,  685,    0,    0,  685,    0,    0,  682,  370,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  682, 
          682,    0,  682,  682,  682,  682,  682,    0,    0,    0, 
            0,    0,    0,    0,  685,  685,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  682,  682,  682,  682,  682,  682, 
          682,  682,  682,  682,  682,  682,  682,    0,    0,    0, 
            0,  682,  682,  682,  682,    0,  694,  682,    0,    0, 
          684,  684,  684,    0,    0,    0,  684,  684,    0,  684, 
            0,    0,    0,    0,    0,    0,  682,  684,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  684, 
          684,    0,  684,  684,  684,  684,  684,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  684,  684,  684,  684,  684,  684, 
          684,  684,  684,  684,  684,  684,  684,    0,    0,    0, 
            0,  684,  684,  684,  684,    0,  696,  684,    0,    0, 
            0,    0,  685,  685,  685,    0,    0,    0,  685,  685, 
            0,  685,    0,    0,    0,    0,  684,    0,    0,  685, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  685,  685,    0,  685,  685,  685,  685,  685,    0, 
          351,  352,  353,  354,  355,  356,  357,    0,    0,  360, 
          361,    0,    0,  687,    0,    0,    0,  364,  365,    0, 
            0,    0,    0,  687,    0,    0,  685,  685,  685,  685, 
          685,  685,  685,  685,  685,  685,  685,  685,  685,    0, 
            0,    0,    0,  685,  685,  685,  685,    0,  697,  685, 
          687,  687,    0,    0,  687,  687,  687,  123,  687,  687, 
          687,    0,    0,    0,    0,    0,    0,    0,  685,    0, 
            0,    0,  687,  687,  142,  687,  687,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  686,  687,    0,    0,  687,    0,    0, 
            0,    0,    0,  686,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  687,  687,    0, 
          686,  686,    0,    0,  686,  686,  686,  122,  686,  686, 
          686,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  686,  686,  141,  686,  686,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  686,  688,    0,  686,    0,    0, 
            0,    0,    0,    0,    0,  688,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  686,  686,    0, 
            0,    0,  688,  688,    0,    0,  688,  688,  688,  124, 
          688,  688,  688,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  688,  688,  143,  688,  688,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  687,  687,  687,    0,    0, 
            0,  687,  687,    0,  687,    0,  688,    0,    0,  688, 
            0,    0,  687,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  687,  687,    0,  687,  687,  687, 
          687,  687,    0,    0,    0,    0,    0,    0,    0,  688, 
          688,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  687, 
          687,  687,  687,  687,  687,  687,  687,  687,  687,  687, 
          687,  687,    0,    0,    0,    0,  687,  687,  687,  687, 
            0,  699,  687,    0,    0,  686,  686,  686,    0,    0, 
            0,  686,  686,    0,  686,    0,    0,    0,    0,    0, 
            0,  687,  686,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  686,  686,    0,  686,  686,  686, 
          686,  686,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  686, 
          686,  686,  686,  686,  686,  686,  686,  686,  686,  686, 
          686,  686,    0,    0,    0,    0,  686,  686,  686,  686, 
            0,  698,  686,    0,    0,    0,    0,  688,  688,  688, 
            0,    0,    0,  688,  688,    0,  688,    0,    0,    0, 
            0,  686,    0,    0,  688,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  688,  688,    0,  688, 
          688,  688,  688,  688,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  679,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  679,    0, 
            0,  688,  688,  688,  688,  688,  688,  688,  688,  688, 
          688,  688,  688,  688,    0,    0,    0,    0,  688,  688, 
          688,  688,    0,  700,  688,  679,  679,    0,    0,  679, 
          679,  679,  115,  679,  679,  679,    0,    0,    0,    0, 
            0,    0,    0,  688,    0,    0,    0,  679,  679,  134, 
          679,  679,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  678,  679, 
            0,    0,  679,    0,    0,    0,    0,    0,  678,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  679,  679,    0,  678,  678,    0,    0,  678, 
          678,  678,  114,  678,  678,  678,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  678,  678,  133, 
          678,  678,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  678, 
          681,    0,  678,    0,    0,    0,    0,    0,    0,    0, 
          681,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  678,  678,    0,    0,    0,  681,  681,    0, 
            0,  681,  681,  681,  117,  681,  681,  681,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  681, 
          681,  136,  681,  681,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          679,  679,  679,    0,    0,    0,  679,  679,    0,  679, 
            0,  681,    0,    0,  681,    0,    0,  679,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  679, 
          679,    0,  679,  679,  679,  679,  679,    0,    0,    0, 
            0,    0,    0,    0,  681,  681,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  679,  679,  679,  679,  679,  679, 
          679,  679,  679,  679,  679,  679,  679,    0,    0,    0, 
            0,  679,  679,  679,  679,    0,  691,  679,    0,    0, 
          678,  678,  678,    0,    0,    0,  678,  678,    0,  678, 
            0,    0,    0,    0,    0,    0,  679,  678,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  678, 
          678,    0,  678,  678,  678,  678,  678,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  678,  678,  678,  678,  678,  678, 
          678,  678,  678,  678,  678,  678,  678,    0,    0,    0, 
            0,  678,  678,  678,  678,    0,  690,  678,    0,    0, 
            0,    0,  681,  681,  681,    0,    0,    0,  681,  681, 
            0,  681,    0,    0,    0,    0,  678,    0,    0,  681, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  681,  681,    0,  681,  681,  681,  681,  681,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  339,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  339,    0,    0,  681,  681,  681,  681, 
          681,  681,  681,  681,  681,  681,  681,  681,  681,    0, 
            0,    0,    0,  681,  681,  681,  681,    0,  693,  681, 
          339,  339,    0,    0,  339,  339,  339,  131,  339,  339, 
          339,    0,    0,    0,    0,    0,    0,    0,  681,    0, 
            0,    0,  339,  339,  150,  339,  339,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  349,  339,    0,    0,  339,    0,    0, 
            0,    0,    0,  349,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  339,  339,    0, 
          349,  349,    0,    0,  349,  349,  349,  130,  349,  349, 
          349,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  349,  349,  149,  349,  349,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  349,  339,    0,  349,    0,    0, 
            0,    0,    0,    0,    0,  339,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  349,  349,    0, 
            0,    0,  339,  339,    0,    0,  339,  339,  339,  339, 
          339,  339,  339,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  339,  339,  150,  339,  339,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  339,  339,  339,    0,    0, 
            0,  339,  339,    0,  339,    0,  339,    0,    0,  339, 
            0,    0,  339,  580,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  580,  339,  339,    0,  339,  339,  339, 
          339,  339,    0,    0,    0,    0,    0,    0,    0,  339, 
          339,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  580,    0,    0,  580,    0,  339, 
          339,  339,  339,  339,  339,  339,  339,  339,  339,  339, 
          339,  339,  580,    0,    0,    0,  339,  339,  339,  339, 
            0,    0,  339,    0,    0,  349,  349,  349,    0,    0, 
            0,  349,  349,    0,  349,    0,    0,    0,    0,    0, 
            0,  339,  349,  581,    0,    0,  580,    0,    0,    0, 
            0,    0,    0,  581,  349,  349,    0,  349,  349,  349, 
          349,  349,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  580,  580,    0, 
            0,    0,    0,    0,  581,    0,    0,  581,    0,  349, 
          349,  349,  349,  349,  349,  349,  349,  349,  349,  349, 
          349,  349,  581,   84,    0,    0,  349,  349,  349,  349, 
            0,    0,  349,   84,    0,    0,    0,  339,  339,  339, 
            0,    0,    0,  339,  339,    0,  339,    0,    0,    0, 
            0,  349,    0,    0,  339,    0,  581,    0,    0,    0, 
            0,    0,    0,    0,   84,    0,  339,  339,    0,  339, 
          339,  339,  339,  339,    0,    0,    0,    0,    0,    0, 
            0,    0,   84,    0,    0,    0,  558,  581,  581,    0, 
            0,    0,    0,    0,    0,    0,  558,    0,    0,    0, 
            0,  339,  339,  339,  339,  339,  339,  339,  339,  339, 
          339,  339,  339,  339,    0,    0,   84,    0,  339,  339, 
          339,  339,    0,    0,  339,    0,    0,  558,    0,    0, 
          558,    0,    0,    0,    0,  580,  580,  580,    0,    0, 
          580,  580,  580,  339,  580,  558,  569,    0,   84,    0, 
            0,    0,  580,    0,  580,    0,  569,    0,    0,    0, 
            0,    0,    0,    0,  580,  580,    0,  580,  580,  580, 
          580,  580,    0,    0,    0,    0,    0,    0,    0,  558, 
            0,    0,    0,    0,    0,    0,    0,  569,    0,    0, 
          569,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  544,  569,    0,    0,    0,    0, 
            0,  558,    0,    0,  544,    0,    0,    0,    0,    0, 
            0,    0,  580,    0,    0,  581,  581,  581,    0,    0, 
          581,  581,  581,    0,  581,    0,    0,    0,    0,  569, 
            0,  580,  581,    0,  581,  544,    0,    0,  561,    0, 
            0,    0,    0,    0,  581,  581,    0,  581,  581,  581, 
          581,  581,    0,  544,    0,  568,    0,    0,    0,    0, 
            0,  569,    0,    0,    0,  568,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   84,   84,   84,    0,    0, 
           84,   84,   84,    0,   84,    0,    0,  544,    0,    0, 
            0,    0,   84,    0,   84,   84,  568,    0,    0,  568, 
            0,    0,  581,    0,   84,   84,    0,   84,   84,   84, 
           84,   84,    0,    0,  568,    0,    0,  561,    0,  544, 
            0,  581,    0,    0,    0,    0,    0,  561,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  558,  558, 
          558,    0,    0,  558,  558,  558,    0,  558,  568,    0, 
            0,    0,    0,    0,    0,  558,    0,  558,  561,    0, 
            0,  561,    0,    0,    0,    0,    0,  558,  558,    0, 
          558,  558,  558,  558,  558,    0,  561,  563,    0,    0, 
          568,   84,    0,    0,    0,    0,    0,  563,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  569,  569, 
          569,    0,    0,  569,  569,  569,    0,  569,    0,    0, 
          561,    0,    0,    0,    0,  569,    0,  569,  563,  554, 
            0,    0,    0,    0,    0,    0,    0,  569,  569,  554, 
          569,  569,  569,  569,  569,    0,  563,    0,    0,    0, 
            0,    0,  561,    0,  558,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  544,  544,  544,    0, 
          554,  544,  544,  544,    0,  544,    0,    0,    0,    0, 
          563,    0,  573,  544,    0,  544,    0,    0,  554,    0, 
            0,    0,  573,    0,    0,  544,  544,    0,  544,  544, 
          544,  544,  544,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  563,    0,  569,    0,    0,    0,    0,    0, 
            0,    0,  554,  573,    0,    0,    0,  568,  568,  568, 
            0,    0,  568,  568,  568,    0,  568,    0,  545,    0, 
            0,  573,    0,    0,  568,    0,  568,    0,  545,    0, 
            0,    0,    0,    0,  554,    0,  568,  568,    0,  568, 
          568,  568,  568,  568,    0,    0,    0,    0,    0,    0, 
            0,    0,  544,    0,    0,  573,  564,    0,    0,  545, 
            0,    0,    0,    0,    0,    0,  564,    0,    0,  561, 
          561,  561,    0,    0,  561,  561,  561,  545,  561,    0, 
            0,    0,    0,    0,    0,    0,  561,  573,  561,    0, 
            0,    0,    0,    0,    0,    0,  549,  564,  561,  561, 
            0,  561,  561,  561,  561,  561,  549,    0,    0,    0, 
            0,  545,    0,  568,    0,  564,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  563, 
          563,  563,    0,    0,  563,  563,  563,  549,  563,    0, 
            0,    0,    0,  545,    0,    0,  563,    0,  563,  564, 
            0,    0,    0,    0,    0,  549,    0,    0,  563,  563, 
            0,  563,  563,  563,  563,  563,    0,    0,    0,    0, 
            0,  554,  554,  554,    0,  561,  554,  554,  554,    0, 
          554,  564,    0,    0,    0,    0,  546,    0,  554,  549, 
          554,    0,    0,    0,    0,    0,  546,    0,    0,    0, 
          554,  554,    0,  554,  554,  554,  554,  554,    0,    0, 
            0,    0,    0,    0,    0,    0,  156,    0,    0,    0, 
            0,  549,    0,    0,  573,  573,  573,  546,    0,  573, 
          573,  573,    0,  573,    0,  563,    0,    0,    0,    0, 
            0,  573,    0,  573,  156,  546,  156,    0,  156,    0, 
            0,    0,  677,  573,  573,    0,  573,  573,  573,  573, 
          573,    0,    0,    0,    0,  156,    0,  156,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  554,    0,  546, 
          545,  545,  545,    0,    0,  545,  545,  545,    0,  545, 
            0,    0,    0,    0,    0,    0,    0,  545,    0,  545, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  545, 
          545,  546,  545,  545,  545,  545,  545,    0,  564,  564, 
          564,  555,    0,  564,  564,  564,    0,  564,    0,    0, 
          573,  555,    0,    0,    0,  564,    0,  564,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  564,  564,    0, 
          564,  564,  564,  564,  564,    0,    0,    0,  549,  549, 
          549,    0,  555,  549,  549,  549,  547,  549,    0,    0, 
            0,    0,    0,    0,    0,  549,  547,  549,    0,    0, 
          555,    0,    0,    0,    0,    0,  545,  549,  549,    0, 
          549,  549,  549,  549,  549,    0,    0,    0,    0,    0, 
            0,    0,    0,  550,    0,    0,    0,  547,    0,    0, 
            0,    0,    0,  550,  555,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  564,  547,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  550,    0,  555,    0,  546,  546, 
          546,  548,    0,  546,  546,  546,    0,  546,    0,  547, 
            0,  548,  550,    0,  549,  546,    0,  546,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  546,  546,    0, 
          546,  546,  546,  546,  546,    0,    0,    0,    0,   76, 
            0,  547,  548,    0,    0,    0,  550,    0,    0,   76, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  157, 
          548,    0,  156,    0,  156,  156,  156,  156,  156,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  550,    0, 
           76,    0,  156,    0,    0,    0,    0,  157,    0,  157, 
            0,  157,    0,    0,  548,  680,  156,    0,   76,    0, 
            0,    0,  677,    0,  546,    0,  156,    0,  157,    0, 
          157,  156,  156,  156,    0,    0,    0,   78,    0,    0, 
            0,    0,    0,    0,    0,    0,  548,   78,    0,    0, 
            0,    0,    0,  555,  555,  555,    0,    0,  555,  555, 
          555,    0,  555,    0,    0,    0,    0,    0,    0,    0, 
          555,    0,  555,    0,    0,    0,    0,    0,   78,    0, 
           79,    0,  555,  555,   76,  555,  555,  555,  555,  555, 
           79,    0,    0,    0,    0,    0,   78,    0,  547,  547, 
          547,    0,    0,  547,  547,  547,    0,  547,    0,    0, 
            0,    0,    0,    0,    0,  547,    0,  547,    0,  513, 
            0,   79,    0,    0,    0,    0,    0,  547,  547,  513, 
          547,  547,  547,  547,  547,  550,  550,  550,    0,   79, 
          550,  550,  550,    0,  550,    0,    0,    0,    0,    0, 
            0,    0,  550,    0,  550,    0,    0,    0,    0,  555, 
          513,    0,   78,    0,  550,  550,  514,  550,  550,  550, 
          550,  550,    0,    0,    0,    0,  514,    0,  513,    0, 
            0,    0,    0,  548,  548,  548,    0,    0,  548,  548, 
          548,    0,  548,    0,    0,    0,    0,    0,    0,    0, 
          548,    0,  548,    0,  547,   79,    0,  514,    0,    0, 
            0,    0,  548,  548,    0,  548,  548,  548,  548,  548, 
            0,   76,   76,   76,    0,  514,   76,   76,   76,  554, 
           76,    0,    0,    0,    0,    0,    0,    0,   76,  554, 
           76,  550,    0,    0,  513,    0,    0,    0,    0,    0, 
           76,   76,    0,   76,   76,   76,   76,   76,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          554,    0,    0,    0,    0,  157,    0,  157,  157,  157, 
          157,  157,  555,    0,    0,    0,    0,    0,  554,  548, 
            0,  514,  555,    0,    0,  157,    0,    0,    0,   78, 
           78,   78,    0,    0,   78,   78,   78,    0,   78,  157, 
            0,    0,    0,    0,    0,  680,   78,    0,   78,  157, 
            0,    0,    0,  555,  157,  157,  157,   76,   78,   78, 
            0,   78,   78,   78,   78,   78,    0,    0,    0,    0, 
            0,  555,   79,   79,   79,    0,    0,   79,   79,   79, 
          328,   79,    0,    0,  554,    0,    0,    0,    0,   79, 
          328,   79,    0,    0,    0,    0,    0,    0,    0,  249, 
            0,   79,   79,    0,   79,   79,   79,   79,   79,    0, 
            0,  513,  513,  513,    0,    0,  513,  513,  513,    0, 
          513,  328,    0,    0,  324,    0,  377,  372,  513,    0, 
          513,  375,  373,    0,  374,   78,  376,  555,    0,  328, 
          513,  513,    0,  513,  513,  513,  513,  513,    0,  369, 
            0,  368,  367,    0,    0,    0,    0,    0,  514,  514, 
          514,    0,    0,  514,  514,  514,    0,  514,    0,    0, 
            0,    0,    0,    0,    0,  514,    0,  514,   79,    0, 
            0,    0,    0,  371,    0,    0,    0,  514,  514,    0, 
          514,  514,  514,  514,  514,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  328,    0,    0,    0,  151, 
            0,    0,    0,  370,    0,    0,    0,  513,    0,    0, 
            0,  554,  554,  554,    0,    0,  554,  554,  554,    0, 
          554,    0,  151,    0,    0,    0,    0,    0,  554,  788, 
          554,    0,    0,    0,    0,  677,    0,    0,    0,    0, 
          554,  554,    0,  554,  554,  554,  554,  554,  151,  151, 
            0,    0,    0,    0,  514,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  555,  555,  555,    0,    0,  555, 
          555,  555,    0,  555,    0,    0,    0,    0,    0,    0, 
          677,  555,    0,  555,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  555,  555,    0,  555,  555,  555,  555, 
          555,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  788,    0,    0,  151,    0,  554,    0,    0, 
            0,    0,    0,  152,    0,    0,    0,    0,    0,    0, 
            0,    0,  328,  328,  328,    0,    0,  328,  328,  328, 
            0,  328,    0,    0,    0,    0,  152,    0,    0,  328, 
            0,    0,    0,  789,    0,    0,    0,    0,    0,  680, 
            0,    0,    0,    0,  328,  328,  328,  328,  328,    0, 
          555,    0,  152,  152,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  680,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,    0,  328, 
            0,    0,  364,  365,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  789,    0,  328,  152, 
            0,    0,    0,    0,    0,  151,  151,  151,  151,  151, 
          151,  151,  151,  151,  151,  151,    0,    0,  151,  151, 
            0,  151,  151,  151,  151,  151,  151,  151,    0,  788, 
            0,    0,    0,  151,  151,  151,  151,  151,  151,  151, 
            0,    0,  151,    0,    0,    0,    0,    0,  151,  151, 
          151,  151,  151,  151,  151,  151,  151,  151,  151,  151, 
          151,    0,  151,  151,  151,  151,  151,  151,  151,    0, 
            0,  151,    0,  151,  151,    0,    0,    0,  806,  525, 
            0,    0,    0,    0,    0,    0,    0,    0,  151,  151, 
            0,    0,    0,    0,  677,  677,  151,    0,    0,  151, 
          151,  151,  151,    0,  151,    0,    0,  151,  151,  151, 
          151,  151,  151,  151,    0,  151,  151,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  152, 
          152,  152,  152,  152,  152,  152,  152,  152,  152,  152, 
            0,    0,  152,  152,    0,  152,  152,  152,  152,  152, 
          152,  152,    0,  789,    0,    0,    0,  152,  152,  152, 
          152,  152,  152,  152,    0,    0,  152,    0,    0,    0, 
            0,    0,  152,  152,  152,  152,  152,  152,  152,  152, 
          152,  152,  152,  152,  152,    0,  152,  152,  152,  152, 
          152,  152,  152,    0,    0,  152,    0,  152,  152,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  152,  152,    0,  151,    0,    0,  680,  680, 
          152,    0,    0,  152,  152,  152,  152,    0,  152,    0, 
            0,  152,  152,  152,  152,  152,  152,  152,  151,  152, 
          152,    0,    0,    0,    0,  791,    0,    0,    0,    0, 
            0,  795,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  151,  151,    0,    0,    0,    0, 
            0,    0,  525,  525,  525,  525,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  525,  525, 
          525,  525,    0,    0,    0,  525,  795,  525,  525,  525, 
          525,  525,  525,    0,    0,    0,    0,  525,    0,    0, 
            0,  525,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  525,  525,    0,  152,  795,    0, 
            0,  151,  525,    0,    0,  525,    0,  525,  525,    0, 
          525,  525,    0,  525,  525,  525,  525,  525,  525,  525, 
          152,  525,  525,    0,    0,    0,    0,  792,    0,    0, 
            0,    0,    0,  348,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  152,  152,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  377,  372,    0,    0,    0,  375,  373,  348,  374, 
            0,  376,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  369,    0,  368,  367,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  152,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  371,    0, 
            0,  151,  151,  151,  151,  151,  151,  151,  151,  151, 
          151,  151,    0,    0,  151,  151,    0,  151,  151,  151, 
          151,  151,  151,  151,    0,  795,    0,    0,  370,  151, 
          151,  151,  151,  151,  151,  151,    0,    0,  151,    0, 
            0,    0,    0,  226,  151,  151,  151,  151,  151,  151, 
          151,  151,  151,  151,  151,  151,  151,    0,  151,  151, 
          151,  151,  151,  151,  151,    0,    0,  151,    0,  151, 
          151,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  151,  151,    0,    0,    0,    0, 
          795,  795,  151,    0,    0,  151,  151,  151,  151,    0, 
          151,    0,    0,  151,  151,  151,  151,  151,  151,  151, 
            0,  151,  151,  152,  152,  152,  152,  152,  152,  152, 
          152,  152,  152,  152,    0,    0,  152,  152,    0,  152, 
          152,  152,  152,  152,  152,  152,   68,    0,    0,    0, 
            0,  152,  152,  152,  152,  152,  152,  152,    0,    0, 
          152,    0,    0,    0,    0,    0,  152,  152,  152,  152, 
          152,  152,  152,  152,  152,  152,  152,  152,  152,    0, 
          152,  152,  152,  152,  152,  152,  152,  152,    0,  152, 
            0,  152,  152,  350,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  152,  152,    0,    0, 
          152,    0,  348,  348,  152,    0,    0,  152,  152,  152, 
          152,    0,  152,  349,    0,  152,  152,  152,  152,  152, 
          152,  152,    0,  152,  152,    0,  152,  152,    0,    0, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,    0,    0,    0,    0,  364,  365,    0, 
            0,    0,    0,  366,    0,    0,    0,    0,  349,    0, 
            0,    0,    0,    0,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,  406, 
            0,    0,    0,  152,   19,   20,   21,  206,  207,  208, 
          209,    0,    0,  210,    0,    0,    0,    0,    0,    0, 
           28,    0,  406,  211,  212,  213,  214,   35,  215,  216, 
          217,  218,  219,   40,   41,   42,   43,   44,   45,   46, 
            0,    0,   47,    0,   48,   49,    0,    0,  406,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   50, 
           51,    0,    0,    0,    0,    0,    0,  220,    0,    0, 
          221,   54,   55,   56,    0,  222,  223,  224,   58,   59, 
          225,   61,   62,   63,   64,    0,   65,   66,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  406,  806,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  152,  152,  152,  152,  152,  152,  152, 
          152,  152,  152,  152,    0,    0,  152,  152,    0,  152, 
          152,  152,  152,  152,  152,  152,    0,    0,    0,    0, 
            0,  152,  152,  152,  152,  152,  152,  152,    0,  524, 
          152,    0,    0,    0,    0,    0,  152,  152,  152,  152, 
          152,  152,  152,  152,  152,  152,  152,  152,  152,    0, 
          152,  152,  152,  152,  152,  152,  152,    0,    0,  152, 
            0,  152,  152,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  152,  152,    0,    0, 
            0,    0,  349,  349,  152,    0,    0,  152,  152,  152, 
          152,    0,  152,    0,    0,  152,  152,  152,  152,  152, 
          152,  152,    0,  152,  152,  406,  406,  406,  406,  406, 
          406,  406,  406,  406,  406,  406,    0,  406,  406,  406, 
          406,  406,  406,  406,  406,  406,  406,  406,  406,    0, 
            0,    0,    0,  406,  406,  406,  406,  406,  406,  406, 
            0,    0,  406,    0,    0,    0,  709,    0,  406,  406, 
          406,  406,  406,  406,  406,  406,  406,  406,  406,  406, 
          406,    0,  406,  406,  406,  406,  406,  406,  406,  709, 
            0,  406,    0,  406,  406,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  406,  406, 
            0,    0,    0,    0,    0,  709,  406,  706,    0,  406, 
          406,  406,  406,    0,  406,    0,    0,  406,  406,  406, 
          406,  406,  406,  406,    0,  406,  406,    0,    0,    0, 
            0,    0,  524,  524,  524,  524,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  524,  524, 
          524,  524,    0,    0,    0,  524,    0,  524,  524,  524, 
          524,  524,  524,    0,    0,    0,    0,  524,  705,    0, 
            0,  524,  709,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  524,  524,    0,    0,    0,    0, 
            0,  705,  524,    0,    0,  524,    0,  524,  524,    0, 
          524,  524,    0,  524,  524,  524,  524,  524,  524,  524, 
            0,  524,  524,    0,    0,    0,    0,  705,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  377,  372,    0,    0,    0,  375,  373,    0,  374, 
            0,  376,    0,    0,  705,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  369,    0,  368,  367,    0,    0, 
            0,    0,  709,  709,  709,  709,  709,  709,  709,  709, 
          709,  709,  709,    0,    0,  709,  709,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

          709,  709,  709,  709,  709,  709,  709,    0,    0,    0, 
          371,    0,  709,  709,  709,  709,  709,  709,  709,    0, 
            0,  709,    0,    0,    0,    0,    0,  709,  709,  709, 
          709,  709,  709,  709,  709,  709,  709,  709,  709,  709, 
          370,  709,  709,  709,  709,  709,  709,  709,    0,    0, 
          709,    0,  709,  709,    0,    0,    0,    0,    0,  818, 
            0,    0,    0,    0,    0,    0,    0,  709,  709,    0, 
            0,    0,    0,    0,    0,  709,    0,    0,  709,  709, 
          709,  709,  818,  709,    0,    0,  709,  709,  709,  709, 
          709,  709,  709,    0,  709,  709,  705,  705,  705,  705, 
          705,  705,  705,  705,  705,  705,  705,    0,  818,  705, 
          705,    0,  705,  705,  705,  705,  705,  705,  705,    0, 
            0,    0,    0,    0,  705,  705,  705,  705,  705,  705, 
          705,    0,    0,  705,    0,    0,    0,    0,    0,  705, 
          705,  705,  705,  705,  705,  705,  705,  705,  705,  705, 
          705,  705,    0,  705,  705,  705,  705,  705,  705,  705, 
            0,    0,  705,    0,  705,  705,    0,    0,    0,    0, 
            0,  818,    0,    0,    0,  818,    0,    0,    0,  705, 
          705,    0,    0,    0,    0,    0,    0,  705,    0,    0, 
          705,  705,  705,  705,  818,  705,    0,    0,  705,  705, 
          705,  705,  705,  705,  705,    0,  705,  705,    0,    0, 
            0,    0,    0,    0,  931,    0,    0,    0,    0,    0, 
          818,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,    0,    0,    0,    0,  364, 
          365,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  377,  372,    0,    0,    0,  375, 
          373,    0,  374,    0,  376,    0,  818,  818,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  369,    0,  368, 
          367,    0,    0,    0,    0,  818,  818,  818,  818,  818, 
          818,  818,  818,  818,  818,  818,    0,    0,  818,  818, 
            0,  818,  818,  818,  818,  818,  818,  818,    0,    0, 
            0,  371,    0,  818,  818,  818,  818,  818,  818,  818, 
            0,    0,  818,    0,    0,    0,    0,    0,  818,  818, 
          818,  818,  818,  818,  818,  818,  818,  818,  818,  818, 
          818,  370,  818,  818,  818,  818,  818,  818,  818,    0, 
            0,  818,  249,  818,  818,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  818,  818, 
            0,    0,    0,    0,    0,  226,  818,    0,    0,  818, 
          818,  818,  818,    0,  818,    0,    0,  818,  818,  818, 
          818,  818,  818,  818,    0,  818,  818,  818,  818,  818, 
          818,  818,  818,    0,    0,    0,  818,  818,    0,    0, 
            0,  818,    0,  818,  818,  818,  818,  818,  818,  818, 
            0,    0,    0,    0,    0,  818,  818,  818,  818,  818, 
          818,  818,    0,    0,  818,    0,    0,    0,    0,    0, 
          818,  818,  818,  818,  818,  818,  818,  818,  818,  818, 
          818,  818,  818,    0,  818,  818,  818,  818,  818,  818, 
          818,    0,    0,  818,  339,  818,  818,    0,   68,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          818,  818,    0,    0,    0,    0,    0,   67,  818,    0, 
            0,  818,  818,  818,  818,    0,  818,    0,    0,  818, 
          818,  818,  818,  818,  818,  818,    0,  818,  818,    0, 
            0,    0,    0,  338,    0,  933,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,    0,    0,    0,    0, 
          364,  365,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  249,    0,    0,    0,    0, 
           68,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   67,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,    0,   19,   20,   21,  206, 
          207,  208,  209,    0,    0,  210,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  211,  212,  213,  214,   35, 
          215,  216,  217,  218,  219,   40,   41,   42,   43,   44, 
           45,   46,    0,    0,   47,    0,   48,   49,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   50,   51,    0,    0,    0,    0,    0,    0,  220, 
            0,   68,  221,   54,   55,   56,    0,  222,  223,  224, 
           58,   59,  225,   61,   62,   63,   64,    0,   65,   66, 
           67,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,    0,   19,   20, 
           21,  206,  207,  208,  209,    0,    0,   26,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  211,  212,  213, 
          214,   35,  215,  216,  217,  218,    0,   40,   41,   42, 
           43,   44,   45,   46,    0,    0,   47,    0,   48,   49, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   50,   51,    0,    0,    0,    0,    0, 
            0,  220,    0,   68,  221,   54,   55,   56,    0,    0, 
            0,    0,   58,   59,   60,   61,   62,   63,   64,    0, 
           65,   66,    4,    5,    6,    0,    8,   67,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,    0,   19, 
           20,   21,  206,  207,  208,  209,    0,    0,   26,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  211,  212, 
          213,  214,   35,  215,  216,  217,  218,    0,   40,   41, 
           42,   43,   44,   45,   46,    0,    0,   47,    0,   48, 
           49,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   50,   51,    0,    0,    0,    0, 
            0,    0,  220,    0,    0,  221,   54,   55,   56,    0, 
           68,    0,    0,   58,   59,   60,   61,   62,   63,   64, 
            0,   65,   66,    3,    4,    5,    6,    7,    8,    0, 
           67,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,   44,   45,   46,    0,    0,   47, 
            0,   48,   49,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   50,   51,    0,    0, 
            0,    0,    0,    0,   52,    0,    0,   53,   54,   55, 
           56,    0,   57,   68,    0,   58,   59,   60,   61,   62, 
           63,   64,    0,   65,   66,    0,    0,    0,    0,    0, 
          270,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,  271,   30,   31,   32,   33, 
           34,   35,   36,   37,   38,   39,   67,   40,   41,   42, 
           43,   44,   45,   46,    0,    0,   47,    0,   48,   49, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  598,   50,   51,    0,    0,    0,    0,    0, 
            0,   52,    0,    0,  272,   54,   55,   56,    0,   57, 
            0,    0,   58,   59,   60,   61,   62,   63,   64,    0, 
           65,   66,    0,  270,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,   68, 
           26,    0,    0,    0,    0,    0,   27,   28,  271,   30, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   67, 
           40,   41,   42,   43,   44,   45,   46,    0,    0,   47, 
            0,   48,   49,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  598,   50,   51,    0,    0, 
            0,    0,    0,    0,   52,    0,    0,   53,   54,   55, 
           56,    0,   57,    0,    0,   58,   59,   60,   61,   62, 
           63,   64,    0,   65,   66,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   68,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    7,    8,    0,   67,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
           44,   45,   46,    0,    0,   47,    0,   48,   49,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   50,   51,    0,    0,    0,    0,    0,    0, 
           52,    0,    0,   53,   54,   55,   56,    0,   57,   68, 
            0,   58,   59,   60,   61,   62,   63,   64,    0,   65, 
           66,    0,    0,    4,    5,    6,    7,    8,    0,   67, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,  271,   30,   31, 
           32,   33,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,   44,   45,   46,    0,    0,   47,    0, 
           48,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   50,   51,    0,    0,    0, 
            0,    0,    0,   52,    0,    0,   53,   54,   55,   56, 
            0,   57,   68,    0,   58,   59,   60,   61,   62,   63, 
           64,    0,   65,   66,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    7,    8,    0,  226,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
           44,   45,   46,    0,    0,   47,    0,   48,   49,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   50,   51,    0,    0,    0,    0,    0,    0, 
           52,    0,    0,   53,   54,   55,   56,    0,   57,   68, 
            0,   58,   59,   60,   61,   62,   63,   64,    0,   65, 
           66,    0,    0,    4,    5,    6,    7,    8,    0,  226, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,   44,   45,   46,    0,    0,   47,    0, 
           48,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   50,   51,    0,    0,    0, 
            0,    0,    0,   52,    0,    0,   53,   54,   55,   56, 
            0,   57,   68,    0,   58,   59,   60,   61,   62,   63, 
           64,    0,   65,   66,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,  226,    0,    0,    0,   19,   20,   21, 
          206,  207,  208,  209,    0,    0,  210,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  211,  212,  213,  214, 
           35,  215,  216,  217,  218,  219,   40,   41,   42,   43, 
           44,   45,   46,    0,    0,   47,    0,   48,   49,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   50,  493,    0,    0,    0,    0,    0,    0, 
          220,    0,    0,  221,   54,   55,   56,    0,  222,  223, 
          224,   58,   59,  225,   61,   62,   63,   64,    0,   65, 
           66,    0,    0,    4,    5,    6,   68,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  258,  259,   17,   18,  315,    0,    0,    0,    0, 
           19,  260,  261,  206,  207,  208,  209,    0,    0,  210, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  211, 
          212,  213,  214,   35,  215,  216,  217,  218,  219,   40, 
           41,   42,   43,   44,   45,   46,    0,    0,   47,    0, 
           48,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   50,   51,    0,    0,    0, 
            0,    0,    0,  220,    0,    0,  221,   54,   55,   56, 
            0,  707,  223,  224,   58,   59,  225,   61,   62,   63, 
           64,    0,   65,   66,    0,    0,    0,    0,  315,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  226,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  258,  259,   17,   18,    0, 
            0,    0,    0,    0,   19,  260,  261,  206,  207,  208, 
          209,    0,    0,  210,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  211,  212,  213,  214,   35,  215,  216, 
          217,  218,  219,   40,   41,   42,   43,   44,   45,   46, 
            0,    0,   47,    0,   48,   49,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   50, 
          493,    0,    0,    0,    0,    0,    0,  220,    0,   68, 
          221,   54,   55,   56,    0,  707,  223,  224,   58,   59, 
          225,   61,   62,   63,   64,    0,   65,   66,  226,  315, 
          315,  315,    0,  315,    0,    0,    0,  315,  315,    0, 
            0,    0,  315,    0,  315,  315,  315,  315,  315,  315, 
          315,    0,    0,    0,    0,    0,  315,  315,  315,  315, 
          315,  315,  315,    0,    0,  315,    0,    0,    0,    0, 
            0,    0,  315,    0,    0,  315,  315,  315,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,    0,    0,  315,    0,  315,  315,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  315,  315,    0,    0,    0,    0,    0,    0,  315, 
            0,   68,  315,  315,  315,  315,    0,  315,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,    0,  315,  315, 
            4,    5,    6,    0,    8,    0,    0,  226,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  258,  259, 
           17,   18,    0,    0,    0,    0,    0,   19,  260,  261, 
          206,  207,  208,  209,    0,    0,  210,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  211,  212,  213,  214, 
           35,  215,  216,  217,  218,  219,   40,   41,   42,   43, 
           44,   45,   46,    0,    0,   47,    0,   48,   49,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   50,   51,    0,    0,    0,    0,    0,    0, 
          220,    0,    0,  221,   54,   55,   56,    0,  222,  223, 
           68,   58,   59,  225,   61,   62,   63,   64,    0,   65, 
           66,    0,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          258,  259,   17,   18,  226,    0,    0,    0,    0,   19, 
          260,  261,  206,  207,  208,  209,    0,    0,  210,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  211,  212, 
          213,  214,   35,  215,  216,  217,  218,  219,   40,   41, 
           42,   43,   44,   45,   46,    0,    0,   47,    0,   48, 
           49,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   50,   51,    0,    0,    0,    0, 
            0,    0,  220,    0,    0,  221,   54,   55,   56,    0, 
            0,  223,  224,   58,   59,  225,   61,   62,   63,   64, 
            0,   65,   66,    0,    0,    0,    0,   68,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  258, 
          259,   17,   18,  226,    0,    0,    0,    0,   19,  260, 
          261,  206,  207,  208,  209,    0,    0,  210,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  211,  212,  213, 
          214,   35,  215,  216,  217,  218,  219,   40,   41,   42, 
           43,   44,   45,   46,    0,    0,   47,    0,   48,   49, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   50,   51,    0,    0,    0,    0,    0, 
            0,  220,    0,    0,  221,   54,   55,   56,    0,  707, 
          223,    0,   58,   59,  225,   61,   62,   63,   64,    0, 
           65,   66,    0,    0,    0,    0,   68,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,    0,  226,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  258,  259,   17,   18, 
            0,    0,    0,    0,    0,   19,  260,  261,  206,  207, 
          208,  209,    0,    0,  210,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,  211,  212,  213,  214,   35,  215, 
          216,  217,  218,  219,   40,   41,   42,   43,   44,   45, 
           46,    0,    0,   47,    0,   48,   49,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           50,   51,    0,    0,    0,    0,    0,    0,  220,    0, 
            0,  221,   54,   55,   56,    0,    0,  223,   68,   58, 
           59,  225,   61,   62,   63,   64,    0,   65,   66,    0, 
            0,    0,    0,    0,    0,    0,  226,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,    0,   19,   20,   21,  206,  207,  208, 
          209,    0,    0,  210,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  211,  212,  213,  214,   35,  215,  216, 
          217,  218,    0,   40,   41,   42,   43,   44,   45,   46, 
            0,    0,   47,    0,   48,   49,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   50, 
           51,    0,    0,    0,    0,    0,    0,  220,    0,   68, 
          221,   54,   55,   56,    0,  826,    0,    0,   58,   59, 
           60,   61,   62,   63,   64,    0,   65,   66,  226,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  258,  259,   17, 
           18,    0,    0,    0,    0,    0,   19,  260,  261,  206, 
          207,  208,  209,    0,    0,  210,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  211,  212,  213,  214,   35, 
          215,  216,  217,  218,    0,   40,   41,   42,   43,   44, 
           45,   46,    0,    0,   47,    0,   48,   49,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   50,   51,    0,    0,    0,    0,    0,    0,  220, 
            0,   68,  221,   54,   55,   56,    0,  826,    0,    0, 
           58,   59,   60,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,  226,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  258,  259, 
           17,   18,    0,    0,    0,    0,    0,   19,  260,  261, 
          206,  207,  208,  209,    0,    0,  210,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  211,  212,  213,  214, 
           35,  215,  216,  217,  218,    0,   40,   41,   42,   43, 
           44,   45,   46,    0,    0,   47,    0,   48,   49,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   50,   51,    0,    0,    0,    0,    0,    0, 
          220,    0,    0,  221,   54,   55,   56,    0,  980,   68, 
            0,   58,   59,   60,   61,   62,   63,   64,    0,   65, 
           66,    0,    4,    5,    6,    0,    8,    0,    0,  806, 
            9,   10,    0,    0,    0,   11,  806,   12,   13,   14, 
          258,  259,   17,   18,    0,    0,    0,    0,    0,   19, 
          260,  261,  206,  207,  208,  209,    0,    0,  210,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  211,  212, 
          213,  214,   35,  215,  216,  217,  218,    0,   40,   41, 
           42,   43,   44,   45,   46,    0,    0,   47,    0,   48, 
           49,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   50,   51,    0,    0,    0,    0, 
            0,    0,  220,    0,    0,  221,   54,   55,   56,    0, 
         1092,    0,  806,   58,   59,   60,   61,   62,   63,   64, 
            0,   65,   66,    0,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,  818,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  258,  259, 
           17,   18,    0,    0,    0,    0,    0,   19,  260,  261, 
          206,  207,  208,  209,    0,    0,  210,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  211,  212,  213,  214, 
           35,  215,  216,  217,  218,    0,   40,   41,   42,   43, 
           44,   45,   46,    0,    0,   47,    0,   48,   49,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   50,   51,    0,    0,    0,    0,    0,    0, 
          220,    0,    0,  221,   54,   55,   56,    0, 1200,  818, 
            0,   58,   59,   60,   61,   62,   63,   64,    0,   65, 
           66,    0,    0,  806,  806,  806,    0,  806,  226,    0, 
            0,  806,  806,    0,    0,    0,  806,    0,  806,  806, 
          806,  806,  806,  806,  806,    0,    0,    0,    0,    0, 
          806,  806,  806,  806,  806,  806,  806,    0,    0,  806, 
            0,    0,    0,    0,    0,    0,  806,    0,    0,  806, 
          806,  806,  806,  806,  806,  806,  806,  806,    0,  806, 
          806,  806,  806,  806,  806,  806,    0,    0,  806,    0, 
          806,  806,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  806,  806,    0,    0,    0, 
            0,    0,    0,  806,    0,    0,  806,  806,  806,  806, 
            0,   68,    0,    0,  806,  806,  806,  806,  806,  806, 
          806,    0,  806,  806,    0,    0,    0,    0,    0,  226, 
          818,  818,  818,    0,  818,    0,    0,    0,  818,  818, 
            0,    0,    0,  818,    0,  818,  818,  818,  818,  818, 
          818,  818,    0,    0,    0,    0,    0,  818,  818,  818, 
          818,  818,  818,  818,    0,    0,  818,    0,    0,    0, 
            0,    0,    0,  818,    0,    0,  818,  818,  818,  818, 
          818,  818,  818,  818,  818,    0,  818,  818,  818,  818, 
          818,  818,  818,    0,    0,  818,    0,  818,  818,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  818,  818,    0,    0,    0,    0,    0,    0, 
          818,    0,   68,  818,  818,  818,  818,    0,  818,    0, 
            0,  818,  818,  818,  818,  818,  818,  818,    0,  818, 
          818,   67,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          258,  259,   17,   18,    0,    0,    0,    0,    0,   19, 
          260,  261,  206,  207,  208,  209,    0,    0,  210,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  211,  212, 
          213,  214,   35,  215,  216,  217,  218,    0,   40,   41, 
           42,   43,   44,   45,   46,    0,    0,   47,    0,   48, 
           49,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   50,   51,    0,    0,    0,    0, 
            0,    0,  220,    0,   68,  221,   54,   55,   56,    0, 
            0,    0,    0,   58,   59,   60,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,  806,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,    0, 
           19,   20,   21,  206,  207,  208,  209,    0,    0,  210, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  211, 
          212,  213,  214,   35,  215,  216,  217,  218,    0,   40, 
           41,   42,   43,   44,   45,   46,    0,    0,   47,    0, 
           48,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   50,   51,    0,    0,    0, 
            0,    0,    0,  220,    0,    0,  221,   54,   55,   56, 
            0,  806,    0,    0,   58,   59,   60,   61,   62,   63, 
           64,    0,   65,   66,    0,    4,    5,    6,    0,    8, 
          277,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,    0,   19,   20,   21,  206,  207,  208,  209,    0, 
            0,   26,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  211,  212,  213,  214,   35,  215,  216,  217,  218, 
            0,   40,   41,   42,   43,   44,   45,   46,    0,    0, 
           47,    0,   48,   49,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   50,   51,    0, 
            0,    0,    0,    0,    0,  220,    0,    0,  221,   54, 
           55,   56,    0,  277,    0,    0,   58,   59,   60,   61, 
           62,   63,   64,    0,   65,   66,    0,    0,    0,    0, 
            0,  818,  806,  806,  806,    0,  806,    0,    0,    0, 
          806,  806,    0,    0,    0,  806,    0,  806,  806,  806, 
          806,  806,  806,  806,    0,    0,    0,    0,    0,  806, 
          806,  806,  806,  806,  806,  806,    0,    0,  806,    0, 
            0,    0,    0,    0,    0,  806,    0,    0,  806,  806, 
          806,  806,  806,  806,  806,  806,  806,    0,  806,  806, 
          806,  806,  806,  806,  806,    0,    0,  806,    0,  806, 
          806,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  806,  806,    0,    0,    0,    0, 
            0,    0,  806,    0,  818,  806,  806,  806,  806,    0, 
            0,    0,    0,  806,  806,  806,  806,  806,  806,  806, 
            0,  806,  806,    0,  277,  277,  277,    0,  277,    0, 
            0,    0,  277,  277,    0,    0,    0,  277,    0,  277, 
          277,  277,  277,  277,  277,  277,    0,    0,    0,    0, 
            0,  277,  277,  277,  277,  277,  277,  277,    0,    0, 
          277,    0,    0,    0,    0,    0,    0,  277,    0,    0, 
          277,  277,  277,  277,  277,  277,  277,  277,  277,    0, 
          277,  277,  277,  277,  277,  277,  277,    0,    0,  277, 
            0,  277,  277,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  277,  277,    0,    0, 
            0,    0,    0,    0,  277,    0,    0,  277,  277,  277, 
          277, 1036,    0,    0,    0,  277,  277,  277,  277,  277, 
          277,  277,    0,  277,  277,  818,  818,  818,    0,  818, 
            0,    0,    0,  818,  818,    0,    0,    0,  818,    0, 
          818,  818,  818,  818,  818,  818,  818,    0,    0,    0, 
            0,    0,  818,  818,  818,  818,  818,  818,  818,    0, 
            0,  818,    0,    0,    0,    0,    0,    0,  818,    0, 
            0,  818,  818,  818,  818,  818,  818,  818,  818,  818, 
            0,  818,  818,  818,  818,  818,  818,  818,    0,    0, 
          818,    0,  818,  818,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  818,  818,    0, 
            0,    0,    0,    0,    0,  818,    0,    0,  818,  818, 
          818,  818,    0,    0,    0,    0,  818,  818,  818,  818, 
          818,  818,  818,  197,  818,  818,    0,  196,  191,    0, 
            0,    0,  194,  192,    0,  193,    0,  195,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          188,    0,  187,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  190,    0,  199,    0,    0,    0, 
            0,    0,    0,    0, 1018, 1019, 1020, 1021,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
         1022, 1023, 1024, 1025,  189,    0,  198, 1026,    0, 1027, 
           40,   41,   42,   43,   44,    0,  197,    0,    0,  303, 
          196,  191,    0,  563,    0,  194,  192,    0,  193,    0, 
          195,    0,    0,    0,    0,    0, 1028, 1029,    0,    0, 
            0,    0,    0,  188, 1030,  187,    0, 1031,    0, 1032, 
         1033,    0, 1034,  567,    0,   58,   59, 1035,   61,   62, 
           63,   64,    0,   65,   66,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  190,    0,  199, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  189,    0,  198, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  126,  127,  128, 
          129,  130,  131,  132,  133,  134,  135,  136,  137,  138, 
          139,  140,  141,  142,  143,  144,  145,  146,  147,  148, 
          149,    0,    0,    0,  150,  151,  152,  153,  154,  155, 
          156,  157,  158,  159,    0,    0,    0,    0,    0,  160, 
          161,  162,  163,  164,  165,  166,  167,  168,  251,    0, 
          169,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  170,  171,  172,  173,  174,  175, 
          176,  177,  178,    0,    0,  179,  180,    0,    0,    0, 
            0,  181,  182,  183,  184,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  185,  186,    0,    0,   59, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
          136,  137,  138,  139,  140,  141,  142,  143,  144,  145, 
          146,  147,  148,  149,    0,    0, 1036,  150,  151,  152, 
          153,  154,  155,  156,  157,  158,  159,    0,    0,    0, 
            0,    0,  160,  161,  162,  163,  164,  165,  166,  167, 
          168,    0,    0,  169,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  170,  171,  172, 
          173,  174,  175,  176,  177,  178,    0,    0,  179,  180, 
            0,    0,    0,    0,  181,  182,  183,  184,    0,    0, 
            0,    0,    0,    0,    0,    0,  197,    0,  185,  186, 
          196,  191,   59,  438,    0,  194,  192,    0,  193,    0, 
          195,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  188,    0,  187,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  190,    0,  199, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  189,    0,  198, 
            0,    0,    0,    0,    0,    0,  197,    0,    0,    0, 
          196,  191,    0,    0,    0,  194,  192,    0,  193,    0, 
          195,    0,    0,    0,    0,    0,    0,    0,    0, 1018, 
         1019, 1020, 1021,  188,    0,  187,    0,    0,    0,    0, 
            0,    0,    0,    0,    0, 1022, 1023, 1024, 1025,    0, 
            0,    0, 1026,    0,    0,   40,   41,   42,   43,   44, 
            0,    0,    0,    0,  303,    0,    0,  190,    0,  199, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0, 1028, 1029,    0,    0,    0,    0,    0,    0, 1030, 
            0,    0, 1031,    0, 1032, 1033,    0,  189,    0,  198, 
           58,   59,   60,   61,   62,   63,   64,    0,   65,   66, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
          136,  137,  138,  139,  140,  141,  142,  143,  144,  145, 
          146,  147,  148,  149,    0,    0,    0,  150,  151,  152, 
          429,  430,  431,  432,  157,  158,  159,    0,    0,    0, 
            0,    0,  160,  161,  162,  163,  433,  434,  435,  436, 
          168,  415,  416,  437,  418,    0,    0,  305,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  170,  171,  172, 
          173,  174,  175,  176,  177,  178,    0,    0,  179,  180, 
            0,    0,    0,    0,  181,  182,  183,  184,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  185,  186, 
          126,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
          136,  137,  138,  139,  140,  141,  142,  143,  144,  145, 
          146,  147,  148,  149,    0,    0,    0,  150,  151,  152, 
          153,  154,  155,  156,  157,  158,  159,    0,    0,    0, 
            0,    0,  160,  161,  162,  163,  164,  165,  166,  167, 
          168,  313,  314,  169,  315,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  170,  171,  172, 
          173,  174,  175,  176,  177,  178,    0,    0,  179,  180, 
            0,    0,    0,    0,  181,  182,  183,  184,    0,    0, 
            0,  197,    0,    0,    0,  196,  191,    0,  185,  186, 
          194,  192,    0,  193,    0,  195,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  188,    0, 
          187,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  190,    0,  199,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,  189,   11,  198,   12,   13,   14,  258,  259, 
           17,   18,    0,    0,  665,    0,    0,   19,  260,  261, 
          290,  291,  292,  293,    0,    0,  210,    0,    0,    0, 
            0,    0,    0,  294,    0,    0,  295,  296,  297,  298, 
           35,  299,  300,  301,  302,    0,   40,   41,   42,   43, 
           44,   45,   46,    0,    0,  303,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          304,    0,    0,  221,   54,   55,   56,    0,    0,    0, 
            0,   58,   59,   60,   61,   62,   63,   64,  197,   65, 
           66,    0,  196,  191,    0,  245,    0,  194,  192,    0, 
          193,    0,  195,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  188,    0,  187,    0,    0, 
            0,    0,    0,    0,    0,  126,  127,  128,  129,  130, 
          131,  132,  133,  134,  135,  136,  137,  138,  139,  140, 
          141,  142,  143,  144,  145,  146,  147,  148,  149,  190, 
            0,  199,  150,  151,  152,  153,  154,  155,  156,  157, 
          158,  159,    0,    0,    0,    0,    0,  160,  161,  162, 
          163,  164,  165,  166,  167,  168,    0,    0,  169,  189, 
            0,  198,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  170,  171,  172,  173,  174,  175,  176,  177, 
          178,    0,    0,  179,  180,    0,    0,    0,    0,  181, 
          182,  183,  184,    0,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,  185,  186,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  258,  259,   17,   18,    0, 
            0,    0,    0,    0,   19,  260,  261,  290,  291,  292, 
          293,    0,    0,  210,    0,    0,    0,    0,    0,    0, 
          294,    0,    0,  295,  296,  297,  298,   35,  299,  300, 
          301,  302,    0,   40,   41,   42,   43,   44,   45,   46, 
            0,    0,  303,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  304,    0,    0, 
          221,   54,   55,   56,    0,    0,    0,    0,   58,   59, 
           60,   61,   62,   63,   64,    0,   65,   66,    0,    0, 
            0,  197,    0,    0,    0,  196,  191,    0,  245,    0, 
          194,  192,    0,  193,    0,  195,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  188,    0, 
          187,  637,  638,    0,    0,  639,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  170, 
          171,  172,  173,  174,  175,  176,  177,  178,    0,    0, 
          179,  180,  190,    0,  199,    0,  181,  182,  183,  184, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  197, 
          185,  186,    0,  196,  191,    0,  245,    0,  194,  192, 
            0,  193,  189,  195,  198,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  188,    0,  187,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  197,    0, 
            0,    0,  196,  191,    0,  245,    0,  194,  192,    0, 
          193,    0,  195,    0,    0,    0,    0,    0,    0,    0, 
          190,    0,  199,    0,    0,  188,    0,  187,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  197,    0,    0, 
            0,  196,  191,    0,  245,    0,  194,  192,    0,  193, 
          189,  195,  198,    0,    0,    0,    0,    0,    0,  190, 
            0,  199,    0,    0,  188,    0,  187,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  197,    0,    0,    0, 
          196,  191,    0,  245,    0,  194,  192,    0,  193,  189, 
          195,  198,    0,    0,    0,    0,    0,    0,  190,    0, 
          199,    0,    0,  188,    0,  187,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  189,    0, 
          198,    0,    0,    0,    0,    0,  197,  190,    0,  199, 
          196,  191,    0,  245,    0,  194,  192,    0,  193,    0, 
          195,    0,    0,    0,  646,  647,    0,    0,  648,    0, 
            0,    0,    0,  188,    0,  187,    0,  189,    0,  198, 
            0,    0,  170,  171,  172,  173,  174,  175,  176,  177, 
          178,    0,    0,  179,  180,    0,    0,    0,    0,  181, 
          182,  183,  184,    0,    0,    0,    0,  190,    0,  199, 
            0,    0,    0,  185,  186,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  189,    0,  198, 
            0,    0,  702,  638,    0,    0,  703,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          170,  171,  172,  173,  174,  175,  176,  177,  178,    0, 
            0,  179,  180,    0,    0,    0,    0,  181,  182,  183, 
          184,  705,  647,    0,    0,  706,    0,    0,    0,    0, 
            0,  185,  186,    0,    0,    0,    0,    0,    0,  170, 
          171,  172,  173,  174,  175,  176,  177,  178,    0,    0, 
          179,  180,    0,    0,    0,    0,  181,  182,  183,  184, 
          737,  638,    0,    0,  738,    0,    0,    0,    0,    0, 
          185,  186,    0,    0,    0,    0,    0,    0,  170,  171, 
          172,  173,  174,  175,  176,  177,  178,    0,    0,  179, 
          180,    0,    0,    0,    0,  181,  182,  183,  184,  740, 
          647,    0,    0,  741,    0,    0,    0,    0,    0,  185, 
          186,    0,    0,    0,    0,    0,    0,  170,  171,  172, 
          173,  174,  175,  176,  177,  178,    0,    0,  179,  180, 
            0,    0,    0,    0,  181,  182,  183,  184,    0,    0, 
            0,    0,    0,    0,    0,  377,  372,    0,  185,  186, 
          375,  373,    0,  374,    0,  376,    0,    0,    0,  843, 
          638,    0,    0,  844,    0,    0,    0,    0,  369,    0, 
          368,  367,    0,    0,    0,    0,    0,  170,  171,  172, 
          173,  174,  175,  176,  177,  178,    0,    0,  179,  180, 
            0,    0,    0,    0,  181,  182,  183,  184,    0,    0, 
            0,    0,  371,    0,    0,    0,  197,    0,  185,  186, 
          196,  191,    0,  245,    0,  194,  192,    0,  193,    0, 
          195,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  370,  188,    0,  187,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  197,    0,    0,    0,  196, 
          191,    0,  245,    0,  194,  192,    0,  193,    0,  195, 
            0,    0,    0,    0,    0,    0,    0,  190,    0,  199, 
            0,    0,  188,    0,  187,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  197,    0,    0,    0,  196,  191, 
            0,  245,    0,  194,  192,    0,  193,  189,  195,  198, 
            0,    0,    0,    0,    0,    0,  190,    0,  199,    0, 
            0,  188,    0,  187,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  197,    0,    0,    0,  196,  191,    0, 
          245,    0,  194,  192,    0,  193,  189,  195,  198,    0, 
            0,    0,    0,    0,    0,  190,    0,  199,    0,    0, 
          188,    0,  187,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  197,    0,    0,    0,  196,  191,    0,  245, 
            0,  194,  192,    0,  193,  189,  195,  198,    0,    0, 
            0,    0,    0,    0,  190,    0,  199,    0,    0,  188, 
            0,  187,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  197,    0,    0,    0,  196,  191,    0,  245,    0, 
          194,  192,    0,  193,  189,  195,  198,    0,    0,    0, 
            0,    0,    0,  190,    0,  199,    0,    0,  188,    0, 
          187,    0,    0,    0,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,    0,    0,    0, 
            0,  364,  365,  189,    0,  198,    0,    0,    0,    0, 
            0,    0,  190,    0,  199,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  658, 
          647,    0,    0,  659,    0,    0,    0,    0,    0,    0, 
            0,    0,  189,    0,  198,    0,    0,  170,  171,  172, 
          173,  174,  175,  176,  177,  178,    0,    0,  179,  180, 
            0,    0,    0,    0,  181,  182,  183,  184,  858,  638, 
            0,    0,  859,    0,    0,    0,    0,    0,  185,  186, 
            0,    0,    0,    0,    0,    0,  170,  171,  172,  173, 
          174,  175,  176,  177,  178,    0,    0,  179,  180,    0, 
            0,    0,    0,  181,  182,  183,  184,  861,  647,    0, 
            0,  862,    0,    0,    0,    0,    0,  185,  186,    0, 
            0,    0,    0,    0,    0,  170,  171,  172,  173,  174, 
          175,  176,  177,  178,    0,    0,  179,  180,    0,    0, 
            0,    0,  181,  182,  183,  184, 1086,  638,    0,    0, 
         1087,    0,    0,    0,    0,    0,  185,  186,    0,    0, 
            0,    0,    0,    0,  170,  171,  172,  173,  174,  175, 
          176,  177,  178,    0,    0,  179,  180,    0,    0,    0, 
            0,  181,  182,  183,  184, 1089,  647,    0,    0, 1090, 
            0,    0,    0,    0,    0,  185,  186,    0,    0,    0, 
            0,    0,    0,  170,  171,  172,  173,  174,  175,  176, 
          177,  178,    0, 1036,  179,  180,    0,    0,    0,    0, 
          181,  182,  183,  184, 1284,  638,    0,    0, 1285,    0, 
            0,    0,    0,    0,  185,  186,    0,    0,    0,    0, 
            0,    0,  170,  171,  172,  173,  174,  175,  176,  177, 
          178,    0,    0,  179,  180,    0,    0,    0,    0,  181, 
          182,  183,  184,    0,    0,    0,    0,    0,    0,    0, 
            0,  197,    0,  185,  186,  196,  191,    0,  245,    0, 
          194,  192,    0,  193,    0,  195,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  188,    0, 
          187,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          197,    0,    0,    0,  196,  191,    0,  245,    0,  194, 
          192,    0,  193,    0,  195,    0,    0,    0,    0,    0, 
            0,    0,  190,    0,  199,    0,    0,  188,    0,  187, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  197, 
            0,    0,    0,  196,  191,    0,    0,    0,  194,  192, 
            0,  193,  189,  195,  198,    0,    0,    0,    0,    0, 
            0,  190,    0,  199,    0,    0,  188,    0,  187,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  377,  372, 
            0,    0,    0,  375,  373,    0,  374,    0,  376,    0, 
            0,  189,    0,  198,    0,    0, 1018, 1019, 1020, 1021, 
          190,  369,  199,  368,  367,    0,    0,    0,    0,    0, 
            0,    0, 1022, 1023, 1024, 1025,    0,    0,    0, 1026, 
            0,    0,   40,   41,   42,   43,   44,    0,    0,    0, 
          189,  303,  198,    0,    0,  371,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0, 1028, 1029, 
            0,    0,    0,    0,    0,    0, 1030,    0,    0, 1031, 
            0, 1032, 1033,    0, 1223,  370,    0,   58,   59,   60, 
           61,   62,   63,   64,    0,   65,   66,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0, 1036,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0, 1287,  647,    0,    0, 1288,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  170,  171,  172,  173,  174,  175,  176,  177, 
          178,    0,    0,  179,  180,    0,    0,    0,    0,  181, 
          182,  183,  184, 1341,  638,    0,    0, 1342,    0,    0, 
            0,    0,    0,  185,  186,    0,    0,    0,    0,    0, 
            0,  170,  171,  172,  173,  174,  175,  176,  177,  178, 
            0,    0,  179,  180,    0,    0,    0,    0,  181,  182, 
          183,  184,  658,  647,    0,    0,  659,    0,    0,    0, 
            0,    0,  185,  186,    0,    0,    0,    0,    0,    0, 
          170,  171,  172,  173,  174,  175,  176,  177,  178,  949, 
            0,  179,  180,    0,    0,    0,    0,  181,  182,  183, 
          184,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  185,  186,    0,    0,    0,    0,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
         1018, 1019, 1020, 1021,  364,  365,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0, 1022, 1023, 1024, 1025, 
            0,    0,    0, 1026,    0,    0,   40,   41,   42,   43, 
           44,    0,    0,    0,    0,  303,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0, 1028, 1029,    0,    0,    0,    0,    0,    0, 
         1030,    0,    0, 1031,    0, 1032, 1033,    0, 1034,    0, 
            0,   58,   59,   60,   61,   62,   63,   64,    0,   65, 
           66,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  258, 
          259,   17,   18,    0,    0,    0,    0,    0,   19,  260, 
          261,  290,  291,  292,  293,    0,    0,  210,    0,    0, 
            0,    0,    0,    0,  294,    0,    0,  295,  296,  297, 
          298,   35,  299,  300,  301,  302,    0,   40,   41,   42, 
           43,   44,   45,   46,    0,    0,  303,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  304,    0,    0,  402,   54,   55,   56,    0,  403, 
            0,    0,   58,   59,   60,   61,   62,   63,   64,    0, 
           65,   66,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          258,  259,   17,   18,    0,    0,    0,    0,    0,   19, 
          260,  261,  407,  408,  409,  410,    0,    0,  210,    0, 
            0,    0,    0,    0,    0,  294,    0,    0,  411,  412, 
          413,  414,   35,  415,  416,  417,  418,    0,   40,   41, 
           42,   43,   44,   45,   46,    0,    0,  303,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  419,    0, 
            0,    0,  420,    0,    0,  221,   54,   55,   56,    0, 
            0,    0,    0,   58,   59,   60,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  258,  259,   17,   18,    0,    0,    0,    0,    0, 
           19,  260,  261,  446,  447,  448,  449,    0,    0,  210, 
            0,    0,    0,    0,    0,    0,  294,    0,    0,  450, 
          451,  452,  453,   35,  454,  455,  456,  457,    0,   40, 
           41,   42,   43,   44,   45,   46,    0,    0,  303,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  458,    0,    0,   53,   54,   55,   56, 
            0,   57,    0,    0,   58,   59,   60,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  258,  259,   17,   18,    0,    0,    0,    0, 
            0,   19,  260,  261,  407,  408,  409,  410,    0,    0, 
          210,    0,    0,    0,    0,    0,    0,  294,    0,    0, 
          411,  412,  413,  414,   35,  415,  416,  417,  418,    0, 
           40,   41,   42,   43,   44,   45,   46,    0,    0,  303, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  420,    0,    0,  221,   54,   55, 
           56,    0,    0,    0,    0,   58,   59,   60,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  258,  259,   17,   18,    0,    0,    0, 
            0,    0,   19,  260,  261,  290,  291,  292,  293,    0, 
            0,  210,    0,    0,    0,    0,    0,    0,  294,    0, 
            0,  295,  296,  297,  298,   35,  299,  300,  301,  302, 
            0,   40,   41,   42,   43,   44,   45,   46,    0,    0, 
          303,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  304,    0,    0,  402,   54, 
           55,   56,    0,    0,    0,    0,   58,   59,   60,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  258,  259,   17,   18,    0,    0, 
            0,    0,    0,   19,  260,  261, 1122, 1123, 1124, 1125, 
            0,    0,  210,    0,    0,    0,    0,    0,    0,  294, 
            0,    0, 1126, 1127, 1128, 1129,   35, 1130, 1131, 1132, 
         1133,    0,   40,   41,   42,   43,   44,   45,   46,    0, 
            0,  303,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0, 1134,    0,    0,  221, 
           54,   55,   56,    0,    0,    0,    0,   58,   59,   60, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  258,  259,   17,   18,    0, 
            0,    0,    0,    0,   19,  260,  261,  407,  408,  409, 
          410,    0,    0,  210,    0,    0,    0,    0,    0,    0, 
          294,    0,    0,  411,  412,  413, 1262,   35,  415,  416, 
         1263,  418,    0,   40,   41,   42,   43,   44,   45,   46, 
            0,    0,  303,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0, 1264,    0,    0, 
          221,   54,   55,   56,    0,    0,    0,    0,   58,   59, 
           60,   61,   62,   63,   64,    0,   65,   66, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            2,  123,  124,   59,  420,  336,   60,   15,   16,  388, 
           67,  109,   53,  485,   21,   21,  237,    7,   27,   96, 
           95,    2,    3,  467,   87,  102,  587,    7,  387,   57, 
          763,  390,  765,  245,   15,   16,  575,   27,  121,  398, 
          579,  335,  870,   57,  763,    2,    3,   27,  320,  321, 
          767,  767,  330,   55,   56,   10,  528,  335,    3,   10, 
          123,   44,   38,  119,  765,   15,   16,   44,   87,   59, 
         1204,  284,   53,   54,  330,  288,   57,   46,   10,  335, 
          481,  109,   84,   85,  485,  936,   67,  115,  116,   47, 
           97,   97,   85,  123,  122,  426,  866,   54,   15,   16, 
          479,   10,   10,  272,   59,   55,  114,   53,   10,   40, 
          565,  123,   46,  288,   10, 1163,  903,  541,   10,  478, 
          663,  480,  657,    0,   40,   10,  661,  662,  109,  119, 
         1251,  306,  905,  114,  115,  116,   44,  118,   55,   56, 
          283,  122,  123,  124,  320,   41,    0,   59,   44,   41, 
           59,   59,   44,   44,  513,  232,   41,   59,   32,   44, 
          539,   46,   10,   59,  114,   61,   41,   59,  248,   37, 
           61,  225,  291,  292,   42,   91,   61,   37,   38,   47, 
          221,  540,   42,   43,   59,   45,  263,   47, 1322,  365, 
           32, 1070,  123,   41, 1028, 1029,   10,  114,  118,  279, 
           10,  281,  312,  123,  124,   40,   91,  305,   40,   85, 
           10,  274,  124,   61, 1335,  256,  326,  283,  935,  936, 
           10,  343,  344,  345,  346,  227,  228,   41,  371,   10, 
           44,  272,  309,  402,  242,  228,  244,  245,  123,   10, 
          221,  665,  785,  245,  274,   59,  356,  719,  125,   59, 
          360, 1102,  254,   10,  261,  274, 1304,  264,  674,   59, 
           41,  242,   10,  244,  245,   10,  999,  248,  280,  250, 
          320,  125,   10,  254,   10,  256,  497,  305,   59,   10, 
          767,  553,  657,  555, 1003,   10,  661,  774,   59,  270, 
           10,  272,  242,   41,  244,  245,  675,  254,  999,   46, 
          755,  756, 1181,   41,   10,  371,  123,   10,   38,   40, 
          124,   59,  691,  270,  307,  365,  717,  676,  719,   44, 
          123,   59,  444,  306,  305,  242,  272,  244,  248, 1116, 
          250, 1165, 1166,  692,   59,   41,   93, 1070,   44,   59, 
          291,  292, 1115,  124,   91,  303,  677,   46,   93,  280, 
          331,  227,  228,   59,  915,  336,   59,   93,  267,  267, 
          341,  402,  343,  344,  345,  346,  347,  348,  349,  908, 
          909,  910,  349,  912, 1202,  403,  345,  346,  917,  281, 
          388,  357,  459,  390,  341, 1102,  388,  283,  279,  403, 
          347,  283,   91,  395,  279,  280,  341,  399,  400,  401, 
          390,  464,  443,  804,  445,  940,  941,  388,  398,  489, 
          945,  946,  346,  368,   32,  839,  496,  349,  124,  499, 
          500,  402,  403,  343,  344,  345,  346,  271,  348,  349, 
          346,  279, 1202,   32,  464,  279, 1153,  517,  419,   10, 
          349,  349,  522,  541,  310,  426,  320,   41,  903,  743, 
          905,   10,   10, 1170, 1171, 1172,  402,  267,  326,  704, 
          345,  346,  443,  444,  445,  743,  326,  267,   41,  283, 
           10,  479,   10,  480,  360,  371,  748,  479,  320,  371, 
          752, 1032,  484,  343,  344,  487,  488,  743,   59,  710, 
          480,   46,  572,  264,  739,  369,  370,  506,  479,  419, 
           59,   59,  283,   32,    0,  717,  513,  763,   46,  765, 
           46,  842,  514,  541,   10, 1343,  506,  989, 1251,   59, 
         1253,   59,  735,  513,  444,   10,  506,  369,  370,   32, 
          124,  539,  595,  540, 1253,  283,   91,  539,  982,  520, 
         1257, 1257,  267,   93, 1079,  283,  269,  267,  271,   40, 
          540,  124,   46,   91,  125,   91, 1091,  371,  539,  269, 
          541,  935,  936,   59,  481,  940,  941,  665, 1012,  279, 
          945,  946,  306,  952,   59,  125,  310,  283, 1117, 1118, 
         1119, 1120,  312, 1070,  664,   26,  594,   28,  989,  597, 
          371,  593,  951,  887,  953,   46,  326,   91,  345,  346, 
          657,  846, 1335,   10,  661,  662,  663,  524,  282,  887, 
          693,   10, 1331,  594, 1030,  860,  597,   61,  288, 1170, 
         1171, 1182,   10,  371,  687,   46,  356,  357, 1189,  125, 
          961,  887,   46,  371,  641,  641,  306,  665,  736,  680, 
           91,   10,   10,  650,  650,   44,  345,  346,  650,   10, 
          348,   10,   59,  660,  660,  696, 1100,  263,  660,  880, 
         1115, 1116,   60,  269,   62,  371,   56,  675,  348,  676, 
           91,   59,   41,  675,   10,   44,  657,   91,   10,  759, 
          661,  662,  663,  691,  665,  692,  676,   37,  697,  691, 
           41,   59,   42,   43,  675,   45,  677,   47,   59,  680, 
           59,  682,  692,   10, 1079,   41,  264,  697,  736,   41, 
          691,  269,  662,  663,   10,  696,   10,  697,   10,  841, 
           10,  728,  729,  263,  264,   61, 1292,  729, 1102,  267, 
          271, 1297,   61,  268,  269,   38,  124,   44,  279,  816, 
         1071,  839,  723,  999, 1283,   41,   44,  822,  310,   41, 
           44, 1167, 1313,   37, 1198,  736,  124,   10,   42,   43, 
         1326,   45,  682,   47, 1251,  124, 1253,   15,   16,   59, 
         1257,  851,  306, 1260,  125,  320,  310,  840,   44,  264, 
         1111,  783,   10,  785,  269,   46,   10, 1032,   41,   40, 
          345,  346,   10,  349,  279,   44,  852,   93,  800,  801, 
          717,  881,  882,  723,  348,  807,  808,  345,  346,  345, 
          346,  839,   40,   44, 1070,  348,   44,   41,   46,   61, 
          365,  901,  863,   10,  369,  370,    2,    3,   46,  219, 
           91,   59,  222,  223,  224,  785,   10,   61, 1217,   15, 
           16,   59,   40, 1088, 1331,  326, 1333,  849, 1335,  971, 
         1337,  345,  346,  294,   41,   10,  326, 1163,  839, 1218, 
          841,  842,  852,   91, 1170, 1171,  114,   41,  870, 1356, 
          348,  873,  874,   91,  876,  877,   10,   53,   54,   41, 
          125,   93,  863,  940,  941,  926,   41,  804,  945,  946, 
          125,   67,  337,  338,  345,  346,  124,  310, 1153,  962, 
         1145, 1146,  657,  264,   59,  123,  661,   41,  269,   10, 
          271,  262,  263,  264,   41, 1170, 1171,  268,  269,   93, 
          271,  841,   44, 1168,  345,  346,  928,   61,  279,  970, 
           10,  345,  346,  331,  332,   61,  938,  939,  114,  354, 
           41,  943,  118,  279,  952,  926,  953,  123,  124,   61, 
          952,   10,  954,  323,   10,   10,  711,    0,  713,  940, 
          941,   41,  320,  953,  945,  946,   10,   10, 1009,  950, 
          125,  952,  262,  263,  264,  730,  326,   44,  959,  269, 
          961, 1035,   41, 1011,  986,   41,   41,  765,   10,  970, 
          971,  769,   93,  950,  242, 1251,  244, 1253,  125, 1244, 
         1245, 1246,  959,  306,   59,  308,  309,  310,  311,  312, 
          596,  369,  370,   10,  372,   59,   59,  368,   60,   41, 
           10,  310, 1079,  326,  279,   40,   10,  803, 1009,   44, 
         1011,   46,   10, 1074, 1091,  811,   59,  340, 1160,   10, 
           61, 1286,  326,   61,   41,  221,  632,  350,   38,  267, 
          636,  971,   42,  356,  357,  279,   41,   41, 1135,  343, 
          344,   44,  280,   41,   61, 1106,  242,  312,  244,  245, 
           44, 1112,  248, 1114,  250,   46,   91,  125,  254, 1335, 
          256,  326,   44,   61,  345,  346,  125,  477,   59, 1169, 
         1071,  481,  678, 1074,  270,  485,  272, 1138, 1079,   44, 
          686,   46,  688,  294,  295,   10,   44,  262,  263,  264, 
         1091,  356,   10,  268,  269,  360,  271,  345,  346, 1121, 
           91,   44,   10,   44,  279, 1106,   44,  345,  346,   44, 
         1111, 1112,  264, 1114,  524,  262,  263,  264,  528,   44, 
         1220,  268,  269,   41,  271,  279,   91,  306, 1270, 1271, 
          306,   10,  279,   41,   59,  331, 1197, 1138,   10, 1187, 
          336, 1241, 1242, 1243,   10,  341,  308,  343,  344,  345, 
          346,  347,  348,  349, 1228,  262,  318,  319,  123, 1160, 
          348,  622,   41,    2,    3,  940,  941,  348,   10,   41, 
          945,  946,  306,  307,  584,   41,   15,   16,    0,   44, 
         1202,  125,   61,   44,  645,  348, 1187,   59,   10, 1217, 
          348, 1218,  388,  368,   10, 1217, 1197, 1219,  267,  124, 
          264,  999,   44, 1001,  268,  269,  402, 1005, 1218,  984, 
          985,  271,  987,  988,   53,   54, 1217,   59, 1266,   41, 
         1160,  368,   44,  419,  279,   41,   10,   32,   67,  348, 
          426,   10,  263,  264,  399,  400,  401,   59,  269,  348, 
           32,  847,  320,  704,  279,   61, 1268,  443,  444,  445, 
          348,  348,  662,  663,   44,   10,   44,   41, 1319,  865, 
           44,   40,  868,   61,  298, 1266,  298,   46,  348, 1270, 
         1271,   58, 1070,   93,   10,  114,  267,   61,  739,  118, 
           59,  279,  124,  479,  123,  124,   41,  365,  698,  125, 
          298,  369,  370,   61,  372,   44,  306,  707,  308,  309, 
          310,  311,  312,  125, 1079,   41,   61,  717,  298,  719, 
          345,  346,   91,  269,  279,  280,  326,   10, 1319,  484, 
          348, 1343,  487,  488,  520,   61,   44,   44,   44,    0, 
         1270, 1271,   44, 1108,  320,  321,   44,  306,  349,   10, 
          350,  124,   10,  539,  123,  355,  356,  357,   41,  514, 
           44,  306,   46,   44,  345,  346,   44,  963,   10,  124, 
           44,  967,  772,  313,  314,  315,  316,   44,   61,  975, 
           41,   44,  978,   44,  320,  785,   44,  983,   41,   10, 
          345,  346,  221,  369,  370,  846,   38,   59,   59,  320, 
           42,   59,  263,   61,  804, 1147,   10,   91,  594,  860, 
          279,  597,  349,  242,  310,  244,  245,   59,   44,  248, 
          125,  250, 1210,   44,  306,  254,  826,  256,   44,  365, 
           44, 1173,   44,  369,  370,  124,   40,   44,   59,  125, 
           41,  270,   46,  272,  365,   44,  368,   46,  369,  370, 
          262,  263,  264,   44,   44,   59,  268,  269,   44,  271, 
          124,  310,   44, 1251,  125,   44,  124,  279,   44,  869, 
           10,  657, 1260,  279,   44,  661,  662,  663,  320,   44, 
            2,    3,  294,  295,  296,  297,  298,   91,   44,  675, 
           44,  677,   91,  320,  680,   93,  682,  125,  267, 1095, 
           40,   41,  331,  124,   44,  691,   46,  336,   41,  271, 
          696,  280,  341,   93,  343,  344,  345,  346,  347,  348, 
          349,   61,  320,  365,   40,  125,   93,  369,  370,  320, 
          372,   53,   54,   58,  279,   57,   93,  723,  365,   10, 
          271,  992,  369,  370,  264, 1333,   70, 1335,  125, 1337, 
         1292,   91,  555,  279,  116, 1297,  368,  852,  958,  388, 
          254, 1268, 1304,  516,  520, 1219,  660,  365, 1356, 1121, 
         1070,  369,  370,  402,  365,   46,  345,  346,  369,  370, 
          980, 1032, 1033,  119, 1326, 1253,  763,  109,   59,  989, 
          419,   10,  755,  115,  116,  279,  279,  426,  903,  939, 
          122,  262,  263,  264, 1346,  767, 1257,  268,  269, 1205, 
          271, 1322,  652,  385,  443,  444,  445,  823,  279, 1070, 
           91,  306,   41,  308,  309,  310,  311,  122, 1343, 1164, 
          291,  292, 1162,  294,  295,  296,  297, 1088,    2,    3, 
           59, 1172,   98, 1172,  783,  800,  801, 1229,  308,  309, 
          479,  311,  807,  808, 1188,  841,  842,   -1,  318,  319, 
           -1,  345,  346,  267,  306,  350,  308,  309,  310,  311, 
          312,  294,  295,  296,  297,  298,  306,  863,  308,  309, 
          279,  311,   -1,   -1,  326,   -1,   -1,   -1,  349,   53, 
           54,  520, 1092,   57, 1145, 1146,   -1,   -1,  340,  221, 
           10,   -1,   -1,   -1,   -1, 1105,  125,  368,  350,   -1, 
          539,   -1,   -1,  355,  356,  357,   -1, 1168,  873,  874, 
          350,  876,  877,  306,   -1,  308,  309,  310,  311,   -1, 
         1181,   -1,  254,   -1,  256,   -1,   46,   -1,   -1,  279, 
          926,  345,  346,   -1,   -1,  109,  345,  346,  270,   59, 
          272,  115,  116,   -1,  940,  941,   -1,   -1,  122,  945, 
          946,    0,   -1,   -1,  950,  594,  952,  350,  597,   -1, 
           -1,   10,  355,  959,   -1,  961,   -1,   -1, 1229,   -1, 
           -1,   91,   -1,  305,  970,  971,   -1,   -1,  943,   -1, 
           -1,   10,   -1, 1244, 1245, 1246,  267,   -1,   -1,  954, 
         1200,   -1,   41,   -1,   -1,  345,  346,   -1,  306,  331, 
          308,  309,  310,  311,  336,   -1,   -1,   -1,   -1,  341, 
           59,   -1,   -1, 1009,   -1,  347, 1277,   46,  657,   10, 
           -1,  986,  661,  662,  663, 1286,   -1,  935,  936,   -1, 
           59,   -1,   -1,  262,  263,  264,  675,   -1,  677,  268, 
          269,  680,  271,  682,   -1,   -1,   -1,  221,   -1,   40, 
          279,   -1,  691,   44,   -1,   46,   10,  696,   -1,   44, 
           -1,   46,   91,   -1,  345,  346,   -1,   -1,   59,   -1, 
          402,  403,   -1,   10,   -1, 1071,  125,   -1, 1074,   -1, 
          254,   -1,  256, 1079,  723,   -1,   40,   -1,   -1,   -1, 
           44,   -1,   46,   -1,  426, 1091,  270,   -1,  272,   -1, 
           91,   -1,   -1,   40,   -1,   59,   91,   44,   -1,   46, 
         1106,  443,   -1,  445,   -1, 1111, 1112,   -1, 1114,   -1, 
         1028, 1029,   59,   10, 1032,  306,   -1,  308,  309,  310, 
          311,  305,  123,  124,   -1,   -1,   -1,   91,   -1,  368, 
           40,   -1, 1138,   -1,   44,   -1,   46,  267,   -1,   -1, 
           -1,   38,   -1,   -1,   91,   42,   -1,  331, 1066,   10, 
           -1,   -1,  336,   -1, 1160,   -1,   -1,  341,   -1,  123, 
          124,   -1,   59,  347,   61,   -1,   -1,   -1,   -1,    2, 
            3,   -1,   -1,   -1,   -1,   -1,  123,  124,  520,   40, 
           41,   91,   -1,   44, 1102,   46,   -1,   -1,   -1,   -1, 
           -1, 1197,  841,  842,   -1,   -1,   -1,   -1,   -1,  541, 
           61,   -1,   -1,  262,  263,  264,   -1,   10,  267,  268, 
          269, 1217,  271,  123,  863,  345,  346,   -1,  402,  403, 
           53,   54,  281,   -1,   57, 1143,   -1,   -1,  267, 1147, 
           91,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,  426,   46,   -1, 1163, 1164, 1165, 1166,   -1, 
           10,   -1, 1170, 1171,   -1, 1173,   59,   -1,   -1,  443, 
           -1,  445,  123,   -1, 1270, 1271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  109,  926,   10,  280, 
           40,   -1,  115,  116,  279,   -1,   46,   -1,   91,  122, 
           10,  940,  941,   -1,   10,   -1,  945,  946,   -1,   59, 
           -1,  950,   -1,  952,    2,    3,  345,  346,   -1,  368, 
          959,   -1,  961, 1319,   46,  657,  280,   -1,   -1,  661, 
          662,  970,  971,  665,   -1,   -1,   46,   59,   -1,   -1, 
           46,   91,   -1,  280,   -1,  677,  520,   -1,  680,   59, 
           -1,   -1,   -1,   59,  345,  346,   -1,   -1,   -1,   -1, 
          345,  346,  935,  936,  696,   53,   54,  541,   -1,   91, 
         1009,   -1,   -1,  123,   -1,   -1,   -1,   -1,   -1,  279, 
          280,   91,   -1,   -1, 1292,   91,   -1,   -1,   -1, 1297, 
           -1,  345,  346,   -1,   -1,   -1, 1304,   -1,  221,   -1, 
           -1,   -1,   -1,   -1,  736,   10,   40,    0,  345,  346, 
           44,   -1,   46,  745,   44,   -1,   46,   10, 1326,  306, 
           -1,  308,  309,  310,  311,  312,   -1,   -1,  279,  280, 
           -1,  254, 1071,  256,  122, 1074,   -1,   -1, 1346,  326, 
         1079,   46,   -1,   -1,   -1,  345,  346,  270,   41,  272, 
           -1,   44, 1091,  340,   59, 1028, 1029,   91,   -1, 1032, 
           -1,   91,   -1,  350,   -1,   -1,   59, 1106,  355,  356, 
          357,   -1, 1111, 1112,  267, 1114,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,  657,   -1,   -1,   91,  661,  662,  123, 
           -1,  665,   10, 1066,  345,  346,   -1,   -1,   -1, 1138, 
           93,   -1,   44,  677,   46,   40,  680,  839,  331,   44, 
          842,   46,   -1,  336,   -1,   -1,   -1,  267,  341,   -1, 
           -1, 1160,  696,   -1,  347,   -1,    0,   -1,   46, 1102, 
          280,  863,  125,  221,   -1,   -1,   10,   -1,   40,   -1, 
           -1,   59,   44,   -1,   46,  267,   -1,   -1,   -1,   91, 
           -1,   -1,  345,  346,   -1,   -1,   91,  267, 1197,   -1, 
           -1,  267,  736,   -1,   -1,   -1,  254,   41,  256,   -1, 
         1143,   -1,   -1,   91, 1147,   -1,   -1,   -1, 1217,  402, 
          403,   -1,  270,   -1,  272,   59,   -1,   -1,  123,   91, 
         1163, 1164, 1165, 1166,  926,  345,  346, 1170, 1171,   -1, 
         1173,   -1,   -1,  426,   -1,   44,   -1,   46,  940,  941, 
           -1,   -1,   -1,  945,  946,   -1,   -1,   -1,  950,   -1, 
          443,  123,  445,  345,  346,   -1,   -1,  959,   -1,  961, 
           -1, 1270, 1271,  935,  936,  345,  346,   -1,  970,  345, 
          346,    2,    3,  331,   -1,  279,  280,   10,  336,  279, 
           -1,  125,   91,  341,   -1,   -1,   -1,   -1,   -1,  347, 
           -1,   44,  267,   46,   -1,  839,   -1,   -1,  842,  262, 
          263,  264,   -1,   -1,  267,  268,  269, 1009,  271, 1011, 
         1319,   -1,   -1,   46,   -1,   -1,  279,   -1,  281,  863, 
           -1,   -1,   53,   54,   -1,   -1,   59,  520,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   -1,   91,   -1, 
           -1,  345,  346,   -1,  402,  345,  346,   -1,  541, 1292, 
           -1,  935,  936,   -1, 1297,   -1, 1028, 1029,   91,   -1, 
         1032, 1304,   -1,   -1,   -1,   -1,   -1,  279,  426, 1071, 
          345,  346, 1074,   -1,  279,  280,   -1, 1079,   -1,  267, 
           -1,   -1,  926, 1326,   -1,  443,  349,  445,    0, 1091, 
           -1,   44,   -1,   46, 1066,   -1,  940,  941,   10,   -1, 
           -1,  945,  946, 1346, 1106,  368,  950,  279,  280, 1111, 
         1112,   -1, 1114,   -1,   -1,  959,   -1,  961,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  970,  271,   -1,   41, 
         1102,   -1,   44,  345,  346,  279, 1138,  281,   91,   -1, 
          345,  346,   -1,   -1, 1028, 1029,   -1,   59, 1032,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,  345,  346,   -1, 
           -1,   -1,  520,   -1,  657, 1009,   -1, 1011,  661,  662, 
          279, 1143,  665,  345,  346, 1147,   -1,   -1,   -1,   -1, 
           -1,   93, 1066,   -1,  677, 1187,   44,  680,   46,   -1, 
          221, 1163, 1164, 1165, 1166, 1197,   -1,   -1, 1170, 1171, 
           -1, 1173,   -1,  696,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   10,   -1,   -1,   -1, 1102,   -1, 
           -1,   10,   -1,  254,  368,  256,  279, 1071,   -1,   -1, 
         1074,   -1,   -1,   91,  267, 1079,  345,  346,   -1,  270, 
           10,  272,   -1,  736,   -1,   41,   -1, 1091,   44,   -1, 
           46,   40,   41,   -1,   -1,   44,   -1,   46,   -1, 1143, 
           10,   -1, 1106, 1147, 1266,   61,   -1, 1111, 1112,   -1, 
         1114,   41,   61,   -1,   44,   -1,   46,   -1,   -1, 1163, 
         1164, 1165, 1166,   -1,   -1,   -1, 1170, 1171,   -1, 1173, 
           40,   61,  345,  346, 1138,   91,   46,   10,   -1,  657, 
          331,   -1,   91,  661,  662,  336,   -1,  935,  936,   59, 
          341,   -1,  345,  346,   -1,   -1,  347, 1319,   -1,  677, 
         1292,   91,  680,   -1,   -1, 1297,  279,   40,   41,   -1, 
           -1,   44, 1304,   46,  123,   -1,   -1,   -1,  696,   -1, 
           -1,   91,   44, 1187,   46,   -1,  839,   -1,   61,  842, 
          262,  263,  264, 1197, 1326,  267,  268,  269,   -1,  271, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281, 
          863,  402,   -1,  123, 1346,   -1,   -1,   -1,   91,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   44,   91, 
           46,   41,  345,  346,   44,  426,   46,   -1,   -1,   -1, 
         1028, 1029,   -1,   -1, 1032,   -1,   -1,   -1, 1292,   -1, 
          123,   61,  443, 1297,  445,   10,   -1,   -1,   -1,   40, 
         1304,  279, 1266,   44,   -1,   46,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  926,   -1,   91,   -1,  349, 1066,   -1, 
           -1,   91, 1326,   -1,   -1,   40,   -1,  940,  941,   -1, 
           10,   46,  945,  946,   -1,   -1,  368,  950,   -1,   -1, 
           -1,   -1, 1346,   -1,   59,   -1,  959,   44,  961,   46, 
           91,   -1,   -1,   -1, 1102, 1319,   -1,  970,   -1,   -1, 
           40,   -1,   -1,  279,  842,   -1,   46,  345,  346,  520, 
          279,  280,   -1,   10,   -1,   -1,   91,   -1,   -1,   59, 
           -1,   -1,  123,   -1,   -1,  863,   -1,   -1,   -1,  279, 
           -1,  935,  936,    0,   91, 1143, 1009,  267, 1011, 1147, 
           -1,   -1,   -1,   10,   41,   -1,   -1,   44,  123,   46, 
          280,   91,   -1,   -1,   -1, 1163, 1164, 1165, 1166,   -1, 
           -1,   -1, 1170, 1171,   61, 1173,   -1,   -1,   -1,  345, 
          346,   -1,   -1,   -1,   41,   -1,  345,  346,   -1,   -1, 
           -1,   -1,   -1,  123,   -1,   -1,  279,  280,  926,   -1, 
           -1,   -1,   59,   -1,   91,  345,  346,  279, 1071,   -1, 
           -1, 1074,  940,  941,   -1,   -1, 1079,  945,  946,   -1, 
           -1,   -1,  950,   -1,   -1,  345,  346,   -1, 1091,   -1, 
           -1,  959,   -1,  961, 1028, 1029,   -1,   -1, 1032,   -1, 
           -1,   -1,  970, 1106,   -1,   -1,   -1,   -1, 1111, 1112, 
           -1, 1114,   -1,  279,   -1,   -1,  657,   15,   16,  279, 
          661,  662,  345,  346,  935,  936,   -1,   -1,  125,   -1, 
           -1,   -1, 1066,  345,  346, 1138,  677,   -1,   -1,  680, 
           -1, 1009,   -1, 1011,   -1,   -1,   -1,   10,  279,  280, 
           48,   49,   50,   51, 1292,  696,   -1,   55,   56, 1297, 
           -1,   -1,  267,   -1,   -1,   -1, 1304,   -1, 1102,   67, 
           68,   -1,   -1,   -1,   -1,  280,   -1,   40,   41,  345, 
          346,   44,   -1,   46, 1187,  345,  346,   -1, 1326,   -1, 
           -1,   -1,  279,   -1, 1197,   -1,   -1,  267,   61,   -1, 
           -1,   -1,   -1, 1071,   -1,   -1, 1074,   -1, 1346, 1143, 
          280, 1079,   -1, 1147,  345,  346,  114, 1028, 1029,   -1, 
           -1, 1032,   -1, 1091,   -1,   -1,   -1,   -1,   91, 1163, 
         1164, 1165, 1166,   -1,   38,   -1, 1170, 1171, 1106, 1173, 
          345,  346,   -1, 1111, 1112,   -1, 1114,   -1,   -1,   -1, 
           -1,   -1,  279,   -1,   -1, 1066,   10,   -1,  345,  346, 
          123,   -1,   -1, 1266,   -1,  262,  263,  264,   -1,   -1, 
         1138,  268,  269,   -1,  271,  345,  346,   -1,   -1,   -1, 
           -1,   -1,  279,  935,  936,   -1,   40,   41,   -1,   -1, 
           44, 1102,   46,   -1,   -1,   -1,   -1,  294,  295,  296, 
          297,  842,   -1,   -1,   -1,   -1,   -1,   61,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1, 1319,   -1,  345,  346, 
           -1,  219,  863,   -1,  222,  223,  224,   -1,  226, 1197, 
           -1,   -1, 1143,   -1,   -1,   -1, 1147,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,  242,   -1,  244,  245,   -1,   -1, 
           -1,   -1, 1163, 1164, 1165, 1166,   -1,   -1, 1292, 1170, 
         1171,   -1, 1173, 1297, 1070,   -1,   -1,   -1,   -1,  123, 
         1304,  368,   -1,   -1,   -1,   -1, 1028, 1029,   -1,   -1, 
         1032,   -1,   -1,   -1,   -1,  926,   -1,   -1,   -1,   -1, 
           10,   -1, 1326,   -1,   -1,   -1,   -1,   -1,   -1,  940, 
          941,   -1,   -1,   -1,  945,  946,   -1,   -1,   -1,  950, 
           -1,   -1, 1346,   -1, 1066,   -1,  279,  280,  959,   -1, 
          961,   41,   -1,   -1,   44,   -1,   46,   -1,   -1,  970, 
           -1,   -1,   -1,   -1,   -1,  935,  936,   -1,   -1,   -1, 
           -1,   61,   -1,   -1,   -1,   -1,   -1,  935,  936,   -1, 
         1102, 1319,   -1,  351,  352,  353,  354,  355,   -1,   -1, 
          358,  359,  360,  361,  362,  363,  364,  365, 1009,  367, 
           -1,   91,  370,  371,  372,  373,  374,  375,  376,  377, 
          378, 1292,  345,  346,   -1,   -1, 1297,   -1,   -1,   -1, 
          388, 1143,   -1, 1304,   -1, 1147,  394,   -1,   -1,   -1, 
           -1,   -1,  306,   -1,  308,  309,  310,  311,  312,   -1, 
           -1, 1163, 1164, 1165, 1166, 1326,   -1,   -1, 1170, 1171, 
           -1, 1173,  326,   -1,   -1,  279,  280,   -1, 1028, 1029, 
         1071,   -1, 1032, 1074,   -1, 1346,   -1,   -1, 1079,   -1, 
           -1,   -1,   -1,   -1, 1032, 1251,  350, 1253,   -1,   -1, 
         1091, 1257,  356,  357, 1260,   -1,   -1, 1070,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1, 1106, 1066,   -1,   -1,   -1, 
         1111, 1112,   -1, 1114,   -1,   -1,    0,   -1, 1066,  477, 
           -1,  479,   -1,  481,   -1,   -1,   10,  485,   -1,   -1, 
           -1,  345,  346,   -1,   -1,  493,   -1, 1138,    0,   -1, 
         1180,   -1, 1102,   -1,   -1, 1185,   -1,   -1,   10,   -1, 
          508,   -1,   -1,  511, 1102,   -1,   -1,   41,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1, 1331,  524, 1333,   -1, 1335, 
          528, 1337,   -1,   -1,   -1,   59,   -1,   -1,   -1,   41, 
         1292,  539,   44, 1143,   -1, 1297,   -1, 1147,   -1,   -1, 
         1356,    0, 1304,   -1,   -1, 1143, 1197,   59,   -1,  279, 
           -1,   10,   -1, 1163, 1164, 1165, 1166,   -1,   -1,   -1, 
         1170, 1171,   -1, 1173, 1326, 1163,   -1,   -1,   -1,   -1, 
           -1,   10, 1170, 1171,   -1,   10,  584,   -1,   -1,   38, 
           -1,   93,   41,   -1, 1346,   44,  594,   -1,   -1,  597, 
           -1,  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   60,   41,   62,   63,   44,   41,   46,   -1,   44, 
           -1,   46,   10,  125,   -1,  345,  346, 1307, 1308, 1309, 
         1310,   -1,   61,   -1, 1314,   -1,   61,   -1, 1251,   -1, 
         1253,   -1,   -1,   -1,   93,   94,   -1, 1260,   -1,   -1, 
           -1,   -1,   -1,   41,   -1,   -1,   44,   -1,   46,  657, 
           -1,   -1,   91,  661,  662,  663,   91, 1347, 1348, 1349, 
         1350,   -1,   -1,   61,   -1,  124,  125,  675, 1319, 1359, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1, 1292,  691,   -1,   -1,   -1, 1297,   -1,   -1, 
          698,  699,  700,   91, 1304,   -1,   -1,   -1,   -1,  707, 
           -1,   -1,   -1,  711,   -1,  713,  714,   -1, 1331,  717, 
         1333,  719, 1335,   -1, 1337,   -1, 1326,   -1,   -1,   -1, 
           -1,   -1,  730,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1, 1356,  268,  269, 1346,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          294,  295,  296,  297,  772,   -1,    0,  279,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   10,  785,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  804,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   41,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   10,   -1,  826,   -1, 
          279,   -1,  281,  282,  283,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,  368,  294,  295,  296,  297,  298, 
          279,   -1,  354,   -1,  279,   -1,   -1,   41,   -1,   -1, 
           44,   -1,   46,   -1,   -1,   -1,  368,   -1,   -1,   93, 
           -1,  869,   -1,   -1,   -1,   -1,   -1,   61,  327,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
           -1,  279,   -1,   -1,  343,  344,   -1,   -1,   -1,   -1, 
          349,  125,   -1,   -1,   -1,  354,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  345,  346,   -1,  368, 
          345,  346,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  931,  932,  933,  934,   -1,   -1,  937, 
           -1,   -1,  940,  941,   10,   -1,   -1,  945,  946,   -1, 
           -1,  949,   -1,   -1,  952,   -1,   -1,  345,  346,    0, 
          958,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   41,   -1,   -1,   44,   -1, 
           46,   -1,  980,   -1,   -1,   -1,  984,  985,   -1,  987, 
          988,  989,   33,   -1,   -1,   61,   37,   38,   -1,   40, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60, 
           61,   62,   63,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           91,   -1,   93,   94,   -1,  279,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
            0, 1079,  123,  124,  125,  126,   -1,   -1,   -1,   -1, 
           10,   -1,   -1, 1091, 1092,  279,   41,   -1,   -1,   44, 
           -1,   46,   -1,   -1,   -1,   -1,   -1, 1105,   -1,   -1, 
         1108,   -1,   -1,   33,   -1,   -1,   61,   37,   38,   -1, 
           40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
          354,   -1,   -1,   -1,   10,   -1,   -1,   -1,   58,   59, 
           60,   61,   62,   63,  368,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  345,  346,   -1,   -1,   41,   -1,   -1,   44,   -1, 
           46,   91,   -1,   93,   94,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   61,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1, 1200,  123,  124,  125,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,  279,   -1,   91,  257,  258,  259, 1217, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,   -1,  300, 
           -1,   -1,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  345, 
          346,  322,   -1,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
           -1,   -1,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,   -1,  366,  367,  368,   -1,   -1, 
          371,   -1,   -1,   -1,  279,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          345,  346,  322,  279,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,   -1,   -1,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,  364,    0,  366,  367,  368,   -1, 
           -1,  371,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  345, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1, 
           -1,   -1,   37,   38,   -1,   40,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   60,   61,   62,   63,   -1, 
           -1,   -1,   -1,   -1,  287,  288,  289,  290,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          303,  304,  305,   -1,   -1,   -1,   91,   -1,   93,   94, 
          313,  314,  315,  316,  317,   -1,   -1,   -1,   -1,  322, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  123,  124, 
          125,  126,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  358,  359,  360,  361,  362, 
          363,  364,   -1,  366,  367,   33,   -1,   -1,   -1,   37, 
           38,   -1,   40,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   60,   61,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   93,   94,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  123,  124,  125,  126,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,  279,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,   -1,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,   -1,   -1,  343,  344, 
          345,  346,  347,   -1,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,  364, 
           -1,  366,  367,  368,   -1,   -1,  371,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,  279,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,  322,   -1,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,   -1,   -1,  343,  344,  345,  346,  347, 
           -1,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,  364,    0,  366,  367, 
          368,   -1,   -1,  371,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           33,   -1,   -1,   -1,   37,   38,   -1,   40,   41,   42, 
           43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61,   62, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           93,   94,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
          123,  124,  125,  126,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1, 
           -1,   37,   38,   -1,   40,   41,   42,   43,   44,   45, 
           46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   60,   -1,   62,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   94,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  123,  124,  125, 
          126,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,  279,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,  322, 
           -1,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,   -1,   -1, 
          343,  344,  345,  346,  347,   -1,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,  364,   -1,  366,  367,  368,   -1,   -1,  371,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  279,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,  298,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,  322,   -1,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,   -1,   -1,  343,  344,  345, 
          346,  347,   -1,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,  364,    0, 
          366,  367,  368,   -1,   -1,  371,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   33,   -1,   -1,   -1,   37,   38,   -1,   40, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60, 
           -1,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   93,   94,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,  123,  124,  125,  126,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33, 
           -1,   -1,   -1,   37,   38,   -1,   40,   41,   42,   43, 
           44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   60,   -1,   62,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93, 
           94,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  123, 
          124,  125,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,   -1,  300, 
           -1,   -1,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,   -1, 
           -1,  322,   -1,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
           -1,   -1,  343,  344,  345,  346,  347,   -1,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,   -1,  366,  367,  368,   -1,   -1, 
          371,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,   -1, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,   -1,   -1,  343, 
          344,  345,  346,  347,   -1,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
          364,    0,  366,  367,  368,   -1,   -1,  371,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   33,   -1,   -1,   -1,   37,   38, 
           -1,   40,   41,   42,   43,   44,   45,   46,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   37,   38,   -1, 
           -1,   -1,   42,   43,   -1,   45,   -1,   47,   -1,   -1, 
           -1,   -1,   91,   -1,   93,   94,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,  124,  125,  126,   -1,   -1, 
           -1,   -1,   -1,   -1,   94,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   37,   38, 
           -1,   -1,   41,   42,   43,   44,   45,   46,   47,   -1, 
           -1,   -1,   -1,   -1,  124,   -1,   -1,   -1,   -1,   58, 
           59,   60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   93,   94,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   38,   -1,   40,   -1,   42,   -1,   -1,   -1,   46, 
           -1,   -1,   -1,   -1,  123,  124,  125,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,   -1,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
           -1,  300,   -1,   -1,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,   -1,   -1,  322,   -1,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,   -1,   -1,  343,  344,  345,  346,  347,   -1, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,  364,  326,  366,  367,  368, 
           -1,   -1,  371,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,  343,  344,   -1,   -1,   -1,   -1,   -1, 
          279,  280,  281,  282,  283,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
           -1,   -1,   -1,   -1,  343,  344,  345,  346,   -1,   -1, 
          349,   -1,   37,   38,   -1,  354,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,  368, 
           -1,   -1,  371,   58,   59,   60,   61,   62,   63,  306, 
           -1,  308,  309,  310,  311,  312,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   94, 
            0,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,  346, 
           10,   -1,   -1,  350,   -1,   -1,   -1,   -1,  355,  356, 
          357,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   38,   -1,   40,   -1,   42, 
           -1,   91,   -1,   93,   94,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   37,   38,   -1,   -1,   41, 
           42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61, 
           62,   63,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283,   91, 
           -1,   93,   94,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,   -1,   -1,   -1,   -1,  343,  344, 
          345,  346,   -1,  348,  349,   -1,   41,   -1,   -1,  354, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,  368,   59,   -1,  371,   -1,   -1,  279, 
           -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   -1,   38,   -1,   -1,   -1,   42,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   38,   -1,   -1,   -1, 
           42,   -1,   -1,   -1,   -1,   -1,  326,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,   -1, 
          125,   -1,   -1,  343,  344,  345,  346,   -1,  348,  349, 
           -1,   -1,   -1,  306,  354,  308,  309,  310,  311,  312, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  368,  271, 
           -1,  371,   -1,  326,   -1,   -1,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,  340,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,  350,   -1,   -1, 
           -1,   -1,  355,  356,  357,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,   -1,   -1,   -1, 
           -1,  343,  344,  345,  346,   -1,  348,  349,   -1,   37, 
           38,   -1,  354,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,   -1,  371, 
           58,   59,   60,   61,   62,   63,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   93,   94,    0,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1, 
           -1,   -1,   -1,   -1,   37,   38,   -1,   -1,   41,   42, 
           43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61,   62, 
           63,   -1,  306,   -1,  308,  309,  310,  311,  312,   -1, 
           -1,   -1,   -1,  368,  306,   -1,  308,  309,  310,  311, 
          312,   -1,  326,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           93,   94,   -1,   -1,  326,    0,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  350,   -1,   -1,   -1, 
           -1,  355,  356,  357,   -1,   -1,   -1,   -1,  350,   -1, 
           -1,  124,  125,  355,  356,  357,   -1,   -1,   -1,   -1, 
           -1,   -1,   37,   38,   -1,   -1,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   60,   61,   62,   63,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,  281,  282,  283,   91,   -1,   93,   94, 
           -1,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  124, 
          125,   -1,   10,   -1,   -1,   -1,   -1,   -1,  326,  327, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,   -1,   -1,   -1,   -1,  343,  344,  345,  346,   -1, 
          348,  349,   -1,   41,   -1,   -1,  354,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
          368,   59,   -1,  371,   -1,   -1,  279,   -1,  281,  282, 
          283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   37,   38,   -1, 
           -1,   -1,   42,   43,   -1,   45,   -1,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           60,   -1,   62,  326,  327,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,   -1,  125,   -1,   -1, 
          343,  344,  345,  346,   -1,  348,  349,   -1,   -1,   -1, 
           -1,  354,   -1,   -1,   94,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  368,  271,   -1,  371,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283,   -1, 
           -1,   -1,   -1,   -1,  124,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,   -1,   -1,   -1,   -1,  343,  344, 
          345,  346,   -1,  348,  349,   -1,   37,   38,   -1,  354, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,  368,   -1,   -1,  371,   58,   59,   60, 
           61,   62,   63,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   93,   94,    0,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   -1,   -1, 
           -1,   37,   38,   -1,   -1,   41,   42,   43,   44,   45, 
           46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   60,   61,   62,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          368,   -1,   -1,   -1,   -1,   -1,  326,   -1,   -1,   -1, 
           -1,  331,  332,   -1,   -1,   91,   -1,   93,   94,   -1, 
           -1,   -1,    0,  343,  344,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   37, 
           38,   -1,   -1,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   60,   61,   62,   63,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,  282,  283,   91,   -1,   93,   94,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,   -1,   -1, 
           -1,   -1,  343,  344,  345,  346,   -1,  348,  349,   -1, 
           41,   -1,   -1,  354,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,  368,   59,   -1, 
          371,   -1,   -1,  279,   -1,  281,  282,  283,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295, 
          296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          326,  327,  328,  329,  330,  331,  332, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          333,  334,  335,  336,  337,  338,   -1,  125,   -1,   -1, 
          343,  344,  345,  346,   -1,  348,  349,   -1,   -1,   -1, 
           -1,  354,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  368,  271,   -1,  371,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,   -1,   -1,   -1,   -1,  343,  344, 
          345,  346,   -1,  348,  349,   -1,   37,   38,   -1,  354, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,  368,   -1,   -1,  371,   58,   59,   60, 
           61,   62,   63,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   93,   94,    0,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   -1,   -1, 
           -1,   37,   38,   -1,   -1,   41,   42,   43,   44,   45, 
           46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   60,   -1,   62,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          368,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   94,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  123,  124,  125, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   37, 
           38,   -1,   -1,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,  282,  283,   91,   -1,   93,   94,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,  123,  124,  125,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,   -1,   -1, 
           -1,   -1,  343,  344,  345,  346,   -1,  348,  349,   -1, 
           41,   -1,   -1,  354,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,  368,   59,   -1, 
          371,   -1,   -1,  279,  280,  281,  282,  283,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295, 
          296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          326,  327,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,   -1,  125,   -1,   -1,  343,  344,  345, 
          346,   -1,   -1,  349,   -1,   -1,   -1,   -1,  354,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  368,  271,   -1,  371,   -1,   -1,   -1,   -1, 
           -1,  279,  280,  281,  282,  283,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,  326,  327, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,   -1,   -1,   -1,   -1,  343,  344,  345,  346,   -1, 
           -1,  349,   -1,   37,   38,   -1,  354,   41,   42,   43, 
           44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
          368,   -1,   -1,  371,   58,   59,   60,   61,   62,   63, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93, 
           94,    0,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          124,  125,   -1,   -1,   -1,   -1,   -1,   -1,   37,   38, 
           -1,   -1,   41,   42,   43,   44,   45,   46,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   93,   94,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   37,   38,   -1,   -1, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60, 
           -1,   62,   63,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283, 
           91,   -1,   93,   94,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,  124,  125,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  326,  327,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,   -1,   -1,   -1,   -1,  343, 
          344,  345,  346,   -1,   -1,  349,   -1,   41,   -1,   -1, 
          354,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,  368,   59,   -1,  371,   -1,   -1, 
          279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
           -1,  125,   -1,   -1,  343,  344,  345,  346,   -1,   -1, 
          349,   -1,   -1,   -1,   -1,  354,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,  368, 
          271,   -1,  371,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,   -1,   -1, 
           -1,   -1,  343,  344,  345,  346,   -1,   -1,  349,   -1, 
           37,   38,   -1,  354,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,   -1, 
          371,   58,   59,   60,   -1,   62,   63,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   93,   94,    0,   -1, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1, 
           -1,   -1,   -1,   -1,   -1,   37,   38,   -1,   -1,   41, 
           42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   -1, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  368,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   93,   94,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   37,   38,   -1,   -1,   41,   42,   43, 
           44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   60,   -1,   62,   63, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  279,   -1,  281,  282,  283,   91,   -1,   93, 
           94,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
          124,  125,   -1,   -1,   10,   -1,   -1,   -1,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,   -1,   -1,   -1,   -1,  343,  344,  345,  346, 
           -1,   -1,  349,   -1,   -1,   41,   -1,  354,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,  368,   -1,   59,  371,   -1,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,   -1,   -1,  125, 
           -1,  343,  344,  345,  346,   -1,   -1,  349,   -1,   -1, 
           -1,   -1,  354,   41,   -1,   -1,   44,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  368,  271,   -1,  371, 
           -1,   59,   -1,   -1,   -1,  279,   -1,  281,  282,  283, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   93,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  326,  327,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,   -1,   -1,  125,   -1,  343, 
          344,  345,  346,   -1,   -1,  349,   -1,   37,   38,   -1, 
          354,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,  368,   -1,   -1,  371,   58,   59, 
           60,   -1,   62,   63,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   93,   94,    0,   -1,   -1,  294,  295, 
          296,  297,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   37,   38,   -1,   -1,   41,   42,   43,   44, 
           45,   -1,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   60,   -1,   62,   63,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  368,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,  281,  282,   -1,   -1,   -1,   93,   94, 
           -1,    0,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   10,   37,   38,   -1,   -1,   -1,   42,   43,   -1, 
           45,   -1,   47,   -1,   -1,   -1,   -1,   -1,   -1,  124, 
          125,   -1,   -1,   -1,   -1,   60,   -1,   62,   37,   38, 
           -1,   -1,   41,   42,   43,   44,   45,   -1,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   60,   -1,   62,   63,   -1,  354,   -1,   -1,   94, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          368,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279, 
           -1,  281,  282,  283,   93,   94,   -1,   -1,   -1,  124, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,   -1, 
           -1,   -1,   -1,  343,  344,  345,  346,   -1,   -1,  349, 
           -1,   -1,   41,   -1,  354,   44,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,  368,   -1, 
           59,  371,   -1,   -1,  279,   -1,  281,  282,  283,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   93,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,   -1,   -1,  125,   -1,  343,  344, 
           -1,   -1,   -1,   -1,  349,   -1,   -1,   -1,   -1,  354, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,  368,   -1,   -1,  371,   -1,   -1,   -1, 
          279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,   -1,   -1,   -1,    0,   -1,   -1,  343,  344, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
           -1,   -1,   -1,   -1,  343,  344,   -1,   -1,   -1,   -1, 
          349,   -1,   37,   38,   -1,  354,   41,   42,   43,   44, 
           45,   -1,   47,   -1,   -1,   -1,   -1,   -1,   -1,  368, 
           -1,   -1,  371,   58,   59,   60,   -1,   62,   63,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          279,   -1,  281,  282,   -1,   -1,   -1,   -1,   93,   94, 
            0,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   -1,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           60,   -1,   62,   63,   -1,  354,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   93,   94,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   37,   38,   -1, 
           -1,   -1,   42,   43,   -1,   45,   -1,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   -1, 
           60,   -1,   62,   37,   38,   -1,   -1,   41,   42,   43, 
           44,   45,   -1,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   60,   -1,   62,   63, 
           -1,   -1,   -1,   -1,   94,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283,   93, 
           94,   -1,   -1,   -1,  124,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
          124,  125,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,   -1,   -1,   -1,   -1,  343,  344, 
           -1,   -1,   -1,   -1,  349,   -1,   41,   -1,   -1,  354, 
            0,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           10,  271,   -1,  368,   59,   -1,  371,   -1,   -1,  279, 
           -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   41,   -1,   -1,   44,   -1,   -1,   -1,   93,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,   -1, 
          125,   -1,   -1,  343,  344,   -1,   -1,   -1,   -1,  349, 
           -1,   -1,   -1,   -1,  354,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,  368,   -1, 
           -1,  371,   -1,   -1,   -1,  279,   -1,  281,  282,  283, 
           -1,   -1,   -1,   -1,   -1,  125,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,  326,  327,  328,  329, 
          330,  331,  332,  333,   -1,  335,  336,   -1,   -1,   -1, 
            0,   -1,   -1,  343,  344,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,  327,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,   -1,   -1,   -1,   -1,  343, 
          344,   -1,   -1,   -1,   -1,  349,   -1,   37,   38,   -1, 
          354,   41,   42,   43,   44,   45,   -1,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,  368,   -1,   -1,  371,   58,   59, 
           60,   -1,   62,   63,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   93,   94,    0,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,  124,  125,   -1,   -1,   -1,  279, 
           -1,   -1,   37,   38,   -1,   -1,   41,   42,   43,   44, 
           45,   -1,   47,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   58,   59,   60,   -1,   62,   63,  354, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  368,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   94, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,  124, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   37,   38, 
           -1,   -1,   41,   42,   43,   44,   45,   -1,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279, 
           -1,  281,  282,  283,   93,   94,   -1,   -1,   -1,   -1, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,   -1, 
           -1,   -1,   -1,  343,  344,   -1,   -1,   -1,   -1,  349, 
           -1,   41,   -1,   -1,  354,    0,   46,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   10,  271,   -1,  368,   59, 
           -1,  371,   -1,   -1,  279,   -1,  281,  282,  283,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   41,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,   -1,  125,   -1,   -1,  343,  344, 
           -1,   -1,   -1,   -1,  349,   -1,   -1,   -1,   93,  354, 
           -1,    0,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   10,  271,  368,   -1,   -1,  371,   -1,   -1,   -1, 
          279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1,  124, 
          125,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,   41,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   10,   -1,   -1,  327,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
           -1,   -1,   -1,   -1,  343,  344,   -1,   -1,   -1,   -1, 
          349,   -1,   37,   38,   93,  354,   41,   42,   43,   44, 
           45,   -1,   47,   -1,   -1,   -1,   -1,   -1,   -1,  368, 
           -1,   -1,  371,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,  262,  263,  264,   -1,  125,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279, 
           -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,   93,   94, 
            0,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,  124, 
          125,   -1,   -1,   -1,  279,   -1,  281,   -1,   38,   -1, 
           -1,   41,   -1,   43,   44,   45,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,  345,  346,   -1,   58,   59, 
           60,   -1,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   93,   94,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,  368,  124,  125,   -1,   -1,   -1,   -1, 
          279,   -1,  281,  282,   38,   -1,   -1,   41,   -1,   43, 
           44,   45,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   -1,   58,   59,   60,   -1,   62,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283,   93, 
           94,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,  368, 
          124,  125,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,  337,  338,   -1,   -1,   -1,   -1,  343,  344, 
           -1,   -1,   -1,   -1,  349,   -1,   -1,   41,   -1,  354, 
           44,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,  368,   58,   59,  371,   -1,   -1,  279, 
           -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,   -1, 
           -1,  125,   -1,  343,  344,   -1,   -1,   -1,   -1,  349, 
           -1,   -1,   -1,   -1,  354,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,  368,   -1, 
           -1,  371,   -1,   -1,   -1,  279,   -1,  281,  282,  283, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  327,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,   38,   -1,   -1,   41,  343, 
          344,   44,   -1,   -1,   -1,  349,   -1,   -1,   -1,   -1, 
          354,   -1,   -1,   -1,   -1,   58,   59,   60,   -1,   62, 
           63,   -1,   -1,   -1,  368,   -1,   -1,  371,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           93,   94,    0,   -1,   -1,  279,   -1,  281,  282,  283, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,  124,  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           38,   -1,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,   -1,   -1, 
          354,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  368,   93,   94,  371,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   41, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   -1, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282, 
          283,   93,   94,   -1,   -1,   -1,   -1,   -1,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   38,   -1,   40, 
           -1,   42,   -1,   -1,   -1,   46,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   -1,   -1,  327,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,   -1,   -1,   -1,    0, 
          343,  344,   -1,   -1,   -1,   -1,  349,   -1,   -1,   10, 
           -1,  354,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,  368,   -1,   -1,  371,   -1, 
           -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1, 
           41,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,   -1,   93,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,  349,   -1,   -1,   -1,   -1,  354,   10,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          368,   -1,   -1,  371,  125,   -1,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   41,  291, 
          292,   44,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   60,   -1,   62, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,   -1,   -1,   -1, 
           93,   94,   -1,    0,   -1,   -1,   -1,  349,   -1,   -1, 
           -1,   -1,  354,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,   -1,  371, 
           -1,  124,  125,   -1,   -1,  306,   -1,  308,  309,  310, 
          311,  312,   -1,   -1,   41,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  326,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   60,   -1,   62,   63,   -1,   -1,  340, 
           -1,  262,  263,  264,   -1,  346,  267,  268,  269,  350, 
          271,   -1,   -1,   -1,  355,  356,  357,   -1,  279,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   93,   -1,    0,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  125,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   41, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   -1, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  368,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282, 
          283,   93,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,   41, 
           -1,  354,   44,    0,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   10,  271,  368,   58,   59,  371,   -1, 
           -1,   63,  279,   -1,  281,  282,  283,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   41,   -1,   -1,   44,   -1,   -1, 
           -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,   -1,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,   -1,   -1,   -1,  354,    0,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   10,  271, 
           -1,  368,   -1,   -1,  371,   -1,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,  125,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   41, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1, 
           -1,   93,  354,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,   -1,  371, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
          262,  263,  264,  125,   -1,  267,  268,  269,   10,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   41, 
           -1,   -1,   44,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   58,   59,   -1,    0, 
           -1,   63,  279,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  333,  334,   -1,   -1,  337,  338,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1, 
           -1,   93,  354,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           41,   -1,   -1,   44,   -1,   -1,  368,   -1,   -1,  371, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,  368,   93,   -1,   -1,   -1,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,  125,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  333,  334,   -1,   -1,  337,  338,   -1,   41,   -1, 
           38,   44,   40,   -1,   42,   -1,   -1,  349,   46,   -1, 
           -1,   -1,  354,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   59,   -1,   61,   -1,   -1,  368,   -1,   -1,  371, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           93,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,    0,   -1,  267,  268,  269,   -1, 
          271,  333,  334,   -1,   10,  337,  338,   -1,  279,   -1, 
          281,  282,  283,   -1,   -1,   -1,   -1,  349,   -1,   -1, 
          291,  292,  354,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   41,  368,   -1,   44,  371, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,  333,  334,   -1,   -1,  337,  338,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1, 
           -1,   -1,   -1,  354,   -1,   -1,   -1,   93,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,   -1, 
          371,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   10,  271,  125, 
           -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282, 
          283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   -1,   41,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  306,   -1, 
          308,  309,  310,  311,  312,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326,   -1, 
          333,  334,   -1,   -1,  337,  338,   -1,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,  349,   -1,  346,   -1, 
           93,  354,  350,   -1,   -1,   -1,   -1,  355,  356,  357, 
           -1,   -1,   -1,   -1,   -1,  368,   -1,   -1,  371,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  279,   -1,  281,  282,  283,   -1,   -1, 
           -1,   -1,   -1,   -1,   41,  291,  292,   44,  294,  295, 
          296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,  334,   -1, 
           -1,  337,  338,   -1,   -1,   -1,   93,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,   -1,   -1,   -1,  354,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,  368,   -1,   -1,  371,   10,   -1,  125,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282, 
          283,   -1,   -1,   -1,   -1,   -1,   -1,   41,  291,  292, 
           44,  294,  295,  296,  297,  298,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   10,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          333,  334,   -1,   -1,  337,  338,   -1,   41,   -1,   93, 
           44,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,   -1, 
           -1,  354,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  368,   -1,   -1,  371,   -1, 
           -1,  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1, 
           10,  125,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   41,   -1,   -1,   44,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  334,   58,   59, 
          337,  338,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,   38,   -1,   40,  354,   42,   -1, 
           -1,   -1,   46,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  368,   -1,   93,  371,   59,   -1,   61,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283, 
           -1,   -1,   -1,   -1,   -1,  125,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283, 
           -1,   -1,   -1,   -1,   -1,   -1,   41,  291,  292,   44, 
          294,  295,  296,  297,  298,  349,   -1,   -1,   -1,   -1, 
          354,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
            0,   -1,   -1,   -1,  368,   -1,   -1,  371,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,   -1,   -1, 
          354,   41,   -1,   -1,   44,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  368,   10,   -1,  371,   58,   59, 
          125,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279, 
           -1,  281,  282,  283,   -1,   -1,   41,   -1,   -1,   44, 
           -1,  291,  292,   93,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1, 
           -1,   -1,  306,   -1,  308,  309,  310,  311,  312,  349, 
           -1,   -1,   -1,   -1,  354,   41,   -1,   -1,   44,   -1, 
           -1,   -1,  326,   -1,   -1,   -1,   -1,   -1,  368,   -1, 
          125,  371,   58,   59,   -1,   -1,  340,   -1,   -1,    0, 
           -1,   -1,  346,   -1,   -1,   -1,  350,   -1,   -1,   10, 
           -1,  355,  356,  357,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   93,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283,   -1, 
           41,   -1,   -1,   44,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   58,   59,  125, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   93,   -1,   -1,   -1,   -1,   -1,   -1,  279, 
           -1,  281,  282,  283,  349,   -1,   -1,   -1,   -1,  354, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,  368,  125,   -1,  371,  262,  263,  264, 
           -1,    0,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  279,   -1,  281,  282,  283,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,   -1,   41,   -1,  354,   44,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   10, 
           59,  371,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  279,  349,  281,  282,  283,   -1,  354, 
           41,   -1,   -1,   44,   93,  291,  292,   -1,  294,  295, 
          296,  297,  298,  368,   -1,   -1,  371,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  125,   -1,   10,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   93,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,  282,  283,  349,   -1,   -1,   -1,   10,  354,   41, 
          291,  292,   44,  294,  295,  296,  297,  298,   -1,    0, 
           -1,   -1,  368,   -1,  125,  371,   58,   59,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   38,   -1,   40,   -1,   42, 
           -1,   -1,   -1,   46,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           41,   93,   -1,   44,   -1,   -1,   -1,   -1,  349,   -1, 
           -1,   -1,   -1,  354,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,   -1, 
          371,   -1,   -1,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   93,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,  125,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,   -1,   -1,   -1, 
          349,   -1,   -1,   -1,   -1,  354,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368, 
           -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   94,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,  349,  281, 
          282,  283,   -1,  354,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,   -1,  368,   -1,   -1, 
          371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,  282,  283,  306,   -1,  308,  309,  310,  311,  312, 
          291,  292,   -1,  294,  295,  296,  297,  349,    0,   -1, 
           -1,   -1,  354,  326,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  368,  340,   -1,  371, 
           -1,   -1,   -1,  346,   -1,   -1,   -1,  350,   -1,   -1, 
           -1,   33,  355,  356,  357,   37,   38,   -1,   -1,   41, 
           42,   43,   44,   45,   46,   47,   -1,   -1,  349,   -1, 
           -1,   -1,   -1,  354,   -1,   -1,   -1,   59,   60,   -1, 
           62,   63,   -1,   -1,   -1,   -1,   -1,  368,   -1,   -1, 
          371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   93,   94,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,  287,  288,  289,  290,   -1,   -1,   -1,   -1,   -1, 
           10,  123,  124,  125,  126,   -1,   -1,  303,  304,  305, 
          306,   -1,   -1,   -1,  310,   -1,   -1,  313,  314,  315, 
          316,  317,   -1,   33,   -1,   -1,  322,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   59, 
           60,  347,   62,   63,  350,   -1,  352,  353,   -1,  355, 
           -1,   -1,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   93,   94,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  123,  124,  125,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,  279,  280,  281, 
          282,   -1,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,   -1,  300,   -1, 
           -1,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,   -1,   -1, 
          322,   -1,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,   -1, 
           -1,  343,  344,  345,  346,  347,   -1,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,  364,   -1,  366,  367,  368,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,  281,  282,   -1,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,   -1,   -1,  343,  344,  345,  346,  347,   -1,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,  364,    0,  366,  367,  368,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1, 
           -1,   -1,   37,   38,   -1,   -1,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   60,   -1,   62,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   94, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,  124, 
          125,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           33,   -1,   -1,   -1,   37,   38,   -1,   40,   41,   42, 
           43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   60,   61,   62, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   94,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          123,  124,  125,  126,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,  279,   -1,  281,  282,   -1,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,   -1,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,   -1,   -1,  343,  344, 
          345,  346,  347,   -1,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,  364, 
           -1,  366,  367,  368,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,  279,  280,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,  322, 
           -1,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,   -1,   -1, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,   -1,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,  364,    0,  366,  367,  368,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1,   37, 
           38,   -1,   40,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   60,   61,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   94,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  123,  124,  125,  126,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1, 
           -1,   37,   38,   -1,   40,   41,   42,   43,   44,   45, 
           46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   60,   61,   62,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   94,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  123,  124,  125, 
          126,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,  322,   -1,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,   -1,   -1,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,   -1,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,  364,   -1,  366,  367, 
          368,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  279,  280,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,  298,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,  322,   -1,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,   -1,   -1,  343, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

          344,  345,  346,  347,   -1,  349,  350,  351,  352,  353, 
           -1,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
          364,    0,  366,  367,  368,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   33,   -1,   -1,   -1,   37,   38, 
           -1,   40,   41,   42,   43,   44,   45,   46,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   94,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  123,  124,  125,  126,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1, 
           37,   38,   -1,   40,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   60,   61,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  123,  124,  125,  126, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,   -1,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
           -1,  300,   -1,   -1,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,   -1,   -1,  322,   -1,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,   -1,   -1,  343,  344,  345,  346,  347,   -1, 
          349,  350,  351,  352,  353,   -1,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,  364,   -1,  366,  367,  368, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,   -1,  300,   -1,   -1,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,   -1,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,   -1,   -1,  343,  344,  345,  346, 
          347,   -1,  349,  350,  351,  352,  353,   -1,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,  364,    0,  366, 
          367,  368,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   33,   -1,   -1,   -1,   37,   38,   -1,   40,   41, 
           42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   60,   61, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   94,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  123,  124,  125,  126,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   33,   -1,   -1,   -1,   37,   38,   -1, 
           40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   94,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  123,  124,  125,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,  279,  280,   -1, 
           -1,   -1,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,   -1,  300,   -1, 
           -1,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,   -1,   -1, 
          322,   -1,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,   -1, 
           -1,  343,  344,  345,  346,  347,   -1,  349,  350,  351, 
          352,  353,   -1,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,  364,   -1,  366,  367,  368,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,   -1,   -1,  343,  344,  345,  346,  347,   -1,  349, 
          350,  351,  352,  353,   -1,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,  364,    0,  366,  367,  368,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1, 
           -1,   -1,   37,   38,   -1,   40,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   60,   61,   62,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   94, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  123,  124, 
          125,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           33,   -1,   -1,   -1,   37,   38,   -1,   40,   41,   42, 
           43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   60,   61,   62, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   94,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  124,  125,  126,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,  279,  280,   -1,   -1,   -1,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,   -1,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,   -1,   -1,  343,  344, 
          345,  346,  347,   -1,  349,  350,  351,  352,  353,   -1, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,  364, 
           -1,  366,  367,  368,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,  279,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,  322, 
           -1,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,   -1,   -1, 
          343,  344,  345,  346,  347,   -1,  349,  350,  351,  352, 
          353,   -1,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,  364,    0,  366,  367,  368,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1,   37, 
           38,   -1,   40,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   60,   61,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   94,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,  124,  125,  126,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   41,   -1,   -1,   -1,   -1, 
           46,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   38,   -1,   40,   -1, 
           42,   -1,   -1,   -1,   46,   -1,   -1,  123,   -1,  125, 
          126,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,  279,   -1,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,  322,   -1,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,   -1,   -1,  343,  344,  345,  346,  347, 
           -1,  349,  350,  351,  352,  353,   -1,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,  364,   -1,  366,  367, 
          368,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  279,  280,  281,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,  298,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,  322,   -1,  324,  325, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,  339,  340,   -1,   10,   -1,   -1,  345, 
          346,  347,   -1,   -1,  350,  351,  352,  353,   -1,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  368,   37,   38,   -1,   -1,   41,   42,   43, 
           44,   45,   46,   47,  306,   -1,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,   59,   60,   -1,   62,   63, 
           -1,   -1,   -1,   -1,  326,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,  346,   -1,   -1,   91,  350,   93, 
           94,    0,   -1,  355,  356,  357,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          124,  125,   -1,   -1,   -1,   -1,   -1,   -1,   37,   38, 
           -1,   -1,   41,   42,   43,   44,   45,   46,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   93,   94,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   37,   38,   -1,   -1, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   60, 
           -1,   62,   63,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282,   -1, 
           91,   -1,   93,   94,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  326,  327,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,   -1,   -1,   -1,   -1,  343, 
          344,  345,  346,   -1,   -1,  349,   -1,   -1,   -1,   -1, 
          354,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   10,  368,   -1,   -1,   -1,   -1,   -1, 
          279,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   38,   -1,   40,   -1,   42,   -1,   -1,   -1,   46, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   -1,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
           -1,   -1,   -1,   -1,  343,  344,  345,  346,   -1,   -1, 
          349,   -1,   -1,   -1,   -1,  354,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,  368, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,   -1,   -1, 
           -1,   -1,  343,  344,  345,  346,   -1,   -1,  349,   -1, 
           37,   38,   -1,  354,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,   -1, 
           -1,   -1,   59,   60,   61,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   91,   -1,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  123,  124,  125,   -1, 
           37,   38,   -1,   -1,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   60,   61,   62,   63,   -1,   -1,  306, 
           -1,  308,  309,  310,  311,  312,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326, 
           -1,   -1,   -1,   -1,   91,    0,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   10,   -1,   -1,   -1,  346, 
           -1,   -1,   -1,  350,   -1,   -1,   -1,   -1,  355,  356, 
          357,   -1,   -1,   -1,   -1,   -1,  123,  124,  125,   -1, 
           -1,   -1,   37,   38,   -1,   -1,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   60,   61,   62,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   91,   -1,   -1,   94, 
           -1,   -1,  279,  280,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,   -1,   -1,   -1,   -1,  343,  344,  345,  346, 
           -1,   -1,  349,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,  368,  279,  280,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,   -1,   -1,   -1,   -1,  343,  344,  345,  346, 
           -1,   -1,  349,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,  368,   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,   -1,   -1,   -1,   -1,  343,  344, 
          345,  346,   -1,  348,  349,   37,   38,   -1,   -1,   41, 
           42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  368,   -1,   -1,   -1,   59,   60,   61, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   91, 
           -1,   -1,   94,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   -1,   37,   38,   -1,   -1,   41, 
           42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   60,   61, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
            0,   -1,   94,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   37,   38,   -1,   -1,   -1,   42,   43,   -1,   45, 
           -1,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   60,   -1,   62,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           60,   61,   62,   63,   -1,   -1,   -1,   -1,   94,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   91,   -1,   -1,   94,   -1,   -1,  279,  124,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,   -1,   -1,   -1, 
           -1,  343,  344,  345,  346,   -1,  348,  349,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,  368,  279,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,   -1,   -1,   -1, 
           -1,  343,  344,  345,  346,   -1,  348,  349,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,  368,   -1,   -1,  279, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,   -1,   -1,    0,   -1,   -1,   -1,  343,  344,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  326,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,   -1, 
           -1,   -1,   -1,  343,  344,  345,  346,   -1,  348,  349, 
           37,   38,   -1,   -1,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1, 
           -1,   -1,   59,   60,   61,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   91,   -1,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1, 
           37,   38,   -1,   -1,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   60,   61,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,    0,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1, 
           -1,   -1,   37,   38,   -1,   -1,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   60,   61,   62,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   91,   -1,   -1,   94, 
           -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,   -1,   -1,   -1,   -1,  343,  344,  345,  346, 
           -1,  348,  349,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,  368,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,   -1,   -1,   -1,   -1,  343,  344,  345,  346, 
           -1,  348,  349,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,  368,   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,   -1,   -1,   -1,   -1,  343,  344, 
          345,  346,   -1,  348,  349,   37,   38,   -1,   -1,   41, 
           42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  368,   -1,   -1,   -1,   59,   60,   61, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   91, 
           -1,   -1,   94,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   -1,   37,   38,   -1,   -1,   41, 
           42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   60,   61, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
            0,   -1,   94,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   -1,   -1,   -1,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   91,   -1,   -1,   94,   -1,   -1,  279,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,   -1,   -1,   -1, 
           -1,  343,  344,  345,  346,   -1,  348,  349,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,  368,  279,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,   -1,   -1,   -1, 
           -1,  343,  344,  345,  346,   -1,  348,  349,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,  368,   -1,   -1,  279, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  326,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,   -1, 
           -1,   -1,   -1,  343,  344,  345,  346,   -1,  348,  349, 
           37,   38,   -1,   -1,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1, 
           -1,   -1,   59,   60,   61,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   91,   -1,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1, 
           37,   38,   -1,   -1,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   60,   61,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,    0,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1, 
           -1,   -1,   37,   38,   -1,   -1,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   60,   61,   62,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   91,   -1,   -1,   94, 
           -1,   -1,  279,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   41,   -1,   -1,   44,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,   59,   -1,   -1,   -1,  343,  344,  345,  346, 
           -1,   -1,  349,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,  368,  279,    0,   -1,   -1,   93,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1, 
           -1,   -1,   -1,   -1,   41,   -1,   -1,   44,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,   59,    0,   -1,   -1,  343,  344,  345,  346, 
           -1,   -1,  349,   10,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,  368,   -1,   -1,  279,   -1,   93,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   41,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,    0,  124,  125,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,   -1,   -1,   93,   -1,  343,  344, 
          345,  346,   -1,   -1,  349,   -1,   -1,   41,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  368,  271,   59,    0,   -1,  125,   -1, 
           -1,   -1,  279,   -1,  281,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   59,   -1,   -1,   -1,   -1, 
           -1,  125,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   93, 
           -1,  368,  279,   -1,  281,   41,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   59,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  125,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   93,   -1,   -1, 
           -1,   -1,  279,   -1,  281,  282,   41,   -1,   -1,   44, 
           -1,   -1,  349,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   59,   -1,   -1,    0,   -1,  125, 
           -1,  368,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   93,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,  281,   41,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   59,    0,   -1,   -1, 
          125,  368,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           93,   -1,   -1,   -1,   -1,  279,   -1,  281,   41,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   10, 
          294,  295,  296,  297,  298,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,  125,   -1,  368,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           41,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           93,   -1,    0,  279,   -1,  281,   -1,   -1,   59,   -1, 
           -1,   -1,   10,   -1,   -1,  291,  292,   -1,  294,  295, 
          296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  125,   -1,  368,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   93,   41,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,    0,   -1, 
           -1,   59,   -1,   -1,  279,   -1,  281,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  125,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  368,   -1,   -1,   93,    0,   -1,   -1,   41, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   59,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  279,  125,  281,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   41,  291,  292, 
           -1,  294,  295,  296,  297,  298,   10,   -1,   -1,   -1, 
           -1,   93,   -1,  368,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   41,  271,   -1, 
           -1,   -1,   -1,  125,   -1,   -1,  279,   -1,  281,   93, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  368,  267,  268,  269,   -1, 
          271,  125,   -1,   -1,   -1,   -1,    0,   -1,  279,   93, 
          281,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  125,   -1,   -1,  262,  263,  264,   41,   -1,  267, 
          268,  269,   -1,  271,   -1,  368,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,  281,   38,   59,   40,   -1,   42,   -1, 
           -1,   -1,   46,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,   93, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,  125,  294,  295,  296,  297,  298,   -1,  262,  263, 
          264,    0,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
          368,   10,   -1,   -1,   -1,  279,   -1,  281,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,  262,  263, 
          264,   -1,   41,  267,  268,  269,    0,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   10,  281,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,  368,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   41,   -1,   -1, 
           -1,   -1,   -1,   10,   93,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  368,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   41,   -1,  125,   -1,  262,  263, 
          264,    0,   -1,  267,  268,  269,   -1,  271,   -1,   93, 
           -1,   10,   59,   -1,  368,  279,   -1,  281,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,    0, 
           -1,  125,   41,   -1,   -1,   -1,   93,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           59,   -1,  306,   -1,  308,  309,  310,  311,  312,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  125,   -1, 
           41,   -1,  326,   -1,   -1,   -1,   -1,   38,   -1,   40, 
           -1,   42,   -1,   -1,   93,   46,  340,   -1,   59,   -1, 
           -1,   -1,  346,   -1,  368,   -1,  350,   -1,   59,   -1, 
           61,  355,  356,  357,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  125,   10,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          279,   -1,  281,   -1,   -1,   -1,   -1,   -1,   41,   -1, 
            0,   -1,  291,  292,  125,  294,  295,  296,  297,  298, 
           10,   -1,   -1,   -1,   -1,   -1,   59,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,  281,   -1,    0, 
           -1,   41,   -1,   -1,   -1,   -1,   -1,  291,  292,   10, 
          294,  295,  296,  297,  298,  262,  263,  264,   -1,   59, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  279,   -1,  281,   -1,   -1,   -1,   -1,  368, 
           41,   -1,  125,   -1,  291,  292,    0,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   10,   -1,   59,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          279,   -1,  281,   -1,  368,  125,   -1,   41,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,  262,  263,  264,   -1,   59,  267,  268,  269,    0, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   10, 
          281,  368,   -1,   -1,  125,   -1,   -1,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           41,   -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310, 
          311,  312,    0,   -1,   -1,   -1,   -1,   -1,   59,  368, 
           -1,  125,   10,   -1,   -1,  326,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,  340, 
           -1,   -1,   -1,   -1,   -1,  346,  279,   -1,  281,  350, 
           -1,   -1,   -1,   41,  355,  356,  357,  368,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   -1,   -1,   -1, 
           -1,   59,  262,  263,  264,   -1,   -1,  267,  268,  269, 
            0,  271,   -1,   -1,  125,   -1,   -1,   -1,   -1,  279, 
           10,  281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   41,   -1,   -1,   44,   -1,   37,   38,  279,   -1, 
          281,   42,   43,   -1,   45,  368,   47,  125,   -1,   59, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   60, 
           -1,   62,   63,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  368,   -1, 
           -1,   -1,   -1,   94,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  124,   -1,   -1,   -1,  368,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   33,   -1,   -1,   -1,   -1,   -1,  279,   40, 
          281,   -1,   -1,   -1,   -1,   46,   -1,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   59,   60, 
           -1,   -1,   -1,   -1,  368,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,  279,   -1,  281,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  123,   -1,   -1,  126,   -1,  368,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   33,   -1,   -1,  279, 
           -1,   -1,   -1,   40,   -1,   -1,   -1,   -1,   -1,   46, 
           -1,   -1,   -1,   -1,  294,  295,  296,  297,  298,   -1, 
          368,   -1,   59,   60,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,   -1,  349, 
           -1,   -1,  343,  344,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  123,   -1,  368,  126, 
           -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   -1,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,   -1,   -1,  284,  285,  286,  287,  288,  289,  290, 
           -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,  317,  318,  319,   -1, 
           -1,  322,   -1,  324,  325,   -1,   -1,   -1,   93,   94, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,  340, 
           -1,   -1,   -1,   -1,  345,  346,  347,   -1,   -1,  350, 
          351,  352,  353,   -1,  355,   -1,   -1,  358,  359,  360, 
          361,  362,  363,  364,   -1,  366,  367,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,   -1,  269,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1, 
           -1,   -1,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,   -1,  324,  325,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,  340,   -1,   10,   -1,   -1,  345,  346, 
          347,   -1,   -1,  350,  351,  352,  353,   -1,  355,   -1, 
           -1,  358,  359,  360,  361,  362,  363,  364,   33,  366, 
          367,   -1,   -1,   -1,   -1,   40,   -1,   -1,   -1,   -1, 
           -1,   46,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   60,   -1,   -1,   -1,   -1, 
           -1,   -1,  287,  288,  289,  290,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  303,  304, 
          305,  306,   -1,   -1,   -1,  310,   91,  312,  313,  314, 
          315,  316,  317,   -1,   -1,   -1,   -1,  322,   -1,   -1, 
           -1,  326,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,  340,   -1,   10,  123,   -1, 
           -1,  126,  347,   -1,   -1,  350,   -1,  352,  353,   -1, 
          355,  356,   -1,  358,  359,  360,  361,  362,  363,  364, 
           33,  366,  367,   -1,   -1,   -1,   -1,   40,   -1,   -1, 
           -1,   -1,   -1,   46,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   60,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   37,   38,   -1,   -1,   -1,   42,   43,   91,   45, 
           -1,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   60,   -1,   62,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  126,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   94,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   -1,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   -1,  124,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1,   -1,   33,  299,  300,  301,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,   -1,  324, 
          325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
          345,  346,  347,   -1,   -1,  350,  351,  352,  353,   -1, 
          355,   -1,   -1,  358,  359,  360,  361,  362,  363,  364, 
           -1,  366,  367,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,  126,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,   -1,   -1, 
          293,   -1,   -1,   -1,   -1,   -1,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,  317,  318,  319,   10,   -1,  322, 
           -1,  324,  325,  279,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,  340,   -1,   -1, 
           33,   -1,  345,  346,  347,   -1,   -1,  350,  351,  352, 
          353,   -1,  355,   46,   -1,  358,  359,  360,  361,  362, 
          363,  364,   -1,  366,  367,   -1,   59,   60,   -1,   -1, 
          326,  327,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,   -1,   -1,   -1,   -1,  343,  344,   -1, 
           -1,   -1,   -1,  349,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   10, 
           -1,   -1,   -1,  126,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1, 
          300,   -1,   33,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,   -1,  324,  325,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,   -1, 
          350,  351,  352,  353,   -1,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,  364,   -1,  366,  367,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  126,   41,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,   -1,   94, 
          293,   -1,   -1,   -1,   -1,   -1,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,  322, 
           -1,  324,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,  340,   -1,   -1, 
           -1,   -1,  345,  346,  347,   -1,   -1,  350,  351,  352, 
          353,   -1,  355,   -1,   -1,  358,  359,  360,  361,  362, 
          363,  364,   -1,  366,  367,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,   -1, 
           -1,   -1,   -1,  284,  285,  286,  287,  288,  289,  290, 
           -1,   -1,  293,   -1,   -1,   -1,   10,   -1,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,  317,  318,  319,   33, 
           -1,  322,   -1,  324,  325,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,  340, 
           -1,   -1,   -1,   -1,   -1,   59,  347,   61,   -1,  350, 
          351,  352,  353,   -1,  355,   -1,   -1,  358,  359,  360, 
          361,  362,  363,  364,   -1,  366,  367,   -1,   -1,   -1, 
           -1,   -1,  287,  288,  289,  290,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  303,  304, 
          305,  306,   -1,   -1,   -1,  310,   -1,  312,  313,  314, 
          315,  316,  317,   -1,   -1,   -1,   -1,  322,   10,   -1, 
           -1,  326,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           -1,   33,  347,   -1,   -1,  350,   -1,  352,  353,   -1, 
          355,  356,   -1,  358,  359,  360,  361,  362,  363,  364, 
           -1,  366,  367,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   37,   38,   -1,   -1,   -1,   42,   43,   -1,   45, 
           -1,   47,   -1,   -1,  126,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   60,   -1,   62,   63,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           94,   -1,  284,  285,  286,  287,  288,  289,  290,   -1, 
           -1,  293,   -1,   -1,   -1,   -1,   -1,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          124,  313,  314,  315,  316,  317,  318,  319,   -1,   -1, 
          322,   -1,  324,  325,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,   -1,   -1,  350,  351, 
          352,  353,   33,  355,   -1,   -1,  358,  359,  360,  361, 
          362,  363,  364,   -1,  366,  367,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,   59,  269, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,  299, 
          300,  301,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,   -1,  324,  325,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,  126,   -1,   -1,   -1,  339, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,   -1, 
          350,  351,  352,  353,   33,  355,   -1,   -1,  358,  359, 
          360,  361,  362,  363,  364,   -1,  366,  367,   -1,   -1, 
           -1,   -1,   -1,   -1,  298,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  326,  327,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,   -1,   -1,   -1,   -1,  343, 
          344,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   37,   38,   -1,   -1,   -1,   42, 
           43,   -1,   45,   -1,   47,   -1,  125,  126,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   60,   -1,   62, 
           63,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   -1,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   94,   -1,  284,  285,  286,  287,  288,  289,  290, 
           -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  124,  313,  314,  315,  316,  317,  318,  319,   -1, 
           -1,  322,   10,  324,  325,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,  340, 
           -1,   -1,   -1,   -1,   -1,   33,  347,   -1,   -1,  350, 
          351,  352,  353,   -1,  355,   -1,   -1,  358,  359,  360, 
          361,  362,  363,  364,   -1,  366,  367,  256,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,   -1,  284,  285,  286,  287,  288, 
          289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1, 
          299,  300,  301,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,  317,  318, 
          319,   -1,   -1,  322,   10,  324,  325,   -1,  126,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,  340,   -1,   -1,   -1,   -1,   -1,   33,  347,   -1, 
           -1,  350,  351,  352,  353,   -1,  355,   -1,   -1,  358, 
          359,  360,  361,  362,  363,  364,   -1,  366,  367,   -1, 
           -1,   -1,   -1,   59,   -1,  298,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  326,  327,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,   -1,   -1,   -1,   -1, 
          343,  344,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
          126,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1, 
           -1,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,  322,   -1,  324,  325,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
           -1,  126,  350,  351,  352,  353,   -1,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,  364,   -1,  366,  367, 
           33,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,   -1,   -1,  293,   -1,   -1, 
           -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,  322,   -1,  324,  325, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,   -1,  126,  350,  351,  352,  353,   -1,   -1, 
           -1,   -1,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  257,  258,  259,   -1,  261,   33,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,   -1,  324, 
          325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,   -1,   -1,  350,  351,  352,  353,   -1, 
          126,   -1,   -1,  358,  359,  360,  361,  362,  363,  364, 
           -1,  366,  367,  256,  257,  258,  259,  260,  261,   -1, 
           33,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,   -1,   -1, 
          293,   -1,   -1,   -1,   -1,   -1,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,  322, 
           -1,  324,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,   -1,   -1,  350,  351,  352, 
          353,   -1,  355,  126,   -1,  358,  359,  360,  361,  362, 
          363,  364,   -1,  366,  367,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,   -1,   -1,  293,   -1,   -1, 
           -1,   -1,   -1,  299,  300,  301,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   33,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,  322,   -1,  324,  325, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,  339,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,   -1,   -1,  350,  351,  352,  353,   -1,  355, 
           -1,   -1,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,   -1,  256,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,   -1,  126, 
          293,   -1,   -1,   -1,   -1,   -1,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   33, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,  322, 
           -1,  324,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,  339,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,   -1,   -1,  350,  351,  352, 
          353,   -1,  355,   -1,   -1,  358,  359,  360,  361,  362, 
          363,  364,   -1,  366,  367,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,  260,  261,   -1,   33,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1, 
           -1,   -1,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,   -1,  324,  325,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,   -1,   -1,  350,  351,  352,  353,   -1,  355,  126, 
           -1,  358,  359,  360,  361,  362,  363,  364,   -1,  366, 
          367,   -1,   -1,  257,  258,  259,  260,  261,   -1,   33, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,  299,  300,  301,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,   -1, 
          324,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,   -1,   -1,  350,  351,  352,  353, 
           -1,  355,  126,   -1,  358,  359,  360,  361,  362,  363, 
          364,   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,  260,  261,   -1,   33,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1, 
           -1,   -1,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,   -1,  324,  325,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,   -1,   -1,  350,  351,  352,  353,   -1,  355,  126, 
           -1,  358,  359,  360,  361,  362,  363,  364,   -1,  366, 
          367,   -1,   -1,  257,  258,  259,  260,  261,   -1,   33, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,  299,  300,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,   -1, 
          324,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,   -1,   -1,  350,  351,  352,  353, 
           -1,  355,  126,   -1,  358,  359,  360,  361,  362,  363, 
          364,   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   33,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1, 
           -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,   -1,  324,  325,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,   -1,   -1,  350,  351,  352,  353,   -1,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,  364,   -1,  366, 
          367,   -1,   -1,  257,  258,  259,  126,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   33,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,   -1, 
          324,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,   -1,   -1,  350,  351,  352,  353, 
           -1,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
          364,   -1,  366,  367,   -1,   -1,   -1,   -1,  126,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   33,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,   -1,  324,  325,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,  126, 
          350,  351,  352,  353,   -1,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,  364,   -1,  366,  367,   33,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1, 
           -1,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,  322,   -1,  324,  325,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
           -1,  126,  350,  351,  352,  353,   -1,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,  364,   -1,  366,  367, 
          257,  258,  259,   -1,  261,   -1,   -1,   33,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1, 
           -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,   -1,  324,  325,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,   -1,   -1,  350,  351,  352,  353,   -1,  355,  356, 
          126,  358,  359,  360,  361,  362,  363,  364,   -1,  366, 
          367,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   33,   -1,   -1,   -1,   -1,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,   -1,  324, 
          325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,   -1,   -1,  350,  351,  352,  353,   -1, 
           -1,  356,  357,  358,  359,  360,  361,  362,  363,  364, 
           -1,  366,  367,   -1,   -1,   -1,   -1,  126,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   33,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,   -1,   -1,  293,   -1,   -1, 
           -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,  322,   -1,  324,  325, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,   -1,   -1,  350,  351,  352,  353,   -1,  355, 
          356,   -1,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,   -1,   -1,   -1,   -1,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,   -1,   33,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,   -1,  284,  285,  286,  287,  288, 
          289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1, 
           -1,  300,   -1,   -1,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,   -1,   -1,  322,   -1,  324,  325,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,   -1, 
           -1,  350,  351,  352,  353,   -1,   -1,  356,  126,  358, 
          359,  360,  361,  362,  363,  364,   -1,  366,  367,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   33,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,   -1,  324,  325,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,  126, 
          350,  351,  352,  353,   -1,  355,   -1,   -1,  358,  359, 
          360,  361,  362,  363,  364,   -1,  366,  367,   33,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1, 
           -1,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,  322,   -1,  324,  325,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
           -1,  126,  350,  351,  352,  353,   -1,  355,   -1,   -1, 
          358,  359,  360,  361,  362,  363,  364,   -1,  366,  367, 
          257,  258,  259,   -1,  261,   -1,   33,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1, 
           -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,   -1,  324,  325,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,   -1,   -1,  350,  351,  352,  353,   -1,  355,  126, 
           -1,  358,  359,  360,  361,  362,  363,  364,   -1,  366, 
          367,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   33, 
          265,  266,   -1,   -1,   -1,  270,   40,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,   -1,  324, 
          325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,   -1,   -1,  350,  351,  352,  353,   -1, 
          355,   -1,  126,  358,  359,  360,  361,  362,  363,  364, 
           -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   33,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1, 
           -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,   -1,  324,  325,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,   -1,   -1,  350,  351,  352,  353,   -1,  355,  126, 
           -1,  358,  359,  360,  361,  362,  363,  364,   -1,  366, 
          367,   -1,   -1,  257,  258,  259,   -1,  261,   33,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,   -1, 
          324,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,   -1,   -1,  350,  351,  352,  353, 
           -1,  126,   -1,   -1,  358,  359,  360,  361,  362,  363, 
          364,   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   33, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1, 
           -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,   -1,  324,  325,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,   -1,  126,  350,  351,  352,  353,   -1,  355,   -1, 
           -1,  358,  359,  360,  361,  362,  363,  364,   -1,  366, 
          367,   33,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,   -1,  324, 
          325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,   -1,  126,  350,  351,  352,  353,   -1, 
           -1,   -1,   -1,  358,  359,  360,  361,  362,  363,  364, 
           -1,  366,  367,  257,  258,  259,   -1,  261,   33,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,   -1, 
          324,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,   -1,   -1,  350,  351,  352,  353, 
           -1,  126,   -1,   -1,  358,  359,  360,  361,  362,  363, 
          364,   -1,  366,  367,   -1,  257,  258,  259,   -1,  261, 
           33,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,   -1,  284,  285,  286,  287,  288,  289,  290,   -1, 
           -1,  293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1, 
           -1,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,  317,  318,  319,   -1,   -1, 
          322,   -1,  324,  325,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,   -1,   -1,  350,  351, 
          352,  353,   -1,  126,   -1,   -1,  358,  359,  360,  361, 
          362,  363,  364,   -1,  366,  367,   -1,   -1,   -1,   -1, 
           -1,   33,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,   -1,  324, 
          325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,   -1,  126,  350,  351,  352,  353,   -1, 
           -1,   -1,   -1,  358,  359,  360,  361,  362,  363,  364, 
           -1,  366,  367,   -1,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,   -1,   -1, 
          293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,  322, 
           -1,  324,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,   -1,   -1,  350,  351,  352, 
          353,   94,   -1,   -1,   -1,  358,  359,  360,  361,  362, 
          363,  364,   -1,  366,  367,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,   -1,  284,  285,  286,  287,  288,  289,  290,   -1, 
           -1,  293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1, 
           -1,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,  317,  318,  319,   -1,   -1, 
          322,   -1,  324,  325,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,   -1,   -1,  350,  351, 
          352,  353,   -1,   -1,   -1,   -1,  358,  359,  360,  361, 
          362,  363,  364,   33,  366,  367,   -1,   37,   38,   -1, 
           -1,   -1,   42,   43,   -1,   45,   -1,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           60,   -1,   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   94,   -1,   96,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  287,  288,  289,  290,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          303,  304,  305,  306,  124,   -1,  126,  310,   -1,  312, 
          313,  314,  315,  316,  317,   -1,   33,   -1,   -1,  322, 
           37,   38,   -1,  326,   -1,   42,   43,   -1,   45,   -1, 
           47,   -1,   -1,   -1,   -1,   -1,  339,  340,   -1,   -1, 
           -1,   -1,   -1,   60,  347,   62,   -1,  350,   -1,  352, 
          353,   -1,  355,  356,   -1,  358,  359,  360,  361,  362, 
          363,  364,   -1,  366,  367,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   94,   -1,   96, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,   -1,  126, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,   -1,   -1,   -1,   -1,   -1,  299, 
          300,  301,  302,  303,  304,  305,  306,  307,  308,   -1, 
          310,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  341,  342,  343,  344,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  355,  356,   -1,   -1,  359, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,   94,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,   -1,   -1,   -1, 
           -1,   -1,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,  341,  342,  343,  344,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,  355,  356, 
           37,   38,  359,   40,   -1,   42,   43,   -1,   45,   -1, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   60,   -1,   62,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   94,   -1,   96, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,   -1,  126, 
           -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1, 
           37,   38,   -1,   -1,   -1,   42,   43,   -1,   45,   -1, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  287, 
          288,  289,  290,   60,   -1,   62,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  303,  304,  305,  306,   -1, 
           -1,   -1,  310,   -1,   -1,  313,  314,  315,  316,  317, 
           -1,   -1,   -1,   -1,  322,   -1,   -1,   94,   -1,   96, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
           -1,   -1,  350,   -1,  352,  353,   -1,  124,   -1,  126, 
          358,  359,  360,  361,  362,  363,  364,   -1,  366,  367, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,   -1,   -1,   -1, 
           -1,   -1,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,  341,  342,  343,  344,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  355,  356, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,   -1,   -1,   -1, 
           -1,   -1,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,  341,  342,  343,  344,   -1,   -1, 
           -1,   33,   -1,   -1,   -1,   37,   38,   -1,  355,  356, 
           42,   43,   -1,   45,   -1,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   60,   -1, 
           62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   94,   -1,   96,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,  124,  270,  126,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   44,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1, 
           -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,   -1,   -1,  350,  351,  352,  353,   -1,   -1,   -1, 
           -1,  358,  359,  360,  361,  362,  363,  364,   33,  366, 
          367,   -1,   37,   38,   -1,   40,   -1,   42,   43,   -1, 
           45,   -1,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   60,   -1,   62,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,  279,  280,   94, 
           -1,   96,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,   -1,   -1,   -1,   -1,   -1,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,   -1,   -1,  310,  124, 
           -1,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341, 
          342,  343,  344,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  355,  356,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,   -1, 
          350,  351,  352,  353,   -1,   -1,   -1,   -1,  358,  359, 
          360,  361,  362,  363,  364,   -1,  366,  367,   -1,   -1, 
           -1,   33,   -1,   -1,   -1,   37,   38,   -1,   40,   -1, 
           42,   43,   -1,   45,   -1,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   60,   -1, 
           62,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   -1,   -1, 
          335,  336,   94,   -1,   96,   -1,  341,  342,  343,  344, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33, 
          355,  356,   -1,   37,   38,   -1,   40,   -1,   42,   43, 
           -1,   45,  124,   47,  126,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   60,   -1,   62,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1, 
           -1,   -1,   37,   38,   -1,   40,   -1,   42,   43,   -1, 
           45,   -1,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           94,   -1,   96,   -1,   -1,   60,   -1,   62,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1, 
           -1,   37,   38,   -1,   40,   -1,   42,   43,   -1,   45, 
          124,   47,  126,   -1,   -1,   -1,   -1,   -1,   -1,   94, 
           -1,   96,   -1,   -1,   60,   -1,   62,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1, 
           37,   38,   -1,   40,   -1,   42,   43,   -1,   45,  124, 
           47,  126,   -1,   -1,   -1,   -1,   -1,   -1,   94,   -1, 
           96,   -1,   -1,   60,   -1,   62,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,   -1, 
          126,   -1,   -1,   -1,   -1,   -1,   33,   94,   -1,   96, 
           37,   38,   -1,   40,   -1,   42,   43,   -1,   45,   -1, 
           47,   -1,   -1,   -1,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,   -1,   60,   -1,   62,   -1,  124,   -1,  126, 
           -1,   -1,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341, 
          342,  343,  344,   -1,   -1,   -1,   -1,   94,   -1,   96, 
           -1,   -1,   -1,  355,  356,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,   -1,  126, 
           -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,   -1,   -1,   -1,   -1,  341,  342,  343, 
          344,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,   -1, 
           -1,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   -1,   -1, 
          335,  336,   -1,   -1,   -1,   -1,  341,  342,  343,  344, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,   -1,   -1, 
          355,  356,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,   -1,   -1,   -1,   -1,  341,  342,  343,  344,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,   -1,   -1,  355, 
          356,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,  341,  342,  343,  344,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   37,   38,   -1,  355,  356, 
           42,   43,   -1,   45,   -1,   47,   -1,   -1,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,   -1,   60,   -1, 
           62,   63,   -1,   -1,   -1,   -1,   -1,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,  341,  342,  343,  344,   -1,   -1, 
           -1,   -1,   94,   -1,   -1,   -1,   33,   -1,  355,  356, 
           37,   38,   -1,   40,   -1,   42,   43,   -1,   45,   -1, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,   60,   -1,   62,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1,   37, 
           38,   -1,   40,   -1,   42,   43,   -1,   45,   -1,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   94,   -1,   96, 
           -1,   -1,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   33,   -1,   -1,   -1,   37,   38, 
           -1,   40,   -1,   42,   43,   -1,   45,  124,   47,  126, 
           -1,   -1,   -1,   -1,   -1,   -1,   94,   -1,   96,   -1, 
           -1,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   33,   -1,   -1,   -1,   37,   38,   -1, 
           40,   -1,   42,   43,   -1,   45,  124,   47,  126,   -1, 
           -1,   -1,   -1,   -1,   -1,   94,   -1,   96,   -1,   -1, 
           60,   -1,   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   33,   -1,   -1,   -1,   37,   38,   -1,   40, 
           -1,   42,   43,   -1,   45,  124,   47,  126,   -1,   -1, 
           -1,   -1,   -1,   -1,   94,   -1,   96,   -1,   -1,   60, 
           -1,   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   33,   -1,   -1,   -1,   37,   38,   -1,   40,   -1, 
           42,   43,   -1,   45,  124,   47,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,   94,   -1,   96,   -1,   -1,   60,   -1, 
           62,   -1,   -1,   -1,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,   -1,   -1,   -1, 
           -1,  343,  344,  124,   -1,  126,   -1,   -1,   -1,   -1, 
           -1,   -1,   94,   -1,   96,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,   -1,  126,   -1,   -1,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,  341,  342,  343,  344,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,   -1,   -1,  355,  356, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   -1,   -1,  335,  336,   -1, 
           -1,   -1,   -1,  341,  342,  343,  344,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,   -1,   -1,  355,  356,   -1, 
           -1,   -1,   -1,   -1,   -1,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,   -1,   -1, 
           -1,   -1,  341,  342,  343,  344,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,   -1,   -1,  355,  356,   -1,   -1, 
           -1,   -1,   -1,   -1,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  341,  342,  343,  344,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,   -1,   -1,  355,  356,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   94,  335,  336,   -1,   -1,   -1,   -1, 
          341,  342,  343,  344,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,   -1,   -1,  355,  356,   -1,   -1,   -1,   -1, 
           -1,   -1,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341, 
          342,  343,  344,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   33,   -1,  355,  356,   37,   38,   -1,   40,   -1, 
           42,   43,   -1,   45,   -1,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   60,   -1, 
           62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           33,   -1,   -1,   -1,   37,   38,   -1,   40,   -1,   42, 
           43,   -1,   45,   -1,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   94,   -1,   96,   -1,   -1,   60,   -1,   62, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33, 
           -1,   -1,   -1,   37,   38,   -1,   -1,   -1,   42,   43, 
           -1,   45,  124,   47,  126,   -1,   -1,   -1,   -1,   -1, 
           -1,   94,   -1,   96,   -1,   -1,   60,   -1,   62,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   37,   38, 
           -1,   -1,   -1,   42,   43,   -1,   45,   -1,   47,   -1, 
           -1,  124,   -1,  126,   -1,   -1,  287,  288,  289,  290, 
           94,   60,   96,   62,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  303,  304,  305,  306,   -1,   -1,   -1,  310, 
           -1,   -1,  313,  314,  315,  316,  317,   -1,   -1,   -1, 
          124,  322,  126,   -1,   -1,   94,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,  340, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,   -1,  350, 
           -1,  352,  353,   -1,  355,  124,   -1,  358,  359,  360, 
          361,  362,  363,  364,   -1,  366,  367,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341, 
          342,  343,  344,  306,  307,   -1,   -1,  310,   -1,   -1, 
           -1,   -1,   -1,  355,  356,   -1,   -1,   -1,   -1,   -1, 
           -1,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341,  342, 
          343,  344,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
           -1,   -1,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,  298, 
           -1,  335,  336,   -1,   -1,   -1,   -1,  341,  342,  343, 
          344,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  355,  356,   -1,   -1,   -1,   -1,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
          287,  288,  289,  290,  343,  344,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  303,  304,  305,  306, 
           -1,   -1,   -1,  310,   -1,   -1,  313,  314,  315,  316, 
          317,   -1,   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,   -1,   -1,  350,   -1,  352,  353,   -1,  355,   -1, 
           -1,  358,  359,  360,  361,  362,  363,  364,   -1,  366, 
          367,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,   -1,   -1,  293,   -1,   -1, 
           -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,  322,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,   -1,   -1,  350,  351,  352,  353,   -1,  355, 
           -1,   -1,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  343,   -1, 
           -1,   -1,  347,   -1,   -1,  350,  351,  352,  353,   -1, 
           -1,   -1,   -1,  358,  359,  360,  361,  362,  363,  364, 
           -1,  366,  367,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,   -1,   -1,  350,  351,  352,  353, 
           -1,  355,   -1,   -1,  358,  359,  360,  361,  362,  363, 
          364,   -1,  366,  367,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,   -1,   -1, 
          293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,  322, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,   -1,   -1,  350,  351,  352, 
          353,   -1,   -1,   -1,   -1,  358,  359,  360,  361,  362, 
          363,  364,   -1,  366,  367,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,   -1,  284,  285,  286,  287,  288,  289,  290,   -1, 
           -1,  293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1, 
           -1,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,  317,  318,  319,   -1,   -1, 
          322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,   -1,   -1,  350,  351, 
          352,  353,   -1,   -1,   -1,   -1,  358,  359,  360,  361, 
          362,  363,  364,   -1,  366,  367,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,   -1,  284,  285,  286,  287,  288,  289,  290, 
           -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1,  300, 
           -1,   -1,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,  317,  318,  319,   -1, 
           -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,   -1,  350, 
          351,  352,  353,   -1,   -1,   -1,   -1,  358,  359,  360, 
          361,  362,  363,  364,   -1,  366,  367,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,   -1, 
          350,  351,  352,  353,   -1,   -1,   -1,   -1,  358,  359, 
          360,  361,  362,  363,  364,   -1,  366,  367, 
      };
   }

}
