Jsonm — Non-blocking streaming JSON codec for OCaml
-------------------------------------------------------------------------------
v1.0.2

Jsonm is a non-blocking streaming codec to decode and encode the JSON
data format. It can process JSON text without blocking on IO and
without a complete in-memory representation of the data.

The alternative "uncut" codec also processes whitespace and
(non-standard) JSON with JavaScript comments.

Jsonm is made of a single module and depends on [Uutf][uutf]. It is distributed
under the ISC license.

[uutf]: http://erratique.ch/software/uutf

Home page: http://erratique.ch/software/jsonm  
Contact: Daniel Bünzli `<daniel.buenzl i@erratique.ch>`


## Installation

Jsonm can be installed with `opam`:

    opam install jsonm

If you don't use `opam` consult the [`opam`](opam) file for build
instructions.


## Documentation

The documentation and API reference is automatically generated by
`ocamldoc` from the interfaces. It can be consulted [online][doc]
and there is a generated version in the `doc` directory of the
distribution.

[doc]: http://erratique.ch/software/jsonm/doc/Jsonm


## Sample programs

If you installed jsonm with `opam`, it installed the `jsontrip` binary
which, among other things, reads JSON on `stdin` and rewrites it on
`stdout`; invoke with `-help` for more information. Sample code is
located in the directory `opam config var jsonm:doc`.

In the distribution sample programs are located in the `test`
directory of the distribution. They can be built with:

    ocamlbuild -use-ocamlfind test/tests.otarget

The resulting binaries are in `_build/test`.
