/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// VmAddDevice struct for VmAddDevice
type VmAddDevice struct {
	Path  *string `json:"path,omitempty"`
	Iommu *bool   `json:"iommu,omitempty"`
	Id    *string `json:"id,omitempty"`
}

// NewVmAddDevice instantiates a new VmAddDevice object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewVmAddDevice() *VmAddDevice {
	this := VmAddDevice{}
	var iommu bool = false
	this.Iommu = &iommu
	return &this
}

// NewVmAddDeviceWithDefaults instantiates a new VmAddDevice object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewVmAddDeviceWithDefaults() *VmAddDevice {
	this := VmAddDevice{}
	var iommu bool = false
	this.Iommu = &iommu
	return &this
}

// GetPath returns the Path field value if set, zero value otherwise.
func (o *VmAddDevice) GetPath() string {
	if o == nil || o.Path == nil {
		var ret string
		return ret
	}
	return *o.Path
}

// GetPathOk returns a tuple with the Path field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VmAddDevice) GetPathOk() (*string, bool) {
	if o == nil || o.Path == nil {
		return nil, false
	}
	return o.Path, true
}

// HasPath returns a boolean if a field has been set.
func (o *VmAddDevice) HasPath() bool {
	if o != nil && o.Path != nil {
		return true
	}

	return false
}

// SetPath gets a reference to the given string and assigns it to the Path field.
func (o *VmAddDevice) SetPath(v string) {
	o.Path = &v
}

// GetIommu returns the Iommu field value if set, zero value otherwise.
func (o *VmAddDevice) GetIommu() bool {
	if o == nil || o.Iommu == nil {
		var ret bool
		return ret
	}
	return *o.Iommu
}

// GetIommuOk returns a tuple with the Iommu field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VmAddDevice) GetIommuOk() (*bool, bool) {
	if o == nil || o.Iommu == nil {
		return nil, false
	}
	return o.Iommu, true
}

// HasIommu returns a boolean if a field has been set.
func (o *VmAddDevice) HasIommu() bool {
	if o != nil && o.Iommu != nil {
		return true
	}

	return false
}

// SetIommu gets a reference to the given bool and assigns it to the Iommu field.
func (o *VmAddDevice) SetIommu(v bool) {
	o.Iommu = &v
}

// GetId returns the Id field value if set, zero value otherwise.
func (o *VmAddDevice) GetId() string {
	if o == nil || o.Id == nil {
		var ret string
		return ret
	}
	return *o.Id
}

// GetIdOk returns a tuple with the Id field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VmAddDevice) GetIdOk() (*string, bool) {
	if o == nil || o.Id == nil {
		return nil, false
	}
	return o.Id, true
}

// HasId returns a boolean if a field has been set.
func (o *VmAddDevice) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// SetId gets a reference to the given string and assigns it to the Id field.
func (o *VmAddDevice) SetId(v string) {
	o.Id = &v
}

func (o VmAddDevice) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Path != nil {
		toSerialize["path"] = o.Path
	}
	if o.Iommu != nil {
		toSerialize["iommu"] = o.Iommu
	}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}
	return json.Marshal(toSerialize)
}

type NullableVmAddDevice struct {
	value *VmAddDevice
	isSet bool
}

func (v NullableVmAddDevice) Get() *VmAddDevice {
	return v.value
}

func (v *NullableVmAddDevice) Set(val *VmAddDevice) {
	v.value = val
	v.isSet = true
}

func (v NullableVmAddDevice) IsSet() bool {
	return v.isSet
}

func (v *NullableVmAddDevice) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableVmAddDevice(val *VmAddDevice) *NullableVmAddDevice {
	return &NullableVmAddDevice{value: val, isSet: true}
}

func (v NullableVmAddDevice) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableVmAddDevice) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
