#---------------------------------------------------------------------------------------
# Bundle: KLayoutHomebrew.app
#
# Descriptions:
#  This script invokes "klayout.app" that shares the Homebrew development environment.
#  More precisely, it uses the Qt5, Ruby, and Python packages of Homebrew installed in
#  the standard location.
#---------------------------------------------------------------------------------------

#--------------------------------------------------------------------------
# Localizing the language
# Workaround discussed in https://github.com/KLayout/klayout/issues/1213
#--------------------------------------------------------------------------
export LANG=$(defaults read -g AppleLocale).UTF-8

#--------------------------------------------------------------------------
# Your setups
#--------------------------------------------------------------------------

#--------------------------------------------------------------------------
# Export the 'PYTHONHOME' environment variable if required
#--------------------------------------------------------------------------
#export PYTHONHOME=

#--------------------------------------------------------------------------
# With "-n" option, you can invoke multiple instances
#--------------------------------------------------------------------------
myklayout=/Applications/klayout.app
myconfig=$HOME/.klayout/klayoutrc

open -n -a $myklayout --args -e -c $myconfig -style=fusion $@
