
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDataWidgetMapper.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QDataWidgetMapper>
#include <QAbstractItemDelegate>
#include <QAbstractItemModel>
#include <QChildEvent>
#include <QEvent>
#include <QModelIndex>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDataWidgetMapper

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QDataWidgetMapper::staticMetaObject);
}


// void QDataWidgetMapper::addMapping(QWidget *widget, int section)


static void _init_f_addMapping_1974 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("section");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addMapping_1974 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->addMapping (arg1, arg2);
}


// void QDataWidgetMapper::addMapping(QWidget *widget, int section, const QByteArray &propertyName)


static void _init_f_addMapping_4175 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("section");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("propertyName");
  decl->add_arg<const QByteArray & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addMapping_4175 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QByteArray &arg3 = gsi::arg_reader<const QByteArray & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->addMapping (arg1, arg2, arg3);
}


// void QDataWidgetMapper::clearMapping()


static void _init_f_clearMapping_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearMapping_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->clearMapping ();
}


// int QDataWidgetMapper::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDataWidgetMapper *)cls)->currentIndex ());
}


// QAbstractItemDelegate *QDataWidgetMapper::itemDelegate()


static void _init_f_itemDelegate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_f_itemDelegate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QDataWidgetMapper *)cls)->itemDelegate ());
}


// QByteArray QDataWidgetMapper::mappedPropertyName(QWidget *widget)


static void _init_f_mappedPropertyName_c1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_mappedPropertyName_c1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  ret.write<QByteArray > ((QByteArray)((QDataWidgetMapper *)cls)->mappedPropertyName (arg1));
}


// int QDataWidgetMapper::mappedSection(QWidget *widget)


static void _init_f_mappedSection_c1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_mappedSection_c1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  ret.write<int > ((int)((QDataWidgetMapper *)cls)->mappedSection (arg1));
}


// QWidget *QDataWidgetMapper::mappedWidgetAt(int section)


static void _init_f_mappedWidgetAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_mappedWidgetAt_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QWidget * > ((QWidget *)((QDataWidgetMapper *)cls)->mappedWidgetAt (arg1));
}


// QAbstractItemModel *QDataWidgetMapper::model()


static void _init_f_model_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemModel * > ();
}

static void _call_f_model_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractItemModel * > ((QAbstractItemModel *)((QDataWidgetMapper *)cls)->model ());
}


// Qt::Orientation QDataWidgetMapper::orientation()


static void _init_f_orientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::Orientation>::target_type > ();
}

static void _call_f_orientation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::Orientation>::target_type > ((qt_gsi::Converter<Qt::Orientation>::target_type)qt_gsi::CppToQtAdaptor<Qt::Orientation>(((QDataWidgetMapper *)cls)->orientation ()));
}


// void QDataWidgetMapper::removeMapping(QWidget *widget)


static void _init_f_removeMapping_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeMapping_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->removeMapping (arg1);
}


// void QDataWidgetMapper::revert()


static void _init_f_revert_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_revert_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->revert ();
}


// QModelIndex QDataWidgetMapper::rootIndex()


static void _init_f_rootIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QModelIndex > ();
}

static void _call_f_rootIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QModelIndex > ((QModelIndex)((QDataWidgetMapper *)cls)->rootIndex ());
}


// void QDataWidgetMapper::setCurrentIndex(int index)


static void _init_f_setCurrentIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentIndex_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->setCurrentIndex (arg1);
}


// void QDataWidgetMapper::setCurrentModelIndex(const QModelIndex &index)


static void _init_f_setCurrentModelIndex_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentModelIndex_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->setCurrentModelIndex (arg1);
}


// void QDataWidgetMapper::setItemDelegate(QAbstractItemDelegate *delegate)


static void _init_f_setItemDelegate_2717 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("delegate");
  decl->add_arg<QAbstractItemDelegate * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemDelegate_2717 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemDelegate *arg1 = gsi::arg_reader<QAbstractItemDelegate * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->setItemDelegate (arg1);
}


// void QDataWidgetMapper::setModel(QAbstractItemModel *model)


static void _init_f_setModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModel_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->setModel (arg1);
}


// void QDataWidgetMapper::setOrientation(Qt::Orientation aOrientation)


static void _init_f_setOrientation_1913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("aOrientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrientation_1913 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->setOrientation (qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg1).cref());
}


// void QDataWidgetMapper::setRootIndex(const QModelIndex &index)


static void _init_f_setRootIndex_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRootIndex_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->setRootIndex (arg1);
}


// void QDataWidgetMapper::setSubmitPolicy(QDataWidgetMapper::SubmitPolicy policy)


static void _init_f_setSubmitPolicy_3488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSubmitPolicy_3488 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->setSubmitPolicy (qt_gsi::QtToCppAdaptor<QDataWidgetMapper::SubmitPolicy>(arg1).cref());
}


// bool QDataWidgetMapper::submit()


static void _init_f_submit_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_submit_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDataWidgetMapper *)cls)->submit ());
}


// QDataWidgetMapper::SubmitPolicy QDataWidgetMapper::submitPolicy()


static void _init_f_submitPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type > ();
}

static void _call_f_submitPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type > ((qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type)qt_gsi::CppToQtAdaptor<QDataWidgetMapper::SubmitPolicy>(((QDataWidgetMapper *)cls)->submitPolicy ()));
}


// void QDataWidgetMapper::toFirst()


static void _init_f_toFirst_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toFirst_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->toFirst ();
}


// void QDataWidgetMapper::toLast()


static void _init_f_toLast_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toLast_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->toLast ();
}


// void QDataWidgetMapper::toNext()


static void _init_f_toNext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toNext_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->toNext ();
}


// void QDataWidgetMapper::toPrevious()


static void _init_f_toPrevious_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toPrevious_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper *)cls)->toPrevious ();
}


// static QString QDataWidgetMapper::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QDataWidgetMapper::tr (arg1, arg2));
}


// static QString QDataWidgetMapper::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QDataWidgetMapper::tr (arg1, arg2, arg3));
}


// static QString QDataWidgetMapper::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QDataWidgetMapper::trUtf8 (arg1, arg2));
}


// static QString QDataWidgetMapper::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QDataWidgetMapper::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QDataWidgetMapper () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addMapping", "@brief Method void QDataWidgetMapper::addMapping(QWidget *widget, int section)\n", false, &_init_f_addMapping_1974, &_call_f_addMapping_1974);
  methods += new qt_gsi::GenericMethod ("addMapping", "@brief Method void QDataWidgetMapper::addMapping(QWidget *widget, int section, const QByteArray &propertyName)\n", false, &_init_f_addMapping_4175, &_call_f_addMapping_4175);
  methods += new qt_gsi::GenericMethod ("clearMapping", "@brief Method void QDataWidgetMapper::clearMapping()\n", false, &_init_f_clearMapping_0, &_call_f_clearMapping_0);
  methods += new qt_gsi::GenericMethod (":currentIndex", "@brief Method int QDataWidgetMapper::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
  methods += new qt_gsi::GenericMethod (":itemDelegate", "@brief Method QAbstractItemDelegate *QDataWidgetMapper::itemDelegate()\n", true, &_init_f_itemDelegate_c0, &_call_f_itemDelegate_c0);
  methods += new qt_gsi::GenericMethod ("mappedPropertyName", "@brief Method QByteArray QDataWidgetMapper::mappedPropertyName(QWidget *widget)\n", true, &_init_f_mappedPropertyName_c1315, &_call_f_mappedPropertyName_c1315);
  methods += new qt_gsi::GenericMethod ("mappedSection", "@brief Method int QDataWidgetMapper::mappedSection(QWidget *widget)\n", true, &_init_f_mappedSection_c1315, &_call_f_mappedSection_c1315);
  methods += new qt_gsi::GenericMethod ("mappedWidgetAt", "@brief Method QWidget *QDataWidgetMapper::mappedWidgetAt(int section)\n", true, &_init_f_mappedWidgetAt_c767, &_call_f_mappedWidgetAt_c767);
  methods += new qt_gsi::GenericMethod (":model", "@brief Method QAbstractItemModel *QDataWidgetMapper::model()\n", true, &_init_f_model_c0, &_call_f_model_c0);
  methods += new qt_gsi::GenericMethod (":orientation", "@brief Method Qt::Orientation QDataWidgetMapper::orientation()\n", true, &_init_f_orientation_c0, &_call_f_orientation_c0);
  methods += new qt_gsi::GenericMethod ("removeMapping", "@brief Method void QDataWidgetMapper::removeMapping(QWidget *widget)\n", false, &_init_f_removeMapping_1315, &_call_f_removeMapping_1315);
  methods += new qt_gsi::GenericMethod ("revert", "@brief Method void QDataWidgetMapper::revert()\n", false, &_init_f_revert_0, &_call_f_revert_0);
  methods += new qt_gsi::GenericMethod (":rootIndex", "@brief Method QModelIndex QDataWidgetMapper::rootIndex()\n", true, &_init_f_rootIndex_c0, &_call_f_rootIndex_c0);
  methods += new qt_gsi::GenericMethod ("setCurrentIndex|currentIndex=", "@brief Method void QDataWidgetMapper::setCurrentIndex(int index)\n", false, &_init_f_setCurrentIndex_767, &_call_f_setCurrentIndex_767);
  methods += new qt_gsi::GenericMethod ("setCurrentModelIndex", "@brief Method void QDataWidgetMapper::setCurrentModelIndex(const QModelIndex &index)\n", false, &_init_f_setCurrentModelIndex_2395, &_call_f_setCurrentModelIndex_2395);
  methods += new qt_gsi::GenericMethod ("setItemDelegate|itemDelegate=", "@brief Method void QDataWidgetMapper::setItemDelegate(QAbstractItemDelegate *delegate)\n", false, &_init_f_setItemDelegate_2717, &_call_f_setItemDelegate_2717);
  methods += new qt_gsi::GenericMethod ("setModel|model=", "@brief Method void QDataWidgetMapper::setModel(QAbstractItemModel *model)\n", false, &_init_f_setModel_2419, &_call_f_setModel_2419);
  methods += new qt_gsi::GenericMethod ("setOrientation|orientation=", "@brief Method void QDataWidgetMapper::setOrientation(Qt::Orientation aOrientation)\n", false, &_init_f_setOrientation_1913, &_call_f_setOrientation_1913);
  methods += new qt_gsi::GenericMethod ("setRootIndex|rootIndex=", "@brief Method void QDataWidgetMapper::setRootIndex(const QModelIndex &index)\n", false, &_init_f_setRootIndex_2395, &_call_f_setRootIndex_2395);
  methods += new qt_gsi::GenericMethod ("setSubmitPolicy|submitPolicy=", "@brief Method void QDataWidgetMapper::setSubmitPolicy(QDataWidgetMapper::SubmitPolicy policy)\n", false, &_init_f_setSubmitPolicy_3488, &_call_f_setSubmitPolicy_3488);
  methods += new qt_gsi::GenericMethod ("submit", "@brief Method bool QDataWidgetMapper::submit()\n", false, &_init_f_submit_0, &_call_f_submit_0);
  methods += new qt_gsi::GenericMethod (":submitPolicy", "@brief Method QDataWidgetMapper::SubmitPolicy QDataWidgetMapper::submitPolicy()\n", true, &_init_f_submitPolicy_c0, &_call_f_submitPolicy_c0);
  methods += new qt_gsi::GenericMethod ("toFirst", "@brief Method void QDataWidgetMapper::toFirst()\n", false, &_init_f_toFirst_0, &_call_f_toFirst_0);
  methods += new qt_gsi::GenericMethod ("toLast", "@brief Method void QDataWidgetMapper::toLast()\n", false, &_init_f_toLast_0, &_call_f_toLast_0);
  methods += new qt_gsi::GenericMethod ("toNext", "@brief Method void QDataWidgetMapper::toNext()\n", false, &_init_f_toNext_0, &_call_f_toNext_0);
  methods += new qt_gsi::GenericMethod ("toPrevious", "@brief Method void QDataWidgetMapper::toPrevious()\n", false, &_init_f_toPrevious_0, &_call_f_toPrevious_0);
  methods += gsi::qt_signal<int > ("currentIndexChanged(int)", "currentIndexChanged", gsi::arg("index"), "@brief Signal declaration for QDataWidgetMapper::currentIndexChanged(int index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QDataWidgetMapper::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QDataWidgetMapper::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QDataWidgetMapper::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QDataWidgetMapper::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QDataWidgetMapper::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QDataWidgetMapper> decl_QDataWidgetMapper (qtdecl_QObject (), "QtGui", "QDataWidgetMapper_Native",
  methods_QDataWidgetMapper (),
  "@hide\n@alias QDataWidgetMapper");

GSI_QTGUI_PUBLIC gsi::Class<QDataWidgetMapper> &qtdecl_QDataWidgetMapper () { return decl_QDataWidgetMapper; }

}


class QDataWidgetMapper_Adaptor : public QDataWidgetMapper, public qt_gsi::QtObjectBase
{
public:

  virtual ~QDataWidgetMapper_Adaptor();

  //  [adaptor ctor] QDataWidgetMapper::QDataWidgetMapper(QObject *parent)
  QDataWidgetMapper_Adaptor() : QDataWidgetMapper()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDataWidgetMapper::QDataWidgetMapper(QObject *parent)
  QDataWidgetMapper_Adaptor(QObject *parent) : QDataWidgetMapper(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QDataWidgetMapper::receivers(const char *signal)
  int fp_QDataWidgetMapper_receivers_c1731 (const char *signal) const {
    return QDataWidgetMapper::receivers(signal);
  }

  //  [expose] QObject *QDataWidgetMapper::sender()
  QObject * fp_QDataWidgetMapper_sender_c0 () const {
    return QDataWidgetMapper::sender();
  }

  //  [adaptor impl] bool QDataWidgetMapper::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QDataWidgetMapper::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QDataWidgetMapper_Adaptor, bool, QEvent *>(&QDataWidgetMapper_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QDataWidgetMapper::event(arg1);
    }
  }

  //  [adaptor impl] bool QDataWidgetMapper::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QDataWidgetMapper::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QDataWidgetMapper_Adaptor, bool, QObject *, QEvent *>(&QDataWidgetMapper_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QDataWidgetMapper::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QDataWidgetMapper::setCurrentIndex(int index)
  void cbs_setCurrentIndex_767_0(int index)
  {
    QDataWidgetMapper::setCurrentIndex(index);
  }

  virtual void setCurrentIndex(int index)
  {
    if (cb_setCurrentIndex_767_0.can_issue()) {
      cb_setCurrentIndex_767_0.issue<QDataWidgetMapper_Adaptor, int>(&QDataWidgetMapper_Adaptor::cbs_setCurrentIndex_767_0, index);
    } else {
      QDataWidgetMapper::setCurrentIndex(index);
    }
  }

  //  [adaptor impl] void QDataWidgetMapper::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QDataWidgetMapper::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QDataWidgetMapper_Adaptor, QChildEvent *>(&QDataWidgetMapper_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QDataWidgetMapper::childEvent(arg1);
    }
  }

  //  [emitter impl] void QDataWidgetMapper::currentIndexChanged(int index)
  void emitter_QDataWidgetMapper_currentIndexChanged_767(int index)
  {
    emit QDataWidgetMapper::currentIndexChanged(index);
  }

  //  [adaptor impl] void QDataWidgetMapper::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QDataWidgetMapper::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QDataWidgetMapper_Adaptor, QEvent *>(&QDataWidgetMapper_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QDataWidgetMapper::customEvent(arg1);
    }
  }

  //  [emitter impl] void QDataWidgetMapper::destroyed(QObject *)
  void emitter_QDataWidgetMapper_destroyed_1302(QObject *arg1)
  {
    emit QDataWidgetMapper::destroyed(arg1);
  }

  //  [adaptor impl] void QDataWidgetMapper::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QDataWidgetMapper::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QDataWidgetMapper_Adaptor, const char *>(&QDataWidgetMapper_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QDataWidgetMapper::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QDataWidgetMapper::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QDataWidgetMapper::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QDataWidgetMapper_Adaptor, QTimerEvent *>(&QDataWidgetMapper_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QDataWidgetMapper::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_setCurrentIndex_767_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QDataWidgetMapper_Adaptor::~QDataWidgetMapper_Adaptor() { }

//  Constructor QDataWidgetMapper::QDataWidgetMapper(QObject *parent) (adaptor class)

static void _init_ctor_QDataWidgetMapper_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QDataWidgetMapper_Adaptor> ();
}

static void _call_ctor_QDataWidgetMapper_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QDataWidgetMapper_Adaptor *> (new QDataWidgetMapper_Adaptor (arg1));
}


// void QDataWidgetMapper::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QDataWidgetMapper::currentIndexChanged(int index)

static void _init_emitter_currentIndexChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentIndexChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QDataWidgetMapper_Adaptor *)cls)->emitter_QDataWidgetMapper_currentIndexChanged_767 (arg1);
}


// void QDataWidgetMapper::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QDataWidgetMapper::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QDataWidgetMapper_Adaptor *)cls)->emitter_QDataWidgetMapper_destroyed_1302 (arg1);
}


// void QDataWidgetMapper::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QDataWidgetMapper::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QDataWidgetMapper_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QDataWidgetMapper::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QDataWidgetMapper_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed int QDataWidgetMapper::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QDataWidgetMapper_Adaptor *)cls)->fp_QDataWidgetMapper_receivers_c1731 (arg1));
}


// exposed QObject *QDataWidgetMapper::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QDataWidgetMapper_Adaptor *)cls)->fp_QDataWidgetMapper_sender_c0 ());
}


// void QDataWidgetMapper::setCurrentIndex(int index)

static void _init_cbs_setCurrentIndex_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setCurrentIndex_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper_Adaptor *)cls)->cbs_setCurrentIndex_767_0 (arg1);
}

static void _set_callback_cbs_setCurrentIndex_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_setCurrentIndex_767_0 = cb;
}


// void QDataWidgetMapper::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDataWidgetMapper_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QDataWidgetMapper> &qtdecl_QDataWidgetMapper ();

static gsi::Methods methods_QDataWidgetMapper_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDataWidgetMapper::QDataWidgetMapper(QObject *parent)\nThis method creates an object of class QDataWidgetMapper.", &_init_ctor_QDataWidgetMapper_Adaptor_1302, &_call_ctor_QDataWidgetMapper_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QDataWidgetMapper::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_currentIndexChanged", "@brief Emitter for signal void QDataWidgetMapper::currentIndexChanged(int index)\nCall this method to emit this signal.", false, &_init_emitter_currentIndexChanged_767, &_call_emitter_currentIndexChanged_767);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QDataWidgetMapper::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QDataWidgetMapper::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QDataWidgetMapper::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QDataWidgetMapper::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QDataWidgetMapper::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QDataWidgetMapper::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QDataWidgetMapper::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("setCurrentIndex", "@brief Virtual method void QDataWidgetMapper::setCurrentIndex(int index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setCurrentIndex_767_0, &_call_cbs_setCurrentIndex_767_0);
  methods += new qt_gsi::GenericMethod ("setCurrentIndex", "@hide", false, &_init_cbs_setCurrentIndex_767_0, &_call_cbs_setCurrentIndex_767_0, &_set_callback_cbs_setCurrentIndex_767_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QDataWidgetMapper::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QDataWidgetMapper_Adaptor> decl_QDataWidgetMapper_Adaptor (qtdecl_QDataWidgetMapper (), "QtGui", "QDataWidgetMapper",
  methods_QDataWidgetMapper_Adaptor (),
  "@qt\n@brief Binding of QDataWidgetMapper");

}


//  Implementation of the enum wrapper class for QDataWidgetMapper::SubmitPolicy
namespace qt_gsi
{

static gsi::Enum<QDataWidgetMapper::SubmitPolicy> decl_QDataWidgetMapper_SubmitPolicy_Enum ("QtGui", "QDataWidgetMapper_SubmitPolicy",
    gsi::enum_const ("AutoSubmit", QDataWidgetMapper::AutoSubmit, "@brief Enum constant QDataWidgetMapper::AutoSubmit") +
    gsi::enum_const ("ManualSubmit", QDataWidgetMapper::ManualSubmit, "@brief Enum constant QDataWidgetMapper::ManualSubmit"),
  "@qt\n@brief This class represents the QDataWidgetMapper::SubmitPolicy enum");

static gsi::QFlagsClass<QDataWidgetMapper::SubmitPolicy > decl_QDataWidgetMapper_SubmitPolicy_Enums ("QtGui", "QDataWidgetMapper_QFlags_SubmitPolicy",
  "@qt\n@brief This class represents the QFlags<QDataWidgetMapper::SubmitPolicy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QDataWidgetMapper> inject_QDataWidgetMapper_SubmitPolicy_Enum_in_parent (decl_QDataWidgetMapper_SubmitPolicy_Enum.defs ());
static gsi::ClassExt<QDataWidgetMapper> decl_QDataWidgetMapper_SubmitPolicy_Enum_as_child (decl_QDataWidgetMapper_SubmitPolicy_Enum, "SubmitPolicy");
static gsi::ClassExt<QDataWidgetMapper> decl_QDataWidgetMapper_SubmitPolicy_Enums_as_child (decl_QDataWidgetMapper_SubmitPolicy_Enums, "QFlags_SubmitPolicy");

}

