/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This header file declares the functions for the various event-centric
 * modules, and their related globals, structs, and so forth.
 */

#include "config.h"

/*
 *  Define's for the different event types we might see
 */
#define EVENT_UNKNOWN   0
#define EVENT_SYSLOG    1
#define EVENT_SNORT     2
#define EVENT_SUDO	3

/* a function to handle some of the repetitive work for all sub-modules	*/
short int mod_premsg_setup();
short int mod_varcheck();

/* a declaration for each sub-module type	*/
short int ltm_unknown();
short int ltm_syslog();
short int ltm_iptables();

char *get_host(char *host);

/* for the snort log lines (this one's a bit complicated)	*/
short int ltm_snort();

/* variables to tell us if we're to use the functions in question or not	*/
short int ltm_use_syslog;
short int ltm_use_snort;
short int ltm_use_sudo;
/* "ltm_unknown(); we allways have enabled (otherwise, what's the use?		*/

/* data structs for iptables and snort and so-on for linking in event->special  */
typedef struct {
	char msg[8096];		/* the ASCII of the event */
       /* where we store the src/dest port's and such          */
        char dst[2024], dst_prt[64]; /* destinationIP:port */
        char src[2024], src_prt[64]; /* source IP:port */
        /* various varibles we may/may not fill up below        */
        char sids[512];         /* the SID field */
        char pproc[512];        /* the pre_processor */
        char proto[64];         /* ICMP/UDP/TCP/RAW? */
        char class[512];        /* Classification: field */
        char prior[512];        /* Priority: field */
} SNORT;
SNORT sn;

/* repeat for iptables variables */
typedef struct {
 	char msg[8096];		/* the ASCII of the event */
	/* our variables we hope to collect     */
        char in_if[128];        /* IN=eth1      input interface         */
        char ou_if[128];        /* OUT=eth0     output interface        */
        char src[1024];         /* SRC=ip       source ip address       */
        char dst[1024];         /* DST=ip       destination ip address  */
        char src_prt[32];       /* SPT=src_prt  source port (if any)    */
        char dst_prt[32];       /* DPT=dst_prt  destination port        */
        char plen[64];          /* LEN=len      packet length           */
        char tos[64];           /* TOS=0xxx     type of service         */
        char prec[64];          /* PREC=??      no idea ;)              */
        char ttl[64];           /* TTL=ttl      packet time to live     */
        char proto[64];         /* PROTO=UDP    protocol of datagram    */
} IPTABLES;
IPTABLES it;

/* a wrapper struct so's we can point to structs like the above from 
 * event.* struct (see logtool.h for this struct) */
typedef struct {
	IPTABLES *iptables;
	SNORT *snort;
} MOD;
