/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// Qt includes
#include <QString>
#include <QObject>
#include <QtQml>


/////////////////////// Local includes
#include "pappsomspp/export-import-config.h"
#include "jsclassregistrar.h"
#include "pappsomspp/core/massspectrum/massspectrum.h"


namespace pappso
{

/*  BEGIN CLASS JS REFERENCE
 *  namespace: pappso
 *  class name: MassSpectrum
 */

//! The MassSpectrumJs class provides a JavaScript wrapper around MassSpectrum.
class PMSPP_LIB_DECL MassSpectrumJs : public QObject
{
  Q_OBJECT
  Q_PROPERTY(int size READ getSize NOTIFY sizeChangedSignal)
  QML_NAMED_ELEMENT(MassSpectrum)

  public:
  Q_INVOKABLE explicit MassSpectrumJs(QObject *parent = nullptr);
  ~MassSpectrumJs();

  // Delete assignment operator (QObjects shouldn't be assigned)
  MassSpectrumJs &operator=(const MassSpectrumJs &) = delete;

  Q_INVOKABLE int getSize() const;

  static void registerJsConstructor(QJSEngine *engine);

  signals:
  void sizeChangedSignal();

  private:
  MassSpectrum m_massSpectrum;
};


/*  END CLASS JS REFERENCE
 *  namespace: pappso
 *  class name: MassSpectrum
 */

PAPPSO_REGISTER_JS_CLASS(pappso, MassSpectrumJs)

} // namespace pappso
