.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XIconifyWindow __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XIconifyWindow, XWithdrawWindow, XReconfigureWMWindow \- manipulate top-level windows
.SH SYNTAX
.HP
Status XIconifyWindow\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP, int
\fIscreen_number\fP\^);
.HP
Status XWithdrawWindow\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, int
\fIscreen_number\fP\^);
.HP
Status XReconfigureWMWindow\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^,
int \fIscreen_number\fP\^, unsigned int \fIvalue_mask\fP\^, XWindowChanges
*\fIvalues\fP);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIscreen_number\fP 1i
Specifies the appropriate screen number on the host server.
.IP \fIvalue_mask\fP 1i
Specifies which values are to be set using information in
the values structure.
This mask is the bitwise inclusive OR of the valid configure window values bits.
.IP \fIvalues\fP 1i
Specifies the
.B XWindowChanges
structure.
.IP \fIw\fP 1i
Specifies the window.
.SH DESCRIPTION
The
.B XIconifyWindow
function sends a WM_CHANGE_STATE
.B ClientMessage
event with a format of 32 and a first data element of
.B IconicState
(as described in section 4.1.4 of the
\fIInter-Client Communication Conventions Manual\fP)
and a window of w
to the root window of the specified screen
with an event mask set to
.BR SubstructureNotifyMask |
.BR SubstructureRedirectMask .
Window managers may elect to receive this message and
if the window is in its normal state,
may treat it as a request to change the window's state from normal to iconic.
If the WM_CHANGE_STATE property cannot be interned,
.B XIconifyWindow
does not send a message and returns a zero status.
It returns a nonzero status if the client message is sent successfully;
otherwise, it returns a zero status.
.LP
The
.B XWithdrawWindow
function unmaps the specified window
and sends a synthetic
.B UnmapNotify
event to the root window of the specified screen.
Window managers may elect to receive this message
and may treat it as a request to change the window's state to withdrawn.
When a window is in the withdrawn state,
neither its normal nor its iconic representations is visible.
It returns a nonzero status if the
.B UnmapNotify
event is successfully sent;
otherwise, it returns a zero status.
.LP
.B XWithdrawWindow
can generate a
.B BadWindow
error.
.LP
The
.B XReconfigureWMWindow
function issues a
.B ConfigureWindow
request on the specified top-level window.
If the stacking mode is changed and the request fails with a
.B BadMatch
error,
the error is trapped by Xlib and a synthetic
.B ConfigureRequestEvent
containing the same configuration parameters is sent to the root
of the specified window.
Window managers may elect to receive this event
and treat it as a request to reconfigure the indicated window.
It returns a nonzero status if the request or event is successfully sent;
otherwise, it returns a zero status.
.LP
.B XReconfigureWMWindow
can generate
.B BadValue
and
.B BadWindow
errors.
.SH DIAGNOSTICS
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XChangeWindowAttributes(__libmansuffix__),
XConfigureWindow(__libmansuffix__),
XCreateWindow(__libmansuffix__),
XDestroyWindow(__libmansuffix__),
XRaiseWindow(__libmansuffix__),
XMapWindow(__libmansuffix__),
XUnmapWindow(__libmansuffix__)
.br
\fI\*(xL\fP
