;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; pos.scm
;;
;; Binary positive numbers
;;
;; $Id: pos.scm 2156 2008-01-25 13:25:12Z schimans $
;;
;; Markus Sauermann
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(add-alg "pos"
	 '("One" "pos")
	 '("SZero" "pos=>pos")
	 '("SOne" "pos=>pos"))

(av "p" (py "pos"))

(define (make-pos-term n)
  (cond ((= n 1) (pt "One"))
	((even? n) (make-term-in-app-form
		    (pt "SZero")
		    (make-pos-term (/ n 2))))
	((odd? n) (make-term-in-app-form
		   (pt "SOne")
		   (make-pos-term (/ (- n 1) 2))))
	(else (myerror "make-pos-term" "positive number expected" n))))

(define (is-pos-term? term)
  (or
   (and (term-in-const-form? term)
	(string=? "One" (const-to-name (term-in-const-form-to-const term))))
   (and (term-in-app-form? term)
	(let ((op (term-in-app-form-to-op term))
	      (arg (term-in-app-form-to-arg term)))
	  (and (term-in-const-form? op)
	       (let ((name (const-to-name (term-in-const-form-to-const op))))
		 (or (and (string=? "SZero" name) (is-pos-term? arg))
		     (and (string=? "SOne" name) (is-pos-term? arg)))))))))

(define (pos-term-to-number term)
  (cond
   ((and (term-in-const-form? term)
	 (string=? "One" (const-to-name
			  (term-in-const-form-to-const term))))
    1)
   ((term-in-app-form? term)
    (let ((op (term-in-app-form-to-op term))
	  (arg (term-in-app-form-to-arg term)))
      (if
       (term-in-const-form? op)
       (let ((name (const-to-name (term-in-const-form-to-const op))))
	 (cond
	  ((string=? "SZero" name)
	   (* 2 (pos-term-to-number arg)))
	  ((string=? "SOne" name)
	   (+ 1 (* 2 (pos-term-to-number arg))))
	  (else (myerror "pos-term-to-number" "unexpected term"
			 (term-to-string term)))))
       (myerror "pos-term-to-number" "unexpected term"
		(term-to-string term)))))
   (else (myerror "pos-term-to-number" "unexpected2 term"
		  (term-to-string term)))))



;; ADDITION


(add-program-constant "posPlus" (py "pos=>pos=>pos") 1 'const 2)

(add-token
 "%+"
 'add-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "posPlus"))
    x y)))

(add-display
 (py "pos")
 (lambda (x)
   (let ((op (term-in-app-form-to-final-op x))
	 (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "posPlus"
			(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'add-op "%+"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))

(add-computation-rule (pt "One%+One") (pt "SZero One"))
(add-computation-rule (pt "SZero p %+ One") (pt "SOne p"))
(add-computation-rule (pt "SOne p %+ One") (pt "SZero (p%+One)"))
(add-computation-rule (pt "One%+SZero p") (pt "SOne p"))
(add-computation-rule (pt "SZero p1%+SZero p2") (pt "SZero(p1%+p2)"))
(add-computation-rule (pt "SOne p1%+SZero p2") (pt "SOne(p1%+p2)"))
(add-computation-rule (pt "One%+SOne p") (pt "SZero(p%+One)"))
(add-computation-rule (pt "SZero p1%+SOne p2") (pt "SOne(p1%+p2)"))
(add-computation-rule (pt "SOne p1%+SOne p2") (pt "SZero(p1%+p2%+One)"))



;; SUBTRACTION: ONLY VALID FOR ARG 1 > ARG 2

(add-program-constant "posMinus" (py "pos=>pos=>pos") 1 'const 2)

(add-token
 "%-"
 'add-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "posMinus"))
    x y)))

(add-display
 (py "pos")
 (lambda (x)
   (let ((op (term-in-app-form-to-final-op x))
	 (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "posMinus"
			(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'add-op "%-"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))

(add-computation-rule (pt "One %- p") (pt "One")) ;; Exact
(add-computation-rule (pt "SZero One %- One") (pt "One")) ;; Exact
(add-computation-rule (pt "SZero (SZero p) %- One") (pt "SOne((SZero p) %- One)")) ;; Exact
(add-computation-rule (pt "SZero (SOne p) %- One") (pt "SOne(SZero p)")) ;; Exact
(add-computation-rule (pt "SZero p1 %- SZero p2") (pt "SZero(p1 %- p2)")) ;; Inexact
(add-computation-rule (pt "SZero p1 %- SOne p2") (pt "(SZero(p1 %- p2)) %- One")) ;; Exact
(add-computation-rule (pt "SOne p %- One") (pt "SZero p")) ;; Exact
(add-computation-rule (pt "SOne p1 %- SZero p2") (pt "SZero p1 %- ((SZero p2) %- One)")) ;; Exact
(add-computation-rule (pt "SOne p1 %- SOne p2") (pt "SZero(p1 %- p2)")) ;; Inexact


;;(add-computation-rule (pt "SZero p1 %- SZero p2") (pt "[if (posLess p2 p1) (SZero(p1 %- p2)) One]")) ; exact but slow
;;(add-computation-rule (pt "SOne  p1 %- SOne  p2") (pt "[if (posLess p2 p1) (SZero(p1 %- p2)) One]")) ; exact but slow

;;(add-computation-rule (pt "SZero p1 %- SZero p2") (pt "(SOne(p1 %- p2)) %- (p2 %+ (SZero One) %- p1)")) ; exact, but exponential slow
;;(add-computation-rule (pt "SOne  p1 %- SOne  p2") (pt "(SOne(p1 %- p2)) %- (p2 %+ (SZero One) %- p1)")) ; exact, but exponential slow



(set-goal (pf "all p. SZero p %- (SZero p %- One) = One"))
(ind)
(use "Truth-Axiom")
(assume "p" 1)
(ng)
(simp 1)
(use "Truth-Axiom")
(assume "p" 1)
(ng)
(simp 1)
(use "Truth-Axiom")
(save "posHelper1")
(add-rewrite-rule (pt "SZero p %- (SZero p %- One)") (pt "One"))

(set-goal (pf "all p. SOne p %- SZero p = One"))
(assume "p")
(use "Truth-Axiom")
(save "posHelper4")


(set-goal (pf "all p. p %+ One %- p = One"))
(ind)
(use "Truth-Axiom")
(assume "p" 1)
(use "Truth-Axiom")
(assume "p" 1)
(ng)
(simp 1)
(use "Truth-Axiom")
(save "posHelper11")
(add-rewrite-rule (pt "p %+ One %- p") (pt "One"))

(set-goal (pf "all p1,p2. SZero p1 %- One = SZero p2 -> F"))
(cases)
(auto)
(save "posHelper10")




;; MULTIPLICATION

(add-program-constant "posTimes" (py "pos=>pos=>pos") 1 'const 2)

(add-token
 "%*"
 'mul-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "posTimes"))
    x y)))
(add-display
 (py "pos")
 (lambda (x)
   (let ((op (term-in-app-form-to-final-op x))
	 (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "posTimes"
			(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'mul-op "%*"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))

(add-computation-rule (pt "p%*One") (pt "p"))
(add-computation-rule (pt "p%*(SZero p1)") (pt "SZero(p%*p1)"))
(add-computation-rule (pt "p%*(SOne p1)") (pt "SZero(p%*p1)%+p"))


;; BIT SHIFTS

(add-program-constant "posSHL" (py "pos=>pos=>pos") 1 'const 2)
(add-computation-rule (pt "posSHL p One") (pt "SZero p"))
(add-computation-rule (pt "posSHL p (SZero p2)") (pt "posSHL (posSHL p p2) p2"))
(add-computation-rule (pt "posSHL p (SOne p2)") (pt "SZero (posSHL (posSHL p p2) p2)"))


(add-program-constant "posSHR" (py "pos=>pos=>pos") 1 'const 2)
(add-computation-rule (pt "posSHR One One") (pt "One"))
(add-computation-rule (pt "posSHR (SZero p) One") (pt "p"))
(add-computation-rule (pt "posSHR (SOne p) One") (pt "p"))
(add-computation-rule (pt "posSHR p (SZero p1)") (pt "posSHR (posSHR p p1) p1"))
(add-computation-rule (pt "posSHR One (SOne p1)") (pt "One"))
(add-computation-rule (pt "posSHR (SZero p) (SOne p1)") (pt "posSHR (posSHR p p1) p1"))
(add-computation-rule (pt "posSHR (SOne p) (SOne p1)") (pt "posSHR (posSHR p p1) p1"))




(set-goal (pf "all p1,p. posSHR (posSHL p p1) p1 = p"))
(ind)
(search)
(assume "p" 1 "p1")
(ng)
(inst-with 1 (pt "(posSHL p1 p)"))
(simp 2)
(use-with 1 (pt "p1"))
(assume "p" 1 "p1")
(ng)
(inst-with 1 (pt "(posSHL p1 p)"))
(simp 2)
(ng)
(use-with 1 (pt "p1"))
(save "posHelper7")
(add-rewrite-rule (pt "posSHR (posSHL p p1) p1") (pt "p"))




;; RELATIONS LESS, LESS OR EQUAL

(add-program-constant "posLess" (py "pos=>pos=>boole") 1 'const 2)
(add-program-constant "posLeq" (py "pos=>pos=>boole") 1 'const 2)

(add-computation-rule (pt "posLess p One") (pt "False"))
(add-computation-rule (pt "posLess One (SZero p)") (pt "True"))
(add-computation-rule (pt "posLess One (SOne p)") (pt "True"))
(add-computation-rule (pt "posLess (SZero p1) (SZero p2)") (pt "posLess p1 p2"))
(add-computation-rule (pt "posLess (SZero p1) (SOne p2)") (pt "posLeq p1 p2"))
(add-computation-rule (pt "posLess (SOne p1) (SZero p2)") (pt "posLess p1 p2"))
(add-computation-rule (pt "posLess (SOne p1) (SOne p2)") (pt "posLess p1 p2"))

(add-computation-rule (pt "posLeq One p") (pt "True"))
(add-computation-rule (pt "posLeq (SZero p) One") (pt "False"))
(add-computation-rule (pt "posLeq (SOne p) One") (pt "False"))
(add-computation-rule (pt "posLeq (SZero p1) (SZero p2)") (pt "posLeq p1 p2"))
(add-computation-rule (pt "posLeq (SOne p1) (SZero p2)") (pt "posLess p1 p2"))
(add-computation-rule (pt "posLeq (SZero p1) (SOne p2)") (pt "posLeq p1 p2"))
(add-computation-rule (pt "posLeq (SOne p1) (SOne p2)") (pt "posLeq p1 p2"))


(set-goal (pf "all p. (posLeq  p p)         & (posLeq  p (SZero p)) &
                      (posLeq  p (SOne p))  & (posLess p p    = F) &
                      (posLess p (SZero p)) & (posLess p (SOne  p))"))
(ind)
(search)
(assume "p" 1)
(search)
(assume "p" 1)
(search)
(save "posHelper8")

(add-rewrite-rule (pt "posLeq p p") (pt "True"))
(add-rewrite-rule (pt "posLeq p (SZero p)") (pt "True"))
(add-rewrite-rule (pt "posLeq p (SOne p)") (pt "True"))
(add-rewrite-rule (pt "posLess p p") (pt "False"))
(add-rewrite-rule (pt "posLess p (SZero p)") (pt "True"))
(add-rewrite-rule (pt "posLess p (SOne p)") (pt "True"))


(set-goal (pf "all p. posLess (SZero p %- One) (SZero p) &
                      posLess (SOne  p %- One) (SOne  p)"))
(ind)
(split)
(use "Truth-Axiom")
(use "Truth-Axiom")
(assume "p" 1)
(use 1)
(assume "p" 1)
(split)
(use "Truth-Axiom")
(use "Truth-Axiom")
(save "posMinusOneLess")
(add-rewrite-rule (pt "posLess (SZero p%-One) (SZero p)") (pt "True"))
(add-rewrite-rule (pt "posLess (SOne p%-One) (SOne p)") (pt "True"))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; LEMMATA


;; LEMMA Definition of SZero and SOne

(set-goal (pf "all p1. p1 %+ p1 = SZero p1 & p1 %+ p1 %+ One = SOne p1"))
(ind)
(prop)
(assume "p" 1)
(search)
(assume "p" 1)
(search)
(save "posConstructors")

;; LEMMMA Addition and Constructors

(set-goal (pf "all p1,p2. SZero (p1%+p2) = SZero p1 %+ SZero p2 &
                          SOne  (p1%+p2) = SZero p1 %+ SZero p2 %+ One"))
(assume "p1" "p2")
(split)
(use "Truth-Axiom")
(use "Truth-Axiom")
(save "posPlusConstructors")

(set-goal (pf "all p1,p2. ((posLess p1 p2) -> SZero (p2%-p1) = SZero p2 %- SZero p1) &
                          ((posLess p1 p2) -> SOne  (p2%-p1) = SZero p2 %- SZero p1 %+ One)"))
(assume "p1" "p2")
(split)
(assume 1)
(use "Truth-Axiom")
(assume 1)
(use "Truth-Axiom")
(save "posMinusConstructors")


;; LEMMA Symmetry on =
(set-goal (pf "all p1,p2. p1=p2 -> p2=p1"))
(strip)
(simp 1)
(use "Truth-Axiom")
(save "posSymm")

;; LEMMA Transitivity on =

(set-goal (pf "all p1,p2,p3. p1=p2 -> p2=p3 -> p1=p3"))
(strip)
(simp 1)
(use 2)
(save "posTrans")

;; LEMMA Commutativity of Plus
(set-goal (pf "all p1,p2. p1%+p2 = p2%+p1"))
(ind)
;;?_2: all p2 One%+p2=p2%+One
(cases)
(use "Truth-Axiom")
(assume "p2")
(use "Truth-Axiom")
(assume "p2")
(use "Truth-Axiom")
;;?_3: all p701.all p2 p701%+p2=p2%+p701 -> all p2 SZero p701%+p2=p2%+SZero p701
(assume "p1" 1)
(cases)
(use "Truth-Axiom")
(assume "p2")
(use 1)
(assume "p2")
(use 1)
;;?_4: all p717.all p2 p717%+p2=p2%+p717 -> all p2 SOne p717%+p2=p2%+SOne p717
(assume "p1" 1)
(cases)
(use "Truth-Axiom")
(assume "p2")
(use 1)
(assume "p2")
(ng)
(simp 1)
(use "Truth-Axiom")
(save "posPlusComm")


;; LEMMA Identity of successors
(set-goal (pf "all p,p1,p2. p1=p2 -> (p1%+p)=(p2%+p)"))
(strip)
(simp 1)
(use "Truth-Axiom")
(save "posIdSucc")


;; LEMMA Associativity of Plus
(set-goal (pf "all p1,p2. p1%+(p2%+One) = p1%+p2%+One"))
(ind)
(assume "p2")
(simp-with "posPlusComm" (pt "One") (pt "p2%+One"))
(use "posIdSucc")
(use "posPlusComm")
(assume "p1" 1)
(cases)
(use "Truth-Axiom")
(assume "p2")
(use "Truth-Axiom")
(assume "p2")
(use 1)
(assume "p1" 1)
(cases)
(use "Truth-Axiom")
(assume "p2")
(use "Truth-Axiom")
(assume "p2")
(use 1)
(save "posPlusAssocOne")


(set-goal (pf "all p,p1,p2. p1%+(p2%+p) = p1%+p2%+p"))
(ind)
(use "posPlusAssocOne")
(assume "p" 1)
(assume "p1" "p2")
(simp "<-" "posConstructors")
(simp 1)
(simp 1)
(simp 1)
(simp 1)
(use "Truth-Axiom")
(assume "p" 1 "p1" "p2")
(simp "<-" "posConstructors")
(simp-with "posPlusComm" (pt "p%+p") (pt "One"))
(simp 1)
(simp 1)
(simp 1)
(simp 1)
(simp 1)
(simp 1)
(simp 1)
(use "posIdSucc")
(use "posIdSucc")
(use "posPlusAssocOne")
(save "posPlusAssoc")

;; LEMMA
(set-goal (pf "all p1,p2. posLess p1 (p1%+p2) & posLess p1 (p2%+p1) &
                          posLeq  p1 (p1%+p2) & posLeq  p1 (p2%+p1) &
                          posLess (p1%+p2) p1 = False & posLess (p2%+p1) p1 = False &
                          posLeq  (p1%+p2) p1 = False & posLeq  (p2%+p1) p1 = False"))
(ind)
(cases)
(auto)
(assume "p1" 1)
(cases)
(auto)
(assume "p1" 1)
(cases)
(auto)
(assume "p2")
(split)
(split)
(split) 
(split) 
(split)
(split)
(split)
(ng)
(simp "<-" "posPlusAssoc")
(use 1)
(ng)
(simp-with "posPlusComm" (pt "p2") (pt "p1"))
(simp "<-" "posPlusAssoc")
(use 1)
(ng)
(simp "<-" "posPlusAssoc")
(use 1)
(ng)
(simp-with "posPlusComm" (pt "p2") (pt "p1"))
(simp "<-" "posPlusAssoc")
(use 1)
(ng)
(simp "<-" "posPlusAssoc")
(use 1)
(ng)
(simp-with "posPlusComm" (pt "p2") (pt "p1"))
(simp "<-" "posPlusAssoc")
(use 1)
(ng)
(simp "<-" "posPlusAssoc")
(use 1)
(ng)
(simp-with "posPlusComm" (pt "p2") (pt "p1"))
(simp "<-" "posPlusAssoc")
(use 1)
(save "posAddIsLessLeq")
(add-rewrite-rule (pt "posLess p1 (p1%+p2)") (pt "T"))
(add-rewrite-rule (pt "posLeq  p1 (p1%+p2)") (pt "T"))
(add-rewrite-rule (pt "posLess p1 (p2%+p1)") (pt "T"))
(add-rewrite-rule (pt "posLeq  p1 (p2%+p1)") (pt "T"))
(add-rewrite-rule (pt "posLess (p1%+p2) p1") (pt "F"))
(add-rewrite-rule (pt "posLeq  (p1%+p2) p1") (pt "F"))
(add-rewrite-rule (pt "posLess (p2%+p1) p1") (pt "F"))
(add-rewrite-rule (pt "posLeq  (p2%+p1) p1") (pt "F"))





;; LEMMA One is no successor and no result of an addition
(set-goal (pf "all p. (p%+One) = One -> F"))
(cases)
(auto)
(save "posOneIsNoSucc")

(set-goal (pf "all p1,p2. (p1%+p2) = One -> F"))
(cases)
(assume "p2")
(simp-with "posPlusComm" (pt "One") (pt "p2"))
(use "posOneIsNoSucc")
(assume "p1")
(cases)
(assume 1)
(use 1)
(assume "p2" 1)
(use 1)
(assume "p2" 1)
(use 1)
(assume "p1")
(cases)
(assume 1)
(use 1)
(assume "p2" 1)
(use 1)
(assume "p2" 1)
(use 1)
(save "posOneIsNoAdd")


;; LEMMA Adding to something is different

(set-goal (pf "all p1,p2. (p2%+p1) = p1 -> F"))
(ind)
(ind)
(auto)
(assume "p1" 1)
(ind)
(assume 2)
(use 2)
(assume "p2" 2 3)
(use 1 (pt "p2"))
(use 3)
(assume "p2" 2 3)
(use 3)
(assume "p1" 1)
(ind)
(assume 2)
(use 2)
(assume "p2" 2 3)
(use 1 (pt "p2"))
(use 3)
(assume "p2" 2 3)
(use 3)
(save "posAddIsLarger")



;; LEMMA Identity of predecessors

(set-goal (pf "all p1,p2. p1%+One = p2%+One -> p1=p2"))
(ind)
(cases)
(prop)
(assume "p" 1)
(prop)
(assume "p" 1)
(use "posOneIsNoSucc" (pt "p"))
(use "posSymm")
(use 1)
;; ?_3: all p131.
(assume "p2" 1)
(cases)
(assume 2)
(use 2)
(assume "p3" 2)
(use "posTrans" (pt "p2%+p2"))
(use "posSymm")
(use "posConstructors")
(use "posTrans" (pt "p3%+p3"))
(cut (pf "p2=p3"))
(assume 3)
(simp 3)
(prop)
(use 2)
(use "posConstructors")
(assume "p3" 2)
(use 2)
(assume "p2" 1)
(cases)
(assume 2)
(ng)
(use "posOneIsNoSucc" (pt "p2"))
(use 2)
(assume "p3" 2)
(use 2)
(assume "p3" 2)
(use "posTrans" (pt "p2%+p2%+One"))
(use "posSymm")
(use "posConstructors")
(use "posTrans" (pt "p3%+p3%+One"))
(cut (pf "p2=p3"))
(assume 3)
(simp 3)
(prop)
(use 1)
(use 2)
(use "posConstructors")
(save "posIdPredOne")

;; LEMMA Identity of predecessors Part 2

(set-goal (pf "all p,p1,p2. p1%+p = p2%+p -> p1=p2"))
(ind)
(cases)
;;?_5: all p2.One%+One=p2%+One -> One=p2
(cases)
(search)
(search)
(assume "p" 1)
(inst-with "posAddIsLarger" (pt "One") (pt "p"))
(use 2)
(use "posSymm")
(use 1)
;;?_6: all p467.
(assume "p")
(cases)
(assume 1)
(use 1)
(assume "p1" 1)
(use 1)
(assume "p1" 1)
(use 1)
;;?_7: all p454.
(assume "p")
(cases)
(assume 1)
(inst-with "posAddIsLarger" (pt "One") (pt "p"))
(use 2)
(use 1)
(assume "p1" 1)
(use 1)
(assume "p1" 1)
(use "posIdPredOne")
(use 1)
;;?_3: all p481.
(assume "p" 1)
(cases)
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p1" 2)
(use 2)
(assume "p1" 2)
(inst-with "posAddIsLarger" (pt "p") (pt "p1"))
(use 3)
(simp 2)
(use "posSymm")
;;?_45: p1%+p=p1%+(p1%+p) from
(cut (pf "p1%+p=p"))
(assume 4)
(simp 4)
(use 2)
(use "posSymm")
(use 2)
(assume "p1")
(cases)
(assume 2)
(use 2)
(assume "p2" 2)
(ng)
(use 1)
(use 2)
(assume "p2" 2)
(use 2)
(assume "p1")
(cases)
(ng)
(use-with "posAddIsLarger" (pt "p") (pt "p1"))
(assume "p2" 2)
(use 2)
(assume "p2" 2)
(ng)
(use 1)
(use 2)
;;?_4: all p502.
(assume "p" 1)
(cases)
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p1" 2)
(use 2)
(assume "p1" 2)
(ng)
(inst-with "posAddIsLarger" (pt "p%+One") (pt "p1"))
(use 3)
(use "posTrans" (pt "p1%+p%+One"))
(use "posPlusAssoc")
(use "posSymm")
(use 2)
(assume "p1")
(cases)
(assume 2)
(use 2)
(assume "p2" 2)
(ng)
(use 1)
(use 2)
(assume "p2" 2)
(use 2)
(assume "p1")
(cases)
(ng)
(assume 2)
(use "posAddIsLarger" (pt "p%+One") (pt "p1"))
(use "posTrans" (pt "p1%+p%+One"))
(use "posPlusAssoc")
(use 2)
(assume "p2" 2)
(use 2)
(assume "p2" 2)
(ng)
(use 1)
(use "posIdPredOne")
(use 2)
(save "posIdPred")


;; LEMMA less implies leq

(set-goal (pf "all p1,p2. (posLess p1 p2) -> (posLeq p1 p2)"))
(ind)
(auto)
(assume "p" 1)
(cases)
(auto)
(assume "p" 1)
(cases)
(auto)
(save "posLessImpLeq")


(set-goal (pf "all p1,p2. posLess p1 (p2%+One) = posLeq p1 p2"))
(ind)
(cases)
(auto)
(assume "p1" 1)
(cases)
(auto)
(assume "p1" 1)
(cases)
(auto)
(save "posLessImpLeqExact")


;; LEMMA negation of relation

(set-goal (pf "all p1,p2. ((posLeq  p1 p2 -> F) -> posLess p2 p1) &
                          ((posLess p1 p2 -> F) -> posLeq  p2 p1) &
                          (posLess p2 p1 -> (posLeq  p1 p2 -> F)) &
                          (posLeq  p2 p1 -> (posLess  p1 p2 -> F))"))
(ind)
(cases)
(auto)
(assume "p" 1)
(cases)
(auto)
(assume "p" 1)
(cases)
(auto)
(save "posNotLeImpRevLe")


;; LEMMA Simplifying of less and leq

(set-goal (pf "all p1,p2. posLeq  (p1%+One) (p2%+One) = posLeq  p1 p2 &
                          posLess (p1%+One) (p2%+One) = posLess p1 p2 &
                          posLess p1        (p2%+One) = posLeq  p1 p2 &
                          posLeq  (p1%+One) p2        = posLess p1 p2"))
(ind)
;; p1 = 1
(cases)
(auto)
(assume "p1" 1)
(cases)
(auto)
(assume "p1" 1)
(cases)
(auto)
(save "posLeqLessSimplifyer")
(add-rewrite-rule (pt "posLeq  (p1%+One) (p2%+One)") (pt "posLeq  p1 p2 "))
(add-rewrite-rule (pt "posLess (p1%+One) (p2%+One)") (pt "posLess p1 p2"))
(add-rewrite-rule (pt "posLess p1         (p2%+One)") (pt "posLeq  p1 p2 "))
(add-rewrite-rule (pt "posLeq  (p1%+One) p2        ") (pt "posLess p1 p2"))



;; LEMMA for + and -
(set-goal (pf "all p. ((p=One -> F)   -> posLess One p) &
                      (posLess One p -> p=One -> F)"))
(cases)
(auto)
(save "posHelper3")


;; LEMMA for transitivity of less and leq
(set-goal (pf "all p1,p2,p3. ((posLess p1 p2) -> (posLess p2 p3) -> (posLess p1 p3)) &
                             ((posLeq  p1 p2) -> (posLeq  p2 p3) -> (posLeq  p1 p3)) &
                             ((posLeq  p1 p2) -> (posLess p2 p3) -> (posLess p1 p3)) &
                             ((posLess p1 p2) -> (posLeq  p2 p3) -> (posLess p1 p3))"))
(ind)
;; p1=1
(cases)
;;  p2=1
(assume "p3")
(split)
(split)
(split)
(auto)
(assume 1 2)
(use "Efq")
(use 1)
;;  p2=2x
(assume "p2")
(cases)
(auto)
;;  p2=2x+1
(assume "p2")
(cases)
(auto)
;; p1=2x
(assume "p1" 1)
(cases)
;;  p2=1
(assume "p3")
(split)
(split)
(split)
(assume 2 3)
(use "Efq")
(use 2)
(assume 2 3)
(use "Efq")
(use 2)
(assume 2 3)
(use "Efq")
(use 2)
(assume 2 3)
(use "Efq")
(use 2)
;;  p2=2x
(assume "p2")
(cases)
;;   p3=1
(search)
;;   p3=2x
(assume "p3")
(split)
(split)
(split)
(assume 2 3)
(use-with 1 (pt "p2") (pt "p3") 'left 'left 'left 2 3)
(assume 2 3)
(use-with 1 (pt "p2") (pt "p3") 'left 'left 'right 2 3)
(assume 2 3)
(use-with 1 (pt "p2") (pt "p3") 'left 'right 2 3)
(assume 2 3)
(use-with 1 (pt "p2") (pt "p3") 'right 2 3)
;;   p3=2x+1
(assume "p3")
(split)
(split)
(split)
(assume 2 3)
(use 1 (pt "p2"))
(use-with "posLessImpLeq" (pt "p1") (pt "p2") 2)
(use 3)
(assume 2 3)
(use-with 1 (pt "p2") (pt "p3") 'left 'left 'right 2 3)
(assume 2 3)
(use-with 1 (pt "p2") (pt "p3") 'left 'left 'right 2 3)
(assume 2 3)
(use 1 (pt "p2"))
(use-with "posLessImpLeq" (pt "p1") (pt "p2") 2)
(use 3)
;;  p2=2x+1
(assume "p2")
(cases)
;;   p3=1
(search)
;;   p3=2x
(assume "p3")
(split)
(split)
(split)
(assume 2 3)
(use 1 (pt "p2") 'left 'right)
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2"))
(use 2)
(use "posLessImpLeq")
(use 3)
(assume 2 3)
(use 1 (pt "p2") 'left 'right)
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2") 'left 'right)
(use 2)
(use 3)
;;   p3=2x+1
(assume "p3")
(split)
(split)
(split)
(assume 2 3)
(use 1 (pt "p2"))
(use 2)
(use "posLessImpLeq")
(use 3)
(assume 2 3)
(use 1 (pt "p2"))
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2"))
(use 2)
(use "posLessImpLeq")
(use 3)
(assume 2 3)
(use 1 (pt "p2"))
(use 2)
(use 3)
;; p1=2x+1
(assume "p1" 1)
(cases)
;;  p2=1
(assume "p3")
(split)
(split)
(split)
(assume 2 3)
(use "Efq")
(use 2)
(assume 2 3)
(use "Efq")
(use 2)
(assume 2 3)
(use "Efq")
(use 2)
(assume 2 3)
(use "Efq")
(use 2)
;;  p2=2x
(assume "p2")
(cases)
;;   p3=1
(search)
;;   p3=2x
(assume "p3")
(split)
(split)
(split)
(assume 2 3)
(use 1 (pt "p2"))
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2") 'right)
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2"))
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2") 'right)
(use 2)
(use 3)
;;   p3=2x+1
(assume "p3")
(split)
(split)
(split)
(assume 2 3)
(use 1 (pt "p2") 'right)
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2"))
(use "posLessImpLeq")
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2") 'right)
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2") 'right)
(use 2)
(use 3)
;;  p2=2x+1
(assume "p2")
(cases)
;;   p3=1
(search)
;;   p3=2x
(assume "p3")
(split)
(split)
(split)
(assume 2 3)
(use 1 (pt "p2"))
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2") 'left 'right)
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2") 'left 'right)
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2"))
(use 2)
(use 3)
;;   p3=2x+1
(assume "p3")
(split)
(split)
(split)
(assume 2 3)
(use 1 (pt "p2"))
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2"))
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2") 'left 'right)
(use 2)
(use 3)
(assume 2 3)
(use 1 (pt "p2") 'right)
(use 2)
(use 3)
(save "posHelper25")

(set-goal (pf "all p1,p2,p3. (posLeq p1 p2) -> (posLess p2 p3) -> (posLess p1 p3)"))
(assume "p1" "p2" "p3")
(use "posHelper25")
(save "posLeqLessTrans")

(set-goal (pf "all p1,p2,p3. (posLess p1 p2) -> (posLeq p2 p3) -> (posLess p1 p3)"))
(assume "p1" "p2" "p3")
(use "posHelper25")
(save "posLessLeqTrans")

(set-goal (pf "all p1,p2,p3. (posLess p1 p2) -> (posLess p2 p3) -> (posLess p1 p3)"))
(assume "p1" "p2" "p3")
(use "posHelper25")
(save "posLessTrans")

(set-goal (pf "all p1,p2,p3. (posLeq p1 p2) -> (posLeq p2 p3) -> (posLeq p1 p3)"))
(assume "p1" "p2" "p3")
(use "posHelper25")
(save "posLeqTrans")


;; LEMMA leq and not equal implies less

(set-goal (pf "all p1,p2. (posLeq p1 p2) -> (p1=p2 -> F) -> (posLess p1 p2)"))
(ind)
(cases)
(assume 1 2)
(use 2)
(use "Truth-Axiom")
(assume "p1" 1)
(assume 2)
(use 1)
(assume "p2" 2 3)
(use 1)
(assume "p1" 1)
(cases)
(assume 2 3)
(use 2)
(assume "p2" 2 3)
(ng)
(use 1)
(use 2)
(use 3)
(assume "p2" 2 3)
(use 2)
(assume "p1" 1)
(cases)
(assume 2 3)
(use 2)
(assume "p2" 2 3)
(use 2)
(assume "p2" 2 3)
(use 1)
(use 2)
(use 3)
(save "posLeqNotEqual")


;; LEMMA subtraction and addition of 1 to a number

(set-goal (pf "all p. ((SZero p) %- One) %+ One = SZero p &
                      ((SOne  p) %- One) %+ One = SOne  p"))
(ind)
(split)
(use "Truth-Axiom")
(use "Truth-Axiom")
(assume "p" 1)
(split)
(use 1)
(use "Truth-Axiom")
(assume "p" 1)
(split)
(use "Truth-Axiom")
(use "Truth-Axiom")
(save "posMinusPlusOne1")
(add-rewrite-rule (pt "(SZero p%-One)%+One") (pt "SZero p"))
(add-rewrite-rule (pt "(SOne p%-One)%+One") (pt "SOne p"))


(set-goal (pf "all p. (p=One -> F) -> (p%-One)%+One = p"))
(cases)
(assume 1)
(use-with 1 "Truth-Axiom")
(assume "p" 1)
(use "Truth-Axiom")
(assume "p" 1)
(use "Truth-Axiom")
(save "posMinusPlusOne2")


(set-goal (pf "all p. p%+One%-One = p"))
(cases)
(use "Truth-Axiom")
(assume "p")
(use "Truth-Axiom")
(assume "p")
(use "posIdPredOne")
(simp (pf "SOne p%+One=SZero(p%+One)"))
(use "posMinusPlusOne1" 'left)
(use "Truth-Axiom")
(save "posPlusMinusOne")
(add-rewrite-rule (pt "p%+One%-One") (pt "p"))


(set-goal (pf "all p. ((posLess (SZero One) p) -> p%-One%-One      = p%-(SZero One)) &
                      ((posLess (SOne  One) p) -> p%-One%-One%-One = p%-(SOne  One))"))
(ind)
(auto)
(cases)
(auto)
(cases)
(auto)
(save "posHelper2")


(set-goal (pf "all p. (posLess One p) -> p%-One = One -> p = SZero One"))
(cases)
(assume 1 2)
(use 1)
(cases)
(assume 1 2)
(use "Truth-Axiom")
(assume "p" 1 2)
(use 2)
(assume "p" 1 2)
(use 2)
(assume "p" 1 2)
(use 2)
(save "posHelper5")



;; LEMMA there is a difference between two numbers

(set-goal (pf "all p1,p2. (posLess p1 p2) -> ex p3. p1 %+ p3 = p2"))
(ind)
;; ?_2: all p2.posLess One p2 -> ex p3 One%+p3=p2
(ind)
;; ?_5: posLess One One -> ex p3 One%+p3=One
(assume 1)
(use "Efq")
(use 1)
;; ?_6: all p1827.
(ng)
(cases)
(assume 1 2)
(ex-intro (pt "One"))
(prop)
(ng)
(assume "p1" 1 2)
(assert (pf "ex p3 One%+p3=SZero p1"))
(use-with 1 2)
(assume 3)
(ex-elim 3)
(assume "p2" 4)
(ex-intro (pt "SOne p2"))
(simp "<-" 4)
(ng)
(use "posPlusComm")
(assume "p1" 1 2)
(ex-intro (pt "SOne (SZero p1)"))
(use 2)
;; ?_7: all p1826.
(assume "p1" 1 2)
(ex-intro (pt "SZero p1"))
(use 2)
;; ?_3: all p1764.
(assume "p1" 1)
(cases)
(assume 2)
(use "Efq")
(use 2)
(assume "p2" 2)
(assert (pf "ex p3 p1%+p3=p2"))
(use 1)
(use 2)
(assume 3)
(ex-elim 3)
(assume "p3" 4)
(ex-intro (pt "SZero p3"))
(use 4)
(assume "p2" 2)
(cases (pt "p1=p2"))
(assume 3)
(ex-intro (pt "One"))
(simp 3)
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess p1 p2"))
(use "posLeqNotEqual")
(ng)
(use 2)
(use 3)
(assume 4)
(assert (pf "ex p3 p1%+p3=p2"))
(use 1)
(use 4)
(assume 5)
(ex-elim 5)
(assume "p3" 6)
(ex-intro (pt "SOne p3"))
(use 6)
;; ?_4: all p1763.
(assume "p1" 1)
(cases)
(assume 2)
(use "Efq")
(use 2)
(assume "p2" 2)
(assert (pf "ex p3 p1%+p3=p2"))
(use 1)
(use 2)
(assume 3)
(ex-elim 3)
(assume "p3" 4)
(ex-intro (pt "(SZero p3)%-One"))
(assert (pf "SOne p1=p1%+p1%+One"))
(use "posSymm")
(use "posConstructors")
(assume 5)
(simp 5)
;; ?_77: p1%+p1%+One%+(SZero p3%-One)=SZero p2 from
(use "posTrans" (pt "(SZero p3%-One)%+(p1%+p1%+One)"))
(use "posPlusComm")
(use "posTrans" (pt "(SZero p3%-One)%+(One%+(p1%+p1))"))
(inst-with "posPlusComm" (pt "p1%+p1") (pt "One"))
(simp 6)
(use "Truth-Axiom")
(use "posTrans" (pt "((SZero p3%-One)%+One)%+(p1%+p1)"))
(use "posPlusAssoc")
(inst-with "posMinusPlusOne1" (pt "p3"))
(simp 6 'left)
(simp "posConstructors" 'left)
(ng)
(simp "<-" 4)
(use "posPlusComm")
;; ?_63: all p2210.posLess(SOne p1)(SOne p2210) -> ex p3 SOne p1%+p3=SOne p2210 from
(assume "p2" 2)
(assert (pf "ex p3 p1%+p3=p2"))
(use 1)
(use 2)
(assume 3)
(ex-elim 3)
(assume "p3" 4)
(ex-intro (pt "SZero p3"))
(use 4)
(save "posExDiff")




(set-goal (pf "all p1,p2. (posLeq (SZero p1) p2 ->  p2 %- (SZero p1 %- One) = p2 %+ One %- SZero p1) &
                          (posLeq (SOne  p1) p2 ->  p2 %- (SOne  p1 %- One) = p2 %+ One %- SOne  p1)"))
(ind)
;; p1 = 1
(ind)
;;  p2 = 1
(split)
(assume 1)
(use 1)
(assume 1)
(use "Truth-Axiom")
;;  p2 = 2x
(assume "p2" 1)
(split)
(assume 1)
(use "Truth-Axiom")
(assume 1)
(use "Truth-Axiom")
;;  p2 = 2x+1
(assume "p2" 1)
(split)
(assume 1)
(use "Truth-Axiom")
(assume 1)
(use "Truth-Axiom")
;; p1 = 2x
(assume "p1" 1)
(ind)
;;  p2 = 1
(split)
(assume 2)
(use 2)
(assume 2)
(use "Truth-Axiom")
;;  p2 = 2x
(assume "p2" 2)
(split)
(assume 3)
(use "Truth-Axiom")
(assume 3)
(use "Truth-Axiom")
;;  p2 = 2x+1
(assume "p2" 2)
(split)
(assume 3)
(ng)
(use 1)
(use 3)
(assume 3)
(use "posIdPredOne")
(ng)
(use 1)
(use 3)
;; p1 = 2x+1
(assume "p1" 1)
(ind)
;;  p2 = 1
(split)
(assume 2)
(use 2)
(assume 2)
(use "Truth-Axiom")
;;  p2 = 2x
(assume "p2" 2)
(split)
(assume 3)
(use "Truth-Axiom")
(assume 3)
(use "Truth-Axiom")
;;  p2 = 2x+1
(assume "p2" 2)
(split)
(assume 3)
(ng)
(use 1)
(use 3)
(assume 3)
(use "posIdPredOne")
(ng)
(use 1)
(use 3)
(save "posDoubleMinusOne1")

(set-goal (pf "all p1,p2. (posLeq p1 p2) -> (p1=One -> F) -> p2%-(p1%-One) = p2%+One%-p1"))
(cases)
;; p1 = 1
(assume "p2" 1 2)
(use "Efq")
(use-with 2 1)
;; p1 = 2x
(assume "p1")
(assume "p2" 1 2)
(use "posDoubleMinusOne1")
(use 1)
;; p1 = 2x+1
(assume "p1")
(assume "p2" 1 2)
(use "posDoubleMinusOne1")
(use 1)
(save "posDoubleMinusOne2")


;; LEMMA shifting of - 1

(set-goal (pf "all p, p2. SZero p %+ p2 %- One = SZero p %- One %+ p2 &
                          SOne  p %+ p2 %- One = SOne  p %- One %+ p2"))
(ind)
;; p = 1
(assume "p2")
(split)
(simp "posPlusComm")
(simp-with "<-" "posConstructors" (pt "One") 'left)
(simp "posPlusAssoc")
(simp "posPlusMinusOne")
(simp "posPlusMinusOne")
(use "posPlusComm")
(simp "<-" "posConstructors" 'right)
(simp "posPlusComm")
(simp "posPlusAssoc")
(simp "posPlusMinusOne")
(simp "posPlusMinusOne")
(use "posPlusComm")
;; p = 2x
(assume "p" 1 "p2")
(split)
(simp-with "<-" "posConstructors" (pt "SZero p") 'left)
(simp "<-" "posPlusAssoc")
(simp 1)
(simp 1)
(use "posPlusAssoc")
(ng)
(simp-with "<-" "posConstructors" (pt "SZero p") 'right)
(simp "<-" "posPlusComm")
(simp "posPlusAssoc")
(simp "posPlusMinusOne")
(simp "posConstructors")
(use "posPlusComm")
;; p = 2x+1
(assume "p" 1 "p2")
(split)
(ng)
(simp "<-" "posConstructors" 'right)
(simp "<-" "posConstructors" 'left)
(simp "posPlusAssoc")
(simp "posPlusComm")
(simp "posPlusAssoc")
(simp "posPlusMinusOne")
(simp "posPlusComm")
(simp-with "posPlusComm" (pt "p%+p%+One") (pt "p%+p"))
(simp "posPlusAssoc")
(simp "posConstructors" 'right)
(simp "posConstructors")
(use "Truth-Axiom")
(ng)
(simp "<-" "posConstructors" 'right)
(simp "posConstructors" 'left)
(simp "posPlusComm")
(simp "posPlusAssoc")
(simp "posPlusMinusOne")
(use "posPlusComm")
(save "posMinusOneShift1")


(set-goal (pf "all p, p2. (p=One -> F) -> p%+p2%-One = p%-One%+p2"))
(cases)
(assume "p2" 1)
(use "Efq")
(use 1)
(use "Truth-Axiom")
(assume "p" "p2" 1)
(use "posMinusOneShift1")
(assume "p" "p2" 1)
(use "posMinusOneShift1")
(save "posMinusOneShift2")


(set-goal (pf "all p1,p2. posLess p1 p2 -> p2%+One%-p1 = p2%-p1%+One"))
(ind)
;; p1 = 1
(cases)
(assume 1)
(simp "posMinusPlusOne2")
(use "Truth-Axiom")
(assume 2)
(use 1)
(assume "p2" 1)
(use "Truth-Axiom")
(assume "p2" 1)
(simp "posPlusMinusOne")
(use "Truth-Axiom")
;; p1 = 2x
(cases)
;; p1 = 2*1
(assume 1)
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p2" 2)
(use "posIdPredOne")
(ng)
(use "posSymm")
(use "posMinusPlusOne2")
(assume 3)
(use (pf "posLess One One"))
(simp (pf "posLess One One = posLess One p2"))
(use 2)
(simp 3)
(use "Truth-Axiom")
(assume "p2" 2)
(use "Truth-Axiom")
;; p1 = 2*2x
(assume "p1" 1)
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p2" 2)
(use "posIdPredOne")
(ng)
(simp "posDoubleMinusOne1")
(use 1)
(use 2)
(use "posLessImpLeq")
(use 2)
(assume "p2" 2)
(ng)
(simp "posDoubleMinusOne1")
(use "Truth-Axiom")
(use 2)
;; p1 = 2*(2x+1)
(assume "p1" 1)
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p2" 2)
(use "posIdPredOne")
(ng)
(simp (pf "p2%-SZero p1=p2%+One%-SOne p1"))
(use 1)
(use 2)
(simp "<-" "posDoubleMinusOne1")
(use "Truth-Axiom")
(use "posLessImpLeq")
(use 2)
(assume "p2" 2)
(ng)
(cases (pt "SOne p1=p2"))
;;  cases = T
(assume 3)
(simp "<-" 3)
(simp "posHelper4")
(simp "<-" "posDoubleMinusOne1")
(use "Truth-Axiom")
(use "Truth-Axiom")
;;  cases = F
(assume 3)
(simp (pf "p2%-SZero p1=p2%-SOne p1%+One"))
(use 1)
(use "posLeqNotEqual")
(use 2)
(use 3)
(simp "<-" 1)
(simp "posDoubleMinusOne1")
(use "Truth-Axiom")
(use 2)
(use "posLeqNotEqual")
(use 2)
(use 3)
;; p1 = 2x+1
(assume "p1" 1)
(cases)
(assume 2)
(use 2)
(assume "p2" 2)
(use "Truth-Axiom")
(assume "p2" 2)
(use "posIdPredOne")
(use 1)
(use 2)
(save "posPlusOneShiftExt")

(set-goal (pf "all p1,p2. ((posLess (p1%+One)(p2%+One)) = posLess p1 p2) &
                          ((posLeq  (p1%+One)(p2%+One)) = posLeq  p1 p2)"))
(cases)
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(save "posIdLessLeqPredOne")


(set-goal (pf "all p,p1,p2. ((posLess (p1%+p)(p2%+p)) = posLess p1 p2) &
                            ((posLeq  (p1%+p)(p2%+p)) = posLeq  p1 p2)"))
(ind)
(cases)
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(assume "p" 1)
(cases)
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(assume "p" 1)
(cases)
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(save "posIdLessLeqPred")


(set-goal (pf "all p1,p2. posLess p1 p2 -> SOne p2 %- SZero p1 = SOne (p2 %- p1)"))
(ind)
;; p1 = 1
(cases)
(assume 1)
(use 1)
(assume "p2" 1)
(use "Truth-Axiom")
(assume "p2" 1)
(use "Truth-Axiom")
;; p1 = 2x
(assume "p1" 1)
(ind)
(assume 2)
(use 2)
(assume "p2" 2 3)
(ng)
(simp 1)
(use "Truth-Axiom")
(use 3)
(assume "p2" 2 3)
(ng)
(simp "posDoubleMinusOne1")
(simp "posPlusOneShiftExt")
(simp "<-" "posConstructors")
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "One") (pt "(SOne p2%-SZero p1%+One)"))
(simp "posPlusAssoc")
(simp "posPlusMinusOne")
(simp "posPlusAssoc")
(simp "posConstructors" 'right)
(use "Truth-Axiom")
(use 3)
(use 3)
;; p1 = 2x+1
(assume "p1" 1)
(cases)
(assume 2)
(use 2)
(assume "p2" 2)
(use "Truth-Axiom")
(assume "p2" 2)
(simp "<-" "posConstructors" 'right)
(simp "posConstructors" 'left)
(simp "<-" "posConstructors" 'right)
(simp "posConstructors" 'left)
(simp "<-" "posConstructors" 'right)
(simp "posConstructors" 'left)
(simp "<-" "posConstructors" 'right)
(simp "posConstructors" 'left)
(ng)
(simp "posDoubleMinusOne1")
(simp "posPlusOneShiftExt")
(simp "<-" "posConstructors")
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "One") (pt "(SZero p2%-SZero p1%+One)"))
(simp "posPlusAssoc")
(simp "posPlusAssoc")
(simp "posPlusMinusOne")
(simp "posConstructors" 'right)
(use "Truth-Axiom")
(use 2)
(use "posLessImpLeq")
(use 2)
(save "posSOneSZeroDiff")

(set-goal (pf "all p1,p2. SZero p1 %+ SOne p2 = SOne (p1%+p2)"))
(assume "p1" "p2")
(use "Truth-Axiom")
(save "posSZeroSOneAdd")

(set-goal (pf "all p1,p2. SOne p1 %+ SZero p2 = SOne (p1%+p2)"))
(assume "p1" "p2")
(use "Truth-Axiom")
(save "posSOneSZeroAdd")

(set-goal (pf "all p1,p2. p2%+p1%-p1 = p2"))
(ind)
;; p1 = 1
(assume "p2")
(use "Truth-Axiom")
;; p1 = 2x
(assume "p1" 1)
(cases)
;;  p2 = 1
(simp "<-" "posConstructors")
(simp "posPlusComm")
(simp "posConstructors" 'right)
(simp "posConstructors" 'left)
(use "Truth-Axiom")
;;  p2 = 2x
(assume "p2")
(use 1)
;;  p2 = 2x+1
(assume "p2")
(simp (pf "SOne p2%+SZero p1 = SOne (p2%+p1)"))
(simp "posSOneSZeroDiff")
(simp 1)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Truth-Axiom")
;; p1 = 2x+1
(assume "p1" 1)
(cases)
;;  p2 = 1
(ng)
(use "Truth-Axiom")
;;  p2 = 2x
(assume "p2")
(simp "posSZeroSOneAdd")
(use 1)
;;  p2 = 2x+1
(assume "p2")
(ng)
(simp "posPlusOneShiftExt")
(simp 1)
(use "posIdPredOne")
(use "Truth-Axiom")
(use "Truth-Axiom")
(save "posPlusMinus")

(set-goal (pf "all p.SOne p %- One = SZero p"))
(cases)
(use "Truth-Axiom")
(assume "p")
(use "Truth-Axiom")
(assume "p")
(use "Truth-Axiom")
(save "posHelper15")

(set-goal (pf "all p. SZero (p%+One) %- One = SOne p"))
(ind)
(use "Truth-Axiom")
(assume "p" 1)
(use "Truth-Axiom")
(assume "p" 1)
(use 1)
(save "posHelper16")


(set-goal (pf "all p1,p2. posLess p1 p2 -> p2 %- p1 %+ p1 = p2"))
(ind)
(cases)
(auto)
(assume "p1" 1)
(cases)
(assume 2)
(use 2)
(assume "p2" 2)
(use 1)
(use 2)
(assume "p2" 2)
(cases (pt "p1=p2"))
(assume 3)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess p1 p2"))
(use "posLeqNotEqual")
(use 2)
(use 3)
(assume 4)
(simp "posSOneSZeroDiff")
(simp "posSOneSZeroAdd")
(simp 1)
(use "Truth-Axiom")
(use 4)
(use 4)
(assume "p1" 1)
(cases)
(assume 2)
(use 2)
(assume "p2" 2)
(ng)
(simp "<-" "posMinusOneShift1")
(use 1)
(use 2)
(assume "p2" 2)
(use 1)
(use 2)
(save "posMinusPlus")


(set-goal (pf "all p1,p2,p3. posLess p3 p1 -> p1%+p2%-p3 = p1%-p3%+p2"))
(ind)
;; p1=1
(assume "p2" "p3" 1)
(ng)
(use "Efq")
(use 1)
;; p1 = 2x
(assume "p1" 1)
(cases)
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p3" 2)
(use "posPlusOneShiftExt")
(use 2)
(assume "p3" 2)
(use "posPlusOneShiftExt")
(use 2)
(assume "p2")
(cases)
(assume 2)
(use "posIdPredOne")
(simp "posMinusPlusOne2")
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "SZero p2") (pt "One"))
(simp "posPlusAssoc")
(use "Truth-Axiom")
(assume 3)
(use 3)
(assume "p3" 2)
(use 1)
(use 2)
(assume "p3" 2)
(use "posIdPredOne")
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "SZero p2") (pt "One"))
(simp "posPlusAssoc")
(use 1)
(use 2)
(assume "p2")
(cases)
(assume 2)
(use "posIdPredOne")
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "SOne p2") (pt "One"))
(simp "posPlusAssoc")
(use "Truth-Axiom")
(assume "p3" 2)
(simp "posSZeroSOneAdd")
(simp "posSOneSZeroDiff")
(use 1)
(use 2)
(use "posLessTrans" (pt "p1"))
(use 2)
(use "Truth-Axiom")
(assume "p3" 2)
(ng)
(simp "<-" "posMinusOneShift1")
(use 1)
(use 2)
;; p1 = 2x+1
(assume "p1" 1)
(cases)
(cases)
(assume 2)
(simp "posMinusPlusOne1")
(use "posPlusMinusOne")
(assume "p3" 2)
(cases (pt "p3=p1"))
(assume 3)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(simp "posSOneSZeroDiff")
(use 1)
(use "posLeqNotEqual")
(use 2)
(assume 4)
(use 3)
(simp 4)
(use "Truth-Axiom")
(use "posLeqNotEqual")
(use 2)
(use 3)
(assume "p3" 2)
(use "posIdPredOne")
(use 1)
(use 2)
(assume "p2")
(cases)
(assume 2)
(simp "posSOneSZeroAdd")
(use "Truth-Axiom")
(assume "p3" 2)
(simp "posSOneSZeroAdd")
(simp "posSOneSZeroDiff")
(cases (pt "p3=p1"))
(assume 3)
(simp 3)
(simp "posPlusComm")
(use "posPlusMinus")
(assume 3)
(assert (pf "posLess p3 p1"))
(use "posLeqNotEqual")
(use 2)
(use 3)
(assume 4)
(simp "posSOneSZeroDiff")
(simp "posSOneSZeroAdd")
(use 1)
(use 4)
(use 4)
(use "posLeqLessTrans" (pt "p1"))
(use 2)
(use "Truth-Axiom")
(assume "p3" 2)
(use 1)
(use 2)
(assume "p2")
(cases)
(assume 2)
(use "posIdPredOne")
(use "Truth-Axiom")
(assume "p3" 2)
(cases (pt "p3=p1"))
(assume 3)
(simp 3)
(ng)
(simp "posHelper1")
(ng)
(simp-with "posPlusComm" (pt "p1") (pt "p2"))
(simp "posPlusComm")
(simp "posPlusAssoc")
(simp "posPlusMinus")
(use "posPlusComm")
(assume 3)
(assert (pf "posLess p3 p1"))
(use "posLeqNotEqual")
(use 2)
(use 3)
(assume 4)
(simp "posSOneSZeroDiff")
(ng)
(simp "posPlusOneShiftExt")
(use "posIdSucc")
(use 1)
(use 4)
(use "posLessTrans" (pt "p1"))
(use 4)
(use "Truth-Axiom")
(use 4)
(assume "p3" 2)
(use "posIdPredOne")
(ng)
(simp "posPlusOneShiftExt")
(use "posIdSucc")
(use 1)
(use 2)
(use "posLessTrans" (pt "p1"))
(use 2)
(use "Truth-Axiom")
(save "posPlusMinusExchange")

(set-goal (pf "all p. SOne p = SZero p %+ One"))
(assume "p")
(use "Truth-Axiom")
(save "posHelper18")


(set-goal (pf "all p1,p2,p3. posLess p1 p3 -> posLess(p3%-p1)p2 ->
                             p1%+p2%-p3 = p2%-(p3%-p1)"))
(ind)
;; p1 = 1
(cases)
(cases)
(auto)
(assume "p2")
(cases)
(assume 1 2)
(use "posIdPredOne")
(use 1)
(assume "p3" 1 2)
(use "Truth-Axiom")
(assume "p3" 1 2)
(use "Truth-Axiom")
(assume "p2")
(cases)
(assume 1 2)
(use "posIdPredOne")
(use 1)
(assume "p3" 1 2)
(simp "posDoubleMinusOne1")
(use "Truth-Axiom")
(simp "<-" "posLeqLessSimplifyer")
(use (pf "posLeq (SZero p3) (SZero p2)"))
(simp "<-" "posLessImpLeqExact")
(simp "<-" "posHelper18")
(use (pf "posLess (SZero p3) ((SOne p2) %+ One)"))
(simp "<-" "posMinusPlusOne1")
(simp "posIdLessLeqPredOne")
(use 2)
(assume "p3" 1 2)
(simp "posHelper15")
(cases (pt "p3=p2"))
(assume 3)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess p3 p2"))
(use "posLeqNotEqual")
(use 2)
(use 3)
(assume 4)
(simp "posSOneSZeroDiff")
(simp "posPlusComm")
(simp "posPlusOneShiftExt")
(use "Truth-Axiom")
(use 4)
(use 4)
;; p1 = 2x
(assume "p1" 1)
(cases)
(cases)
(assume 2 3)
(use 3)
(assume "p3" 2 3)
(use "Efq")
(use 3)
(assume "p3" 2 3)
(use 3)
(assume "p2")
(cases)
(assume 2 3)
(use "Efq")
(use 2)
(assume "p3" 2 3)
(use 1)
(use 2)
(use 3)
(assume "p3" 2 3)
(cases (pt "p1=p3"))
(assume 4)
(simp 4)
(ng)
(simp "posPlusComm")
(simp "posPlusMinus")
(use "Truth-Axiom")
(assume 4)
(assert (pf "posLess p1 p3"))
(use "posLeqNotEqual")
(use 2)
(use 4)
(assume 5)
(simp "posSOneSZeroDiff")
(assert (pf "posLess(SOne (p3%-p1))(SZero p2)"))
(simp "<-" "posSOneSZeroDiff")
(use 3)
(use 5)
(assume 6)
(ng)
(simp "posIdPredOne")
(use "Truth-Axiom")
(simp "posMinusPlusOne1")
(simp "posMinusPlusOne1")
(use 1)
(use 5)
(use 6)
(use 5)
(assume "p2")
(cases)
(assume 2 3)
(use "Efq")
(use 2)
(assume "p3" 2 3)
(simp "posSZeroSOneAdd")
(simp (pf "SZero p3%-SZero p1= SZero (p3%-p1)"))
(cases (pt "p3%-p1=p2"))
(assume 4)
(simp 4)
(simp "<-" 4)
(simp "posPlusComm")
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 2)
(assume 4)
(assert (pf "posLess (p3%-p1) p2"))
(use "posLeqNotEqual")
(use 3)
(use 4)
(assume 5)
(assert (pf "posLess p3 (p1%+p2)"))
(simp-with "<-" "posMinusPlus" (pt "p1") (pt "p3") 2)
(simp-with "posPlusComm" (pt "p1") (pt "p2"))
(simp "posIdLessLeqPred")
(use 5)
(assume 6)
(simp "posSOneSZeroDiff")
(simp "posSOneSZeroDiff")
(use 1)
(use 2)
(use 5)
(use 5)
(use 6)
(use "Truth-Axiom")
(assume "p3" 2 3)
(simp "posSZeroSOneAdd")
(cases (pt "p1=p3"))
(assume 4)
(simp 4)
(simp "posHelper4")
(ng)
(simp "posPlusComm")
(use "posPlusMinus")
(assume 4)
(assert (pf "posLess p1 p3"))
(use "posLeqNotEqual")
(use 2)
(use 4)
(assume 5)
(simp "posSOneSZeroDiff")
(assert (pf "posLess(SOne (p3%-p1))(SOne p2)"))
(simp "<-" "posSOneSZeroDiff")
(use 3)
(use 5)
(assume 6)
(use 1)
(use 5)
(use 6)
(use 5)
;; p1 = 2x+1
(assume "p1" 1)
(cases)
(cases)
(assume 2 3)
(use "Efq")
(use 2)
(assume "p3" 2 3)
(use 3)
(assume "p3" 2 3)
(use "Efq")
(use 3)
(assume "p2")
(cases)
(assume 2 3)
(simp "posSOneSZeroAdd")
(simp "posHelper15")
(use "posIdPredOne")
(use 2)
(assume "p3" 2 3)
(simp "posSOneSZeroAdd")
(cases (pt "p1%+p2=p3"))
(assume 4)
(simp 4)
(simp "posHelper4")
(simp "<-" 4)
(ng)
(simp "posPlusComm")
(simp "posPlusMinus")
(use "Truth-Axiom")
(assume 4)
(assert (pf "posLess (p3) (p2%+p1)"))
(use "posLeqNotEqual")
(use (pf "posLess (SZero p3) (SOne (p2%+p1))"))
(simp "<-" "posSZeroSOneAdd")
(simp-with "<-" "posMinusPlus" (pt "SOne p1") (pt "SZero p3") 2)
(simp "posIdLessLeqPred")
(use 3)
(assume 5)
(use 4)
(simp 5)
(use "posPlusComm")
(assume 5)
(assert (pf "posLess (p3 %-p1) p2"))
(simp "<-" "posIdLessLeqPred" (pt "p1"))
(simp "posMinusPlus")
(use 5)
(use 2)
(assume 6)
(simp "posSOneSZeroDiff")
(ng)
(simp "posDoubleMinusOne1")
(simp "<-" "posHelper18")
(simp "posSOneSZeroDiff")
(use 1)
(use 2)
(use 6)
(use 6)
(use "posLessImpLeq")
(use 6)
(simp "posPlusComm")
(use 5)
(assume "p3" 2 3)
(simp "posSOneSZeroAdd")
(use 1)
(use 2)
(use 3)
(assume "p2")
(cases)
(assume 2 3)
(use "Efq")
(use 2)
(assume "p3" 2 3)
(ng)
(simp "posDoubleMinusOne1")
(ng)
(simp "<-" "posPlusAssoc")
(use 1)
(use 2)
(use (pf "posLess(SZero(p3%-p1))(SZero(p2%+One))"))
(simp (pf "(SZero(p2%+One))=(SOne(p2)%+One)"))
(simp "<-" "posMinusPlusOne1")
(simp "posLeqLessSimplifyer")
(use 3)
(use "Truth-Axiom")
(simp "<-" "posMinusPlusOne1")
(simp "posLeqLessSimplifyer")
(use 3)
(assume "p3" 2 3)
(ng)
(simp "posDoubleMinusOne1")
(simp "<-" "posHelper18")
(cases (pt "p3%-p1=p2"))
(assume 4)
(simp 4)
(simp "posHelper4")
(simp "<-" 4)
(simp-with "posPlusComm" (pt "p1") (pt "p3%-p1"))
(simp "posMinusPlus")
(simp "posPlusComm")
(simp "posPlusMinus")
(use "Truth-Axiom")
(use 2)
(assume 4)
(assert (pf "posLess (p3%-p1) p2"))
(use "posLeqNotEqual")
(use 3)
(use 4)
(assume 5)
(simp "posSOneSZeroDiff")
(use "posIdPredOne")
(simp "posMinusPlusOne1")
(ng)
(simp "<-" "posPlusOneShiftExt")
(simp "<-" "posPlusAssoc")
(use 1)
(use 2)
(use "posLessTrans" (pt "p2"))
(use 5)
(use "Truth-Axiom")
(use 5)
(use 5)
(use 3)
(save "posDoubleMinus")


(set-goal (pf "all p1,p2. posLess p2 p1 -> (p1%+One) %- (p2%+One) = p1 %- p2"))
(ind)
(cases)
(assume 1)
(use 1)
(assume "p2" 1)
(use "Truth-Axiom")
(assume "p2" 1)
(use 1)
(assume "p1" 1)
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p2" 2)
(use "Truth-Axiom")
(assume "p2" 2)
(simp "<-" "posHelper18")
(simp (pf "SOne p2%+One = SZero(p2%+One)"))
(cases (pt "p2%+One=p1"))
(assume 3)
(simp 3)
(simp "posHelper4")
(simp "<-" 3)
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess (p2%+One) p1"))
(use "posLeqNotEqual")
(simp "posLeqLessSimplifyer")
(use 2)
(use 3)
(assume 4)
(simp "posSOneSZeroDiff")
(use "posIdPredOne")
(ng)
(simp "<-" "posPlusOneShiftExt")
(use 1)
(use 2)
(use 4)
(use 4)
(use "Truth-Axiom")
(assume "p1" 1)
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p2" 2)
(cases (pt "p2=p1"))
(assume 3)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess p2 p1"))
(use "posLeqNotEqual")
(use 2)
(use 3)
(assume 4)
(simp "posSOneSZeroDiff")
(simp "<-" "posHelper18")
(simp "posPlusMinusExchange")
(use "Truth-Axiom")
(use 4)
(use 4)
(assume "p3" 2)
(simp "posPlusMinusExchange")
(simp (pf "SOne p3%+One=SZero(p3%+One)"))
(ng)
(simp "posPlusConstructors")
(simp-with "<-" "posConstructors" (pt "One") 'left)
(simp "posPlusAssoc")
(simp "posPlusMinus")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use 2)
(save "posDoublePlusOneEqual")



(set-goal (pf "all p1,p2,p3. posLess (p2%+p3)p1 -> p1%-(p2%+p3) = p1%-p2%-p3"))
(ind)
;; p1 = 1
(assume "p2" "p3" 1)
(use "Truth-Axiom")
;; p1 = 2x
(cases)
;; p1 = 2*1
(assume 1)
(cases)
(cases)
(assume 2)
(use 2)
(assume "p3" 2)
(use "Truth-Axiom")
(assume "p3" 2)
(use 2)
(assume "p2")
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p3" 2)
(use "Truth-Axiom")
(assume "p3" 2)
(use "Truth-Axiom")
(assume "p2")
(cases)
(assume 2)
(use 2)
(assume "p3" 2)
(use "Truth-Axiom")
(assume "p3" 2)
(use 2)
;; p1 = 2*2x
(assume "p1" 1)
(cases)
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p3" 2)
(simp (pf "SZero(SZero p1)%-One=SOne(SZero p1 %- One)"))
(cases (pt "p3 = (SZero p1 %- One)"))
(assume 3)
(simp "<-" 3)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess p3(SZero p1 %-One)"))
(use "posLeqNotEqual")
(simp "<-" "posLeqLessSimplifyer")
(simp "posMinusPlusOne1")
(use 2)
(use 3)
(assume 4)
(simp "posSOneSZeroDiff")
(assert (pf "posLess(One%+p3)(SZero p1)"))
(simp "posPlusComm")
(simp-with "<-" "posMinusPlusOne1" (pt "p1") 'left)
(simp "posLeqLessSimplifyer")
(use 4)
(assume 5)
(simp "posIdPredOne")
(use "Truth-Axiom")
(ng)
(simp "<-" "posPlusOneShiftExt")
(use "Truth-Axiom")
(use 4)
(use 4)
(simp "posIdPredOne")
(use "Truth-Axiom")
(simp "posMinusPlusOne1")
(use "Truth-Axiom")
(assume "p3" 2)
(ng)
(simp "posPlusComm")
(use-with 1 (pt "One") (pt "p3") "?")
(simp "posPlusComm")
(use 2)
(assume "p2")
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p3" 2)
(use 1)
(use 2)
(assume "p3" 2)
(ng)
(simp "posIdPredOne")
(use "Truth-Axiom")
(use 1)
(use 2)
(assume "p2")
(cases)
(assume 2)
(use "posIdPredOne")
(use "posIdPredOne")
(ng)
(simp 1)
(simp "posMinusPlusOne2")
(simp "posMinusPlusOne2")
(simp "posMinusPlusOne1")
(use "Truth-Axiom")
(assume 3)
(assert (pf "SZero p1%-p2=One"))
(use (pf "SZero (SZero p1%-p2)=SZero One"))
(use "posHelper5")
(use "Truth-Axiom")
(use 3)
(assume 4)
(assert (pf "SZero p1 = One %+ p2"))
(simp "<-" 4)
(simp "posMinusPlus")
(use "Truth-Axiom")
(use "posLessTrans" (pt "p2%+One"))
(use "Truth-Axiom")
(use 2)
(assume 5)
(use (pf "posLess(SZero p1)(SZero p1)"))
(simp (pf "posLess(SZero p1)(SZero p1)=posLess(p2%+One)(SZero p1)"))
(use 2)
(simp "posPlusComm")
(simp "<-" 5)
(use "Truth-Axiom")
(assume 3)
(ng)
(assert (pf "SZero p1 = One%+p2"))
(simp "<-" 3)
(simp "posMinusPlus")
(use "Truth-Axiom")
(simp "posLessTrans" (pt "p2%+One"))
(use "Truth-Axiom")
(use 2)
(use "Truth-Axiom")
(assume 4)
(use (pf "posLess (SZero p1) (SZero p1)"))
(simp (pf "posLess (SZero p1) (SZero p1) = posLess(p2%+One)(SZero p1)"))
(use 2)
(simp 4)
(ng)
(simp "posPlusComm")
(use "Truth-Axiom")
(use 2)
(assume "p3" 2)
(use "posIdPredOne")
(ng)
(simp "<-" "posPlusOneShiftExt")
(simp "posMinusPlusOne1")
(ng)
(use 1)
(use 2)
(simp "<-" "posLeqLessSimplifyer")
(simp "posMinusPlusOne1")
(ng)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(simp "posPlusComm")
(use 2)
(use "posLessTrans" (pt "p2%+p3"))
(use "Truth-Axiom")
(use 2)
(assume "p3" 2)
(ng)
(simp (pf "SZero(SZero p1%-p2)%-One=SOne(SZero p1%-p2%-One)"))
(ng)
(use "posIdPredOne")
(simp "<-" "posPlusOneShiftExt")
(simp "posDoublePlusOneEqual")
(simp 1)
(simp "<-" "posPlusOneShiftExt")
(simp "posMinusPlusOne2")
(use "Truth-Axiom")
(assume 3)
(use (pf "posLess (p2%+One%+p3)(p2%+One)"))
(simp "<-" "posPlusAssoc")
(simp "posPlusComm")
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "p3") (pt "p2"))
(simp "posPlusComm")
(simp (pf "p2%+One=SZero p1"))
(use 2)
(simp "<-" 3)
(simp "posPlusComm")
(use "posMinusPlus")
(use "posLessTrans" (pt "p2%+p3%+One"))
(use "Truth-Axiom")
(use 2)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(assert (pf "posLess(p2%+One)(SZero p1)"))
(use "posLessTrans" (pt "p2%+p3%+One"))
(use "Truth-Axiom")
(use 2)
(assume 3)
(simp "<-" 1)
(simp-with "posPlusComm" (pt "p2") (pt "One"))
(simp 1)
(simp "posMinusPlus")
(simp "<-" "posLeqLessSimplifyer")
(simp "posMinusPlusOne1")
(simp-with "posPlusComm" (pt "p3") (pt "p2"))
(use 2)
(simp "<-" "posLeqLessSimplifyer")
(simp "posMinusPlusOne1")
(use 3)
(simp "posPlusComm")
(use 3)
(use 3)
(use "posLessTrans" (pt "p2%+p3%+One"))
(use "Truth-Axiom")
(use 2)
(use "posLessTrans" (pt "p2%+p3%+One"))
(use "Truth-Axiom")
(use 2)
(use 2)
(use "posIdPredOne")
(ng)
(simp "posMinusPlusOne2")
(use "Truth-Axiom")
(assume 3)
(assert (pf "SZero p1=p2%+One"))
(simp "posMinusPlus" (pt "p2"))
(simp "<-" 3)
(simp "posPlusComm")
(simp "posMinusPlus")
(use "Truth-Axiom")
(use "posLessTrans" (pt "p2%+p3%+One"))
(use "Truth-Axiom")
(use 2)
(assume 4)
(use (pf "posLess (p2%+One%+p3)(p2%+One)"))
(simp "<-" "posPlusAssoc")
(simp "posPlusComm")
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "p3") (pt "p2"))
(simp "posPlusComm")
(simp "<-" 4)
(use 2)
(assume "p1" 1)
(cases)
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p3" 2)
(simp (pf "SZero(SOne p1) %- One = SOne (SZero p1)"))
(cases (pt "p3=SZero p1"))
(assume 3)
(simp "<-" 3)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess p3(SZero p1)"))
(use "posLeqNotEqual")
(ng)
(simp "<-" "posLeqLessSimplifyer" 'left 'right 'right)
(use 2)
(assume 4)
(use 3)
(use 4)
(assume 4)
(simp "posSOneSZeroDiff")
(ng)
(simp (pf "SZero(SOne p1%-p3)%-One=SOne(SOne p1%-p3%-One)"))
(simp "<-" 1)
(simp "posPlusComm")
(simp 1)
(use "Truth-Axiom")
(simp "posPlusComm")
(simp "posHelper18")
(simp "posLeqLessSimplifyer")
(use 4)
(simp "posHelper18")
(simp "posLeqLessSimplifyer")
(use 4)
(ng)
(use "posIdPredOne")
(simp "posMinusPlusOne1")
(ng)
(simp "posMinusPlusOne2")
(use "Truth-Axiom")
(assume 5)
(use (pf "posLess p3 p3"))
(simp (pf "posLess p3 p3=posLess p3 (SZero p1)"))
(use 4)
(simp (pf "SZero p1 = p3"))
(use "Truth-Axiom")
(use "posIdPredOne")
(simp "<-" "posHelper18")
(simp "<-" 5)
(simp "posPlusComm")
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 2)
(use 4)
(use "Truth-Axiom")
(assume "p3" 2)
(ng)
(simp (pf "SZero p1=SOne p1%-One"))
(simp "posPlusComm")
(use 1)
(simp "posPlusComm")
(use 2)
(use "Truth-Axiom")
(assume "p2")
(cases)
(assume 2)
(use "Truth-Axiom")
(assume "p3" 2)
(use 1)
(use 2)
(assume "p3" 2)
(ng)
(simp 1)
(use "Truth-Axiom")
(use 2)
(assume "p2")
(cases)
(assume 2)
(ng)
(simp 1)
(simp "posMinusConstructors")
(use "posSymm")
(use "posHelper2")
(ng)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posPlusComm")
(simp "posMinusPlus")
(use 2)
(use "posLessTrans" (pt "p2%+One"))
(use "Truth-Axiom")
(use 2)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posPlusComm")
(simp "posMinusPlus")
(use 2)
(use "posLessTrans" (pt "p2%+One"))
(use "Truth-Axiom")
(use 2)
(use 2)
(assume "p3" 2)
(ng)
(simp 1)
(use "posIdPredOne")
(ng)
(simp "<-" "posPlusOneShiftExt")
(use "Truth-Axiom")
(simp "<-" "posIdLessLeqPredOne")
(simp "posMinusPlusOne1")
(ng)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(simp "posPlusComm")
(use 2)
(use "posLessTrans" (pt "p2%+p3"))
(use "Truth-Axiom")
(use 2)
(use 2)
(assume "p3" 2)
(ng)
(simp (pf "SZero(SOne p1%-p2)%-One = SOne(SOne p1%-p2%-One)"))
(ng)
(use "posIdPredOne")
(simp "<-" "posPlusOneShiftExt")
(simp "posDoublePlusOneEqual")
(simp "<-" "posPlusOneShiftExt")
(simp "posMinusPlusOne2")
(use 1)
(use "posLessTrans" (pt "p2%+p3%+One"))
(use "Truth-Axiom")
(use 2)
(assume 4)
(use (pf "posLess (p2%+One%+p3)(p2%+One)"))
(simp "<-" "posPlusAssoc")
(simp "posPlusComm")
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "p3") (pt "p2"))
(simp "posPlusComm")
(simp (pf "p2%+One=SOne p1"))
(simp "posPlusComm")
(simp "posPlusComm")
(use 2)
(simp "<-" 3)
(simp "posPlusComm")
(use "posMinusPlus")
(use "posLessTrans" (pt "p2%+p3%+One"))
(use "Truth-Axiom")
(use 2)
(simp "<-" "posLeqLessSimplifyer")
(simp "posMinusPlusOne2")
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(simp "posPlusComm")
(simp "posPlusAssoc")
(use 2)
(use "posLessTrans" (pt "p2%+p3%+One"))
(use "Truth-Axiom")
(use 2)
(assume 4)
(use (pf "posLess (p2%+One%+p3)(p2%+One)"))
(simp "<-" "posPlusAssoc")
(simp "posPlusComm")
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "p3") (pt "p2"))
(simp "posPlusComm")
(simp "<-" (pf "SOne p1=p2%+One"))
(use 2)
(simp "<-" 3)
(simp "posPlusComm")
(use "posSymm")
(use "posMinusPlus")
(use "posLessTrans" (pt "p2%+p3%+One"))
(use "Truth-Axiom")
(use 2)
(use "posLessTrans" (pt "p2%+p3%+One"))
(use "Truth-Axiom")
(use 2)
(use 2)
(use "posIdPredOne")
(ng)
(use "posSymm")
(use "posMinusPlusOne2")
(assume 3)
(use (pf "posLess (p2%+One%+p3)(p2%+One)"))
(simp "<-" "posPlusAssoc")
(simp "posPlusComm")
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "p3") (pt "p2"))
(simp "posPlusComm")
(simp (pf "p2%+One=SOne p1"))
(use 2)
(simp "<-" 3)
(simp "posPlusComm")
(use "posMinusPlus")
(use "posLessTrans" (pt "p2%+p3%+One"))
(use "Truth-Axiom")
(use 2)
;; p1 = 2x+1
(assume "p1" 1)
(cases)
(cases)
(assume 2)
(use "posSymm")
(use "Truth-Axiom")
(assume "p3" 2)
(use "Truth-Axiom")
(assume "p3" 2)
(use "posIdPredOne")
(ng)
(simp "posPlusConstructors")
(simp-with "<-" "posConstructors" (pt "One") 'left)
(simp "posPlusAssoc")
(simp "posPlusMinusOne")
(use "Truth-Axiom")
(assume "p2")
(cases)
(assume 2)
(ng)
(simp "posDoubleMinusOne1")
(simp "posPlusOneShiftExt")
(use "Truth-Axiom")
(use 2)
(use "posLessImpLeq")
(use 2)
(assume "p3" 2)
(simp "posSOneSZeroDiff")
(simp "<-" "posPlusConstructors")
(cases (pt "p2%+p3=p1"))
(assume 3)
(simp 3)
(simp "posHelper4")
(simp "<-" 3)
(simp "posPlusComm")
(simp "posPlusMinus")
(simp "posHelper4")
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess (p2%+p3)p1"))
(use "posLeqNotEqual")
(use 2)
(use 3)
(assume 4)
(simp "posSOneSZeroDiff")
(simp "posSOneSZeroDiff")
(use 1)
(use 4)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(simp "posPlusComm")
(use 4)
(use "posLessTrans" (pt "p2%+p3"))
(use "Truth-Axiom")
(use 4)
(use 4)
(use "posLessLeqTrans" (pt "p2%+p3"))
(use "Truth-Axiom")
(use 2)
(assume "p3" 2)
(simp "posSZeroSOneAdd")
(simp "posSOneSZeroDiff")
(use 1)
(use 2)
(use "posLessTrans" (pt "p2%+p3"))
(use "Truth-Axiom")
(use 2)
(assume "p2")
(cases)
(assume 2)
(simp (pf "SOne p2%+One=SZero(p2%+One)"))
(cases (pt "p2%+One=p1"))
(assume 3)
(simp 3)
(simp "posHelper4")
(simp "<-" 3)
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess (p2%+One)p1"))
(use "posLeqNotEqual")
(use 2)
(use 3)
(assume 4)
(simp "posSOneSZeroDiff")
(ng)
(simp (pf "SZero(p1%-p2)%-One=SOne(p1%-p2%-One)"))
(use 1)
(use 4)
(use "posIdPredOne")
(ng)
(simp "posMinusPlusOne2")
(use "Truth-Axiom")
(assume 5)
(use (pf "posLess p1 p1"))
(simp (pf "posLess p1 p1 = posLess (p2%+(p1%-p2)) p1"))
(simp 5)
(use 4)
(simp "posPlusComm")
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 2)
(use 4)
(use "Truth-Axiom")
(assume "p3" 2)
(simp "posSOneSZeroAdd")
(use 1)
(use 2)
(assume "p3" 2)
(ng)
(simp "posPlusConstructors")
(simp-with "<-" "posConstructors" (pt "One") 'left)
(simp "posPlusAssoc")
(simp "posPlusMinus")
(use "posIdPredOne")
(simp "<-" "posPlusOneShiftExt")
(simp "posDoublePlusOneEqual")
(use 1)
(use 2)
(use 2)
(use 2)
(save "posTwoMinus")


(set-goal (pf "all p. One%*p=p"))
(ind)
(use "Truth-Axiom")
(assume "p" 1)
(use 1)
(assume "p" 1)
(use 1)
(save "posTimesCommPre")
(add-rewrite-rule (pt "One%*p") (pt "p"))

(set-goal (pf "all p1,p2. p1%*p2 = p2%*p1"))
(ind)
(ind)
(use "Truth-Axiom")
(assume "p2" 1)
(use 1)
(assume "p2" 1)
(use 1)
(assume "p1" 1)
(ind)
(ng)
(use "Truth-Axiom")
(assume "p2" 2)
(ng)
(simp "<-" 1)
(simp 2)
(simp "<-" 1)
(use "Truth-Axiom")
(assume "p2" 2)
(ng)
(simp 2)
(simp "<-" 1)
(simp "<-" 1)
(use "Truth-Axiom")
(assume "p1" 1)
(ind)
(use "Truth-Axiom")
(assume "p2" 2)
(ng)
(simp 2)
(simp "<-" 1)
(simp "<-" 1)
(use "Truth-Axiom")
(assume "p2" 2)
(ng)
(simp 2)
(simp "<-" 1)
(simp "<-" 1)
(ng)
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "p2") (pt "p1"))
(use "posPlusAssoc")
(save "posTimesComm")

(set-goal (pf "all p1,p2. SZero p1%*p2 = SZero (p1%*p2)"))
(assume "p1")
(ind)
(use "Truth-Axiom")
(assume "p2" 1)
(use 1)
(assume "p2" 1)
(use "posIdSucc")
(use 1)
(save "posHelper21")
(add-rewrite-rule (pt "SZero p1%*p2") (pt "SZero (p1%*p2)"))

(set-goal (pf "all p,p1,p2. (p1%+p2)%*p = p1%*p %+ p2%*p"))
(ind)
(assume "p1" "p2")
(use "Truth-Axiom")
(assume "p" 1)
(use 1)
(assume "p" 1)
(ng)
(assume "p1" "p2")
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "p1") (pt "(SZero(p2%*p)%+p2)"))
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "p2") (pt "p1"))
(simp "posPlusAssoc")
(simp "posPlusAssoc")
(simp "posPlusAssoc")
(use "posIdSucc")
(use "posIdSucc")
(use 1)
(save "posRightDistrib")

(set-goal (pf "all p,p1,p2. p%*(p1%+p2) = p%*p1 %+ p%*p2"))
(assume "p" "p1" "p2")
(simp "posTimesComm")
(simp-with "posTimesComm" (pt "p") (pt "p1"))
(simp-with "posTimesComm" (pt "p") (pt "p2"))
(use "posRightDistrib")
(save "posLeftDistrib")

(set-goal (pf "all p1,p2. SOne p1 %* p2 = SZero (p1%*p2) %+ p2"))
(assume "p1" "p2")
(simp "posHelper18")
(simp "posRightDistrib")
(use "Truth-Axiom")
(save "posHelper22")

(set-goal (pf "all p1,p2,p3. p1%*(p2%*p3) = p1%*p2%*p3"))
(ind)
(assume "p2" "p3")
(use "Truth-Axiom")
(assume "p1" 1)
(use 1)
(assume "p1" 1)
(assume "p2" "p3")
(simp "posHelper22")
(simp "posHelper22")
(simp "posRightDistrib")
(simp 1)
(use "Truth-Axiom")
(save "posTimesAssoc")

(set-goal (pf "all p1,p2,p3,p4. posLess p2 p1 -> posLess (p3%+p1) (p4%+p2) -> posLess p3 p4"))
(assume "p1" "p2" "p3" "p4" 1 2)
(simp "<-" "posIdLessLeqPred" (pt "p1"))
(use "posLessTrans" (pt "p4%+p2"))
(use 2)
(simp "posPlusComm")
(simp-with "posPlusComm" (pt "p4") (pt "p1"))
(simp "posIdLessLeqPred")
(use 1)
(save "posHelper23")


(set-goal (pf "all p1,p2,p. posLess (p1%*p) (p2%*p) = posLess p1 p2"))
(assume "p1" "p2")
(ind)
(use "Truth-Axiom")
(assume "p" 1)
(use 1)
(assume "p" 1)
(cases (pt "posLess p1 p2"))
(assume 2)
(ng)
(simp "posLessTrans" (pt "SZero(p2%*p)%+p1"))
(use "Truth-Axiom")
(simp "posPlusComm")
(simp-with "posPlusComm" (pt "SZero(p2%*p)") (pt "p2"))
(simp "posIdLessLeqPred")
(use 2)
(simp "posIdLessLeqPred")
(ng)
(simp 1)
(use 2)
(assume 2)
(cases (pt "p2=p1"))
(assume 3)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess p2 p1"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 2)
(use 3)
(assume 4)
(assert (pf "posLess p1 p2 = False"))
(cases (pt "posLess p1 p2"))
(assume 5)
(use 2)
(use 5)
(assume 5)
(use "Truth-Axiom")
(assume 5)
(ng)
(cases (pt "posLess(SZero(p1%*p)%+p1)(SZero(p2%*p)%+p2)"))
(assume 6)
(use 2)
(simp "<-" 1)
(use (pf "posLess (SZero(p1%*p)) (SZero(p2%*p))"))
(use "posHelper23" (pt "p1") (pt "p2"))
(use 4)
(use 6)
(assume 6)
(use "Truth-Axiom")
(save "posIdLessPredTimes")
(add-rewrite-rule (pt "posLess (p1%*p) (p2%*p)") (pt "posLess p1 p2"))

(set-goal (pf "all p1,p2. posLeq p1 (p1%*p2)"))
(assume "p1")
(ind)
(use "Truth-Axiom")
(assume "p2" 1)
(use "posLeqTrans" (pt "p1%*p2"))
(use 1)
(use "Truth-Axiom")
(assume "p2" 1)
(use "Truth-Axiom")
(save "posTimesLargerEqual")
(add-rewrite-rule (pt "posLeq p1 (p1%*p2)") (pt "True"))


(set-goal (pf "all p1,p2,p3,p4. posLeq p2 p1 -> posLeq (p3%+p1) (p4%+p2) -> posLeq p3 p4"))
(assume "p1" "p2" "p3" "p4" 1 2)
(simp "<-" "posIdLessLeqPred" (pt "p1"))
(use "posLeqTrans" (pt "p4%+p2"))
(use 2)
(simp "posPlusComm")
(simp-with "posPlusComm" (pt "p4") (pt "p1"))
(simp "posIdLessLeqPred")
(use 1)
(save "posHelper24")

(set-goal (pf "all p1,p2,p. posLeq (p1%*p) (p2%*p) = posLeq p1 p2"))
(assume "p1" "p2")
(ind)
(use "Truth-Axiom")
(assume "p" 1)
(use 1)
(assume "p" 1)
(cases (pt "posLeq p1 p2"))
(assume 2)
(ng)
(simp "posLeqTrans" (pt "SZero(p2%*p)%+p1"))
(use "Truth-Axiom")
(simp "posPlusComm")
(simp-with "posPlusComm" (pt "SZero(p2%*p)") (pt "p2"))
(simp "posIdLessLeqPred")
(use 2)
(simp "posIdLessLeqPred")
(ng)
(simp 1)
(use 2)
(assume 2)
(assert (pf "posLess p2 p1"))
(use "posNotLeImpRevLe")
(use 2)
(assume 3)
(ng)
(cases (pt "posLeq(SZero(p1%*p)%+p1)(SZero(p2%*p)%+p2)"))
(assume 4)
(use 2)
(simp "<-" 1)
(use (pf "posLeq (SZero(p1%*p)) (SZero(p2%*p))"))
(use "posHelper24" (pt "p1") (pt "p2"))
(use "posLessImpLeq")
(use 3)
(use 4)
(assume 4)
(use "Truth-Axiom")
(save "posIdLeqPredTimes")
(add-rewrite-rule (pt "posLeq (p1%*p) (p2%*p)") (pt "posLeq p1 p2"))

(set-goal (pf "all p1,p2,p3,p4. posLess p1 p2 -> posLess p3 p4 -> posLess (p1%+p3) (p2%+p4)"))
(assume "p1" "p2" "p3" "p4" 1 2)
(use "posLessTrans" (pt "p2%+p3"))
(simp "posIdLessLeqPred")
(use 1)
(simp "posPlusComm")
(simp-with "posPlusComm" (pt "p2") (pt "p4"))
(simp "posIdLessLeqPred")
(use 2)
(save "posLessPlusSplit")

(set-goal (pf "all p,p1,p2. posLess p2 p1 -> p%*(p1%-p2) = p%*p1 %- p%*p2"))
(ind)
(assume "p1" "p2" 1)
(use "Truth-Axiom")
(assume "p" 1 "p1" "p2" 2)
(use 1)
(use 2)
(assume "p" 1 "p1" "p2" 2)
(simp "posTimesComm")
(simp-with "posTimesComm" (pt "SOne p") (pt "p1"))
(simp-with "posTimesComm" (pt "SOne p") (pt "p2"))
(ng)
(simp "posTimesComm")
(simp 1)
(simp "posTwoMinus")
(simp "posPlusMinusExchange")
(ng)
(simp "posPlusComm")
(use "posSymm")
(simp "posPlusComm")
(simp "posPlusMinusExchange")
(simp "posTimesComm")
(simp-with "posTimesComm" (pt "p2") (pt "p"))
(use "Truth-Axiom")
(use 2)
(use 2)
(use "posLessPlusSplit")
(use 2)
(use 2)
(use 2)
(save "posLeftDistribMinus")

(set-goal (pf "all p,p1,p2. posLess p2 p1 -> (p1%-p2)%*p = p1%*p %- p2%*p"))
(assume "p" "p1" "p2" 1)
(simp "posTimesComm")
(simp-with "posTimesComm" (pt "p1") (pt "p"))
(simp-with "posTimesComm" (pt "p2") (pt "p"))
(use "posLeftDistribMinus")
(use 1)
(save "posRightDistribMinus")

(set-goal (pf "all p1,p2,p3,p4. posLeq p1 p2 -> posLeq p3 p4 -> posLeq (p1%+p3) (p2%+p4)"))
(assume "p1" "p2" "p3" "p4" 1 2)
(use "posLeqTrans" (pt "p1%+p4"))
(simp "posPlusComm")
(simp-with "posPlusComm" (pt "p1") (pt "p4"))
(simp "posIdLessLeqPred")
(use 2)
(simp "posIdLessLeqPred")
(use 1)
(save "posLeqAdd")

(set-goal (pf "all p1,p2,p3,p4. posLess p1 p2 -> posLess p3 p4 -> posLess (p1%+p3) (p2%+p4)"))
(assume "p1" "p2" "p3" "p4" 1 2)
(use "posLessTrans" (pt "p1%+p4"))
(simp "posPlusComm")
(simp-with "posPlusComm" (pt "p1") (pt "p4"))
(simp "posIdLessLeqPred")
(use 2)
(simp "posIdLessLeqPred")
(use 1)
(save "posLessAdd")


(set-goal (pf "all p1,p2. ((p1=p2) -> Pvar) ->
                          ((posLess p1 p2) -> Pvar) ->
                          ((posLess p2 p1) -> Pvar) -> Pvar"))
(assume "p1" "p2" 1 2 3)
(cases (pt "p1=p2"))
(use 1)
(assume 4)
(cases (pt "posLess p1 p2"))
(use 2)
(assume 5)
(use 3)
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 5)
(assume 6)
(use 4)
(simp 6)
(use "Truth-Axiom")
(save "posTriple")



(set-goal (pf "all p1,p2. posLeq (p1%-p2) p1"))
(ind)
(assume "p2")
(use "Truth-Axiom")
(assume "p1" 1)
(cases)
(simp "<-" "posLeqLessSimplifyer")
(simp "posMinusPlusOne1")
(use "Truth-Axiom")
(assume "p2")
(use 1)
(assume "p2")
(ng)
(simp "<-" "posLeqLessSimplifyer")
(simp "posMinusPlusOne1")
(use 1)
(assume "p1" 1)
(cases)
(simp "<-" "posLeqLessSimplifyer")
(simp "posMinusPlusOne1")
(use "Truth-Axiom")
(cases)
(ng)
(simp "<-" "posLeqLessSimplifyer")
(simp "posMinusPlusOne1")
(use "Truth-Axiom")
(assume "p2")
(ng)
(simp "<-" "posLeqLessSimplifyer")
(simp "posMinusPlusOne1")
(ng)
(use "posLeqTrans" (pt "p1"))
(use 1)
(use "Truth-Axiom")
(assume "p2")
(ng)
(simp "<-" "posLeqLessSimplifyer")
(simp "posMinusPlusOne1")
(ng)
(use "posLeqTrans" (pt "p1"))
(use 1)
(use "Truth-Axiom")
(assume "p2")
(use 1)
(save "posMinusLeq")

(set-goal (pf "all p1,p2. posLess p1 p2 -> posLess p2 p1 -> F"))
(assume "p1" "p2" 1 2)
(use (pf "posLess p1 p1"))
(use "posLessTrans" (pt "p2"))
(use 1)
(use 2)
(save "posHelper27")

(set-goal (pf "all p1,p2. posLeq p1 p2 -> posLess p2 p1 -> F"))
(assume "p1" "p2" 1 2)
(use (pf "posLess p1 p1"))
(use "posLeqLessTrans" (pt "p2"))
(use 1)
(use 2)
(save "posHelper28")
