## Usage

```js
var Snapdragon = require('snapdragon');
var captureSet = require('snapdragon-capture-set');
var parser = new Snapdragon.Parser()
  .use(captureSet())
  .captureSet('brace', /^\{/, /^\}/) 
  .set('text', function() {
    var pos = this.position();
    var m = this.match(/^[^{}]/);
    if (!m) return;
    return pos({
      type: 'text',
      val: m[0]
    });
  });

var ast = parser.parse('a{b,{c,d},e}f');
console.log(ast.nodes[2]);
// Node {
//   type: 'brace',
//   nodes:
//    [ Node { type: 'brace.open', val: '{', position: [Object] },
//      Node { type: 'text', val: 'b', position: [Object] },
//      Node { type: 'text', val: ',', position: [Object] },
//      Node { type: 'brace', nodes: [Object], position: [Object] },
//      Node { type: 'text', val: ',', position: [Object] },
//      Node { type: 'text', val: 'e', position: [Object] },
//      Node { type: 'brace.close', val: '}', position: [Object] } ],
//   position: Position { start: { line: 1, column: 2 }, end: { line: 1, column: 3 } } }
```

## API
{%= apidocs("index.js") %}
