# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hdinsight import HDInsightManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHDInsightManagementClustersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HDInsightManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_create(self, resource_group):
        response = self.client.clusters.begin_create(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str", "tenantId": "str"}},
                },
                "location": "str",
                "properties": {
                    "clusterDefinition": {
                        "blueprint": "str",
                        "componentVersion": {"str": "str"},
                        "configurations": {},
                        "kind": "str",
                    },
                    "clusterVersion": "str",
                    "computeIsolationProperties": {"enableComputeIsolation": False, "hostSku": "str"},
                    "computeProfile": {
                        "roles": [
                            {
                                "VMGroupName": "str",
                                "autoscale": {
                                    "capacity": {"maxInstanceCount": 0, "minInstanceCount": 0},
                                    "recurrence": {
                                        "schedule": [
                                            {
                                                "days": ["str"],
                                                "timeAndCapacity": {
                                                    "maxInstanceCount": 0,
                                                    "minInstanceCount": 0,
                                                    "time": "str",
                                                },
                                            }
                                        ],
                                        "timeZone": "str",
                                    },
                                },
                                "dataDisksGroups": [{"diskSizeGB": 0, "disksPerNode": 0, "storageAccountType": "str"}],
                                "encryptDataDisks": False,
                                "hardwareProfile": {"vmSize": "str"},
                                "minInstanceCount": 0,
                                "name": "str",
                                "osProfile": {
                                    "linuxOperatingSystemProfile": {
                                        "password": "str",
                                        "sshProfile": {"publicKeys": [{"certificateData": "str"}]},
                                        "username": "str",
                                    }
                                },
                                "scriptActions": [{"name": "str", "parameters": "str", "uri": "str"}],
                                "targetInstanceCount": 0,
                                "virtualNetworkProfile": {"id": "str", "subnet": "str"},
                            }
                        ]
                    },
                    "diskEncryptionProperties": {
                        "encryptionAlgorithm": "str",
                        "encryptionAtHost": False,
                        "keyName": "str",
                        "keyVersion": "str",
                        "msiResourceId": "str",
                        "vaultUri": "str",
                    },
                    "encryptionInTransitProperties": {"isEncryptionInTransitEnabled": False},
                    "kafkaRestProperties": {
                        "clientGroupInfo": {"groupId": "str", "groupName": "str"},
                        "configurationOverride": {"str": "str"},
                    },
                    "minSupportedTlsVersion": "str",
                    "networkProperties": {
                        "outboundDependenciesManagedType": "str",
                        "privateLink": "str",
                        "publicIpTag": {"ipTagType": "str", "tag": "str"},
                        "resourceProviderConnection": "str",
                    },
                    "osType": "str",
                    "privateLinkConfigurations": [
                        {
                            "groupId": "str",
                            "ipConfigurations": [
                                {
                                    "name": "str",
                                    "id": "str",
                                    "primary": bool,
                                    "privateIPAddress": "str",
                                    "privateIPAllocationMethod": "str",
                                    "provisioningState": "str",
                                    "subnet": {"id": "str"},
                                    "type": "str",
                                }
                            ],
                            "name": "str",
                            "id": "str",
                            "provisioningState": "str",
                            "type": "str",
                        }
                    ],
                    "securityProfile": {
                        "aaddsResourceId": "str",
                        "clusterUsersGroupDNs": ["str"],
                        "directoryType": "str",
                        "domain": "str",
                        "domainUserPassword": "str",
                        "domainUsername": "str",
                        "ldapsUrls": ["str"],
                        "msiResourceId": "str",
                        "organizationalUnitDN": "str",
                    },
                    "storageProfile": {
                        "storageaccounts": [
                            {
                                "container": "str",
                                "enableSecureChannel": bool,
                                "fileSystem": "str",
                                "fileshare": "str",
                                "isDefault": bool,
                                "key": "str",
                                "msiResourceId": "str",
                                "name": "str",
                                "resourceId": "str",
                                "saskey": "str",
                            }
                        ]
                    },
                    "tier": "str",
                },
                "tags": {"str": "str"},
                "zones": ["str"],
            },
            api_version="2025-01-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_update(self, resource_group):
        response = self.client.clusters.update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str", "tenantId": "str"}},
                },
                "tags": {"str": "str"},
            },
            api_version="2025-01-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_delete(self, resource_group):
        response = self.client.clusters.begin_delete(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2025-01-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_get(self, resource_group):
        response = self.client.clusters.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2025-01-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list_by_resource_group(self, resource_group):
        response = self.client.clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-01-15-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_resize(self, resource_group):
        response = self.client.clusters.begin_resize(
            resource_group_name=resource_group.name,
            cluster_name="str",
            role_name="str",
            parameters={"targetInstanceCount": 0},
            api_version="2025-01-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_update_auto_scale_configuration(self, resource_group):
        response = self.client.clusters.begin_update_auto_scale_configuration(
            resource_group_name=resource_group.name,
            cluster_name="str",
            role_name="str",
            parameters={
                "autoscale": {
                    "capacity": {"maxInstanceCount": 0, "minInstanceCount": 0},
                    "recurrence": {
                        "schedule": [
                            {
                                "days": ["str"],
                                "timeAndCapacity": {"maxInstanceCount": 0, "minInstanceCount": 0, "time": "str"},
                            }
                        ],
                        "timeZone": "str",
                    },
                }
            },
            api_version="2025-01-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list(self, resource_group):
        response = self.client.clusters.list(
            api_version="2025-01-15-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_rotate_disk_encryption_key(self, resource_group):
        response = self.client.clusters.begin_rotate_disk_encryption_key(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={"keyName": "str", "keyVersion": "str", "vaultUri": "str"},
            api_version="2025-01-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_get_gateway_settings(self, resource_group):
        response = self.client.clusters.get_gateway_settings(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2025-01-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_update_gateway_settings(self, resource_group):
        response = self.client.clusters.begin_update_gateway_settings(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={
                "restAuthCredential.isEnabled": True,
                "restAuthCredential.password": "str",
                "restAuthCredential.username": "str",
                "restAuthEntraUsers": [{"displayName": "str", "objectId": "str", "upn": "str"}],
            },
            api_version="2025-01-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_get_azure_async_operation_status(self, resource_group):
        response = self.client.clusters.get_azure_async_operation_status(
            resource_group_name=resource_group.name,
            cluster_name="str",
            operation_id="str",
            api_version="2025-01-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_update_identity_certificate(self, resource_group):
        response = self.client.clusters.begin_update_identity_certificate(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={"applicationId": "str", "certificate": "str", "certificatePassword": "str"},
            api_version="2025-01-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_execute_script_actions(self, resource_group):
        response = self.client.clusters.begin_execute_script_actions(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={
                "persistOnSuccess": bool,
                "scriptActions": [
                    {"name": "str", "roles": ["str"], "uri": "str", "applicationName": "str", "parameters": "str"}
                ],
            },
            api_version="2025-01-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
