% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genePlots.R
\name{degPlot}
\alias{degPlot}
\title{Plot top genes allowing more variables to color and shape points}
\usage{
degPlot(
  dds,
  xs,
  res = NULL,
  n = 9,
  genes = NULL,
  group = NULL,
  batch = NULL,
  metadata = NULL,
  ann = c("geneID", "symbol"),
  slot = 1L,
  log2 = TRUE,
  xsLab = xs,
  ysLab = "abundance",
  color = "black",
  groupLab = group,
  batchLab = batch
)
}
\arguments{
\item{dds}{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet} object or SummarizedExperiment
or Matrix or data.frame. In case of a DESeqDataSet object, always
the normalized expression will be used
from \code{counts(dds, normalized = TRUE)}.}

\item{xs}{Character, colname in colData that will be used as X-axes.}

\item{res}{\link[DESeq2:DESeqResults]{DESeq2::DESeqResults} object.}

\item{n}{Integer number of genes to plot from the \code{res} object. It will
take the top N using padj values to order the table.}

\item{genes}{Character of gene names matching rownames of count data.}

\item{group}{Character, colname in colData to color points and add different
lines for each level.}

\item{batch}{Character, colname in colData to shape points, normally used by
batch effect visualization.}

\item{metadata}{Metadata in case dds is a matrix.}

\item{ann}{Columns in rowData (if available) used to print gene names. First
element in the vector is the column name in rowData that matches the
row.names of the \code{dds} or \code{count} object. Second element in the vector
is the column name in rowData that it will be used as the title for each
gene or feature figure.}

\item{slot}{Name of the slot to use to get count data.}

\item{log2}{Whether to apply or not log2 transformation.}

\item{xsLab}{Character, alternative label for x-axis (default: same as xs)}

\item{ysLab}{Character, alternative label for y-axis..}

\item{color}{Color to use to plot groups. It can be one color, or a palette
compatible with \code{ggplot2::scale_color_brewer()}.}

\item{groupLab}{Character, alternative label for group (default: same as group).}

\item{batchLab}{Character, alternative label for batch (default: same as batch).}
}
\value{
ggplot showing the expresison of the genes
}
\description{
Plot top genes allowing more variables to color and shape points
}
\examples{
data(humanGender)
library(DESeq2)
idx <- c(1:10, 75:85)
dse <- DESeqDataSetFromMatrix(assays(humanGender)[[1]][1:1000, idx],
  colData(humanGender)[idx,], design=~group)
dse <- DESeq(dse)
degPlot(dse, genes = rownames(dse)[1:10], xs = "group")
degPlot(dse, genes = rownames(dse)[1:10], xs = "group", color = "orange")
degPlot(dse, genes = rownames(dse)[1:10], xs = "group", group = "group",
        color = "Accent")
}
