% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trav_out_until.R
\name{trav_out_until}
\alias{trav_out_until}
\title{Traverse outward node-by-node until stopping conditions are met}
\usage{
trav_out_until(
  graph,
  conditions,
  max_steps = 30,
  exclude_unmatched = TRUE,
  add_to_selection = FALSE
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{conditions}{An option to use a stopping condition for the traversal. If
the condition is met during the traversal (i.e., the node(s) traversed to
match the condition), then those traversals will terminate at those nodes.
Otherwise, traversals with continue and terminate when the number of steps
provided in \code{max_steps} is reached.}

\item{max_steps}{The maximum number of \code{trav_out()} steps (i.e., node-to-node
traversals in the outward direction) to allow before stopping.}

\item{exclude_unmatched}{If \code{TRUE} (the default value) then any nodes not
satisfying the conditions provided in \code{conditions} that are in the ending
selection are excluded.}

\item{add_to_selection}{If \code{TRUE} then every node traversed will be part of
the final selection of nodes. If \code{FALSE} (the default value) then only the
nodes finally traversed to will be part of the final node selection.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph}, move along outward edges from one
or more nodes present in a selection to other connected nodes, replacing the
current nodes in the selection with those nodes traversed to until reaching
nodes that satisfy one or more conditions.

This traversal function makes use of an active selection of nodes. After the
traversal, depending on the traversal conditions, there will either be a
selection of nodes or no selection at all.

Selections of nodes can be performed using the following node selection
(\verb{select_*()}) functions: \code{\link[=select_nodes]{select_nodes()}}, \code{\link[=select_last_nodes_created]{select_last_nodes_created()}},
\code{\link[=select_nodes_by_degree]{select_nodes_by_degree()}}, \code{\link[=select_nodes_by_id]{select_nodes_by_id()}}, or
\code{\link[=select_nodes_in_neighborhood]{select_nodes_in_neighborhood()}}.

Selections of nodes can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out]{trav_out()}}, \code{\link[=trav_in]{trav_in()}}, \code{\link[=trav_both]{trav_both()}},
\code{\link[=trav_out_node]{trav_out_node()}}, \code{\link[=trav_in_node]{trav_in_node()}}, \code{\link[=trav_out_until]{trav_out_until()}}, or
\code{\link[=trav_in_until]{trav_in_until()}}.
}
\examples{
# Create a path graph and add
# values of 1 to 10 across the
# nodes from beginning to end;
# select the first path node
graph <-
  create_graph() \%>\%
  add_path(
    n = 10,
    node_data = node_data(
      value = 1:10)) \%>\%
  select_nodes_by_id(
    nodes = 1)

# Traverse outward, node-by-node
# until stopping at a node where
# the `value` attribute is 8
graph <-
  graph \%>\%
  trav_out_until(
    conditions =
      value == 8)

# Get the graph's node selection
graph \%>\% get_selection()

# Create two cycles in graph and
# add values of 1 to 6 to the
# first cycle, and values 7 to
# 12 in the second; select nodes
# `1` and `7`
graph <-
  create_graph() \%>\%
  add_cycle(
    n = 6,
    node_data = node_data(
      value = 1:6)) \%>\%
  add_cycle(
    n = 6,
    node_data = node_data(
      value = 7:12)) \%>\%
  select_nodes_by_id(
    nodes = c(1, 7))

# Traverse outward, node-by-node
# from `1` and `7` until stopping
# at the first nodes where the
# `value` attribute is 5, 6, or 15;
# specify that we should only
# keep the finally traversed to
# nodes that satisfy the conditions
graph <-
  graph \%>\%
  trav_out_until(
    conditions =
      value \%in\% c(5, 6, 9),
    exclude_unmatched = TRUE)

# Get the graph's node selection
graph \%>\% get_selection()

}
