% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R
\name{dplyr-ggvis}
\alias{dplyr-ggvis}
\alias{groups.ggvis}
\alias{group_by.ggvis}
\alias{ungroup.ggvis}
\alias{summarise.ggvis}
\alias{mutate.ggvis}
\alias{arrange.ggvis}
\alias{select.ggvis}
\alias{filter.ggvis}
\alias{distinct.ggvis}
\alias{slice.ggvis}
\alias{rename.ggvis}
\alias{transmute.ggvis}
\alias{groups.reactive}
\alias{ungroup.reactive}
\alias{group_by.reactive}
\alias{summarise.reactive}
\alias{mutate.reactive}
\alias{arrange.reactive}
\alias{select.reactive}
\alias{filter.reactive}
\alias{distinct.reactive}
\alias{slice.reactive}
\alias{rename.reactive}
\alias{transmute.reactive}
\title{Dplyr verbs for ggvis.}
\usage{
\method{groups}{ggvis}(x)

\method{group_by}{ggvis}(.data, ..., .add = FALSE)

\method{ungroup}{ggvis}(x)

\method{summarise}{ggvis}(.data, ...)

\method{mutate}{ggvis}(.data, ...)

\method{arrange}{ggvis}(.data, ...)

\method{select}{ggvis}(.data, ...)

filter.ggvis(.data, ...)

\method{distinct}{ggvis}(.data, ...)

\method{slice}{ggvis}(.data, ...)

\method{rename}{ggvis}(.data, ...)

\method{transmute}{ggvis}(.data, ...)

\method{groups}{reactive}(x)

\method{ungroup}{reactive}(x)

\method{group_by}{reactive}(.data, ..., add = FALSE)

\method{summarise}{reactive}(.data, ...)

\method{mutate}{reactive}(.data, ...)

\method{arrange}{reactive}(.data, ...)

\method{select}{reactive}(.data, ...)

filter.reactive(.data, ...)

\method{distinct}{reactive}(.data, ...)

\method{slice}{reactive}(.data, ...)

\method{rename}{reactive}(.data, ...)

\method{transmute}{reactive}(.data, ...)
}
\description{
Applying a dplyr verb to a ggvis object creates a reactive transformation:
whenever the underlying data changes the transformation will be recomputed.
}
\section{Non-standard evaluation}{

Both dplyr and shiny do non-standard evaluation, so to help each package
figure out when it should evaluate its code, reactive components in
these functions must be wrapped in \code{eval()}.
}

\examples{
library(dplyr)
base <- mtcars \%>\% ggvis(~mpg, ~cyl) \%>\% layer_points()
base \%>\% group_by(cyl) \%>\% summarise(mpg = mean(mpg)) \%>\%
  layer_points(fill := "red", size := 100)

base \%>\% filter(mpg > 25) \%>\% layer_points(fill := "red")

base \%>\% mutate(cyl = jitter(cyl)) \%>\% layer_points(fill := "red")

\dontrun{
# Dynamically restrict range using filter
mtcars \%>\% ggvis(~disp, ~mpg) \%>\%
   filter(cyl > eval(input_slider(0, 10))) \%>\%
   layer_points()

# Dynamically compute box-cox transformation with mutate
bc <- function(x, lambda) {
  if (abs(lambda) < 1e-6) log(x) else (x ^ lambda - 1) / lambda
}
bc_slider <- input_slider(-2, 2, 1, step = 0.1)
mtcars \%>\%
 ggvis(~disp, ~mpg) \%>\%
 mutate(disp = bc(disp, eval(bc_slider))) \%>\%
 layer_points()
}
}
\keyword{internal}
