% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{MedianAE}
\alias{MedianAE}
\title{Median Absolute Error Loss}
\usage{
MedianAE(y_pred, y_true)
}
\arguments{
\item{y_pred}{Estimated target values vector}

\item{y_true}{Ground truth (correct) target values vector}
}
\value{
Median Absolute Error Loss
}
\description{
Compute the median absolute error regression loss.
}
\examples{
data(cars)
reg <- lm(log(dist) ~ log(speed), data = cars)
MedianAE(y_pred = exp(reg$fitted.values), y_true = cars$dist)
}

