% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unload.R
\name{unload}
\alias{unload}
\alias{unregister}
\title{Unload a package}
\usage{
unload(package = pkg_name(), quiet = FALSE)

unregister(package = pkg_name())
}
\arguments{
\item{package}{package name.}

\item{quiet}{if \code{TRUE} suppresses output from this function.}
}
\description{
\code{unload()} attempts to cleanly unload a package, including unloading
its namespace, deleting S4 class definitions and unloading any loaded
DLLs. Unfortunately S4 classes are not really designed to be cleanly
unloaded, and so we have to manually modify the class dependency graph in
order for it to work - this works on the cases for which we have tested
but there may be others.  Similarly, automated DLL unloading is best tested
for simple scenarios (particularly with \code{useDynLib(pkgname)} and may
fail in other cases. If you do encounter a failure, please file a bug report
at \url{https://github.com/r-lib/pkgload/issues}.

\code{unregister()} is a gentler version of \code{unload()} which removes the
package from the search path, unregisters methods, and unregisters
the namespace. It doesn't unload the namespace or its DLL to keep
it in working order in case of dangling references.
}
\examples{
\dontrun{
# Unload package that is in current directory
unload()

# Unload package that is in ./ggplot2/
unload(pkg_name("ggplot2/"))

library(ggplot2)
# unload the ggplot2 package directly by name
unload("ggplot2")
}
}
