% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-message.R
\name{format_error_bullets}
\alias{format_error_bullets}
\title{Format bullets for error messages}
\usage{
format_error_bullets(x)
}
\arguments{
\item{x}{A named character vector of messages. Elements named as
\code{x} or \code{i} are prefixed with the corresponding bullet.}
}
\description{
\code{format_error_bullets()} takes a character vector and returns a single
string (or an empty vector if the input is empty). The elements of
the input vector are assembled as a list of bullets, depending on
their names:
\itemize{
\item Elements named \code{"i"} are bulleted with a blue "info" symbol.
\item Elements named \code{"x"} are bulleted with a red "cross" symbol.
\item Unnamed elements are bulleted with a "*" symbol.
}

This experimental infrastructure is based on the idea that
sentences in error messages are best kept short and simple. From
this point of view, the best way to present the information is in
the \code{\link[=cnd_body]{cnd_body()}} method of an error conditon, as a bullet list of
simple sentences containing a single clause. The info and cross
symbols of the bullets provide hints on how to interpret the bullet
relative to the general error issue, which should be supplied as
\code{\link[=cnd_header]{cnd_header()}}.
}
