// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from TestDisplay.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.test {
  public class Display : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("test.Display:1.0.0", null);

    public Display(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Display(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Display StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Display(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum Orientation {
      NORMAL,
      FLIPPED,
      LEFT,
      RIGHT,
    }

    public class Info : ICloneable {
      public object Clone() {
        Info copy = new Info();
        copy.type = this.type;
        copy.address = this.address;
        copy.options = this.options;
        copy.orientation = this.orientation;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["type"] = this.type;
        json["address"] = this.address;
        json["options"] = new JsonArray(this.options.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value)
        })));
        json["orientation"] = (int)this.orientation;
        return json;
      }

      public static Info Decode(LightJson.JsonObject json, Agent agent) {
        Info inst = new Info();
        inst.type = (string)json["type"];
        inst.address = (string)json["address"];
        inst.options = DictionaryHelper.Create(json["options"].AsJsonArray.Select(
          _value => new System.Collections.Generic.KeyValuePair<string, string>(_value["key"], (string)_value["value"])));
        inst.orientation = (Com.Raritan.Idl.test.Display.Orientation)(int)json["orientation"];
        return inst;
      }

      public string type = "";
      public string address = "";
      public System.Collections.Generic.IDictionary<string, string> options = new System.Collections.Generic.Dictionary<string, string>();
      public Com.Raritan.Idl.test.Display.Orientation orientation = Com.Raritan.Idl.test.Display.Orientation.NORMAL;
    }

    public class GetInfoResult {
      public Com.Raritan.Idl.test.Display.Info _ret_;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret._ret_ = Com.Raritan.Idl.test.Display.Info.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret._ret_ = Com.Raritan.Idl.test.Display.Info.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TestSequenceResult {
    }

    public TestSequenceResult testSequence(int cycleTime_ms) {
      var _parameters = new LightJson.JsonObject();
      _parameters["cycleTime_ms"] = cycleTime_ms;

      var _result = RpcCall("testSequence", _parameters);
      var _ret = new TestSequenceResult();
      return _ret;
    }

    public AsyncRequest testSequence(int cycleTime_ms, AsyncRpcResponse<TestSequenceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return testSequence(cycleTime_ms, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest testSequence(int cycleTime_ms, AsyncRpcResponse<TestSequenceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["cycleTime_ms"] = cycleTime_ms;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("testSequence", _parameters,
        _result => {
          try {
            var _ret = new TestSequenceResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
