## Contributing to Reflex

There are just a few simple guidelines for reporting issues or submitting
patches.

### Issues

* For bugs:
  - Make sure you're using the latest version of Reflex
  - Describe the expected and actual behavior
  - Include your operating system with the bug report
* Feature requests are unlikely to be implemented unless you're willing to
  contribute the code.

### Pull Requests

* For nontrivial new features, open an issue to describe the change first so we
  can all be on the same page about whether it's a good fit for Reflex.
  Tiny improvements and bug fixes don't need this.
* Make a branch just for the bugfix/feature. Split it up into reasonably-sized
  commits. Make one new branch/pull request for each logically distinct
  bugfix/feature.
* If you're not already on the list, add your name to the authors list in
  README.md (in a commit by itself with your pull request).

### Code style

* Run `gofmt` on any code before committing.
* Stick to the code style around you.
