from setuptools import find_packages
from setuptools import setup

package_name = 'ament_xmllint'

setup(
    name=package_name,
    version='0.20.3',
    packages=find_packages(exclude=['test']),
    data_files=[
        ('share/' + package_name, ['package.xml']),
        ('share/ament_index/resource_index/packages',
            ['resource/' + package_name]),
    ],
    package_data={'': ['py.typed']},
    install_requires=['setuptools'],
    zip_safe=True,
    author='Dirk Thomas',
    author_email='dthomas@osrfoundation.org',
    maintainer='Michael Jeronimo',
    maintainer_email='michael.jeronimo@openrobotics.org',
    url='https://github.com/ament/ament_lint',
    download_url='https://github.com/ament/ament_lint/releases',
    keywords=['ROS'],
    classifiers=[
        'Intended Audience :: Developers',
        'Programming Language :: Python',
        'Topic :: Software Development',
    ],
    description='Check XML markup using xmllint.',
    long_description="""\
The ability to check XML files like the package manifest using xmllint
and generate xUnit test result files.""",
    license='Apache License, Version 2.0',
    extras_require={
        'test': [
            'pytest',
        ],
    },
    entry_points={
        'console_scripts': [
            'ament_xmllint = ament_xmllint.main:main',
        ],
        'pytest11': [
            'ament_xmllint = ament_xmllint.pytest_marker',
        ],
    },
)
