### WARNING: This file is auto-generated by our OpenAPI spec. Do not
### edit it manually.

require_relative '../../resource_includes/response_helper'

module Asana
  module Resources
    class PortfoliosBase < Resource

      def self.inherited(base)
        Registry.register(base)
      end

      class << self
        # Add a custom field to a portfolio
        #
        # portfolio_gid - [str]  (required) Globally unique identifier for the portfolio.
        # options - [Hash] the request I/O options
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def add_custom_field_setting_for_portfolio(client, portfolio_gid: required("portfolio_gid"), options: {}, **data)
          path = "/portfolios/{portfolio_gid}/addCustomFieldSetting"
          path["{portfolio_gid}"] = portfolio_gid
          CustomFieldSetting.new(parse(client.post(path, body: data, options: options)).first, client: client)
        end

        # Add a portfolio item
        #
        # portfolio_gid - [str]  (required) Globally unique identifier for the portfolio.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def add_item_for_portfolio(client, portfolio_gid: required("portfolio_gid"), options: {}, **data)
          path = "/portfolios/{portfolio_gid}/addItem"
          path["{portfolio_gid}"] = portfolio_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Add users to a portfolio
        #
        # portfolio_gid - [str]  (required) Globally unique identifier for the portfolio.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def add_members_for_portfolio(client, portfolio_gid: required("portfolio_gid"), options: {}, **data)
          path = "/portfolios/{portfolio_gid}/addMembers"
          path["{portfolio_gid}"] = portfolio_gid
          Portfolio.new(parse(client.post(path, body: data, options: options)).first, client: client)
        end

        # Create a portfolio
        #

        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def create_portfolio(client, options: {}, **data)
          path = "/portfolios"
          Portfolio.new(parse(client.post(path, body: data, options: options)).first, client: client)
        end

        # Delete a portfolio
        #
        # portfolio_gid - [str]  (required) Globally unique identifier for the portfolio.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def delete_portfolio(client, portfolio_gid: required("portfolio_gid"), options: {})
          path = "/portfolios/{portfolio_gid}"
          path["{portfolio_gid}"] = portfolio_gid
          parse(client.delete(path, options: options)).first
        end

        # Get portfolio items
        #
        # portfolio_gid - [str]  (required) Globally unique identifier for the portfolio.
        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_items_for_portfolio(client, portfolio_gid: required("portfolio_gid"), options: {})
          path = "/portfolios/{portfolio_gid}/items"
          path["{portfolio_gid}"] = portfolio_gid
          Collection.new(parse(client.get(path, options: options)), type: Project, client: client)
        end

        # Get a portfolio
        #
        # portfolio_gid - [str]  (required) Globally unique identifier for the portfolio.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_portfolio(client, portfolio_gid: required("portfolio_gid"), options: {})
          path = "/portfolios/{portfolio_gid}"
          path["{portfolio_gid}"] = portfolio_gid
          Portfolio.new(parse(client.get(path, options: options)).first, client: client)
        end

        # Get multiple portfolios
        #

        # workspace - [str]  (required) The workspace or organization to filter portfolios on.
        # owner - [str]  (required) The user who owns the portfolio. Currently, API users can only get a list of portfolios that they themselves own.
        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_portfolios(client, workspace: nil, owner: nil, options: {})
          path = "/portfolios"
          params = { workspace: workspace, owner: owner }.reject { |_,v| v.nil? || Array(v).empty? }
          Collection.new(parse(client.get(path, params: params, options: options)), type: Portfolio, client: client)
        end

        # Remove a custom field from a portfolio
        #
        # portfolio_gid - [str]  (required) Globally unique identifier for the portfolio.
        # options - [Hash] the request I/O options
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def remove_custom_field_setting_for_portfolio(client, portfolio_gid: required("portfolio_gid"), options: {}, **data)
          path = "/portfolios/{portfolio_gid}/removeCustomFieldSetting"
          path["{portfolio_gid}"] = portfolio_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Remove a portfolio item
        #
        # portfolio_gid - [str]  (required) Globally unique identifier for the portfolio.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def remove_item_for_portfolio(client, portfolio_gid: required("portfolio_gid"), options: {}, **data)
          path = "/portfolios/{portfolio_gid}/removeItem"
          path["{portfolio_gid}"] = portfolio_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Remove users from a portfolio
        #
        # portfolio_gid - [str]  (required) Globally unique identifier for the portfolio.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def remove_members_for_portfolio(client, portfolio_gid: required("portfolio_gid"), options: {}, **data)
          path = "/portfolios/{portfolio_gid}/removeMembers"
          path["{portfolio_gid}"] = portfolio_gid
          Portfolio.new(parse(client.post(path, body: data, options: options)).first, client: client)
        end

        # Update a portfolio
        #
        # portfolio_gid - [str]  (required) Globally unique identifier for the portfolio.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to PUT
        def update_portfolio(client, portfolio_gid: required("portfolio_gid"), options: {}, **data)
          path = "/portfolios/{portfolio_gid}"
          path["{portfolio_gid}"] = portfolio_gid
          Portfolio.new(parse(client.put(path, body: data, options: options)).first, client: client)
        end

      end
    end
  end
end
