/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axis.scalepolicy.AxisScalePolicyTransformation;
import info.monitorenter.util.Range;
import info.monitorenter.util.math.MathUtil;
import java.awt.event.MouseEvent;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AAxisTransformation<T extends AxisScalePolicyTransformation>
extends AAxis<T> {
    protected long m_outputErrorTstamp = 0L;

    public AAxisTransformation() {
    }

    public AAxisTransformation(IAxisLabelFormatter formatter, T scalePolicy) {
        super(formatter, scalePolicy);
    }

    @Override
    protected AAxis.AChart2DDataAccessor createAccessor(Chart2D chart, int dimension, int position) {
        AAxis.AChart2DDataAccessor result;
        if (dimension == 1) {
            if ((position & 0x30) == 0) {
                throw new IllegalArgumentException("X axis only valid with top or bottom position.");
            }
            this.setAxisPosition(position);
            result = new XDataAccessor(chart);
        } else if (dimension == 2) {
            if ((position & 0xC) == 0) {
                throw new IllegalArgumentException("Y axis only valid with left or right position.");
            }
            this.setAxisPosition(position);
            result = new YDataAccessor(chart);
        } else {
            throw new IllegalArgumentException("Dimension has to be Chart2D.X or Chart2D.Y!");
        }
        return result;
    }

    public double getMaxTransformed() {
        double result = 1.0;
        try {
            result = this.transform(super.getMax());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    public double getMinTransformed() {
        double result = 0.0;
        try {
            result = this.transform(super.getMin());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public final double getScaledValue(double absolute) {
        double result;
        Range range = new Range(this.getMinTransformed(), this.getMaxTransformed());
        try {
            result = this.transform(absolute) - range.getMin();
            double scaler = range.getExtent();
            if (!MathUtil.isDouble(result /= scaler)) {
                result = 0.0;
            }
        }
        catch (IllegalArgumentException e) {
            long tstamp = System.currentTimeMillis();
            if (tstamp - this.m_outputErrorTstamp > 30000L) {
                System.out.println(e.getLocalizedMessage());
                this.m_outputErrorTstamp = tstamp;
            }
            result = 0.0;
        }
        return result;
    }

    @Override
    public void scaleTrace(ITrace2D trace) {
        Range range = new Range(this.getMinTransformed(), this.getMaxTransformed());
        this.m_accessor.scaleTrace(trace, range);
    }

    public abstract double transform(double var1) throws IllegalArgumentException;

    @Override
    public final double translateMousePosition(MouseEvent mouseEvent) throws IllegalArgumentException {
        return this.untransform(this.getAccessor().translateMousePosition(mouseEvent));
    }

    @Override
    public double translatePxToValue(int pixel) {
        return this.untransform(this.m_accessor.translatePxToValue(pixel));
    }

    public abstract double untransform(double var1);

    protected final class YDataAccessor
    extends AAxis.YDataAccessor {
        public YDataAccessor(Chart2D chart) {
            super(chart);
        }

        protected void scaleTrace(ITrace2D trace, Range range) {
            if (trace.isVisible()) {
                double scaler = range.getExtent();
                Iterator<ITracePoint2D> itPoints = trace.iterator();
                while (itPoints.hasNext()) {
                    double result;
                    ITracePoint2D point = itPoints.next();
                    double absolute = point.getY();
                    try {
                        result = AAxisTransformation.this.transform(absolute) - range.getMin();
                        if (!MathUtil.isDouble(result /= scaler)) {
                            result = 0.0;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        long tstamp = System.currentTimeMillis();
                        if (tstamp - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                            System.out.println(e.getLocalizedMessage());
                            AAxisTransformation.this.m_outputErrorTstamp = tstamp;
                        }
                        result = 0.0;
                    }
                    point.setScaledY(result);
                }
            }
        }

        public double translatePxToValue(int pixel) {
            double result = 0.0;
            double px = this.m_chart.getYChartStart() - pixel;
            int rangeY = this.m_chart.getYChartStart() - this.m_chart.getYChartEnd();
            if (rangeY != 0) {
                double scaledY = px / (double)rangeY;
                Range valueRangeY = new Range(AAxisTransformation.this.getMinTransformed(), AAxisTransformation.this.getMaxTransformed());
                result = scaledY * valueRangeY.getExtent() + valueRangeY.getMin();
            }
            return result;
        }

        public final int translateValueToPx(double value) {
            double normalizedValue;
            int result = 0;
            Range range = AAxisTransformation.this.getRange();
            double scaler = range.getExtent();
            double absolute = value;
            try {
                normalizedValue = AAxisTransformation.this.transform(absolute) - range.getMin();
                if (!MathUtil.isDouble(normalizedValue /= scaler)) {
                    normalizedValue = 0.0;
                }
            }
            catch (IllegalArgumentException e) {
                long tstamp = System.currentTimeMillis();
                if (tstamp - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                    System.out.println(e.getLocalizedMessage());
                    AAxisTransformation.this.m_outputErrorTstamp = tstamp;
                }
                normalizedValue = 0.0;
            }
            Chart2D chart = this.getChart();
            int pixelRange = this.getPixelRange();
            result = (int)Math.round((double)chart.getYChartStart() - normalizedValue * (double)pixelRange);
            return result;
        }
    }

    protected final class XDataAccessor
    extends AAxis.XDataAccessor {
        public XDataAccessor(Chart2D chart) {
            super(chart);
        }

        protected void scaleTrace(ITrace2D trace, Range range) {
            if (trace.isVisible()) {
                Iterator<ITracePoint2D> itPoints = trace.iterator();
                double scaler = range.getExtent();
                itPoints = trace.iterator();
                while (itPoints.hasNext()) {
                    double result;
                    ITracePoint2D point = itPoints.next();
                    double absolute = point.getX();
                    try {
                        result = AAxisTransformation.this.transform(absolute) - range.getMin();
                        if (!MathUtil.isDouble(result /= scaler)) {
                            result = 0.0;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        long tstamp = System.currentTimeMillis();
                        if (tstamp - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                            System.out.println(e.getLocalizedMessage());
                            AAxisTransformation.this.m_outputErrorTstamp = tstamp;
                        }
                        result = 0.0;
                    }
                    point.setScaledX(result);
                }
            }
        }

        public double translatePxToValue(int pixel) {
            double result = 0.0;
            double px = pixel - this.m_chart.getXChartStart();
            int rangeX = this.m_chart.getXChartEnd() - this.m_chart.getXChartStart();
            if (rangeX != 0) {
                double scaledX = px / (double)rangeX;
                Range valueRangeX = new Range(AAxisTransformation.this.getMinTransformed(), AAxisTransformation.this.getMaxTransformed());
                result = scaledX * valueRangeX.getExtent() + valueRangeX.getMin();
            }
            return result;
        }

        public final int translateValueToPx(double value) {
            double normalizedValue;
            Range range = new Range(AAxisTransformation.this.getMinTransformed(), AAxisTransformation.this.getMaxTransformed());
            double scaler = range.getExtent();
            double absolute = value;
            try {
                normalizedValue = AAxisTransformation.this.transform(absolute) - range.getMin();
                if (!MathUtil.isDouble(normalizedValue /= scaler)) {
                    normalizedValue = 0.0;
                }
            }
            catch (IllegalArgumentException e) {
                long tstamp = System.currentTimeMillis();
                if (tstamp - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                    System.out.println(e.getLocalizedMessage());
                    AAxisTransformation.this.m_outputErrorTstamp = tstamp;
                }
                normalizedValue = 0.0;
            }
            Chart2D chart = this.getChart();
            int pixelRange = this.getPixelRange();
            int result = (int)Math.round((double)chart.getXChartStart() + normalizedValue * (double)pixelRange);
            return result;
        }
    }
}

