# Developing Scala in IntelliJ IDEA

Use the latest IntelliJ release and install the Scala plugin from within the IDE.

## Initial Setup

To create the IntelliJ project files:

  - Run `sbt intellij`
  - Open `src/intellij/scala.ipr` in IntelliJ
  - In `File` → `Project Structure` → `Project` → `Project SDK`, create an SDK entry
    named "1.8" containing the Java 1.8 SDK (1.6 if you're on the Scala the 2.11.x branch)

The project files are created as copies of the `.SAMPLE` files, which are under version
control. The actual IntelliJ project files are in `.gitignore` so that local changes
are ignored.

## Dependencies

For every module in the IntelliJ project there is a corresponding `-deps` library, for exmaple `compiler-deps` provides `ant.jar` for the compiler codebase.
The `.jar` files in these `-deps` libraries can be easily kept up-to-date by running `sbt intellij` again.
This is necessary whenever the dependencies in the sbt build change, for example when the `starr` version is updated.

Note that this command only patches the dependency lists, all other settings in the IntelliJ project definition are unchanged.
To overwrite the project definition files by copying the `.SAMPLE` files again run `sbt intellijFromSample`.

## Switching Branches

The 2.12.x branch contains IntelliJ module files for `actors` and `forkjoin` even though these modules only exist in 2.11.x.
This allows using the same IntelliJ project files when switching to the 2.11.x branch (without causing any issues while working on 2.12.x).

When switching between 2.11.x and 2.12.x, make sure to run `sbt intellij`.
Note that the `Project SDK` is not updated in this process.
If you want to use the Java 1.6 SDK while working on 2.11.x you need to change it manually (`File` → `Project Structure` → `Project` → `Project SDK`).

If you switch between 2.11.x and 2.12.x often, it makes sense to have a separate clone
of the repository for each branch.

## Incremental Compilation

Run `Build` → `Make Project` to build all modules of the Scala repository (library,
compiler, etc). Note that compilation IntelliJ is performed in a single pass (no
bootstrap), like the sbt build.

Note that the output directory when compiling in IntelliJ is the same as for the
sbt and (deprecated) ant builds. This allows building incrementally in IntelliJ
and directly use the changes using the command-line scripts in `build/quick/bin/`.

## Running JUnit Tests

JUnit tests can be executed by right-clicking on a test class or test method and
selecting "Run" or "Debug". The debugger will allow you to stop at breakpoints
within the Scala library.

It is possible to invoke the Scala compiler from a JUnit test (passing the source
code as a string) and inspect the generated bytecode, see for example
`scala.issues.BytecodeTest`. Debugging such a test is an easy way to stop at
breakpoints within the Scala compiler.

## Running the Compiler and REPL

You can create run/debug configurations to run the compiler and REPL directly within
IntelliJ, which might accelerate development and debugging of the the compiler.

To debug the Scala codebase you can also use "Remote" debug configuration and pass
the corresponding arguments to the jvm running the compiler / program.

To run the compiler create an "Application" configuration with
  - Main class: `scala.tools.nsc.Main`
  - Program arguments: `-usejavacp -cp sandbox -d sandbox sandbox/Test.scala`
  - Working directory: the path of your checkout
  - Use classpath of module: `compiler`

To run the REPL create an "Application" configuration with
  - Main class: `scala.tools.nsc.MainGenericRunner`
  - Program arguments: `-usejavacp`
  - Working directory: the path of your checkout
  - Use classpath of module: `repl`

## Updating the `.SAMPLE` files

The command `intellijToSample` overwrites the `.SAMPLE` files using the current project definition files.
