ALTER DYNAMIC TABLE foo REFRESH;

ALTER DYNAMIC TABLE my_dynamic_table SUSPEND;

ALTER DYNAMIC TABLE IF EXISTS my_dynamic_table SUSPEND;

ALTER DYNAMIC TABLE my_dynamic_table RESUME;

ALTER DYNAMIC TABLE my_dynamic_table RENAME TO my_updated_dynamic_table;

ALTER DYNAMIC TABLE my_dynamic_table SWAP WITH my_new_dynamic_table;

ALTER DYNAMIC TABLE my_dynamic_table REFRESH;

ALTER DYNAMIC TABLE my_dynamic_table REFRESH COPY SESSION;

ALTER DYNAMIC TABLE my_dynamic_table CLUSTER BY (date);

ALTER DYNAMIC TABLE my_dynamic_table CLUSTER BY (c1, c2);

ALTER DYNAMIC TABLE my_dynamic_table DROP CLUSTERING KEY;

ALTER DYNAMIC TABLE my_dynamic_table RESUME RECLUSTER;

ALTER DYNAMIC TABLE my_dynamic_table SUSPEND RECLUSTER;

ALTER DYNAMIC TABLE my_dynamic_table SET COMMENT = 'a dynamic table comment';

ALTER DYNAMIC TABLE my_dynamic_table UNSET COMMENT;

ALTER DYNAMIC TABLE my_dynamic_table SET TAG my_tag = 'tag_value';

ALTER DYNAMIC TABLE my_dynamic_table SET TAG my_tag = 'tag_value',
my_other_tag = 'other_value';

ALTER DYNAMIC TABLE my_dynamic_table UNSET TAG my_tag;

ALTER DYNAMIC TABLE my_dynamic_table ADD ROW ACCESS POLICY rap ON (pii1);

ALTER DYNAMIC TABLE my_dynamic_table ADD ROW ACCESS POLICY rap ON (pii1, pii2);

ALTER DYNAMIC TABLE my_dynamic_table DROP ROW ACCESS POLICY rap;

ALTER DYNAMIC TABLE my_dynamic_table DROP ROW ACCESS POLICY rap,
ADD ROW ACCESS POLICY rap ON (pii1, pii2);

ALTER DYNAMIC TABLE my_dynamic_table DROP ALL ROW ACCESS POLICIES;

ALTER DYNAMIC TABLE my_dynamic_table SET AGGREGATION POLICY my_policy;

ALTER DYNAMIC TABLE my_dynamic_table
SET AGGREGATION POLICY my_policy ENTITY KEY (col1);

ALTER DYNAMIC TABLE my_dynamic_table
SET AGGREGATION POLICY my_policy ENTITY KEY (col1, col2, col3);

ALTER DYNAMIC TABLE my_dynamic_table SET AGGREGATION POLICY my_policy FORCE;

ALTER DYNAMIC TABLE my_dynamic_table
SET AGGREGATION POLICY my_policy ENTITY KEY (col1) FORCE;

ALTER DYNAMIC TABLE my_table UNSET AGGREGATION POLICY;

ALTER DYNAMIC TABLE my_dynamic_table ADD SEARCH OPTIMIZATION;

ALTER DYNAMIC TABLE my_dynamic_table ADD SEARCH OPTIMIZATION
ON EQUALITY (c1), EQUALITY (c2, c3);

ALTER DYNAMIC TABLE my_dynamic_table ADD SEARCH OPTIMIZATION
ON EQUALITY (*);

ALTER DYNAMIC TABLE my_dynamic_table ADD SEARCH OPTIMIZATION
ON EQUALITY (*), SUBSTRING (*), GEO (*);

ALTER DYNAMIC TABLE my_dynamic_table ADD SEARCH OPTIMIZATION
ON EQUALITY (c1, c2);

ALTER DYNAMIC TABLE my_dynamic_table DROP SEARCH OPTIMIZATION
ON EQUALITY (c1), EQUALITY (c2, c3);

ALTER DYNAMIC TABLE my_dynamic_table DROP SEARCH OPTIMIZATION
ON EQUALITY (c1, c2), 5, c3;

ALTER DYNAMIC TABLE my_dynamic_table SUSPEND SEARCH OPTIMIZATION
ON EQUALITY (c1), EQUALITY (c2, c3);

ALTER DYNAMIC TABLE my_dynamic_table SUSPEND SEARCH OPTIMIZATION
ON EQUALITY (c1, c2), 5, c3;

ALTER DYNAMIC TABLE my_dynamic_table RESUME SEARCH OPTIMIZATION
ON EQUALITY (c1), EQUALITY (c2, c3);

ALTER DYNAMIC TABLE my_dynamic_table RESUME SEARCH OPTIMIZATION
ON EQUALITY (c1, c2), 5, c3;

ALTER DYNAMIC TABLE my_dynamic_table SET TARGET_LAG = '1 hour';

ALTER DYNAMIC TABLE my_dynamic_table SET TARGET_LAG = DOWNSTREAM;

ALTER DYNAMIC TABLE my_dynamic_table SET WAREHOUSE = my_warehouse;

ALTER DYNAMIC TABLE my_dynamic_table SET DATA_RETENTION_TIME_IN_DAYS = 7;

ALTER DYNAMIC TABLE my_dynamic_table SET MAX_DATA_EXTENSION_TIME_IN_DAYS = 7;

ALTER DYNAMIC TABLE my_dynamic_table SET DEFAULT_DDL_COLLATION = 'en_US-trim';

-- TODO: Validate if DEBUG might be quoted or must be quoted
ALTER DYNAMIC TABLE my_dynamic_table SET LOG_LEVEL = DEBUG;

ALTER DYNAMIC TABLE my_dynamic_table SET CONTACT (STEWARD = steward_group);

ALTER DYNAMIC TABLE my_dynamic_table SET CONTACT
(
    STEWARD = steward_group,
    SUPPORT = support_group,
    ACCESS_APPROVAL = access_group
);

ALTER DYNAMIC TABLE my_dynamic_table
SET IMMUTABLE WHERE (ts < current_timestamp() - INTERVAL '1 day');


ALTER DYNAMIC TABLE my_dynamic_table UNSET DATA_RETENTION_TIME_IN_DAYS;
ALTER DYNAMIC TABLE my_dynamic_table UNSET MAX_DATA_EXTENSION_TIME_IN_DAYS;
ALTER DYNAMIC TABLE my_dynamic_table UNSET DEFAULT_DDL_COLLATION;
ALTER DYNAMIC TABLE my_dynamic_table UNSET LOG_LEVEL;
ALTER DYNAMIC TABLE my_dynamic_table UNSET CONTACT STEWARD;
ALTER DYNAMIC TABLE my_dynamic_table UNSET CONTACT SUPPORT;
ALTER DYNAMIC TABLE my_dynamic_table UNSET CONTACT ACCESS_APPROVAL;
ALTER DYNAMIC TABLE my_dynamic_table UNSET IMMUTABLE;
