/***************************************************************************
                            KActionMenu.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A KActionMenu is an action that holds a sub-menu of other actions.
 insert() and remove() allow to insert and remove actions into this action-menu.
 Plugged in a popupmenu, it will create a submenu.
 Plugged in a toolbar, it will create a button with a popup menu.

 This is the action used by the XMLGUI since it holds other actions.
 If you want a submenu for selecting one tool among many (without icons), see KSelectAction.
 See also setDelayed about the main action.
 
 See {@link KActionMenuSignals} for signals emitted by KActionMenu.

 See {@link KActionMenuEventHandling} for event handlers to override in subclasses of KActionMenu.

 @short 
 A KActionMenu is an action that holds a sub-menu of other actions.
*/
public class KActionMenu extends KAction  {
	protected KActionMenu(Class dummy){super((Class) null);}

	private native void newKActionMenu( String text, QObject parent, String name);
	public KActionMenu( String text, QObject parent, String name) {
		super((Class) null);
		newKActionMenu( text, parent, name);
	}
	private native void newKActionMenu( String text);
	public KActionMenu( String text) {
		super((Class) null);
		newKActionMenu( text);
	}
	private native void newKActionMenu( String text, QIconSet icon, QObject parent, String name);
	public KActionMenu( String text, QIconSet icon, QObject parent, String name) {
		super((Class) null);
		newKActionMenu( text, icon, parent, name);
	}
	private native void newKActionMenu( String text, QIconSet icon);
	public KActionMenu( String text, QIconSet icon) {
		super((Class) null);
		newKActionMenu( text, icon);
	}
	private native void newKActionMenu( String text, String icon, QObject parent, String name);
	public KActionMenu( String text, String icon, QObject parent, String name) {
		super((Class) null);
		newKActionMenu( text, icon, parent, name);
	}
	private native void newKActionMenu( String text, String icon);
	public KActionMenu( String text, String icon) {
		super((Class) null);
		newKActionMenu( text, icon);
	}
	private native void newKActionMenu( QObject parent, String name);
	public KActionMenu( QObject parent, String name) {
		super((Class) null);
		newKActionMenu( parent, name);
	}
	private native void newKActionMenu();
	public KActionMenu() {
		super((Class) null);
		newKActionMenu();
	}
	protected native void finalize() throws InternalError;
	public native void insert( KAction arg1, int index);
	public native void insert( KAction arg1);
	public native void remove( KAction arg1);
	public native KPopupMenu popupMenu();
	public native void popup( QPoint global);

/** 
       Returns true if this action creates a delayed popup menu
       when plugged in a KToolbar.
     
*/
	public native boolean delayed();

/** 
       If set to true, this action will create a delayed popup menu
       when plugged in a KToolbar. Otherwise it creates a normal popup.
       Default: delayed

       Remember that if the "main" action (the toolbar button itself)
       cannot be clicked, then you should call setDelayed(false).

       On the opposite, if the main action can be clicked, it can only happen
       in a toolbar: in a menu, the parent of a submenu can't be activated.
       To get a "normal" menu item when plugged a menu (and no submenu)
       use KToolBarPopupAction.
    
*/
	public native void setDelayed( boolean _delayed);

/** 
 Returns true if this action creates a sticky popup menu.
 See {@link setStickyMenu}.
     
*/
	public native boolean stickyMenu();

/** 
 If set to true, this action will create a sticky popup menu
 when plugged in a KToolbar.
 "Sticky", means it's visible until a selection is made or the mouse is
 clicked elsewhere. This feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.
 Default: sticky.
     
*/
	public native void setStickyMenu( boolean sticky);
	public native int plug( QWidget widget, int index);
	public native int plug( QWidget widget);
	public native void unplug( QWidget widget);
	public native void setEnabled( boolean b);
	protected native void setEnabled( int i, boolean enable);
	protected native void setText( int identifier, String text);
	protected native void setIconSet( int identifier, QIconSet iconSet);
	public native void setIconSet( QIconSet i);
	public native void setText( String s);
}
