package org.kde.koala;
import org.kde.qt.*;


/** {@link KFileIconView} emits these signals */
public interface KFileIconViewSignals {
	void rightButtonPressed( QIconViewItem item, QPoint pos );
	void moved();
	void destroyed();
	void returnPressed( QIconViewItem item );
	void rightButtonClicked( QIconViewItem item, QPoint pos );
	void contentsMoving( int x, int y );
	void pressed( QIconViewItem arg1, QPoint arg2 );
	void clicked( QIconViewItem arg1, QPoint arg2 );
	void currentChanged( QIconViewItem item );
	void itemRenamed( QIconViewItem item );
	void mouseButtonPressed( int button, QIconViewItem item, QPoint pos );
	void mouseButtonClicked( int button, QIconViewItem item, QPoint pos );
//	void dropped( QDropEvent e, QValueList<QIconDragItem>* lst );

/** 
 This signal gets emitted whenever the user double clicks into the
 iconview.

 Note that you may not delete any {@link QIconViewItem} objects in slots
 connected to this signal.

 This signal is more or less here for the sake of completeness.
 You should normally not need to use this. In most cases its better
 to use {@link KFileIconView#executed} instead.
   
*/
	void doubleClicked( QIconViewItem item, QPoint pos );
	void selectionChanged( QIconViewItem item );
	void onViewport();
	void onItem( QIconViewItem item );

/** 
 This signal is emitted whenever the user executes an iconview item.
 That means depending on the KDE wide Single Click/Double Click
 setting the user clicked or double clicked on that item.

 Note that you may not delete any {@link QIconViewItem} objects in slots
 connected to this signal.
   
*/
	void executed( QIconViewItem item, QPoint pos );
}

