/***************************************************************************
                            KIconEffect.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Apply effects to icons.
 
 @short 
 Apply effects to icons.
*/
public class  KIconEffect implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KIconEffect(Class dummy){}

	private native void newKIconEffect();
	public KIconEffect() {
		newKIconEffect();
	}
	protected native void finalize() throws InternalError;

/** 
 Reread configuration.
     
*/
	public native void init();

/**  
 Returns a fingerprint for the effect selected by 
 [<code>group</code>, <code>state</code>]. This is usefull for caching.
     
*/
	public native String fingerprint( int group, int state);

/** 
 Apply an effect to an image. The effect to apply depends on the
 <code>group</code> and <code>state</code> parameters, and is configured by the user.

*/
	public native QImage apply( QImage src, int group, int state);

/** 
 Apply an effect to an image.

*/
	public native QImage apply( QImage src, int effect, float value, QColor rgb, boolean trans);

/** 
 Apply an effect to a pixmap.
     
*/
	public native QPixmap apply( QPixmap src, int group, int state);

/** 
 Apply an effect to a pixmap.
     
*/
	public native QPixmap apply( QPixmap src, int effect, float value, QColor rgb, boolean trans);

/** 
 Returns an image twice as large, consisting of 2x2 pixels.
     
*/
	public native QImage doublePixels( QImage src);

/** 
 Provide visual feedback to show activation of an icon on a widget.

 Not strictly an 'icon effect', but in practice that's what it looks
 like.
     
*/
	public static native void visualActivate( QWidget arg1, QRect arg2);
	public static native void toGray( QImage image, float value);
	public static native void colorize( QImage image, QColor col, float value);
	public static native void deSaturate( QImage image, float value);
	public static native void toGamma( QImage image, float value);
	public static native void semiTransparent( QImage image);
	public static native void semiTransparent( QPixmap pixmap);
	public static native void overlay( QImage src, QImage overlay);
	public static final int NoEffect = 0;
	public static final int ToGray = 1;
	public static final int Colorize = 2;
	public static final int ToGamma = 3;
	public static final int DeSaturate = 4;
	public static final int LastEffect = 5;
}
