/***************************************************************************
                            KRootPixmap.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Create pseudo-transparent widgets. 

 A pseudo-transparent widget is a widget with its background pixmap set to
 that part of the desktop background that it is currently obscuring. This
 gives a transparency effect.

 To create a transparent widget, construct a {@link KRootPixmap} and pass it a 
 pointer to your widget. That's it! Moving, resizing and background changes 
 are handled automatically.

 See {@link KRootPixmapSignals} for signals emitted by KRootPixmap.

 See {@link KRootPixmapEventHandling} for event handlers to override in subclasses of KRootPixmap.

 @author Geert Jansen <jansen@kde.org>

 @version $Id: KRootPixmap.java,v 1.2.2.1 2001/08/29 23:14:10 rdale Exp $
 
 @short 
 Create pseudo-transparent widgets.
*/
public class KRootPixmap extends QObject  {
	protected KRootPixmap(Class dummy){super((Class) null);}


/** 
 Construct a KRootPixmap.

*/
	private native void newKRootPixmap( QWidget widget);
	public KRootPixmap( QWidget widget) {
		super((Class) null);
		newKRootPixmap( widget);
	}
	protected native void finalize() throws InternalError;

/** 
 Set the fade effect.

 This effect will fade the background to the
 specified color. 

*/
	public native void setFadeEffect( double strength, QColor color);

/** 
 Start background handling.
     
*/
	public native void start();

/** 
 Stop background handling.
     
*/
	public native void stop();

/** 
 Check if pseudo-transparency is available.

*/
	public native boolean checkAvailable( boolean ignored);

/** 
 Repaint the widget background.

 Normally, you shouldn't need this.

*/
	public native void repaint( boolean force);
	public native void repaint();
	public native boolean eventFilter( QObject arg1, QEvent arg2);
}
