/***************************************************************************
                            KUniqueApplication.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Maintain only a single
 instance of a running application at a time.

 If another instance
 is started, it will determine (via DCOP) whether it is the first instance
 or a second instance.  If it is a second instance, it will forward on
 the information to the first instance and then quit.

 See {@link KUniqueApplicationSignals} for signals emitted by KUniqueApplication.

 See {@link KUniqueApplicationEventHandling} for event handlers to override in subclasses of KUniqueApplication.

 @author Preston Brown <pbrown@kde.org>
 
 @short 
 Maintain only a single
 instance of a running application at a time.
*/
public class KUniqueApplication extends KApplication implements  DCOPObjectInterface {
	protected KUniqueApplication(Class dummy){super((Class) null);}


/** 
 Constructor. Takes command line arguments from KCmdLineArgs
 Parameters : See {@link KApplication} constructor.
 <code>configUnique</code> If true, the uniqueness of the application will
                 depend on the value of the "MultipleInstances"
                 key in the "KDE" group of the application config file.

   
*/
	private native void newKUniqueApplication( boolean allowStyles, boolean GUIenabled, boolean configUnique);
	public KUniqueApplication( boolean allowStyles, boolean GUIenabled, boolean configUnique) {
		super((Class) null);
		newKUniqueApplication( allowStyles, GUIenabled, configUnique);
	}
	private native void newKUniqueApplication( boolean allowStyles, boolean GUIenabled);
	public KUniqueApplication( boolean allowStyles, boolean GUIenabled) {
		super((Class) null);
		newKUniqueApplication( allowStyles, GUIenabled);
	}
	private native void newKUniqueApplication();
	public KUniqueApplication() {
		super((Class) null);
		newKUniqueApplication();
	}

/**  Destructor 
*/
	protected native void finalize() throws InternalError;

	public native String objId();
/**
 Retrieve the DCOP client object.

*/
	public native DCOPClient dcopClient();

/**
 Dispatches a message.

 Usually you want to use an IDL
 compiler to automatically generate an implementation for
 this function.

 If this function returns <code>false</code>, then {@link #processDynamic}
 is called.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native boolean process( String fun, byte[] data, String replyType, byte[] replyData);

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #process} but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
	public native boolean processDynamic( String fun, byte[] data, String replyType, byte[] replyData);

/**
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
	public native ArrayList interfaces();

/**
 Returns the list of functions understood by the object. It gets
 reimplemented by the IDL compiler. If you don't use the IDL
 compiler, consider implementing this function manually if you
 want your object to be easily scriptable.

 Rationale: functions() allows an interpreter to do client-side
 type-casting properly.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native ArrayList functions();

/**
 Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as
 arguments

*/
	public native void emitDCOPSignal( String signal, byte[] data);

/**
 Connect to a DCOP signal

*/
	public native boolean connectDCOPSignal( String sender, String senderObj, String signal, String slot, boolean Volatile);

/**
 Disconnect a DCOP signal

 A special case is when both sender & signal are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
	public native boolean disconnectDCOPSignal( String sender, String senderObj, String signal, String slot);

/**

 {@link DCOPObjectProxy}

*/
	public static native boolean hasObject( String objId);

/**

 This function does not query the {@link DCOPObjectProxy}.

*/
	public static native DCOPObjectInterface find( String objId);

/**
 Creates an object id for the QObject <code>obj.</code> This is done
 using the {@link QObject#name} function.

*/
	public static native String objectName( QObject obj);

}
