package org.kde.koala;
import org.kde.qt.*;


/** {@link KUniqueApplication} emits these signals */
public interface KUniqueApplicationSignals {
	void destroyed();

/** 
 {@link KApplication} has changed either its GUI style, its font or its palette
 in response to a kdisplay request. Normally, widgets will update their styles
 automatically, but you should connect to this to program special
 behavior. 
*/
	void appearanceChanged();

/** 
 The settings for toolbars have been changed. KToolBar will know what to do.
   
*/
	void toolbarAppearanceChanged( int arg1 );
	void aboutToQuit();

/** 
 KApplication has changed its font in response to a {@link KDisplay} request.

 Normally widgets will update their fonts automatically, but you should
 connect to this to monitor global font changes, especially if you are
 using explicit fonts.
   
*/
	void kdisplayFontChanged();

/**  Your application is killed. Either by your program itself,
      <code>xkill</code> or (the usual case) by KDE's logout.

      The signal is particularly useful if your application has to do some
      last-second cleanups. Note that no user interaction is possible at
      this state.
   
*/
	void shutDown();

/** 
 KApplication has changed its GUI style in response to a {@link KDisplay} request.

 Normally, widgets will update their styles automatically (as they would
 respond to an explicit setGUIStyle() call), but you should connect to
 this to program special behaviour.
   
*/
	void kdisplayStyleChanged();

/** 
 Emitted when a KIPC user message has been received.
   
*/
	void kipcMessage( int identifier, int data );

/** 
 The global icon settings have been changed.
   
*/
	void iconChanged( int group );

/** 
 The desktop background has been changed by <code>kcmdisplay.</code>

*/
	void backgroundChanged( int desk );

/** 
 The global settings have been changed - see KGlobalSettings
 KApplication takes care of calling reparseConfiguration on KGlobal.config()
 so that applications/classes using this only have to re-read the configuration

*/
	void settingsChanged( int category );
	void guiThreadAwake();

/** 
      Session management asks you to save the state of your application.

     This signal is provided for compatibility only. For new
     appliations, simply use KMainWindow. By reimplementing {@link KMainWindow#queryClose}, {@link KMainWindow#saveProperties} and
     {@link KMainWindow#readProperties} you can simply handle session
     management for applications with multiple toplevel windows.

     For purposes without KMainWindow, create an instance of
     KSessionManaged and reimplement the functions {@link KSessionManaged#commitData} and/or {@link KSessionManaged#saveState}

     If you still want to use this signal, here is what you should do:

     Connect to this signal in order to save your data. Do NOT
     manipulate the UI in that slot, it is blocked by the session
     manager.

     Use the {@link KUniqueApplication#sessionConfig} KConfig object to store all your
     instance specific datas.

     Do not do any closing at this point! The user may still select
     Cancel  wanting to continue working with your
     application. Cleanups could be done after shutDown() (see
     the following).

  
*/
	void saveYourself();
	void lastWindowClosed();

/** 
 KApplication has changed its palette due to a KDisplay request.

 Normally, widgets will update their palettes automatically, but you
 should connect to this to program special behaviour.
   
*/
	void kdisplayPaletteChanged();
}

