/***************************************************************************
                            MidiMapper.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A Midi Mapper class which defines the way MIDI events are translated
 (or "mapped") to different ones. This way, when two MIDI devices "talk"
 in a somehow different way, they can still communicate.

 When the user has an external keyboard that is not compatible with the
 General Midi standard, he can use a MIDI mapper file to play files
 as if the synthesizer was GM compatible.

 Please see the KMid documentation 
 ( http://www.arrakis.es/~rlarrosa/kmid.html ) for information on the
 format of a MIDI mapper definition file, and how they work.

 I created this class because I had one of those non-GM keyboards, 
 so it can do everything I needed it to do for my keyboard to work
 exactly as a GM synth, and a few more things. Currently, it's the most
 featured MIDI mapper available.

 The usage of this class is quite simple, just create an object with
 a correct filename in the constructor and then use this object as
 parameter for {@link DeviceManager#setMidiMap}.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>  
 
 @version 0.9.5 17/01/2000

 @short Midi Mapper.
*/
public class  MidiMapper implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected MidiMapper(Class dummy){}


/** 
 Constructor. Loads a MIDI Mapper definition from a file.

*/
	private native void newMidiMapper( String name);
	public MidiMapper( String name) {
		newMidiMapper( name);
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;

/** 
 Loads a MIDI Mapper definition file (you don't need to use this if you
 used a correct filename in constructor). 
     
*/
	public native void loadFile( String name);

/** 
 Returns the status of the object.
     
*/
	public native int ok();

/**  
 Returns the channel which chn should be mapped to.
     
*/
	public native String channel( String chn);

/**  
 Returns the patch which pgm used on channel chn should be mapped to.
     
*/
	public native String patch( String chn, String pgm);

/**  
 Returns the key that key note playing a pgm patch on channel chn should
 be mapped to.
     
*/
	public native String key( String chn, String pgm, String note);

/** 
 Returns the value which the pitch bender on channel chn should be
 mapped to.
     
*/
	public native void pitchBender( String chn, String lsb, String msb);

/** 
 Returns the value which a given controller and its value should
 be mapped to when played on channel chn.
     
*/
	public native void controller( String chn, String ctl, String v);

/** 
 Returns the path and name of the file which the object loaded the
 mapper from.
     
*/
	public native String filename();
}
