/*
    This file is part of KitchenSync.

    Copyright (c) 2002 Holger Freyther <zecke@handhelds.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "konnectorinfo.h"

using namespace KSync;

KonnectorInfo::KonnectorInfo( const QString& name,
                              const QIconSet& set,
                              const QString& iconName,
                              bool isCon )
{
    m_na = name;
    m_icon = set;
    m_name = iconName;
    m_con = isCon;
}

KonnectorInfo::~KonnectorInfo()
{
}

bool KonnectorInfo::operator==( const KonnectorInfo& rhs )
{
    if ( m_na   != rhs.m_na   ) return false;
    if ( m_name != rhs.m_name ) return false;

    return true;
}

QString KonnectorInfo::name() const
{
    return m_na;
}

QIconSet KonnectorInfo::iconSet() const
{
    return m_icon;
}

QString KonnectorInfo::iconName() const
{
    return m_name;
}

bool KonnectorInfo::isConnected() const
{
    return m_con;
}
