//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  This class is a base class for all Akonadi agents, which covers the real
    ///  agent processes and all resources.
    ///  It provides:
    ///  - lifetime management
    ///  - change monitoring and recording
    ///  - configuration interface
    ///  - problem reporting
    ///  See <see cref="IAgentBaseSignals"></see> for signals emitted by AgentBase
    /// </remarks>        <author> Till Adam <adam@kde.org>, Volker Krause <vkrause@kde.org>
    ///  </author>
    ///         <short> The base class for all Akonadi agents and resources. </short>
    [SmokeClass("Akonadi::AgentBase")]
    public class AgentBase : QObject, IQDBusContext {
        protected AgentBase(Type dummy) : base((Type) null) {}
        /// <remarks>
        ///  The Observer provides an interface to react on monitored or replayed changes.
        ///  Since the this base class does only tell the change recorder that the change
        ///  has been processed, an AgentBase subclass which wants to actually process
        ///  the change needs to subclass Observer and reimplement the methods it is
        ///  interested in.
        ///  Such an agent specific Observer implementation can either be done
        ///  stand-alone, i.e. as a separate object, or by inheriting both AgentBase
        ///  and AgentBase.Observer.
        ///  The observer implementation then has registered with the agent, so it
        ///  can forward the incoming changes to the observer.
        ///  @note In the multiple inheritance approach the init() method automatically
        ///        registers itself as the observer.
        ///  Example for stand-alone observer:
        ///  @code
        ///  class ExampleAgent : public AgentBase
        ///  {
        ///    public      ExampleAgent( stringid );
        ///      
        ///    private:
        ///      AgentBase.Observer mObserver;
        ///  }
        ///  class ExampleObserver : public AgentBase.Observer
        ///  {
        ///    protected:
        ///      void itemChanged( Itemitem );
        ///  }
        ///  ExampleAgent.ExampleAgent( stringid ), mObserver( 0 )
        ///  {
        ///    mObserver = new ExampleObserver();
        ///    registerObserver( mObserver );
        ///  }
        ///  ExampleAgent.~ExampleAgent()
        ///  {
        ///    delete mObserver;
        ///  }
        ///  void ExampleObserver.ItemChanged( Itemitem )
        ///  {
        ///    // do something with item
        ///    kDebug() << "Item id=" << item.id();
        ///    // let base implementation tell the change recorder that we
        ///    // have processed the change
        ///    AgentBase.Observer.ItemChanged( item );
        ///  }
        ///  @endcode
        ///  Example for observer through multiple inheritance:
        ///  @code
        ///  class ExampleAgent : public AgentBase, public AgentBase.Observer
        ///  {
        ///    public      ExampleAgent( stringid );
        ///    protected:
        ///      void itemChanged( Itemitem );
        ///  }
        ///  ExampleAgent.ExampleAgent( stringid )
        ///  {
        ///    // no need to create or register observer since
        ///    // we are the observer and registration happens automatically
        ///    // in init()
        ///  }
        ///  void ExampleAgent.ItemChanged( Itemitem )
        ///  {
        ///    // do something with item
        ///    kDebug() << "Item id=" << item.id();
        ///    // let base implementation tell the change recorder that we
        ///    // have processed the change
        ///    AgentBase.Observer.ItemChanged( item );
        ///  }
        ///  @endcode
        /// </remarks>        <author> Kevin Krammer <kevin.krammer@gmx.at>
        ///      </author>
        ///         <short> The interface for reacting on monitored or replayed changes. </short>
        [SmokeClass("Akonadi::AgentBase::Observer")]
        public class Observer : Object, IDisposable {
            protected SmokeInvocation interceptor = null;
            private IntPtr smokeObject;
            protected Observer(Type dummy) {}
            protected void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(Observer), this);
            }
            // void itemChanged(const Akonadi::Item& arg1,const QSet<QByteArray>& arg2); >>>> NOT CONVERTED
            /// <remarks>
            ///  Creates an observer instance.
            ///          </remarks>        <short>    Creates an observer instance.</short>
            public Observer() : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Observer", "Observer()", typeof(void));
            }
            /// <remarks>
            ///  Reimplement to handle adding of new items.
            /// <param> name="item" The newly added item.
            /// </param><param> name="collection" The collection <code>item</code> got added to.
            ///          </param></remarks>        <short>    Reimplement to handle adding of new items.</short>
            [SmokeMethod("itemAdded(const Akonadi::Item&, const Akonadi::Collection&)")]
            public virtual void ItemAdded(Akonadi.Item item, Akonadi.Collection collection) {
                interceptor.Invoke("itemAdded##", "itemAdded(const Akonadi::Item&, const Akonadi::Collection&)", typeof(void), typeof(Akonadi.Item), item, typeof(Akonadi.Collection), collection);
            }
            /// <remarks>
            ///  Reimplement to handle changes to existing items.
            /// <param> name="item" The changed item.
            /// </param><param> name="partIdentifiers" The identifiers of the item parts that has been changed.
            ///          </param></remarks>        <short>    Reimplement to handle changes to existing items.</short>
            /// <remarks>
            ///  Reimplement to handle deletion of items.
            /// <param> name="item" The deleted item.
            ///          </param></remarks>        <short>    Reimplement to handle deletion of items.</short>
            [SmokeMethod("itemRemoved(const Akonadi::Item&)")]
            public virtual void ItemRemoved(Akonadi.Item item) {
                interceptor.Invoke("itemRemoved#", "itemRemoved(const Akonadi::Item&)", typeof(void), typeof(Akonadi.Item), item);
            }
            /// <remarks>
            ///  Reimplement to handle adding of new collections.
            /// <param> name="collection" The newly added collection.
            /// </param><param> name="parent" The parent collection.
            ///           </param></remarks>        <short>    Reimplement to handle adding of new collections.</short>
            [SmokeMethod("collectionAdded(const Akonadi::Collection&, const Akonadi::Collection&)")]
            public virtual void CollectionAdded(Akonadi.Collection collection, Akonadi.Collection parent) {
                interceptor.Invoke("collectionAdded##", "collectionAdded(const Akonadi::Collection&, const Akonadi::Collection&)", typeof(void), typeof(Akonadi.Collection), collection, typeof(Akonadi.Collection), parent);
            }
            /// <remarks>
            ///  Reimplement to handle changes to existing collections.
            /// <param> name="collection" The changed collection.
            ///          </param></remarks>        <short>    Reimplement to handle changes to existing collections.</short>
            [SmokeMethod("collectionChanged(const Akonadi::Collection&)")]
            public virtual void CollectionChanged(Akonadi.Collection collection) {
                interceptor.Invoke("collectionChanged#", "collectionChanged(const Akonadi::Collection&)", typeof(void), typeof(Akonadi.Collection), collection);
            }
            /// <remarks>
            ///  Reimplement to handle deletion of collections.
            /// <param> name="collection" The deleted collection.
            ///          </param></remarks>        <short>    Reimplement to handle deletion of collections.</short>
            [SmokeMethod("collectionRemoved(const Akonadi::Collection&)")]
            public virtual void CollectionRemoved(Akonadi.Collection collection) {
                interceptor.Invoke("collectionRemoved#", "collectionRemoved(const Akonadi::Collection&)", typeof(void), typeof(Akonadi.Collection), collection);
            }
            ~Observer() {
                interceptor.Invoke("~Observer", "~Observer()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~Observer", "~Observer()", typeof(void));
            }
        }
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(AgentBase), this);
        }
        /// <remarks>
        ///  This enum describes the different states the
        ///  agent can be in.
        ///      </remarks>        <short>    This enum describes the different states the  agent can be in.</short>
        public enum Status {
            Idle = 0,
            Running = 1,
            Broken = 2,
        }
        // Akonadi::AgentBase* AgentBase(Akonadi::AgentBasePrivate* arg1,const QString& arg2); >>>> NOT CONVERTED
        /// <remarks>
        ///  This method returns the current status code of the agent.
        ///  The following return values are possible:
        ///   - 0 - Idle
        ///   - 1 - Running
        ///   - 2 - Broken
        ///      </remarks>        <short>    This method returns the current status code of the agent.</short>
        [SmokeMethod("status() const")]
        public virtual int status() {
            return (int) interceptor.Invoke("status", "status() const", typeof(int));
        }
        /// <remarks>
        ///  This method returns an i18n'ed description of the current status code.
        ///      </remarks>        <short>    This method returns an i18n'ed description of the current status code.</short>
        [SmokeMethod("statusMessage() const")]
        public virtual string StatusMessage() {
            return (string) interceptor.Invoke("statusMessage", "statusMessage() const", typeof(string));
        }
        /// <remarks>
        ///  This method returns the current progress of the agent in percentage.
        ///      </remarks>        <short>    This method returns the current progress of the agent in percentage.</short>
        [SmokeMethod("progress() const")]
        public virtual int Progress() {
            return (int) interceptor.Invoke("progress", "progress() const", typeof(int));
        }
        /// <remarks>
        ///  This method returns an i18n'ed description of the current progress.
        ///      </remarks>        <short>    This method returns an i18n'ed description of the current progress.</short>
        [SmokeMethod("progressMessage() const")]
        public virtual string ProgressMessage() {
            return (string) interceptor.Invoke("progressMessage", "progressMessage() const", typeof(string));
        }
        /// <remarks>
        ///  This method is called whenever the agent shall show its configuration dialog
        ///  to the user. It will be automatically called when the agent is started for
        ///  the first time.
        /// <param> name="windowId" The parent window id.
        ///      </param></remarks>        <short>    This method is called whenever the agent shall show its configuration dialog  to the user.</short>
        [SmokeMethod("configure(WId)")]
        public virtual void Configure(uint windowId) {
            interceptor.Invoke("configure$", "configure(WId)", typeof(void), typeof(uint), windowId);
        }
        /// <remarks>
        ///  This method returns the windows id, which should be used for dialogs.
        ///      </remarks>        <short>    This method returns the windows id, which should be used for dialogs.</short>
        public uint WinIdForDialogs() {
            return (uint) interceptor.Invoke("winIdForDialogs", "winIdForDialogs() const", typeof(uint));
        }
        /// <remarks>
        ///  Overload of <see cref="#configure"></see> needed because WId cannot be automatically casted
        ///  to qlonglong on Windows.
        ///      </remarks>        <short>    Overload of @ref configure needed because WId cannot be automatically casted  to qlonglong on Windows.</short>
        public void Configure(long windowId) {
            interceptor.Invoke("configure?", "configure(qlonglong)", typeof(void), typeof(long), windowId);
        }
        /// <remarks>
        ///  Returns the instance identifier of this agent.
        ///      </remarks>        <short>    Returns the instance identifier of this agent.</short>
        public string Identifier() {
            return (string) interceptor.Invoke("identifier", "identifier() const", typeof(string));
        }
        /// <remarks>
        ///  This method is called when the agent is removed from
        ///  the system, so it can do some cleanup stuff.
        ///      </remarks>        <short>    This method is called when the agent is removed from  the system, so it can do some cleanup stuff.</short>
        [SmokeMethod("cleanup()")]
        public virtual void Cleanup() {
            interceptor.Invoke("cleanup", "cleanup()", typeof(void));
        }
        /// <remarks>
        ///  Registers the given observer for reacting on monitored or recorded changes.
        /// <param> name="observer" The change handler to register. No ownership transfer, i.e.
        ///                  the caller stays owner of the pointer and can reset
        ///                  the registration by calling this method with <code>0</code>
        ///      </param></remarks>        <short>    Registers the given observer for reacting on monitored or recorded changes.</short>
        public void RegisterObserver(Akonadi.AgentBase.Observer observer) {
            interceptor.Invoke("registerObserver#", "registerObserver(Akonadi::AgentBase::Observer*)", typeof(void), typeof(Akonadi.AgentBase.Observer), observer);
        }
        /// <remarks>
        ///  Creates an agent base.
        /// <param> name="id" The instance id of the agent.
        ///      </param></remarks>        <short>    Creates an agent base.</short>
        public AgentBase(string id) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("AgentBase$", "AgentBase(const QString&)", typeof(void), typeof(string), id);
        }
        /// <remarks>
        ///  This method is called whenever the agent application is about to
        ///  quit.
        ///  Reimplement this method to do session cleanup (e.g. disconnecting
        ///  from groupware server).
        ///      </remarks>        <short>    This method is called whenever the agent application is about to  quit.</short>
        [SmokeMethod("aboutToQuit()")]
        protected virtual void AboutToQuit() {
            interceptor.Invoke("aboutToQuit", "aboutToQuit()", typeof(void));
        }
        /// <remarks>
        ///  Returns the Akonadi.ChangeRecorder object used for monitoring.
        ///  Use this to configure which parts you want to monitor.
        ///      </remarks>        <short>    Returns the Akonadi.ChangeRecorder object used for monitoring.</short>
        protected Akonadi.ChangeRecorder ChangeRecorder() {
            return (Akonadi.ChangeRecorder) interceptor.Invoke("changeRecorder", "changeRecorder() const", typeof(Akonadi.ChangeRecorder));
        }
        /// <remarks>
        ///  Marks the current change as processes and replays the next change if change
        ///  recording is enabled (noop otherwise). This method is called
        ///  from the default implementation of the change notification slots. While not
        ///  required when not using change recording, it is nevertheless recommended
        ///  to call this method when done with processing a change notification.
        ///      </remarks>        <short>    Marks the current change as processes and replays the next change if change  recording is enabled (noop otherwise).</short>
        protected void ChangeProcessed() {
            interceptor.Invoke("changeProcessed", "changeProcessed()", typeof(void));
        }
        /// <remarks>
        ///  Returns whether the agent is currently online.
        ///      </remarks>        <short>    Returns whether the agent is currently online.</short>
        protected bool IsOnline() {
            return (bool) interceptor.Invoke("isOnline", "isOnline() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets whether the agent shall be online or not.
        ///      </remarks>        <short>    Sets whether the agent shall be online or not.</short>
        protected void SetOnline(bool state) {
            interceptor.Invoke("setOnline$", "setOnline(bool)", typeof(void), typeof(bool), state);
        }
        /// <remarks>
        ///  This method is called whenever the <code>online</code> status has changed.
        ///  Reimplement this method to react on online status changes.
        ///      </remarks>        <short>    This method is called whenever the <code>online</code> status has changed.</short>
        [SmokeMethod("doSetOnline(bool)")]
        protected virtual void DoSetOnline(bool online) {
            interceptor.Invoke("doSetOnline$", "doSetOnline(bool)", typeof(void), typeof(bool), online);
        }
        public bool CalledFromDBus() {
            return (bool) interceptor.Invoke("calledFromDBus", "calledFromDBus() const", typeof(bool));
        }
        public QDBusConnection Connection() {
            return (QDBusConnection) interceptor.Invoke("connection", "connection() const", typeof(QDBusConnection));
        }
        public QDBusMessage Message() {
            return (QDBusMessage) interceptor.Invoke("message", "message() const", typeof(QDBusMessage));
        }
        public bool IsDelayedReply() {
            return (bool) interceptor.Invoke("isDelayedReply", "isDelayedReply() const", typeof(bool));
        }
        public void SetDelayedReply(bool enable) {
            interceptor.Invoke("setDelayedReply$", "setDelayedReply(bool) const", typeof(void), typeof(bool), enable);
        }
        public void SendErrorReply(string name, string msg) {
            interceptor.Invoke("sendErrorReply$$", "sendErrorReply(const QString&, const QString&) const", typeof(void), typeof(string), name, typeof(string), msg);
        }
        public void SendErrorReply(string name) {
            interceptor.Invoke("sendErrorReply$", "sendErrorReply(const QString&) const", typeof(void), typeof(string), name);
        }
        public void SendErrorReply(QDBusError.ErrorType type, string msg) {
            interceptor.Invoke("sendErrorReply$$", "sendErrorReply(QDBusError::ErrorType, const QString&) const", typeof(void), typeof(QDBusError.ErrorType), type, typeof(string), msg);
        }
        public void SendErrorReply(QDBusError.ErrorType type) {
            interceptor.Invoke("sendErrorReply$", "sendErrorReply(QDBusError::ErrorType) const", typeof(void), typeof(QDBusError.ErrorType), type);
        }
        protected new IAgentBaseSignals Emit {
            get { return (IAgentBaseSignals) Q_EMIT; }
        }
    }

    public interface IAgentBaseSignals : IQObjectSignals {
        /// <remarks>
        ///  This signal should be emitted whenever the status of the agent has been changed.
        /// <param> name="status" The new Status code.
        /// </param><param> name="message" A i18n'ed description of the new status.
        ///      </param></remarks>        <short>    This signal should be emitted whenever the status of the agent has been changed.</short>
        [Q_SIGNAL("void status(int, QString)")]
        void Status(int status, string message);
        /// <remarks>
        ///  This signal should be emitted whenever the status of the agent has been changed.
        /// <param> name="status" The new Status code.
        /// </param><param> name="message" A i18n'ed description of the new status.
        ///      </param></remarks>        <short>    This signal should be emitted whenever the status of the agent has been changed.</short>
        [Q_SIGNAL("void status(int)")]
        void Status(int status);
        /// <remarks>
        ///  This signal should be emitted whenever the progress of an action in the agent
        ///  (e.g. data transfer, connection establishment to remote server etc.) has changed.
        /// <param> name="progress" The progress of the action in percent.
        ///      </param></remarks>        <short>    This signal should be emitted whenever the progress of an action in the agent  (e.</short>
        [Q_SIGNAL("void percent(int)")]
        void Percent(int progress);
        /// <remarks>
        ///  This signal shall be used to report warnings.
        /// <param> name="message" The i18n'ed warning message.
        ///      </param></remarks>        <short>    This signal shall be used to report warnings.</short>
        [Q_SIGNAL("void warning(QString)")]
        void Warning(string message);
        /// <remarks>
        ///  This signal shall be used to report errors.
        /// <param> name="message" The i18n'ed error message.
        ///      </param></remarks>        <short>    This signal shall be used to report errors.</short>
        [Q_SIGNAL("void error(QString)")]
        void Error(string message);
    }
}
