/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2002-2013                                               *
 *   Umbrello UML Modeller Authors <umbrello-devel@kde.org>                *
 ***************************************************************************/

#ifndef DOCWINDOW_H
#define DOCWINDOW_H

#include <QWidget>

class AssociationWidget;
class KTextEdit;
class QLabel;
class UMLObject;
class UMLDoc;
class UMLScene;
class UMLWidget;

/**
 * @author Paul Hensgen
 * Bugs and comments to umbrello-devel@kde.org or http://bugs.kde.org
 */
class DocWindow : public QWidget
{
    Q_OBJECT
public:
    explicit DocWindow(UMLDoc * doc, QWidget *parent = 0);
    ~DocWindow();

    void showDocumentation(UMLObject * object, bool overwrite = false);
    void showDocumentation(UMLScene * scene, bool overwrite = false);
    void showDocumentation(UMLWidget * widget, bool overwrite = false);
    void showDocumentation(AssociationWidget * widget, bool overwrite = false);

    void updateDocumentation(bool clear = false, bool startup = false);

    void reset();

    bool isTyping();
    void setFocus();

public slots:
    void slotAssociationRemoved(AssociationWidget* association);
    void slotWidgetRemoved(UMLWidget* widget);

private slots:
    void slotTextChanged();

private:
    /**
     * Used internally to know which type of object we are showing
     * documentation for.
     */
    enum ShowingType {
        st_Project,
        st_UMLScene,
        st_UMLObject,
        st_UMLWidget,
        st_Association
    };

    UMLObject         *m_pUMLObject;    ///< The UMLObject we are going to show documentation.
    UMLScene          *m_pUMLScene;     ///< The UMLScene we are going to show documentation.
    UMLDoc            *m_pUMLDoc;       ///< The Project we are going to show documentation.
    UMLWidget         *m_pUMLWidget;    ///< The UMLWidget we are going to show documentation.
    AssociationWidget *m_pAssocWidget;  ///< The association we are going to show documentation.

    ShowingType m_Showing;  ///< Which type of documentation we are showing.

    QLabel    *m_typeLabel;      ///< label for type icon
    QLabel    *m_nameLabel;      ///< label for name text
    QLabel    *m_modifiedLabel;  ///< label for modified flag icon
    KTextEdit *m_docTE;          ///< documentation widget

    bool isModified();
    QLabel* createPixmapLabel();
    void updateLabel(const QString &name = QString());
};

#endif
