//Auto-generated by kalyptus. DO NOT EDIT.
namespace Nepomuk.Types {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class Property property.h Nepomuk/Types/Property
    ///  \brief A property is a resource of type rdf:Property which relates a domain
    ///  with a range. The latter one can be a Literal or a Class.
    ///  Property instances are explicitly shared. Two instances created
    ///  with the same uri reference the same data.
    ///  While Resource objects can be changed Property instances are considered
    ///  to be static and never changed during their lifetime.
    ///  \author Sebastian Trueg <trueg@kde.org>
    ///          </remarks>        <short>    \class Property property.</short>
    [SmokeClass("Nepomuk::Types::Property")]
    public class Property : Nepomuk.Types.Entity, IDisposable {
        protected Property(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Property), this);
        }
        /// <remarks>
        ///  Default constructor. Creates an empty Property.
        ///              </remarks>        <short>    Default constructor.</short>
        public Property() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Property", "Property()", typeof(void));
        }
        /// <remarks>
        ///  Create the property referred to by <pre>uri</pre>.
        ///  The result is either a valid property which could be loaded from the
        ///  Nepomuk store or a simple property which only contains the uri.
        ///  Be aware that the data is only loaded once read.
        ///  Subsequent calls result in a simple hash lookup of cached data.
        ///              </remarks>        <short>    Create the property referred to by \p uri.</short>
        public Property(QUrl uri) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Property#", "Property(const QUrl&)", typeof(void), typeof(QUrl), uri);
        }
        /// <remarks>
        ///  Default copy constructor
        ///              </remarks>        <short>    Default copy constructor              </short>
        public Property(Nepomuk.Types.Property arg1) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Property#", "Property(const Nepomuk::Types::Property&)", typeof(void), typeof(Nepomuk.Types.Property), arg1);
        }
        /// <remarks>
        ///  Each property can have multiple parent properties.
        ///  \return A list of all parent properties of this property.
        ///  If the list is emppty it means that the property has no direct
        ///  parents, i.e. it is derived from rdf:Resource.
        ///              </remarks>        <short>    Each property can have multiple parent properties.</short>
        public List<Nepomuk.Types.Property> ParentProperties() {
            return (List<Nepomuk.Types.Property>) interceptor.Invoke("parentProperties", "parentProperties()", typeof(List<Nepomuk.Types.Property>));
        }
        /// <remarks>
        ///  \return A list of all properties that have this property as a parent.
        ///  Be aware that this list can never be final since other ontologies
        ///  that have not been loaded yet may contain properties that are derived
        ///  from this property.
        ///              </remarks>        <short>    \return A list of all properties that have this property as a parent.</short>
        public List<Nepomuk.Types.Property> SubProperties() {
            return (List<Nepomuk.Types.Property>) interceptor.Invoke("subProperties", "subProperties()", typeof(List<Nepomuk.Types.Property>));
        }
        /// <remarks>
        ///  The inverse property (nrl:inverseProperty).
        ///  \return A Property instance representing the inverse property of this one
        ///  or 0 if none was specified in the ontology.
        ///              </remarks>        <short>    The inverse property (nrl:inverseProperty).</short>
        public Nepomuk.Types.Property InverseProperty() {
            return (Nepomuk.Types.Property) interceptor.Invoke("inverseProperty", "inverseProperty()", typeof(Nepomuk.Types.Property));
        }
        /// <remarks>
        ///  The range of the property.
        ///  \return The range of the property or an invalid Class in case
        ///  the range of this poperty is a literal.
        ///  \sa literalRange
        ///              </remarks>        <short>    The range of the property.</short>
        public Nepomuk.Types.Class Range() {
            return (Nepomuk.Types.Class) interceptor.Invoke("range", "range()", typeof(Nepomuk.Types.Class));
        }
        /// <remarks>
        ///  If the rage of this property is a literal (i.e. range returns an invalid Class)
        ///  this method provides the literal type.
        ///  \returns the literal type of this property or an empty, invalid Literal
        ///  if the range is a Class.
        ///  \sa range
        ///              </remarks>        <short>    If the rage of this property is a literal (i.</short>
        public Nepomuk.Types.Literal LiteralRangeType() {
            return (Nepomuk.Types.Literal) interceptor.Invoke("literalRangeType", "literalRangeType()", typeof(Nepomuk.Types.Literal));
        }
        /// <remarks>
        ///  The domain of the property.
        ///              </remarks>        <short>    The domain of the property.</short>
        public Nepomuk.Types.Class Domain() {
            return (Nepomuk.Types.Class) interceptor.Invoke("domain", "domain()", typeof(Nepomuk.Types.Class));
        }
        /// <remarks>
        ///  The cardinality of this property as specified by nrl:cardinality.
        ///  \return the cardinality of the property or -1 if none was set.
        ///              </remarks>        <short>    The cardinality of this property as specified by nrl:cardinality.</short>
        public int Cardinality() {
            return (int) interceptor.Invoke("cardinality", "cardinality()", typeof(int));
        }
        /// <remarks>
        ///  The minimum cardinality of this property as specified by nrl:minCardinality.
        ///  \return the minimum cardinality of the property or -1 if none was set.
        ///              </remarks>        <short>    The minimum cardinality of this property as specified by nrl:minCardinality.</short>
        public int MinCardinality() {
            return (int) interceptor.Invoke("minCardinality", "minCardinality()", typeof(int));
        }
        /// <remarks>
        ///  The maximum cardinality of this property as specified by nrl:maxCardinality.
        ///  \return the maximum cardinality of the property or -1 if none was set.
        ///              </remarks>        <short>    The maximum cardinality of this property as specified by nrl:maxCardinality.</short>
        public int MaxCardinality() {
            return (int) interceptor.Invoke("maxCardinality", "maxCardinality()", typeof(int));
        }
        /// <remarks>
        ///  Check if a property inherits this property. This is a recursive method which
        ///  does not only check direct child propertyes.
        ///  \return true if other is derived from this property, false otherwise.
        ///              </remarks>        <short>    Check if a property inherits this property.</short>
        public bool IsParentOf(Nepomuk.Types.Property other) {
            return (bool) interceptor.Invoke("isParentOf#", "isParentOf(const Nepomuk::Types::Property&)", typeof(bool), typeof(Nepomuk.Types.Property), other);
        }
        /// <remarks>
        ///  Check if this property is derived from another property. This is a recursive method which
        ///  does not only check direct child propertyes.
        ///  \return true if this property is derived from other, false otherwise.
        ///              </remarks>        <short>    Check if this property is derived from another property.</short>
        public bool IsSubPropertyOf(Nepomuk.Types.Property other) {
            return (bool) interceptor.Invoke("isSubPropertyOf#", "isSubPropertyOf(const Nepomuk::Types::Property&)", typeof(bool), typeof(Nepomuk.Types.Property), other);
        }
        ~Property() {
            interceptor.Invoke("~Property", "~Property()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Property", "~Property()", typeof(void));
        }
    }
}
