
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef XSLDBGENTITIESIMPL_H 
#define XSLDBGENTITIESIMPL_H 
 
/** 
  *@author Keith Isdale 
  */ 
 
#include "ui_xsldbgentities.h" 
#include "xsldbgdialogbase.h" 

#include <QWidget>

class XsldbgDebugger; 
 
class XsldbgEntitiesImpl : public QWidget, Ui::XsldbgEntities, XsldbgDialogBase  { 
  Q_OBJECT 
 
public: 
	explicit XsldbgEntitiesImpl(XsldbgDebugger *debugger, QWidget *parent=0); 
	~XsldbgEntitiesImpl(); 
	// this must match the order of columns in tableWidget
	enum ColumnDataTypes {PublicIDColumn, SystemIDColumn };
 
public slots: 
	/** Process request to add entity to view, First parameter is QString() 
			to indicate start of entity list notfication */ 
	void slotProcEntityItem(QString SystemID,  QString PublicID); 
	 
	void itemSelectionChanged();	 
	 
	/** Called to resize the table widget contents after enough time has lapsed */
	void resizeContents();
	 
	/** refresh data from source */ 
	void refresh(); 
 
	 
private: 
	XsldbgDebugger *debugger; 
 
}; 
 
#endif 
